create table Roc_MPHD_Tab_Najchov
(
	KrajOkr varchar(3),
	Podnik varchar(3),
	Podnik_nazov varchar(35),
	Prev_plem varchar(10),
	Priem_stav_krav int,
	Priem_stav_MD int,
	poc_vaz_210 int,
	Hm210 int,
	Medziobd float,
	Inde_x float,
	rok int
)
go


----------------------------------------------------------

/****** Script for SelectTopNRows command from SSMS  ******/
/** Rocenka MLHD ----PREHLAD VYSLEDKOV PODLA KRAJOV - POCET SOMATICKYCH BUNIEK VO VZORKACH MLIEKA ---str 15 **/
/**  SB do 200, 400, 600, 800, 1000 anad 1000 **/
CREATE procedure [dbo].[Roc_MLHD_5A]

    @datumOd date,
    @datumDo date
  --declare @datumOD date = '2017-01-01', @datumDo date = '2017-12-31'
as
  begin


    /**somaticke bunky do 200 tisic**/
    select t.kraj, t.nazov, Count(*) as SB_kraj_do200
    from (select distinct ch.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(k.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM < 201
            and p.KRAJ <> 0
          union
          select distinct ch.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(ak.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM < 201
            and p.KRAJ <> 0) as t
    group by t.kraj, t.nazov
    order by t.KRAJ
    /**somaticke bunky do 400 tisic**/
    select t.kraj, t.nazov, Count(*) as SB_kraj_do400
    from (select distinct ch.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(k.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 200
            and k.BUNECELEM < 401
            and p.KRAJ <> 0
          union
          select distinct ch.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(ak.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 200
            and ak.BUNECELEM < 401
            and p.KRAJ <> 0) as t
    group by t.kraj, t.nazov
    order by t.KRAJ

    /**somaticke bunky do 600 tisic**/
    select t.kraj, t.nazov, Count(*) as SB_kraj_do600
    from (select distinct ch.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(k.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 400
            and k.BUNECELEM < 601
            and p.KRAJ <> 0
          union
          select distinct ch.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(ak.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 400
            and ak.BUNECELEM < 601
            and p.KRAJ <> 0) as t
    group by t.kraj, t.nazov
    order by t.KRAJ
    /**somaticke bunky do 800 tisic**/
    select t.kraj, t.nazov, Count(*) as SB_kraj_do800
    from (select distinct ch.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(k.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 600
            and k.BUNECELEM < 801
            and p.KRAJ <> 0
          union
          select distinct ch.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(ak.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 600
            and ak.BUNECELEM < 801
            and p.KRAJ <> 0) as t
    group by t.kraj, t.nazov
    order by t.KRAJ
    /**somaticke bunky do 1000 tisic**/
    select t.kraj, t.nazov, Count(*) as SB_kraj_do1000
    from (select distinct ch.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(k.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 800
            and k.BUNECELEM < 1001
            and p.KRAJ <> 0
          union
          select distinct ch.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(ak.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 800
            and ak.BUNECELEM < 1001
            and p.KRAJ <> 0) as t
    group by t.kraj, t.nazov
    order by t.KRAJ

    /**somaticke bunky nad 1000 tisic**/
    select t.kraj, t.nazov, Count(*) as SB_kraj_nad1000
    from (select distinct ch.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(k.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 1000
            and p.KRAJ <> 0
          union
          select distinct ch.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(ak.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 1000
            and p.KRAJ <> 0) as t
    group by t.kraj, t.nazov
    order by t.KRAJ


    /**SR somaticke bunky do 200 tisic**/
    select Count(*) as SB_SR_do201
    from (select distinct k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = k.CISCHOVU
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM < 201
          union
          select distinct ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = ak.CISCHOVU
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM < 201) as t
    --group by t.kraj, t.nazov
    --order by t.KRAJ

    /**SR somaticke bunky do 400 tisic**/
    select distinct Count(*) as SB_SR_do400
    from (select distinct k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = k.CISCHOVU
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 200
            and k.BUNECELEM < 401
          union
          select distinct ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = ak.CISCHOVU
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 200
            and ak.BUNECELEM < 401) as t

    /**SR somaticke bunky do 600 tisic**/
    select distinct Count(*) as SB_SR_do600
    from (select distinct k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = k.CISCHOVU
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 400
            and k.BUNECELEM < 601
          union
          select distinct ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = ak.CISCHOVU
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 400
            and ak.BUNECELEM < 601) as t

    /**SR somaticke bunky do 800 tisic**/
    select distinct Count(*) as SB_SR_do800
    from (select distinct k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = k.CISCHOVU
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 600
            and k.BUNECELEM < 801
          union
          select distinct ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = ak.CISCHOVU
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 600
            and ak.BUNECELEM < 801) as t

    /**SR somaticke bunky do 1000 tisic**/
    select distinct Count(*) as SB_SR_do1000
    from (select distinct k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = k.CISCHOVU
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 800
            and k.BUNECELEM < 1001
          union
          select distinct ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = ak.CISCHOVU
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 800
            and ak.BUNECELEM < 1001) as t

    /**SR somaticke bunky nad 1000 tisic**/
    select distinct Count(*) as SB_SR_nad10000
    from (select distinct k.CISKRAVY, k.DATKONTR
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = k.CISCHOVU
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
            and k.BUNECELEM > 1000
          union
          select distinct ak.CISKRAVY, ak.DATKONTR
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = ak.CISCHOVU
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo
            and ak.BUNECELEM > 1000) as t



    /**priemer SB za kraj**/
    select distinct t.kraj,
                    t.nazov,
                    Count(*)                  as pocet_kontrol,
                    sum(BUNECELEM)            as spolu_SB,
                    sum(BUNECELEM) / Count(*) as priemer
    from (select distinct ch.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR, BUNECELEM
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(k.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
          union
          select distinct ch.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR, BUNECELEM
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj = SUBSTRING(ak.CISCHOVU, 1, 1)
                 left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo) as t
    group by t.kraj, t.nazov
    order by t.KRAJ

    /**SR priemer SB za SR**/
    select distinct Count(*) as SR_pocet_kontrol, sum(BUNECELEM) as SR_spolu_SB, sum(BUNECELEM) / Count(*) as SR_priemer
    from (select distinct k.CISKRAVY, k.DATKONTR, BUNECELEM
          from CM_Kontroly as k
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = k.CISCHOVU
              --left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where k.DATKONTR >= @datumOD
            and k.DATKONTR <= @datumDo
          union
          select distinct ak.CISKRAVY, ak.DATKONTR, BUNECELEM
          from CM_ArchKon as ak
                 left outer join NM_CHOVMAS as ch on ch.kraj + ch.OKRES + ch.PODNIK + ch.CHOV = ak.CISCHOVU
              --left outer join NC_KRAJ p on p.KRAJ = ch.kraj
          where ak.DATKONTR >= @datumOD
            and ak.DATKONTR <= @datumDo) as t
    --group by t.kraj, t.nazov
    --order by t.KRAJ


  end
go



---------------------------------------------------------------

CREATE procedure [dbo].[Rocenka_MLHD_Tab_15]
    @rok varchar(4)
	
as
begin

	
	select * 
	from plis.dbo.Roc_MLHD_Tab_15 as z
	where   z.rok = @rok
  ORDER BY Okres, mlieko desc 
end
go



-------------------------------------------------------------------

CREATE procedure  [dbo].[Roc_MLHD_12]
	@datumOd date,
	@datumDo date

	as 
	begin
    
    delete from Roc_MLHD_Tab_12 where rok = DATEPART(YEAR, @datumOd);
	
--declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31'
/***naj mastale podla kg bielkovin ***/

	--holstein
	declare @prvostky_H table(
		chov varchar(9),
		pocet_prvostok_na_chove int,
		/*bielk_max int,*/
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float
		)
	--slovenske strakate
	declare @prvostky_S table( 
		chov varchar(9),
		pocet_prvostok_na_chove int,
		/*bielk_max int,*/
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float
		)
	--Pinzgauske
		declare @prvostky_P table( 
		chov varchar(9),
		pocet_prvostok_na_chove int,
		/*bielk_max int,*/
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float
		)
	--Braunvieh
	declare @prvostky_B table( 
		chov varchar(9),
		pocet_prvostok_na_chove int,
		/*bielk_max int,*/
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float
		)

insert into @prvostky_H 
(chov,pocet_prvostok_na_chove, /*bielk_max, */okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
		select top 20 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				--ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,	
				count(Lakt.zmena)as pocet_N_lakt,
				ROUND(AVG(Lakt.LAKDNIN),2) as lakt_dni,
				ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
				ROUND(AVG(Lakt.TUKNOR),2) as tuk,
				ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
				ROUND(AVG(MEDZIOBD),2) as medziobd 
		
		FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
							left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
							--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
							left outer join NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
						 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
								or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
							and (eko.ZRUS is null or eko.datumZrusenia> @datumOd)
							and r.rok = DATEPART(YEAR,@datumOd)
							and SUBSTRING(r.stpec_5,1,1) in ('H','R')
							AND eko.TYPZV='1'
							and Lakt.MLIEKCEL <>''
							and Lakt.ZMENA in ('30','40')
							and Lakt.PORLAK= '1'
							
										
					group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV,r.stpec_5--, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'') 
					having count(lakt.CISKRAVY) >10
					order by ROUND(AVG(Lakt.BIELKNOR),2) desc
	--select * from @prvostky_H

	insert into @prvostky_S 
(chov,pocet_prvostok_na_chove, /*bielk_max, */okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
		select top 15 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				--ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,	
				count(Lakt.zmena)as pocet_N_lakt,
				ROUND(AVG(Lakt.LAKDNIN),2) as lakt_dni,
				ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
				ROUND(AVG(Lakt.TUKNOR),2) as tuk,
				ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
				ROUND(AVG(MEDZIOBD),2) as medziobd 
		
		FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
							left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
							--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
							left outer join  NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
						 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
								or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
							and eko.ZRUS is null AND eko.TYPZV='1'
							and r.rok = DATEPART(YEAR,@datumOd)
							and SUBSTRING(r.stpec_5,1,2) in ('S ','MB')
							and Lakt.MLIEKCEL <>''
							and Lakt.ZMENA in ('30','40')
							and Lakt.PORLAK= '1'
										
					group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV,r.stpec_5 --, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'')
					having count(lakt.CISKRAVY) >10
					order by ROUND(AVG(Lakt.BIELKNOR),2) desc
	
	insert into @prvostky_P 
	(chov,pocet_prvostok_na_chove, /*bielk_max, */okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
		select top 10 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				--ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,	
				count(Lakt.zmena)as pocet_N_lakt,
				ROUND(AVG(Lakt.LAKDNIN),2) as lakt_dni,
				ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
				ROUND(AVG(Lakt.TUKNOR),2) as tuk,
				ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
				ROUND(AVG(MEDZIOBD),2) as medziobd 
		
		FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
							left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
							--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
							left outer join  NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
						 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
								or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
							and r.rok = DATEPART(YEAR,@datumOd)
							and SUBSTRING(r.stpec_5,1,2) in ('P')
							and eko.ZRUS is null AND eko.TYPZV='1'
							and Lakt.MLIEKCEL <>''
							and Lakt.ZMENA in ('30','40')
							and Lakt.PORLAK= '1'
							
										
					group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV, r.stpec_5  --, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'')
					having count(lakt.CISKRAVY) >10
					order by ROUND(AVG(Lakt.BIELKNOR),2) desc
	
	insert into @prvostky_B
	(chov,pocet_prvostok_na_chove, /*bielk_max, */okres, podnik, mastal, char_ust, plem,pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
		select top 100 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				--ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,	
				count(Lakt.zmena)as pocet_N_lakt,
				ROUND(AVG(Lakt.LAKDNIN),2) as lakt_dni,
				ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
				ROUND(AVG(Lakt.TUKNOR),2) as tuk,
				ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
				ROUND(AVG(MEDZIOBD),2) as medziobd 
		
		FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
							left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
							--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
							left outer join  NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
						 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
								or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
							and r.rok = DATEPART(YEAR,@datumOd)
							and SUBSTRING(r.stpec_5,1,2) in ('B')
							and eko.ZRUS is null 
							AND eko.TYPZV='1'
							and Lakt.MLIEKCEL <>''
							and Lakt.ZMENA in ('30','40')
							and Lakt.PORLAK= '1'
							
										
					group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV, r.stpec_5 --, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'')
					having count(lakt.CISKRAVY) >10
					order by ROUND(AVG(Lakt.BIELKNOR),2) desc

	----declare @prvostky_fin table(
	----	chov varchar(9),
	----	pocet_prvostok_na_chove int,
	----	okres varchar(100),
	----	podnik varchar(100),
	----	mastal  varchar(100),
	----	char_ust  varchar(30),
	----	plem  varchar(10),
	----	pocet_N_lakt float,
	----	lakt_dni float,
	----	mlieko float, 
	----	tuk_P float,
	----	tuk float,
	----	bielk_P float,
	----	bielk float,
	----	vek_otel Varchar(10),
	----	plemeno varchar(5),
	----	rok int,
	----	B_M varchar(2)
	----	)
	insert into Roc_MLHD_Tab_12-- @prvostky_fin
			(chov,pocet_prvostok_na_chove, okres, podnik, mastal, char_ust, plem,pocet_N_lakt, lakt_dni, mlieko, tuk_P, tuk, bielk_P, bielk, vek_otel, plemeno, rok, B_M )
		select chov,pocet_prvostok_na_chove, okres, podnik, UPPER(mastal) AS mastal, char_ust, plem,	pocet_N_lakt, lakt_dni, mlieko, 
			ROUND(tuk / mlieko * 100, 2)as tuk_P, 
			tuk, 
			ROUND(bielk / mlieko * 100, 2)as bielk_P, 
			bielk, 
			convert(varchar, round(medziobd  / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, medziobd ) % 30.42, 0)) ) AS vek_otel,
			'H' as plemeno,
			DATEPART(YEAR, @datumOd) as rok, 
			'B' as B_M
		from @prvostky_H
	
	union

		select chov,pocet_prvostok_na_chove, okres, podnik, UPPER(mastal) AS mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, 
			ROUND(tuk / mlieko * 100, 2)as tuk_P, 
			tuk, 
			ROUND(bielk / mlieko * 100, 2)as bielk_P, 
			bielk, 
			convert(varchar, round(medziobd  / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, medziobd ) % 30.42, 0)) ) AS vek_otel,
			'S' as plemeno,
			DATEPART(YEAR, @datumOd) as rok, 
			'B' as B_M
		from @prvostky_S

	union

		select chov,pocet_prvostok_na_chove, okres, podnik, UPPER(mastal) AS mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, 
			ROUND(tuk / mlieko * 100, 2)as tuk_P, 
			tuk, 
			ROUND(bielk / mlieko * 100, 2)as bielk_P, 
			bielk, 
			convert(varchar, round(medziobd  / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, medziobd ) % 30.42, 0)) ) AS vek_otel,
			'P' as plemeno,
			DATEPART(YEAR, @datumOd) as rok, 
			'B' as B_M
		from @prvostky_P

	union

		select chov,pocet_prvostok_na_chove, okres, podnik, UPPER(mastal) AS mastal, char_ust, plem,	pocet_N_lakt, lakt_dni, mlieko, 
			ROUND(tuk / mlieko * 100, 2)as tuk_P, 
			tuk, 
			ROUND(bielk / mlieko * 100, 2)as bielk_P, 
			bielk, 
			convert(varchar, round(medziobd  / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, medziobd ) % 30.42, 0)) ) AS vek_otel,
			'B' as plemeno,
			DATEPART(YEAR, @datumOd) as rok, 
			'B' as B_M
		from @prvostky_B


----select * from @prvostky_fin where rok = '2017' and B_M = 'B'
----	order by plemeno, bielk desc

/***naj mastale podla kg mlieka ***/

	--holstein
	declare @prvostkyM_H table(
		chov varchar(9),
		pocet_prvostok_na_chove int,
		/*bielk_max int,*/
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float
		)
	--slovenske strakate
	declare @prvostkyM_S table( 
		chov varchar(9),
		pocet_prvostok_na_chove int,
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float
		)
	--Pinzgauske
		declare @prvostkyM_P table( 
		chov varchar(9),
		pocet_prvostok_na_chove int,
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float
		)
	--Braunvieh
	declare @prvostkyM_B table( 
		chov varchar(9),
		pocet_prvostok_na_chove int,
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float
		)

insert into @prvostkyM_H 
(chov,pocet_prvostok_na_chove, okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
		select top 20 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				--ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,
				count(Lakt.zmena)as pocet_N_lakt,	
				ROUND(AVG(Lakt.LAKDNIN),2) as lakt_dni,
				ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
				ROUND(AVG(Lakt.TUKNOR),2) as tuk,
				ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
				ROUND(AVG(MEDZIOBD),2) as medziobd 
		
		FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
							left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
							--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
							left outer join NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
						 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
								or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
							and (eko.ZRUS is null or eko.datumZrusenia> @datumOd)
							and r.rok = DATEPART(YEAR,@datumOd)
							and SUBSTRING(r.stpec_5,1,1) in ('H','R')
							AND eko.TYPZV='1'
							and Lakt.MLIEKCEL <>''
							and Lakt.ZMENA in ('30','40')
							and Lakt.PORLAK= '1'
							
										
					group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV,r.stpec_5--, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'') 
					having count(lakt.CISKRAVY) >10
					order by ROUND(AVG(Lakt.MLIEKNOR),2) desc
	--select * from @prvostky_H

	insert into @prvostkyM_S 
(chov,pocet_prvostok_na_chove, /*bielk_max, */okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
		select top 15 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				--ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,	
				count(Lakt.zmena)as pocet_N_lakt,
				ROUND(AVG(Lakt.LAKDNIN),2) as lakt_dni,
				ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
				ROUND(AVG(Lakt.TUKNOR),2) as tuk,
				ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
				ROUND(AVG(MEDZIOBD),2) as medziobd 
		
		FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
							left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
							--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
							left outer join  NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
						 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
								or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
							and eko.ZRUS is null AND eko.TYPZV='1'
							and r.rok = DATEPART(YEAR,@datumOd)
							and SUBSTRING(r.stpec_5,1,2) in ('S ','MB')
							and Lakt.MLIEKCEL <>''
							and Lakt.ZMENA in ('30','40')
							and Lakt.PORLAK= '1'
										
					group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV,r.stpec_5 --, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'')
					having count(lakt.CISKRAVY) >10
					order by ROUND(AVG(Lakt.MLIEKNOR),2) desc
	
	insert into @prvostkyM_P 
	(chov,pocet_prvostok_na_chove, /*bielk_max, */okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
		select top 10 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				--ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,
				count(Lakt.zmena)as pocet_N_lakt,	
				ROUND(AVG(Lakt.LAKDNIN),2) as lakt_dni,
				ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
				ROUND(AVG(Lakt.TUKNOR),2) as tuk,
				ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
				ROUND(AVG(MEDZIOBD),2) as medziobd 
		
		FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
							left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
							--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
							left outer join  NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
						 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
								or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
							and r.rok = DATEPART(YEAR,@datumOd)
							and SUBSTRING(r.stpec_5,1,2) in ('P')
							and eko.ZRUS is null AND eko.TYPZV='1'
							and Lakt.MLIEKCEL <>''
							and Lakt.ZMENA in ('30','40')
							and Lakt.PORLAK= '1'
							
										
					group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV, r.stpec_5  --, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'')
					having count(lakt.CISKRAVY) >10
					order by ROUND(AVG(Lakt.MLIEKNOR),2) desc
	
	insert into @prvostkyM_B
	(chov,pocet_prvostok_na_chove, /*bielk_max, */okres, podnik, mastal, char_ust, plem,pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
		select top 100 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				--ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,	
				count(Lakt.zmena)as pocet_N_lakt,
				ROUND(AVG(Lakt.LAKDNIN),2) as lakt_dni,
				ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
				ROUND(AVG(Lakt.TUKNOR),2) as tuk,
				ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
				ROUND(AVG(MEDZIOBD),2) as medziobd 
		
		FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
							left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
							--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
							left outer join  NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
						 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
								or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
							and r.rok = DATEPART(YEAR,@datumOd)
							and SUBSTRING(r.stpec_5,1,2) in ('B')
							and eko.ZRUS is null 
							AND eko.TYPZV='1'
							and Lakt.MLIEKCEL <>''
							and Lakt.ZMENA in ('30','40')
							and Lakt.PORLAK= '1'
							
										
					group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV, r.stpec_5 --, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'')
					having count(lakt.CISKRAVY) >10
					order by ROUND(AVG(Lakt.MLIEKNOR),2) desc


	insert into Roc_MLHD_Tab_12--@prvostky_fin
			(chov,pocet_prvostok_na_chove, okres, podnik, mastal, char_ust, plem,pocet_N_lakt, lakt_dni, mlieko, tuk_P, tuk, bielk_P, bielk, vek_otel, plemeno, rok, B_M)
		select chov,pocet_prvostok_na_chove, okres, podnik, mastal, char_ust, plem,	pocet_N_lakt, lakt_dni, mlieko, 
			ROUND(tuk / mlieko * 100, 2)as tuk_P, 
			tuk, 
			ROUND(bielk / mlieko * 100, 2)as bielk_P, 
			bielk, 
			convert(varchar, round(medziobd  / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, medziobd ) % 30.42, 0)) ) AS vek_otel,
			'H' as plemeno,
			DATEPART(YEAR, @datumOd) as rok, 
			'M' as B_M
		from @prvostkyM_H
	
	union

		select chov,pocet_prvostok_na_chove, okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, 
			ROUND(tuk / mlieko * 100, 2)as tuk_P, 
			tuk, 
			ROUND(bielk / mlieko * 100, 2)as bielk_P, 
			bielk, 
			convert(varchar, round(medziobd  / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, medziobd ) % 30.42, 0)) ) AS vek_otel,
			'S' as plemeno,
			DATEPART(YEAR, @datumOd) as rok, 
			'M' as B_M
		from @prvostkyM_S

	union

		select chov,pocet_prvostok_na_chove, okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, 
			ROUND(tuk / mlieko * 100, 2)as tuk_P, 
			tuk, 
			ROUND(bielk / mlieko * 100, 2)as bielk_P, 
			bielk, 
			convert(varchar, round(medziobd  / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, medziobd ) % 30.42, 0)) ) AS vek_otel,
			'P' as plemeno,
			DATEPART(YEAR, @datumOd) as rok, 
			'M' as B_M
		from @prvostkyM_P

	union

		select chov,pocet_prvostok_na_chove, okres, podnik, mastal, char_ust, plem,	pocet_N_lakt, lakt_dni, mlieko, 
			ROUND(tuk / mlieko * 100, 2)as tuk_P, 
			tuk, 
			ROUND(bielk / mlieko * 100, 2)as bielk_P, 
			bielk, 
			convert(varchar, round(medziobd  / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, medziobd ) % 30.42, 0)) ) AS vek_otel,
			'B' as plemeno,
			DATEPART(YEAR, @datumOd) as rok, 
			'M' as B_M
		from @prvostkyM_B


----select * from @prvostky_fin where rok='2017' and B_M = 'M'
----	order by plemeno, mlieko desc


	END
go



-----------------------------------------------------------------------------

CREATE procedure  [dbo].[Roc_MLHD_7]
	
	@datumOd date,
	@datumDo date

	as 
	begin
		
		delete from Roc_MLHD_Tab_7 where ROK = DATEPART(YEAR, @datumOd);

	--declare @datumOd date, @datumDo date
	--set @datumOd = '2017-01-01'
	--set @datumDo = '2017-11-30'

	--create table Roc_MLHD_Tab_7
	--	(
	--	KRAJ varchar (35),
	--	CISKRAVY varchar(14),
	--	OKRES varchar(35),
	--	PODNIK varchar(35),
	--	CHOV varchar(35),
	--	OTEC varchar (8),
	--	PLEM varchar(50),
	--	PORLAK int,
	--	MLIEKNOR int,
	--	TUKPERC float,
	--	TUKNOR float,
	--	BIELKPERC float,
	--	BIELKNOR float,
	--	CHOVATEL varchar(9),
	--	ROK varchar(4),
	--	)
	
	insert into Roc_MLHD_Tab_7
		SELECT top 1 
			'Bratislavský' as Kraj
			,lakt.CISKRAVY
			,o.NAZOV as OKRES
			,p.NAZOVSKR as PODNIK
			,ch.NAZOV as Chov
			,(k.OTECLIN + '-' + RIGHT ('000' + CONVERT (varchar, k.OTECREG), 3)) AS Otec
			,ISNULL(k.PL1 + '-' + CONVERT (varchar, k.KR1), '') /*+ '  ' + ISNULL(k.PL2, '')
			  + ISNULL(k.PL3,'') + ISNULL(k.PL4,'') + ISNULL(k.PL5,'')*/  AS PLEM
			,PORLAK
			--,MLIEKCEL
			,MLIEKNOR
			,round((lakt.TUKNOR*100)/lakt.MLIEKNOR,2) as TUKPERC
			,TUKNOR
			,round(((lakt.BIELKNOR*100)/lakt.MLIEKNOR),2) as BIELKPERC
			,BIELKNOR
			,lakt.CHOVATEL
			,DATEPART(YEAR, @datumOd) as Rok    
	
		  FROM [dbo].[View_CP_LaktaciePreZostavy] as Lakt
		  left outer join CM_Krava as k on Lakt.CISKRAVY = k.CISKRAVY
		  left outer join NM_PODNIK as p on p.KRAJ + p.OKRES + p.PODNIK = lakt.podnik
		  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = Lakt.okres
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV = Lakt.CHOVATEL

		  where BIELKNOR > 0
				and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.ZMENA in ('30','40')
				--and k.PL1 in ('H','R')
				--and Lakt.MLIEKCEL <>''
				and ((lakt.TUKNOR*100)/lakt.MLIEKNOR ) < 6
				and ((lakt.BIELKNOR*100)/lakt.MLIEKNOR) < 5
				and (ch.ZRUS is null or (ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
					and ch.TYPZV='1'
--				and DATEPART(year,k.DATPOSKONT) = DATEPART(YEAR, @datumOd)
				and SUBSTRING(lakt.CHOVATEL,1,1) ='1'
		order by lakt.MLIEKNOR desc

	insert into Roc_MLHD_Tab_7
		SELECT top 1 
			'Trnavský' as Kraj
			,lakt.CISKRAVY
			,o.NAZOV as OKRES
			,p.NAZOVSKR as PODNIK
			,ch.NAZOV as Chov
			,(k.OTECLIN + '-' + RIGHT ('000' + CONVERT (varchar, k.OTECREG), 3)) AS Otec
			,ISNULL(k.PL1 + '-' + CONVERT (varchar, k.KR1), '') /*+ '  ' + ISNULL(k.PL2, '')
			  + ISNULL(k.PL3,'') + ISNULL(k.PL4,'') + ISNULL(k.PL5,'')*/  AS PLEM
			,PORLAK
			--,MLIEKCEL
			,MLIEKNOR
			,round((lakt.TUKNOR*100)/lakt.MLIEKNOR,2) as TUKPERC
			,TUKNOR
			,round(((lakt.BIELKNOR*100)/lakt.MLIEKNOR),2) as BIELKPERC
			,BIELKNOR
			,lakt.CHOVATEL
			,DATEPART(YEAR, @datumOd) as Rok    
	
		  FROM [dbo].[View_CP_LaktaciePreZostavy] as Lakt
		  left outer join CM_Krava as k on Lakt.CISKRAVY = k.CISKRAVY
		  left outer join NM_PODNIK as p on p.KRAJ + p.OKRES + p.PODNIK = lakt.podnik
		  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = Lakt.okres
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV = Lakt.CHOVATEL

		  where BIELKNOR > 0
				and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.ZMENA in ('30','40')
				--and k.PL1 in ('H','R')
				--and Lakt.MLIEKCEL <>''
				and ((lakt.TUKNOR*100)/lakt.MLIEKNOR ) < 6
				and ((lakt.BIELKNOR*100)/lakt.MLIEKNOR) < 5
				and (ch.ZRUS is null or (ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
					and ch.TYPZV='1'
--				and DATEPART(year,k.DATPOSKONT) = DATEPART(YEAR, @datumOd)
				and SUBSTRING(lakt.CHOVATEL,1,1)='2'
		order by lakt.MLIEKNOR desc
		
	insert into Roc_MLHD_Tab_7
		SELECT top 1 
			'Trenčiansky' as Kraj
			,lakt.CISKRAVY
			,o.NAZOV as OKRES
			,p.NAZOVSKR as PODNIK
			,ch.NAZOV as Chov
			,(k.OTECLIN + '-' + RIGHT ('000' + CONVERT (varchar, k.OTECREG), 3)) AS Otec
			,ISNULL(k.PL1 + '-' + CONVERT (varchar, k.KR1), '') /*+ '  ' + ISNULL(k.PL2, '')
			  + ISNULL(k.PL3,'') + ISNULL(k.PL4,'') + ISNULL(k.PL5,'')*/  AS PLEM
			,PORLAK
			--,MLIEKCEL
			,MLIEKNOR
			,round((lakt.TUKNOR*100)/lakt.MLIEKNOR,2) as TUKPERC
			,TUKNOR
			,round(((lakt.BIELKNOR*100)/lakt.MLIEKNOR),2) as BIELKPERC
			,BIELKNOR
			,lakt.CHOVATEL
			,DATEPART(YEAR, @datumOd) as Rok    
	
		  FROM [dbo].[View_CP_LaktaciePreZostavy] as Lakt
		  left outer join CM_Krava as k on Lakt.CISKRAVY = k.CISKRAVY
		  left outer join NM_PODNIK as p on p.KRAJ + p.OKRES + p.PODNIK = lakt.podnik
		  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = Lakt.okres
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV = Lakt.CHOVATEL

		  where BIELKNOR > 0
				and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.ZMENA in ('30','40')
				--and k.PL1 in ('H','R')
				--and Lakt.MLIEKCEL <>''
				and ((lakt.TUKNOR*100)/lakt.MLIEKNOR ) < 6
				and ((lakt.BIELKNOR*100)/lakt.MLIEKNOR) < 5
				and (ch.ZRUS is null or (ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
					and ch.TYPZV='1'
--				and DATEPART(year,k.DATPOSKONT) = DATEPART(YEAR, @datumOd)
				and SUBSTRING(lakt.CHOVATEL,1,1)='3'
		order by lakt.MLIEKNOR desc

	insert into Roc_MLHD_Tab_7
		SELECT top 1 
			'Nitriansky' as Kraj
			,lakt.CISKRAVY
			,o.NAZOV as OKRES
			,p.NAZOVSKR as PODNIK
			,ch.NAZOV as Chov
			,(k.OTECLIN + '-' + RIGHT ('000' + CONVERT (varchar, k.OTECREG), 3)) AS Otec
			,ISNULL(k.PL1 + '-' + CONVERT (varchar, k.KR1), '') /*+ '  ' + ISNULL(k.PL2, '')
			  + ISNULL(k.PL3,'') + ISNULL(k.PL4,'') + ISNULL(k.PL5,'')*/  AS PLEM
			,PORLAK
			--,MLIEKCEL
			,MLIEKNOR
			,round((lakt.TUKNOR*100)/lakt.MLIEKNOR,2) as TUKPERC
			,TUKNOR
			,round(((lakt.BIELKNOR*100)/lakt.MLIEKNOR),2) as BIELKPERC
			,BIELKNOR
			,lakt.CHOVATEL
			,DATEPART(YEAR, @datumOd) as Rok    
	
		  FROM [dbo].[View_CP_LaktaciePreZostavy] as Lakt
		  left outer join CM_Krava as k on Lakt.CISKRAVY = k.CISKRAVY
		  left outer join NM_PODNIK as p on p.KRAJ + p.OKRES + p.PODNIK = lakt.podnik
		  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = Lakt.okres
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV = Lakt.CHOVATEL

		  where BIELKNOR > 0
				and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.ZMENA in ('30','40')
				--and k.PL1 in ('H','R')
				--and Lakt.MLIEKCEL <>''
				and ((lakt.TUKNOR*100)/lakt.MLIEKNOR ) < 6
				and ((lakt.BIELKNOR*100)/lakt.MLIEKNOR) < 5
				and (ch.ZRUS is null or (ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
					and ch.TYPZV='1'
--				and DATEPART(year,k.DATPOSKONT) = DATEPART(YEAR, @datumOd)
				and SUBSTRING(lakt.CHOVATEL,1,1)='4'
		order by lakt.MLIEKNOR desc

	insert into Roc_MLHD_Tab_7
		SELECT top 1 
			'Žilinský' as Kraj
			,lakt.CISKRAVY
			,o.NAZOV as OKRES
			,p.NAZOVSKR as PODNIK
			,ch.NAZOV as Chov
			,(k.OTECLIN + '-' + RIGHT ('000' + CONVERT (varchar, k.OTECREG), 3)) AS Otec
			,ISNULL(k.PL1 + '-' + CONVERT (varchar, k.KR1), '') /*+ '  ' + ISNULL(k.PL2, '')
			  + ISNULL(k.PL3,'') + ISNULL(k.PL4,'') + ISNULL(k.PL5,'')*/  AS PLEM
			,PORLAK
			--,MLIEKCEL
			,MLIEKNOR
			,round((lakt.TUKNOR*100)/lakt.MLIEKNOR,2) as TUKPERC
			,TUKNOR
			,round(((lakt.BIELKNOR*100)/lakt.MLIEKNOR),2) as BIELKPERC
			,BIELKNOR
			,lakt.CHOVATEL
			,DATEPART(YEAR, @datumOd) as Rok    
	
		  FROM [dbo].[View_CP_LaktaciePreZostavy] as Lakt
		  left outer join CM_Krava as k on Lakt.CISKRAVY = k.CISKRAVY
		  left outer join NM_PODNIK as p on p.KRAJ + p.OKRES + p.PODNIK = lakt.podnik
		  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = Lakt.okres
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV = Lakt.CHOVATEL

		  where BIELKNOR > 0
				and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.ZMENA in ('30','40')
				--and k.PL1 in ('H','R')
				--and Lakt.MLIEKCEL <>''
				and ((lakt.TUKNOR*100)/lakt.MLIEKNOR ) < 6
				and ((lakt.BIELKNOR*100)/lakt.MLIEKNOR) < 5
				and (ch.ZRUS is null or (ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
					and ch.TYPZV='1'
--				and DATEPART(year,k.DATPOSKONT) = DATEPART(YEAR, @datumOd)
				and SUBSTRING(lakt.CHOVATEL,1,1)='5'
		order by lakt.MLIEKNOR desc

	insert into Roc_MLHD_Tab_7
		SELECT top 1 
			'Banskobystrický' as Kraj
			,lakt.CISKRAVY
			,o.NAZOV as OKRES
			,p.NAZOVSKR as PODNIK
			,ch.NAZOV as Chov
			,(k.OTECLIN + '-' + RIGHT ('000' + CONVERT (varchar, k.OTECREG), 3)) AS Otec
			,ISNULL(k.PL1 + '-' + CONVERT (varchar, k.KR1), '') /*+ '  ' + ISNULL(k.PL2, '')
			  + ISNULL(k.PL3,'') + ISNULL(k.PL4,'') + ISNULL(k.PL5,'')*/  AS PLEM
			,PORLAK
			--,MLIEKCEL
			,MLIEKNOR
			,round((lakt.TUKNOR*100)/lakt.MLIEKNOR,2) as TUKPERC
			,TUKNOR
			,round(((lakt.BIELKNOR*100)/lakt.MLIEKNOR),2) as BIELKPERC
			,BIELKNOR
			,lakt.CHOVATEL
			,DATEPART(YEAR, @datumOd) as Rok    
	
		  FROM [dbo].[View_CP_LaktaciePreZostavy] as Lakt
		  left outer join CM_Krava as k on Lakt.CISKRAVY = k.CISKRAVY
		  left outer join NM_PODNIK as p on p.KRAJ + p.OKRES + p.PODNIK = lakt.podnik
		  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = Lakt.okres
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV = Lakt.CHOVATEL

		  where BIELKNOR > 0
				and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.ZMENA in ('30','40')
				--and k.PL1 in ('H','R')
				--and Lakt.MLIEKCEL <>''
				and ((lakt.TUKNOR*100)/lakt.MLIEKNOR ) < 6
				and ((lakt.BIELKNOR*100)/lakt.MLIEKNOR) < 5
				and (ch.ZRUS is null or (ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
					and ch.TYPZV='1'
--				and DATEPART(year,k.DATPOSKONT) = DATEPART(YEAR, @datumOd)
				and SUBSTRING(lakt.CHOVATEL,1,1)='6'
		order by lakt.MLIEKNOR desc

	insert into Roc_MLHD_Tab_7
		SELECT top 1 
			'Prešovský' as Kraj
			,lakt.CISKRAVY
			,o.NAZOV as OKRES
			,p.NAZOVSKR as PODNIK
			,ch.NAZOV as Chov
			,(k.OTECLIN + '-' + RIGHT ('000' + CONVERT (varchar, k.OTECREG), 3)) AS Otec
			,ISNULL(k.PL1 + '-' + CONVERT (varchar, k.KR1), '') /*+ '  ' + ISNULL(k.PL2, '')
			  + ISNULL(k.PL3,'') + ISNULL(k.PL4,'') + ISNULL(k.PL5,'')*/  AS PLEM
			,PORLAK
			--,MLIEKCEL
			,MLIEKNOR
			,round((lakt.TUKNOR*100)/lakt.MLIEKNOR,2) as TUKPERC
			,TUKNOR
			,round(((lakt.BIELKNOR*100)/lakt.MLIEKNOR),2) as BIELKPERC
			,BIELKNOR
			,lakt.CHOVATEL
			,DATEPART(YEAR, @datumOd) as Rok    
	
		  FROM [dbo].[View_CP_LaktaciePreZostavy] as Lakt
		  left outer join CM_Krava as k on Lakt.CISKRAVY = k.CISKRAVY
		  left outer join NM_PODNIK as p on p.KRAJ + p.OKRES + p.PODNIK = lakt.podnik
		  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = Lakt.okres
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV = Lakt.CHOVATEL

		  where BIELKNOR > 0
				and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.ZMENA in ('30','40')
				--and k.PL1 in ('H','R')
				--and Lakt.MLIEKCEL <>''
				and ((lakt.TUKNOR*100)/lakt.MLIEKNOR ) < 6
				and ((lakt.BIELKNOR*100)/lakt.MLIEKNOR) < 5
				and (ch.ZRUS is null or (ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
					and ch.TYPZV='1'
--				and DATEPART(year,k.DATPOSKONT) = DATEPART(YEAR, @datumOd)
				and SUBSTRING(lakt.CHOVATEL,1,1)='7'
		order by lakt.MLIEKNOR desc
	
	insert into Roc_MLHD_Tab_7
		SELECT top 1 
			'Košický' as Kraj
			,lakt.CISKRAVY
			,o.NAZOV as OKRES
			,p.NAZOVSKR as PODNIK
			,ch.NAZOV as Chov
			,(k.OTECLIN + '-' + RIGHT ('000' + CONVERT (varchar, k.OTECREG), 3)) AS Otec
			,ISNULL(k.PL1 + '-' + CONVERT (varchar, k.KR1), '') /*+ '  ' + ISNULL(k.PL2, '')
			  + ISNULL(k.PL3,'') + ISNULL(k.PL4,'') + ISNULL(k.PL5,'')*/  AS PLEM
			,PORLAK
			--,MLIEKCEL
			,MLIEKNOR
			,round((lakt.TUKNOR*100)/lakt.MLIEKNOR,2) as TUKPERC
			,TUKNOR
			,round(((lakt.BIELKNOR*100)/lakt.MLIEKNOR),2) as BIELKPERC
			,BIELKNOR
			,lakt.CHOVATEL
			,DATEPART(YEAR, @datumOd) as Rok    
	
		  FROM [dbo].[View_CP_LaktaciePreZostavy] as Lakt
		  left outer join CM_Krava as k on Lakt.CISKRAVY = k.CISKRAVY
		  left outer join NM_PODNIK as p on p.KRAJ + p.OKRES + p.PODNIK = lakt.podnik
		  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = Lakt.okres
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV = Lakt.CHOVATEL

		  where BIELKNOR > 0
				and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.ZMENA in ('30','40')
				--and k.PL1 in ('H','R')
				--and Lakt.MLIEKCEL <>''
				and ((lakt.TUKNOR*100)/lakt.MLIEKNOR ) < 6
				and ((lakt.BIELKNOR*100)/lakt.MLIEKNOR) < 5
				and (ch.ZRUS is null or (ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
					and ch.TYPZV='1'
--				and DATEPART(year,k.DATPOSKONT) = DATEPART(YEAR, @datumOd)
				and SUBSTRING(lakt.CHOVATEL,1,1)='8'
		order by lakt.MLIEKNOR desc

end
go


---------------------------------------------------------------------------------------------



CREATE procedure  [dbo].[Roc_MLHD_20]
	@datumOd date,
	@datumDo date,
	--@datumPolRok date, /*='2017-09-30'*/  --- kvoli priemernemu veku k 30.9. 
	@datumFakturOd date,  /*'2017-12-13'*/
	@datumFakturDo date		 /*'2018-01-04'*/

	as 
	begin
	delete from Roc_MLHD_Tab_20 where rok = DATEPART(YEAR, @datumOd)

-- !!!!!!!!!!!!!!!! 
--declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31', @datumPolRok date ='2017-09-30'
--!!!!!!!!!!!!!!!!!!

declare @tab1 table
(
	[Por] bigint ,
	[kod] [varchar](3) NULL,
	[Oznacenie] [varchar](3) NULL,
	[stlpec_6] [varchar](30) NULL,
	[stlpec_7] [int] NULL,
	[stlpec_8] [int] NULL,
	[stlpec_9] [int] NULL,
	[stlpec_10] [float] NULL,
	[stlpec_11] [int] NULL,
	[stlpec_12] [float] NULL,
	[stlpec_13] [int] NULL,
	[stlpec_14Mesiac] [int] NULL,
	[stlpec_14Den] [int] NULL,
	[stlpec_15] [int] NULL,
	[stlpec_16] [int] NULL,
	[stlpec_17] [int] NULL,
	[stlpec_18] [float] NULL,
	[stlpec_19] [int] NULL,
	[stlpec_20] [float] NULL,
	[stlpec_21] [int] NULL,
	[stlpec_22] [int] NULL,
	[stlpec_23] [int] NULL,
	[stlpec_24] [int] NULL,
	[stlpec_25] [int] NULL,
	[stlpec_26] [float] NULL,
	[stlpec_27] [int] NULL,
	[stlpec_28] [float] NULL,
	[stlpec_29] [int] NULL,
	[stlpec_30] [int] NULL,
	[stlpec_31] [float] NULL,
	[stlpec_32_1] [int] NULL,
	[stlpec_32_2] [int] NULL,
	[rok] [varchar](4) NULL,
	[stlpec_14] [varchar](8) NULL,
	[stlpec_32] [varchar](8) NULL
)

insert into @tab1
	(kod, Oznacenie,stlpec_6,stlpec_7,stlpec_8,stlpec_9,stlpec_10,stlpec_11,stlpec_12,stlpec_13,stlpec_14Den, stlpec_14Mesiac, stlpec_15,stlpec_16,stlpec_17 ,stlpec_18,stlpec_19 ,stlpec_20,stlpec_21 ,stlpec_22,stlpec_23,stlpec_24
      ,stlpec_25 ,stlpec_26,stlpec_27,stlpec_28 ,stlpec_29, stlpec_32_1, stlpec_32_2, rok 
	)
select 
	(case when len(l.oznacenie)=1 then l.oznacenie+'99'
		else l.oznacenie end) as kod,
	l.oznacenie as Oznacenie,
	(case when len(l.oznacenie)=3 then o.NAZOV 
		when l.Oznacenie= '1' then 'Bratislavský kraj'
		when l.Oznacenie= '2' then 'Trnavský kraj'
		when l.Oznacenie= '3' then 'Trenčiansky kraj'
		when l.Oznacenie= '4' then 'Nitriansky kraj'
		when l.Oznacenie= '5' then 'Žilinský kraj'
		when l.Oznacenie= '6' then 'Banskobystrický kraj'
		when l.Oznacenie= '7' then 'Prešovský kraj'
		when l.Oznacenie= '8' then 'Košický kraj'
		when l.oznacenie='SR' then 'SR' end) as stlpec_6
	,l.PocLakN1 as stlpec_7
	,round(l.LakdniNL1,0) as stlpec_8
	,round(l.MliekNorL1,0) as stlpec_9
	,round((l.TukNorL1*100)/l.MliekNorL1,2) as stlpec_10
	,round(l.TukNorL1,0) as stlpec_11
	,round((l.BielkNorL1*100)/l.MliekNorL1,2) as stlpec_12
	,round(l.BielkNorL1,0) as stlpec_13
	--,l.MedziobdL1 as stlpec_14
	,(select val from string2table (l.MedziobdL1,'/') where seq = 1) as stpec_14Den
	,(select val from string2table (l.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
	,l.PocLakN2 as stlpec_15
	,round(l.LakDniNL2,0) as stlpec_16
	,round(l.MliekNorL2,0) as stlpec_17
	,round((l.TukNorL2*100)/l.MliekNorL2,2) as stlpec_18
	,round(l.TukNorL2,0) as stlpec_19
	,round((l.BielkNorL2*100)/l.MliekNorL2,2) as stlpec_20
	,round(l.BielkNorL2,0) as stlpec_21
	,round(l.MedziobdL2,0) as stlpec_22
	,l.PocLakNcelk as stlpec_23
	,round(l.LakDniNCelk,0) as stlpec_24
	,round(l.MliekNorCelk,0) as stlpec_25
	,round((l.TukNorCelk*100)/l.MliekNorCelk,2) as stlpec_26
	,round(l.TukNorCelk,0) as stlpec_27
	,round((l.BielkNorCelk*100)/l.MliekNorCelk,2) as stlpec_28
	,round(l.BielkNorCelk,0) as stpec_29
	,convert(varchar, round(l.MedziobdCelk / 30.42, 0)) as stlpec_32_1
	,convert(varchar, convert(decimal(5,0), ROUND( convert(int, l.MedziobdCelk) % 30.42, 0)) ) AS  stlpec_32_2
	,datepart(year,@datumOd) as rok

		from CR_LaktacneZostavy_Opr as l
			left outer join NC_Okres as o on o.kraj+o.okres = l.oznacenie
			left outer join NC_Kraj as k on k.kraj = l.oznacenie
		where l.datumOd=@datumOd and l.datumDo= @datumDo
			and ((len(l.filter)=3 and l.oznacenie =l.filter) or (len(l.filter)=1 and l.oznacenie =l.filter) or Filter='SR')
			and l.Region is null

		order by Oznacenie
	--select * from @tab1
	--order by kod

----------------------------------------------------------------------------------------------------------------------------------------
	/***vypocet prisposobeny fakturacii...aby sedeli pocty***/
	declare @stavKrav table
		(
		oznacenie varchar(3), 
		pocet_krav int
		) 
		insert into @stavKrav
			select distinct c.KRAJ as oznacenie, count( distinct k.ciskravy ) as pocet_krav---kraje
				from NM_CHOVMAS as c
					inner join NM_HDDETAIL as h on h.kraj+h.OKRES+h.PODNIK+h.CHOV=c.kraj+c.OKRES+ c.PODNIK+c.CHOV and h.PRIZNAK='01' and h.SPVYKON not in ('0','4','5') and h.TECHUSMD ='00'
	  				inner join CM_Krava as k on c.kraj+c.OKRES+ c.PODNIK+c.CHOV = k.CHOVATEL and (k.DOVVYR is null) and k.datzar <=@datumFakturDo /*'2018-01-04'*/ 
				where  c.TYPZV='1'
					and c.ZRUS is null
				group by c.kraj
				
		union 
			select distinct c.KRAJ+c.OKRES as oznacenie, count( distinct k.ciskravy ) as pocet_krav---kraje
				from NM_CHOVMAS as c
					inner join NM_HDDETAIL as h on h.kraj+h.OKRES+h.PODNIK+h.CHOV=c.kraj+c.OKRES+ c.PODNIK+c.CHOV and h.PRIZNAK='01' and h.SPVYKON not in ('0','4','5') and h.TECHUSMD ='00'
	  				inner join CM_Krava as k on c.kraj+c.OKRES+ c.PODNIK+c.CHOV = k.CHOVATEL and (k.DOVVYR is null) and k.datzar <= @datumFakturDo /*'2018-01-04'*/ 
				where  c.TYPZV='1'
					and c.ZRUS is null
				group by c.KRAJ+c.OKRES
		union 
			select 'SR' as oznacenie, count( distinct k.ciskravy ) as pocet_krav---SLOVENSKO
				from NM_CHOVMAS as c
					inner join NM_HDDETAIL as h on h.kraj+h.OKRES+h.PODNIK+h.CHOV=c.kraj+c.OKRES+ c.PODNIK+c.CHOV and h.PRIZNAK='01' and h.SPVYKON not in ('0','4','5') and h.TECHUSMD ='00'
	  				inner join CM_Krava as k on c.kraj+c.OKRES+ c.PODNIK+c.CHOV = k.CHOVATEL and (k.DOVVYR is null) and k.datzar <= @datumFakturDo /*'2018-01-04'*/ 
				where  c.TYPZV='1'
					and c.ZRUS is null
					
	--select * from @stavKrav
	---------------------------------------------------------------------------------------------------------------
--/**--priem poradie laktacie**/
	declare @porlak table
	(
	oznacenie varchar(3), 
	porlak float
	)
	insert into @porlak
		select SUBSTRING(CHOVATEL,1,3) as oznacenie , convert(decimal(5,2),AVG(PORLAK *1.0)) as porlak 
			from View_CP_LaktaciePreZostavy	
				where ZMENA in ('30','40') 
				and ((DATUKONL >= @datumOd and DATUKONL <= @datumDo) and (DATUKNORL is null or DATUKNORL >= @datumOd) 
							or (DATUKNORL >= @datumOd and DATUKNORL <= @datumDo))
				group by SUBSTRING(CHOVATEL,1,3)
	union 
		select SUBSTRING(CHOVATEL,1,1) as oznacenie , convert(decimal(5,2),AVG(PORLAK *1.0)) as porlak 
			from View_CP_LaktaciePreZostavy	
				where ZMENA in ('30','40') 
				and ((DATUKONL >= @datumOd and DATUKONL <= @datumDo) and (DATUKNORL is null or DATUKNORL >= @datumOd) 
							or (DATUKNORL >= @datumOd and DATUKNORL <= @datumDo))
				group by SUBSTRING(CHOVATEL,1,1)
	union
		select 'SR' as oznacenie , convert(decimal(5,2),AVG(PORLAK *1.0)) as porlak 
			from View_CP_LaktaciePreZostavy	
				where ZMENA in ('30','40') 
				and ((DATUKONL >= @datumOd and DATUKONL <= @datumDo) and (DATUKNORL is null or DATUKNORL >= @datumOd) 
							or (DATUKNORL >= @datumOd and DATUKNORL <= @datumDo))
	--select * from @porlak 
	--order by oznacenie

	insert into Roc_MLHD_Tab_20
	(
	Por,stlpec_6,stlpec_7,stlpec_8,stlpec_9,stlpec_10,stlpec_11,stlpec_12,stlpec_13,stlpec_14Mesiac ,stlpec_14Den, stlpec_15,stlpec_16,stlpec_17 ,stlpec_18,stlpec_19 ,stlpec_20,stlpec_21 ,stlpec_22,stlpec_23,stlpec_24
      ,stlpec_25 ,stlpec_26,stlpec_27,stlpec_28 ,stlpec_29,stlpec_30,stlpec_31, stlpec_32_1, stlpec_32_2, rok 
	)
	select 
	 ROW_NUMBER() OVER(ORDER BY t.kod asc) AS Por,
		upper(t.stlpec_6) as stlpec_6,t.stlpec_7 as stlpec_7,t.stlpec_8 as stlpec_8,t.stlpec_9 as stlpec_9,t.stlpec_10 as stlpec_10,t.stlpec_11 as stlpec_11,
		t.stlpec_12 as stlpec_12,t.stlpec_13 as stlpec_13, t.stlpec_14Den  as stlpec_14Den, t.stlpec_14Mesiac as stlpec_14Mesiac, t.stlpec_15 as stlpec_15,t.stlpec_16 as stlpec_16,t.stlpec_17  as stlpec_17,t.stlpec_18 as stlpec_18,
		t.stlpec_19 as stlpec_19 ,t.stlpec_20 as stlpec_20,t.stlpec_21  as stlpec_21 ,
		t.stlpec_22 as stlpec_22,t.stlpec_23 as stlpec_23,t.stlpec_24 as stlpec_24
		,t.stlpec_25 as stlpec_25 ,t.stlpec_26 as stlpec_26,t.stlpec_27 as stlpec_27,t.stlpec_28 as stlpec_28 ,t.stlpec_29 as stlpec_29,
		k.pocet_krav as stlpec_30,
		p.porlak as  stlpec_31,
		t.stlpec_32_1  as stlpec_32_1,  
		t.stlpec_32_2  as stlpec_32_2,  
		t.rok as rok
		
		
		from @tab1 as t
		left outer join @porlak as p on t.Oznacenie = p.oznacenie
		left outer join @stavKrav as k on t.Oznacenie = k.oznacenie
		--left outer join CR_LaktacneZostavy as l on l.filter = t.Oznacenie
				--where l.datumOd=@datumOd and l.datumDo= @datumPolRok
	end
go



-----------------------------------------------------------------------------


CREATE procedure [dbo].[Roc_MLHD_21]
	@chov varchar(3),
	@datumOd date,
	@datumDo date
	  --use plis --Declare @datumOd date, @datumDo date, @chov varchar(9),  --  set @datumOd ='2017-01-01' -- set @datumDo ='2017-10-15' -- set @chov = '301701031'
as 
begin
Declare @tab21 TABLE
	  (
	  KRAJ VARCHAR(1)NULL,
	  OKRES VARCHAR(2)NULL,
	  OKRES_NAZOV VARCHAR(30)NULL,
	  Por_v_okrese varchar(2)null,
	  NAZOV VARCHAR(50)NULL,
	  ROK VARCHAR(4),
	   stpec_7 [int] NULL,
		[stpec_8] [int] NULL,
		[stpec_9] [int] NULL,
		[stpec_10] [float] NULL,
		[stpec_11] [int] NULL,
		[stpec_12] [float] NULL,
		[stpec_13] [int] NULL,
		[stpec_14Mesiac] [int] NULL,
		[stpec_14Den] [int] NULL,
		[stpec_15] [int] NULL,
		[stpec_16] [int] NULL,
		[stpec_17] [int] NULL,
		[stpec_18] [float] NULL,
		[stpec_19] [int] NULL,
		[stpec_20] [float] NULL,
		[stpec_21] [int] NULL,
		[stpec_22] [int] NULL,
		[stpec_23] [int] NULL,
		[stpec_24] [int] NULL,
		[stpec_25] [int] NULL,
		[stpec_26] [float] NULL,
		[stpec_27] [int] NULL,
		[stpec_28] [float] NULL,
		[stpec_29] [int] NULL
	   )

   INSERT INTO @tab21   -----vyber chovov
	   (kraj, okres, OKRES_NAZOV, Por_v_okrese, NAZOV, ROK,
		stpec_7,stpec_8, stpec_9, stpec_10, stpec_11, stpec_12, stpec_13,stpec_14Den, stpec_14Mesiac, stpec_15, stpec_16, stpec_17, stpec_18, stpec_19, stpec_20,
		stpec_21,
		 stpec_22, stpec_23 , 
		stpec_24, stpec_25, 
		stpec_26, stpec_27, stpec_28, stpec_29
		)
   
	select o.kraj, o.okres, o.NAZOV, 
		'1' as Por_v_okrese,
		'Výsledky za okres'+ ' ' +o.NAZOV as NAZOV,
		datepart (year, @datumOd) as rok,
		z.PocLakN1 as stpec_7
		,z.LakdniNL1 as stpec_8
		,z.MliekNorL1 as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,z.TukNorL1 as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,z.BielkNorL1 as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,z.LakDniNL2 as stpec_16
		,z.MliekNorL2 as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,z.TukNorL2 as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,z.BielkNorL2 as stpec_21
		,z.MedziobdL2 as stpec_22
		,z.PocLakNcelk as stpec_23
		,z.LakDniNCelk as stpec_24
		,z.MliekNorCelk as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,z.TukNorCelk as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,z.BielkNorCelk as stpec_29
	from  NC_OKRES as o 
		  left join CR_LaktacneZostavy_Opr as z on z.filter = o.kraj + o.okres and @datumOd = z.DatumOd and @datumDo = z.DatumDo
	where o.kraj + o.okres = @chov  --  SUBSTRING(@chov,1,3)

	union 

		select o.kraj, o.okres, o.NAZOV, 
			'2' as Por_v_okrese,
			'Výsledky za predchádzajúci rok' as NAZOV,
			datepart (year, @datumOd) as rok,
			  a.stpec_7 as stpec_7 ,a.stpec_8 as stpec_8 ,a.stpec_9 as stpec_9 ,a.stpec_10 as stpec_10 ,a.stpec_11 as stpec_11 ,a.stpec_12 as stpec_12 ,a.stpec_13 as stpec_13
			   ,a.stpec_14Den as stpec_14Den, a.stpec_14Mesiac as stpec_14Mesiac ,a.stpec_15 as stpec_15 ,a.stpec_16 as stpec_16,a.stpec_17 as stpec_17 ,a.stpec_18 as stpec_18
			   ,a.stpec_19 as stpec_19 ,a.stpec_20 as stpec_20,a.stpec_21 as stpec_21,
			   a.stpec_22 as stpec_22 ,a.stpec_23 as stpec_23 ,
			   a.stpec_24 as stpec_24
			   ,a.stpec_25 as stpec_25,
			   a.stpec_26 as stpec_26 ,a.stpec_27 as stpec_27,a.stpec_28 as stpec_28 ,a.stpec_29 as stpec_29
		from  NC_OKRES as o 
			  left outer join  Roc_MLHD_Tab_21A as a on  a.kraj+ a.okres = o.KRAJ + o.okres
															and a.Nazov ='Výsledky za okres' + ' ' + o.NAZOV 
															and a.rok = datepart(year,DATEADD(year,-1,@datumDo))
		where o.kraj + o.okres = @chov -- SUBSTRING(@chov,1,3)

	union
		select o.kraj, o.okres, o.NAZOV, 
		('1'+ convert(varchar,right(s.ID,1))) as Por_v_okrese,
		s.NAZOV as NAZOV,
		datepart (year, @datumOd) as rok,
		z.PocLakN1 as stpec_7
		,z.LakdniNL1 as stpec_8
		,z.MliekNorL1 as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,z.TukNorL1 as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,z.BielkNorL1 as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,z.LakDniNL2 as stpec_16
		,z.MliekNorL2 as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,z.TukNorL2 as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,z.BielkNorL2 as stpec_21
		,z.MedziobdL2 as stpec_22
		,z.PocLakNcelk as stpec_23
		,z.LakDniNCelk as stpec_24
		,z.MliekNorCelk as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,z.TukNorCelk as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,z.BielkNorCelk as stpec_29
	from  NC_OKRES as o 
			
		  left join CR_LaktacneZostavy_Opr as z on z.filter = o.kraj + o.okres + ', ,' + ('S'+(select id from NC_Sektor where id in (select SUBSTRING(z.Filter,8,2)))) and @datumOd = z.DatumOd and @datumDo = z.DatumDo
		  left outer join NC_Sektor as s on s.ID = SUBSTRING(z.Filter,8,2)
	where o.kraj + o.okres = @chov-- SUBSTRING(@chov,1,3)

	--select * from @tab21

	insert into Roc_MLHD_Tab_21A
		(
		kraj ,okres,Okres_nazov,Por_v_okrese,Nazov,stpec_7, stpec_8 ,stpec_9, stpec_10 ,stpec_11, stpec_12 ,stpec_13, stpec_14Den ,stpec_14Mesiac , stpec_15 ,stpec_16 , stpec_17, stpec_18
		,stpec_19 , stpec_20,
		stpec_21, stpec_22 ,stpec_23, stpec_24,
		stpec_25,stpec_26, stpec_27,stpec_28 , stpec_29,rok
		)
	select 
	kraj ,okres,
	Okres_nazov ,Por_v_okrese,Nazov,       
    stpec_7, stpec_8 ,stpec_9, stpec_10 ,stpec_11, stpec_12 ,stpec_13, stpec_14Den ,stpec_14Mesiac , stpec_15 ,stpec_16 , stpec_17, stpec_18
	,stpec_19 , stpec_20,stpec_21, 
	stpec_22 ,stpec_23, stpec_24,stpec_25, 
	stpec_26, stpec_27,stpec_28 , stpec_29,rok

	  from  @tab21

	end
go


-------------------------------------------------------------------------------------------------------

CREATE procedure  [dbo].[Roc_MLHD_15]
	@datumOd date,
	@datumDo date

	as 
	begin

    delete from Roc_MLHD_Tab_15 where rok = datepart(year,@datumOd);
--declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31'

declare @kravy table
	(
	ciskravy varchar(14),
	CHOVATEL varchar (9),
	MLIEKNOR float,
	PLEM_TYP varchar(10)
		)
	insert into @kravy
	select distinct CISKRAVY as ciskravy,
			CHOVATEL as CHOVATEL,
			MAX(MLIEKNOR) as MLIEKNOR,
			PLEM as PLEM_TYP
	from  dbo.View_CP_LaktaciePreZostavy
		where  ((DATUKONL >= @datumOd and DATUKONL <= @datumDo) and (DATUKNORL is null or DATUKNORL >= @datumOd) 
						or (DATUKNORL >= @datumOd and DATUKNORL <= @datumDo))
					and MLIEKCEL <>''
					and ZMENA in ('30','40')
		Group by CISKRAVY, CHOVATEL, PLEM
		ORDER BY ciskravy
	--select * from @kravy order by ciskravy
	
declare @SR table
	(
	ciskravy varchar(14),
	Por_SR bigint,
	MLIEKNOR float,
	CHOVATEL varchar (9)
	)
	
	insert into @SR
		select distinct CISKRAVY as ciskravy,
			ROW_NUMBER() OVER(ORDER BY MLIEKNOR desc) AS Por_SR,
			MLIEKNOR as MLIEKNOR,
			CHOVATEL as CHOVATEL
		from  @kravy
		ORDER BY MLIEKNOR
		--select * from @SR order by ciskravy

	declare @Kraje table				
			(
			Kraj varchar (3),
			ciskravy varchar(14),
			Por bigint,
			Mlieknor float
			)
			
	declare @counterK int,  @kraj varchar(3)
		
	DECLARE poradie_cursorK CURSOR LOCAL
		FOR
			SELECT distinct substring(CHOVATEL,1,1) FROM @kravy
						
		OPEN poradie_cursorK
		FETCH NEXT FROM poradie_cursorK INTO @kraj
		WHILE @@FETCH_STATUS = 0
			BEGIN 			
				--print @chovatelia			
						
				insert into @Kraje
					(Kraj,ciskravy,Por,  Mlieknor )
					select distinct 
							substring(CHOVATEL,1,1) as Kraj,
							CISKRAVY as ciskravy,
							ROW_NUMBER() OVER(ORDER BY MLIEKNOR desc) AS Por,
							MLIEKNOR as Mlieknor
					from @kravy
						where substring(CHOVATEL,1,1) = @kraj
					ORDER BY  MLIEKNOR
				
				FETCH NEXT FROM poradie_cursorK INTO @kraj
			END

		CLOSE poradie_cursorK
		DEALLOCATE poradie_cursorK
	--select* from @Kraje order by Kraj,Por  


	declare @Okresy table				
			(
			Okres varchar (3),
			ciskravy varchar(14),
			Por bigint,
			Mlieknor float
			)

	declare @counter int,  @okres varchar(3)
		
	DECLARE poradie_cursor CURSOR LOCAL
		FOR
			SELECT distinct substring(CHOVATEL,1,3) FROM @kravy
						
		OPEN poradie_cursor
		FETCH NEXT FROM poradie_cursor INTO @okres
		WHILE @@FETCH_STATUS = 0
			BEGIN 			
				insert into @Okresy
					(Okres,ciskravy,Por,  Mlieknor )
					select distinct 
							substring(CHOVATEL,1,3) as okres,
							CISKRAVY as ciskravy,
							ROW_NUMBER() OVER(ORDER BY MLIEKNOR desc) AS Por,
							 MLIEKNOR as Mlieknor
					from @kravy
						where substring(CHOVATEL,1,3) = @okres
				ORDER BY  MLIEKNOR

				FETCH NEXT FROM poradie_cursor INTO @okres
			END

		CLOSE poradie_cursor
		DEALLOCATE poradie_cursor
		--select* from @Okresy order by okres,Por  

		declare @Chovy table				-----PL1 a ich podiel v chove
			(
			Chov varchar (9),
			ciskravy varchar(14),
			Por bigint,
			Por_lakt int,
			mlieko float, 
			tuk_P float, 
			tuk_KG int, 
			bielk_P float, 
			bielk_KG int
			)

	declare @counterCH int,  @chov varchar(9)
		
	DECLARE poradie_cursorCH CURSOR LOCAL
		FOR
			SELECT distinct CHOVATEL FROM @kravy
						
		OPEN poradie_cursorCH
		FETCH NEXT FROM poradie_cursorCH INTO @chov
		WHILE @@FETCH_STATUS = 0
			BEGIN 			
				--print @chovatelia			
						
				insert into @Chovy
					(Chov, ciskravy, Por,Por_lakt,mlieko, tuk_P, tuk_KG, bielk_P, bielk_KG)
					select distinct Top 1 
							k.CHOVATEL as Chov,
							k.CISKRAVY as ciskravy,
							ROW_NUMBER() OVER(ORDER BY k.MLIEKNOR desc) AS Por,
							Lakt.PORLAK as Por_lakt,
							 k.MLIEKNOR as mlieko,
							Round(Lakt.TUKNOR / Lakt.MLIEKNOR*100,2,2) as tuk_P,
							round(Lakt.TUKNOR,0) as tuk_KG, 
							round(Lakt.BIELKNOR / Lakt.MLIEKNOR*100,2,2) as bielk_P,
						  round(Lakt.BIELKNOR,0) as bielk_KG
						from  @kravy as k
							left outer join dbo.View_CP_LaktaciePreZostavy as Lakt on k.ciskravy=Lakt.ciskravy 
							where  k.CHOVATEL = @chov
									and k.MLIEKNOR = Lakt.MLIEKNOR
						
						ORDER BY k.MLIEKNOR desc
				
				FETCH NEXT FROM poradie_cursorCH INTO @chov
			END

		CLOSE poradie_cursorCH
		DEALLOCATE poradie_cursorCH
		--select* from @Chovy order by Chov,Por  

	declare @Plem_typ table				
			(
			plem varchar (3),
			ciskravy varchar(14),
			Por bigint,
			Mlieknor float
			)

	declare @counterP int,  @plemeno varchar(3)
		
	DECLARE poradie_cursorP CURSOR LOCAL
		FOR
			SELECT distinct PLEM_TYP FROM @kravy
						
		OPEN poradie_cursorP
		FETCH NEXT FROM poradie_cursorP INTO @plemeno
		WHILE @@FETCH_STATUS = 0
			BEGIN 			
				--print @chovatelia			
						
				insert into @Plem_typ
					(plem, ciskravy, Por, Mlieknor )
					select distinct 
							PLEM_TYP as plem,
							CISKRAVY as ciskravy,
							ROW_NUMBER() OVER(ORDER BY MLIEKNOR desc) AS Por,
							MLIEKNOR as Mlieknor
						from  @kravy
							where PLEM_TYP = @plemeno
						ORDER BY MLIEKNOR
				
				FETCH NEXT FROM poradie_cursorP INTO @plemeno
			END

		CLOSE poradie_cursorP
		DEALLOCATE poradie_cursorP

		--select* from @Plem_typ order by Plem,Por  

	insert into Roc_MLHD_Tab_15
		(chovatel, Okres ,PorOkres ,PorKraj,PorSR ,PorPlemTyp ,Ciskravy ,PlemTyp,Podnik,Chov ,OLinReg ,Plemeno,Por_lakt
		,mlieko ,tuk_P ,tuk_KG ,bielk_P,bielk_KG,rok)
	select distinct
			c.chov as chovatel,
			ok.NAZOV as Okres
		  ,o.Por as PorOkres
		  ,k.por as PorKraj
		  ,s.Por_SR as PorSR
		  ,p.Por as PorPlemTyp 
		  ,c.ciskravy as Ciskravy
		  ,p.plem as PlemTyp
		  ,pd.NAZOVSKR as Podnik
		  ,ch.NAZOV as  Chov
		  ,(case when ka.Oteclin is null then substring(b.MENO,1,15)
				 else ka.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,ka.otecreg), 3)end) as OLinReg
		  ,ISNULL(ka.PL1 + CONVERT(varchar, ka.KR1), '') 
						+  ISNULL(ka.PL2, '')+  ISNULL(ka.PL3, '')+  ISNULL(ka.PL4, '')+  ISNULL(ka.PL5, '') as Plemeno
		  ,c.Por_lakt as Por_lakt
		  ,convert(int,c.mlieko) as mlieko
		  ,c.tuk_P as tuk_P
		  ,c.tuk_KG as tuk_KG
		  ,c.bielk_P as bielk_P
		  ,c.bielk_KG as bielk_KG
		  ,datepart(year,@datumOd) as rok
			
		
		from @Chovy as c
		left outer join CM_Krava as ka on ka.ciskravy = c.ciskravy
		left outer join CM_Byci as b on b.USCISLO = ka.OUSCIS
		left outer join @Kraje as k on k.ciskravy = c.ciskravy
		left outer join @Okresy as o on o.ciskravy = c.ciskravy 
		left outer join @SR as s on s.ciskravy = c.ciskravy  
		left outer join @Plem_typ  as p on p.ciskravy = c.ciskravy  
		left outer join NC_OKRES as ok on ok.KRAJ + ok.OKRES = o.Okres 
		left outer join NM_PODNIK as pd on pd.kraj + pd.okres + pd.podnik = SUBSTRING(c.Chov,1,6)
		left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK+ ch.CHOV = c.Chov
		where ch.zrus is null 
			and pd.ZRUS is null
	
	order by chovatel
	

	End
go


-----------------------------------------------------------------------------------------------



CREATE procedure [dbo].[Rocenka_MLHD_Tab_17]
    @rok varchar(4),
	@Plem_typ varchar(6)
as
begin

	
	select * 
	from dbo.Roc_MLHD_Tab_17 as z
	where   z.rok = @rok and z. Plem_typ=@Plem_typ 
	order by CONVERT(INT, por)
end
go


---------------------------------------------------------------------------------------------

/******
Rocenka KU Mlieka ... od str. 80 Vysledky kontrolu uzitkovosti hovadzieho dobytka
jedna z procedur, ktore sa spustaju do tejto tabulky
*******/
 CREATE procedure [dbo].[Roc_MLHD_22]
	@chov varchar(6),
	@datumOd date,
	@datumDo date

  --use plis

 --Declare @datumOd date  ='2018-01-01', @datumDo date ='2018-09-30', @chov varchar(9)  = '108520'
  -- set @datumOd ='2018-01-01'
  --set @datumDo ='2018-09-30'
  --set @chov = '102501011'

as 
begin
Declare @tab22 TABLE
	  (
	  KRAJ VARCHAR(1)NULL,
	  OKRES VARCHAR(2)NULL,
	  PODNIK VARCHAR(3)NULL,
	  OKRES_NAZOV VARCHAR(30)NULL,
	  chov varchar(3)null, 
	  chov_nazov varchar(100),
	  ROK VARCHAR(4)
	   )

   INSERT INTO @tab22   -----vyber chovov
   (kraj, okres, podnik, OKRES_NAZOV, chov, chov_nazov, ROK)
   
	select n.kraj, n.okres, n.podnik, o.NAZOV, ch.chov, ch.NAZOV,  
	 	datepart (year, @datumOd) as rok
	from NM_PODNIK as n
	  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK = n.KRAJ + n.OKRES + n.PODNIK
	  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = n.KRAJ + n.OKRES
	where n.kraj + n.okres + n.PODNIK =  @chov
		and ch.KRAJ + ch.OKRES + ch.PODNIK = @chov
		and ch.TYPZV=1 
		and ch.chov not in ('010','700', '699') 
		and left(ch.chov,1) not in ('7','8','9')
		and (ch.ZRUS is null or(ch.ZRUS is not null and ch.datumZrusenia > @datumDo))
		and ch.kraj + ch.okres+ ch.podnik + ch.chov in (select kraj + okres + podnik + chov from NM_HDDETAIL
											 where (NOT(SPVYKON IN ('0', '4', '5'))) AND (PRIZNAK = '01') AND TECHUSMD = '00' or (PRIZNAK='99' and SPVYKON<>'0'))
	
	
	--select * from @tab22

	 Declare @tab22N TABLE 
	  (
	  KRAJ VARCHAR(1)NULL,
	  OKRES VARCHAR(2)NULL,
	  PODNIK VARCHAR(3)NULL,
	  OKRES_NAZOV VARCHAR(30)NULL,
	  chov varchar(3)null, 
	  chov_nazov varchar(100),
	  ROK VARCHAR(4)	   
	   )

	 INSERT INTO @tab22N   ----doplnenie mastali
		(kraj, okres, podnik, OKRES_NAZOV, chov, chov_nazov, ROK)
	 select * from @tab22
	 	union
	 select kraj, okres, podnik, OKRES_NAZOV, SUBSTRING(chov, 1,2) as chov, 'Chov spolu' as chov_nazov, rok
			from @tab22 
			group by SUBSTRING(chov, 1,2), kraj, okres, podnik, OKRES_NAZOV, rok 
			having count(chov)>1
	--select * from @tab22N
	
	 Declare @tab22A TABLE
	  (
		  KRAJ VARCHAR(1)NULL,
		  OKRES VARCHAR(2)NULL,
		  PODNIK VARCHAR(3)NULL,
		  OKRES_NAZOV VARCHAR(30)NULL,
		  chov varchar(3)null, 
		  chov_nazov varchar(100),
		  ROK VARCHAR(4), 
		  SPVYKON varchar(1)null, 
		  CHARCHOV_kod varchar(1)null, 
		  CHARCHOV VARCHAR(30)NULL,
		  VYROBL varchar(1)null, 
		  CHARUS varchar(1)null,
		  PL1 varchar(10),
		  [stpec_7] [int] NULL,
		[stpec_8] [float] NULL,
		[stpec_9] [float] NULL,
		[stpec_10] [float] NULL,
		[stpec_11] [float] NULL,
		[stpec_12] [float] NULL,
		[stpec_13] [float] NULL,
		[stpec_14Mesiac] [int] NULL,
		[stpec_14Den] [int] NULL,
		[stpec_15] [float] NULL,
		[stpec_16] [float] NULL,
		[stpec_17] [float] NULL,
		[stpec_18] [float] NULL,
		[stpec_19] [float] NULL,
		[stpec_20] [float] NULL,
		[stpec_21] [float] NULL,
		[stpec_22] [float] NULL,
		[stpec_23] [float] NULL,
		[stpec_24] [float] NULL,
		[stpec_25] [float] NULL,
		[stpec_26] [float] NULL,
		[stpec_27] [float] NULL,
		[stpec_28] [float] NULL,
		[stpec_29] [float] NULL
	     )
	   insert into @tab22A
		   (KRAJ, OKRES, PODNIK, OKRES_NAZOV, chov, chov_nazov, ROK, SPVYKON, CHARCHOV_kod, CHARCHOV, VYROBL, CHARUS, 
			stpec_7,stpec_8, stpec_9, stpec_10, stpec_11, stpec_12, stpec_13, stpec_14Mesiac, stpec_14Den, stpec_15, stpec_16, stpec_17, stpec_18, stpec_19, stpec_20,
			stpec_21, stpec_22, stpec_23 , stpec_24, stpec_25, stpec_26, stpec_27, stpec_28, stpec_29)
			--h.CHARCHOV AS CHARCHOV_kod,/*, PL1, KR1*/
	   select n.kraj, n.okres, n.podnik, n.OKRES_NAZOV, n.chov, n.chov_nazov, n.ROK,
				h.SPVYKON as SPVYKON,
				(CASE WHEN h.CHARCHOV = '0' THEN 'O'
					WHEN h.CHARCHOV = '1' THEN 'S'
					WHEN h.CHARCHOV = '2' THEN 'P'
					WHEN h.CHARCHOV = '3' THEN 'H'
					WHEN h.CHARCHOV = '4' THEN 'M'
					WHEN h.CHARCHOV = '5' THEN 'B'
					END) AS CHARCHOV_kod,
				ChCh.NAZOV as CHARCHOV,
				(case when h.VYROBL = '1' then 'H'
					when h.VYROBL = '2' then 'N'
					else '' end) as VYROBL, 
				h.CHARUS as CHARUS,
				PocLakN1 as stpec_7
				,LakdniNL1 as stpec_8
				,MliekNorL1 as stpec_9
				, round((TukNorL1*100)/MliekNorL1,2) as stpec_10
				,TukNorL1 as stpec_11
				,round((BielkNorL1*100)/MliekNorL1,2) as stpec_12
				,BielkNorL1 as stpec_13
				,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Mesiac
			  ,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Den
				,PocLakN2 as stpec_15
				,LakDniNL2 as stpec_16
				,MliekNorL2 as stpec_17
				,round((TukNorL2*100)/MliekNorL2,2) as stpec_18
				,TukNorL2 as stpec_19
				,round((BielkNorL2*100)/MliekNorL2,2) as stpec_20
				,BielkNorL2 as stpec_21
				,MedziobdL2 as stpec_22
				,PocLakNcelk as stpec_23
				,LakDniNCelk as stpec_24
				,MliekNorCelk as stpec_25
				,round((TukNorCelk*100)/MliekNorCelk,2) as stpec_26
				,TukNorCelk as stpec_27
				,round((BielkNorCelk*100)/MliekNorCelk,2) as stpec_28
				,BielkNorCelk as stpec_29
			
	    from @tab22N as n 
			left outer join NM_HDDETAIL as h on h.KRAJ + h.OKRES + h.PODNIK + h.CHOV = n.KRAJ + n.OKRES + n.PODNIK + n.chov
			left outer join NC_VyrObl as vo on vo.KOD = h.VYROBL
			left outer join NC_CharChov as ChCh on ChCh.KOD = h.CHARCHOV and ChCh.DRUHHZ = h.TYPZV
			left join CR_LaktacneZostavy_Opr as z on z.filter = n.kraj + n.okres + n.podnik + n.chov and @datumOd = z.DatumOd and @datumDo = z.DatumDo
		--select * from @tab22A
		
		declare @podiely table				-----PL1 a ich podiel v chove
			(
			CHOVATEL varchar (9),
			PL1 varchar(3),
			KR1 float,
			PodielPerc float--
			)
		
	declare @chovy int = (select count(chov) from  @tab22A )
	 print 'chovy'
	 print @chovy
	
	if @chovy >0
	begin 
		Insert into @podiely
		 (PL1, CHOVATEL,  KR1, PodielPerc)

		select distinct	 k.pl1 as PL1, 
			k.chovatel as chovatel,
			sum(k.KR1)as KR1,
			(sum(k.KR1)/(select sum(k1.KR1)from CM_Krava as k1 
										where k1.CHOVATEL = k.chovatel
											and PRIZNAKKU = 1 
											and (k1.dovvyr is null or (k1.dovvyr is not null and k1.DATVYR>=@datumOd))))*100 as PodielPerc 
		from @tab22A as a --CM_Krava
			left outer join CM_Krava as k on k.CHOVATEL = a.KRAJ + a.OKRES + a.PODNIK + a.chov
			where  k.CHOVATEL =  a.kraj+a.okres+a.podnik+a.chov
				and k.PRIZNAKKU = 1 
				and (k.dovvyr is null or (k.dovvyr is not null and k.DATVYR>=@datumOd))
			group by k.PL1, k.CHOVATEL

	end
	--select * from @podiely
		
	declare @counter int,  @chovatelia varchar(9)
	declare @plemena table
		(
		PL1 varchar(3),
		KR1 float,
		PodielPerc float,
		CHOVATEL varchar (9),
		por int
		)

	declare @ZoznamPL1 table
		(
		CHOVATEL VARCHAR(9),
		plem varchar(10)
		)
		
	DECLARE poradie_cursor CURSOR LOCAL
		FOR
			SELECT CHOVATEL FROM @podiely group by CHOVATEL
						
		OPEN poradie_cursor
		FETCH NEXT FROM poradie_cursor INTO @chovatelia
		WHILE @@FETCH_STATUS = 0
			BEGIN 			
				--print @chovatelia			
				delete from  @plemena			
				insert into @plemena
					(PL1, KR1, PodielPerc, CHOVATEL, por)
					select PL1,KR1, PodielPerc, CHOVATEL,ROW_NUMBER() OVER (ORDER BY PodielPerc desc) as por from @podiely as p where p.PodielPerc >12.5 and CHOVATEL = @chovatelia
			
				declare @PL1 varchar(10) = ISNULL((select pl1 from @plemena where por=1),'') +' '+ isnull((select PL1 from @plemena where por=2),'') +' '+ isnull((select PL1  from @plemena where por=3),'') 
		
				insert into @ZoznamPL1
				select @chovatelia,@PL1
						
				FETCH NEXT FROM poradie_cursor INTO @chovatelia
			END

		CLOSE poradie_cursor
		DEALLOCATE poradie_cursor

		--select * from  @ZoznamPL1

	UPDATE @tab22A SET 
	PL1 = plem FROM @ZoznamPL1 WHERE  KRAJ+okres+podnik+chov = CHOVATEL
	

	Declare @tab22X TABLE
	  (
	 KRAJ VARCHAR(1)NULL,
		  OKRES VARCHAR(2)NULL,
		  PODNIK VARCHAR(3)NULL,
		  OKRES_NAZOV VARCHAR(30)NULL,
		  chov varchar(3)null, 
		  chov_nazov varchar(100),
		  ROK VARCHAR(4), 
		  SPVYKON varchar(1)null, 
		  CHARCHOV_kod varchar(1)null, 
		  CHARCHOV VARCHAR(30)NULL,
		  VYROBL varchar(1)null, 
		  CHARUS varchar(1)null,
		  PL1 varchar(10),
		[stpec_7] [int] NULL,
		[stpec_8] [float] NULL,
		[stpec_9] [float] NULL,
		[stpec_10] [float] NULL,
		[stpec_11] [float] NULL,
		[stpec_12] [float] NULL,
		[stpec_13] [float] NULL,
		[stpec_14Mesiac] [int] NULL,
		[stpec_14Den] [int] NULL,
		[stpec_15] [float] NULL,
		[stpec_16] [float] NULL,
		[stpec_17] [float] NULL,
		[stpec_18] [float] NULL,
		[stpec_19] [float] NULL,
		[stpec_20] [float] NULL,
		[stpec_21] [float] NULL,
		[stpec_22] [float] NULL,
		[stpec_23] [float] NULL,
		[stpec_24] [float] NULL,
		[stpec_25] [float] NULL,
		[stpec_26] [float] NULL,
		[stpec_27] [float] NULL,
		[stpec_28] [float] NULL,
		[stpec_29] [float] NULL
	   )


	INSERT INTO @tab22X 
		( KRAJ , OKRES ,PODNIK, OKRES_NAZOV, chov, chov_nazov, ROK, SPVYKON, CHARCHOV_kod, CHARCHOV, VYROBL, CHARUS, PL1
		,stpec_7,stpec_8, stpec_9, stpec_10, stpec_11, stpec_12, stpec_13,stpec_14Mesiac, stpec_14Den, stpec_15, stpec_16, stpec_17, stpec_18, stpec_19, stpec_20,
		 stpec_21, stpec_22, stpec_23 , stpec_24, stpec_25, stpec_26, stpec_27, stpec_28, stpec_29)
	
	SELECT  KRAJ , OKRES ,PODNIK, OKRES_NAZOV, chov, chov_nazov, ROK, SPVYKON, CHARCHOV_kod, CHARCHOV, VYROBL, CHARUS, PL1
		,stpec_7,stpec_8, stpec_9, stpec_10, stpec_11, stpec_12, stpec_13,stpec_14Mesiac, stpec_14Den, stpec_15, stpec_16, stpec_17, stpec_18, stpec_19, stpec_20,
		 stpec_21, stpec_22, stpec_23 , stpec_24, stpec_25, stpec_26, stpec_27, stpec_28, stpec_29
	from @tab22A 
----	  left join CR_LaktacneZostavy as z on z.filter = a.kraj + a.okres + a.podnik + a.chov and @datumOd = z.DatumOd and @datumDo = z.DatumDo
	  
	  union 
		  select 
		   n.KRAJ , 
		   n.OKRES, n.PODNIK, n.OKRES_NAZOV, '999' as chov,  'Výsledky za predchádzajúci kontrolný rok' as chov_nazov, 
		   n.rok, 
		   '' as SPVYKON, '' as CHARCHOV_kod, '' as CHARCHOV, '' as VYROBL, '' as CHARUS, '' as PL1,
		   a.stpec_7 as stpec_7 ,a.stpec_8 as stpec_8 ,a.stpec_9 as stpec_9 ,a.stpec_10 as stpec_10 ,a.stpec_11 as stpec_11 ,a.stpec_12 as stpec_12 ,a.stpec_13 as stpec_13
		   ,a.stpec_14Mesiac as stpec_14Mesiac ,a.stpec_14Den as stpec_14Den ,a.stpec_15 as stpec_15 ,a.stpec_16 as stpec_16,a.stpec_17 as stpec_17 ,a.stpec_18 as stpec_18
		   ,a.stpec_19 as stpec_19 ,a.stpec_20 as stpec_20,a.stpec_21 as stpec_21,a.stpec_22 as stpec_22 ,a.stpec_23 as stpec_23 ,a.stpec_24 as stpec_24
		   ,a.stpec_25 as stpec_25,a.stpec_26 as stpec_26 ,a.stpec_27 as stpec_27,a.stpec_28 as stpec_28 ,a.stpec_29 as stpec_29
		 from @tab22A as n
		 left outer join  Roc_MLHD_Tab_22A as a 
					/*on  a.kraj+ a.okres + a.podnik  = n.KRAJ + n.okres + n.podnik + '' --platilo pre rocenku 2017
						and a.stpec_6 <>'Výsledky za predchádzajúci kontrolný rok' 
						and a.rok = datepart(year,DATEADD(year,-1,@datumDo))*/
					on  a.kraj+ a.okres + a.podnik  = n.KRAJ + n.okres + n.podnik + '' --platilo od rocenky 2018
						and a.stlpec_6c = '199'
						and a.rok = datepart(year,DATEADD(year,-1,@datumDo))

	union 
		select 
		   n.KRAJ , 
		   n.OKRES, n.PODNIK, n.OKRES_NAZOV, '199' as chov, k.NAZOVSKR as chov_nazov, 
		   n.rok, 
		   '' as SPVYKON, '' as CHARCHOV_kod, '' as CHARCHOV, '' as VYROBL, '' as CHARUS, '' as PL1,
		   PocLakN1 as stpec_7
		  ,LakdniNL1 as stpec_8
		  ,MliekNorL1 as stpec_9
		  , round((TukNorL1*100)/MliekNorL1,2) as stpec_10
		  ,TukNorL1 as stpec_11
		  ,round((BielkNorL1*100)/MliekNorL1,2) as stpec_12
		  ,BielkNorL1 as stpec_13
			,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Mesiac
		  ,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Den
		  ,PocLakN2 as stpec_15
		  ,LakDniNL2 as stpec_16
		  ,MliekNorL2 as stpec_17
		  ,round((TukNorL2*100)/MliekNorL2,2) as stpec_18
	  	  ,TukNorL2 as stpec_19
		  ,round((BielkNorL2*100)/MliekNorL2,2) as stpec_20
		  ,BielkNorL2 as stpec_21
		  ,MedziobdL2 as stpec_22
		  ,PocLakNcelk as stpec_23      
		  ,LakDniNCelk as stpec_24
		  ,MliekNorCelk as stpec_25
		  ,round((TukNorCelk*100)/MliekNorCelk,2) as stpec_26
		  ,TukNorCelk as stpec_27
		  ,round((BielkNorCelk*100)/MliekNorCelk,2) as stpec_28
		  ,BielkNorCelk as stpec_29
		 from @tab22A as n
		 left outer join CR_LaktacneZostavy_Opr as z on z.filter = n.KRAJ + n.OKRES + n.PODNIK and @datumOd = z.DatumOd and @datumDo = z.DatumDo
		 left outer join NM_PODNIK as k on k.KRAJ + k.OKRES + k.PODNIK = n.KRAJ + n.OKRES + n.PODNIK

  --select * from @tab22X

  insert into Roc_MLHD_Tab_22A 
  ( KRAJ,OKRES,PODNIK,Okres_nazov,stpec_1,stpec_2,stpec_3,stpec_4,stpec_5,stpec_6,stlpec_6c,stpec_7
      ,stpec_8,stpec_9,stpec_10,stpec_11,stpec_12,stpec_13,stpec_14Mesiac,stpec_14Den,stpec_15,stpec_16,stpec_17,stpec_18
      ,stpec_19,stpec_20,stpec_21,stpec_22,stpec_23,stpec_24,stpec_25,stpec_26,stpec_27,stpec_28,stpec_29,rok)

	  select KRAJ , OKRES ,PODNIK, OKRES_NAZOV,  
	  SPVYKON as stpec_1, 
	  CHARCHOV_kod as stpec_2, 
	  VYROBL as stpec_3, 
	  CHARUS as stpec_4,
	  PL1 as stpec_5,
	  chov_nazov as stpec_6,
	  chov as stlpec_6c,
	  stpec_7,stpec_8, stpec_9, stpec_10, stpec_11, stpec_12, stpec_13,stpec_14Mesiac, stpec_14Den, stpec_15, stpec_16, stpec_17, stpec_18, stpec_19, stpec_20,
	  stpec_21, stpec_22, stpec_23 , stpec_24, stpec_25, stpec_26, stpec_27, stpec_28, stpec_29, ROK
		 
		 from @tab22X 
	end
go



-----------------------------------------------------------------------------------------------------------

CREATE procedure [dbo].[Rocenka_MLHD_Tab_19A]
	@rok varchar(4),
	@plem_typ varchar(4)

as	
begin
select * from Roc_MLHD_Tab_19A
where rok=@rok and Plem_typ = @plem_typ
ORDER BY KRAJ, OKRES, PODNIK, CHOV, Por
end


-------------------------------------------------------------------------------------------------------------

CREATE procedure [dbo].[Rocenka_MPHD_17_predch_rok]
	--@chov varchar(9),
	@datumOd date

	as 
	begin


    select
      akt.kraj,
      akt.okres,
      akt.podnik,
      CASE
      WHEN len(akt.podnik) > 0 and len(akt.chov) = 0
        THEN '99'
      ELSE akt.chov
      END as chov,
      CASE
      WHEN len(akt.podnik) > 0 and len(akt.mastal) = 0
        THEN '9'
      ELSE akt.mastal
      END as mastal,
      predch.K2_poc,
      predch.K2_poc_120,
      predch.K2_perc_120,
      predch.K2_poc_210,
      predch.K2_perc_210,
      predch.K2_poc_365,
      predch.K2_perc_365,
      predch.K2_poc_500,
      nullif(predch.K2_Priem_Hm_120, 0) as K2_Priem_Hm_120,
      nullif(predch.K2_Priem_Hm_210, 0) as K2_Priem_Hm_210,
      nullif(predch.K2_Priem_Hm_365, 0) as K2_Priem_Hm_365,
      nullif(predch.K2_Priem_Hm_500, 0) as K2_Priem_Hm_500,
      predch.K2_perc_500,
      nullif(predch.K2_priem_ziv_prirastok_120,0) as K2_priem_ziv_prirastok_120,
      nullif(predch.K2_priem_ziv_prirastok_210,0) as K2_priem_ziv_prirastok_210,
      nullif(predch.K2_priem_ziv_prirastok_365,0) as K2_priem_ziv_prirastok_365,
      nullif(predch.K2_priem_ziv_prirastok_500,0) as K2_priem_ziv_prirastok_500,
      nullif(predch.K2_medziobd,0) as K2_medziobd,
      nullif(predch.K2_vek_1_otel, ' 0  0') as K2_vek_1_otel,
      predch.K2_priem_lakt,
      predch.K2_vyradene,
      predch.MD2_poc,
      predch.MD2_poc_vaz_120,
      predch.MD2_perc_120,
      predch.MD2_poc_vaz_210,
      predch.MD2_perc_210,
      predch.MD2_poc_vaz_365,
      predch.MD2_perc_365,
      predch.MD2_poc_vaz_500,
      predch.MD2_perc_500,
      nullif(predch.MD2_Priem_Hm_120,0) as MD2_Priem_Hm_120,
      nullif(predch.MD2_Priem_Hm_210,0) as MD2_Priem_Hm_210,
      nullif(predch.MD2_Priem_Hm_365,0) as MD2_Priem_Hm_365,
      nullif(predch.MD2_Priem_Hm_500,0) as MD2_Priem_Hm_500,
      nullif(predch.MD2_priem_ziv_prirastok_chov_120,0) as MD2_priem_ziv_prirastok_chov_120,
      nullif(predch.MD2_priem_ziv_prirastok_chov_210,0) as MD2_priem_ziv_prirastok_chov_210,
      nullif(predch.MD2_priem_ziv_prirastok_chov_365,0) as MD2_priem_ziv_prirastok_chov_365,
      nullif(predch.MD2_priem_ziv_prirastok_chov_500,0) as MD2_priem_ziv_prirastok_chov_500,
      predch.MD2_vyradene,
      predch.rok
    from Roc_MPHD_Tab_17 as akt
      left outer join (select  kraj,
                         okres,
                         podnik,
                         chov,
                         mastal,
                         K1_poc,
                         K1_poc_120,
                         K1_perc_120,
                         K1_poc_210,
                         K1_perc_210,
                         K1_poc_365,
                         K1_perc_365,
                         K1_poc_500,
                         K1_perc_500,
                         K1_Priem_Hm_120,
                         K1_Priem_Hm_210,
                         K1_Priem_Hm_365,
                         K1_Priem_Hm_500,
                         K1_priem_ziv_prir_120,
                         K1_priem_ziv_prir_210,
                         K1_priem_ziv_prir_365,
                         K1_priem_ziv_prir_500,
                         K1_medziobd,
                         K1_vek_1_otel,
                         K1_priem_lakt,
                         MD1_poc,
                         MD1_poc_vaz_120,
                         MD1_perc_120,
                         MD1_poc_vaz_210,
                         MD1_perc_210,
                         MD1_poc_vaz_365,
                         MD1_perc_365,
                         MD1_poc_vaz_500,
                         MD1_perc_500,
                         MD1_Priem_Hm_120,
                         MD1_Priem_Hm_210,
                         MD1_Priem_Hm_365,
                         MD1_Priem_Hm_500,
                         MD1_priem_ziv_prirastok_chov_120,
                         MD1_priem_ziv_prirastok_chov_210,
                         MD1_priem_ziv_prirastok_chov_365,
                         MD1_priem_ziv_prirastok_chov_500,
                         K2_poc,
                         K2_poc_120,
                         K2_perc_120,
                         K2_poc_210,
                         K2_perc_210,
                         K2_poc_365,
                         K2_perc_365,
                         K2_poc_500,
                         K2_perc_500,
                         K2_Priem_Hm_120,
                         K2_Priem_Hm_210,
                         K2_Priem_Hm_365,
                         K2_Priem_Hm_500,
                         K2_priem_ziv_prirastok_120,
                         K2_priem_ziv_prirastok_210,
                         K2_priem_ziv_prirastok_365,
                         K2_priem_ziv_prirastok_500,
                         K2_medziobd,
                         K2_vek_1_otel,
                         K2_priem_lakt,
                         K2_vyradene,
                         J_poc,
                         J_poc_vaz_120,
                         J_perc_120,
                         J_poc_vaz_210,
                         J_perc_210,
                         J_poc_vaz_365,
                         J_perc_365,
                         J_poc_vaz_500,
                         J_perc_500,
                         J_Priem_Hm_120,
                         J_Priem_Hm_210,
                         J_Priem_Hm_365,
                         J_Priem_Hm_500,
                         J_priem_ziv_prirastok_chov_120,
                         J_priem_ziv_prirastok_chov_210,
                         J_priem_ziv_prirastok_chov_365,
                         J_priem_ziv_prirastok_chov_500,
                         B_poc,
                         B_poc_vaz_120,
                         B_perc_120,
                         B_poc_vaz_210,
                         B_perc_210,
                         B_poc_vaz_365,
                         B_perc_365,
                         B_poc_vaz_500,
                         B_perc_500,
                         B_Priem_Hm_120,
                         B_Priem_Hm_210,
                         B_Priem_Hm_365,
                         B_Priem_Hm_500,
                         B_priem_ziv_prirastok_chov_120,
                         B_priem_ziv_prirastok_chov_210,
                         B_priem_ziv_prirastok_chov_365,
                         B_priem_ziv_prirastok_chov_500,
                         MD2_poc,
                         MD2_poc_vaz_120,
                         MD2_perc_120,
                         MD2_poc_vaz_210,
                         MD2_perc_210,
                         MD2_poc_vaz_365,
                         MD2_perc_365,
                         MD2_poc_vaz_500,
                         MD2_perc_500,
                         MD2_Priem_Hm_120,
                         MD2_Priem_Hm_210,
                         MD2_Priem_Hm_365,
                         MD2_Priem_Hm_500,
                         MD2_priem_ziv_prirastok_chov_120,
                         MD2_priem_ziv_prirastok_chov_210,
                         MD2_priem_ziv_prirastok_chov_365,
                         MD2_priem_ziv_prirastok_chov_500,
                         MD2_vyradene,
                         rok,
                         plem_podiel,
                         EKOCHOV
                       from Roc_MPHD_Tab_17
                       where rok = year(@datumOd) - 1
                       union --ak mal podnik iba jeden chov, zoberie sa ako data za podnik
                       select  kraj,
                         okres,
                         podnik,
                         '' as chov,
                         '' as mastal,
                         K1_poc,
                         K1_poc_120,
                         K1_perc_120,
                         K1_poc_210,
                         K1_perc_210,
                         K1_poc_365,
                         K1_perc_365,
                         K1_poc_500,
                         K1_perc_500,
                         K1_Priem_Hm_120,
                         K1_Priem_Hm_210,
                         K1_Priem_Hm_365,
                         K1_Priem_Hm_500,
                         K1_priem_ziv_prir_120,
                         K1_priem_ziv_prir_210,
                         K1_priem_ziv_prir_365,
                         K1_priem_ziv_prir_500,
                         K1_medziobd,
                         K1_vek_1_otel,
                         K1_priem_lakt,
                         MD1_poc,
                         MD1_poc_vaz_120,
                         MD1_perc_120,
                         MD1_poc_vaz_210,
                         MD1_perc_210,
                         MD1_poc_vaz_365,
                         MD1_perc_365,
                         MD1_poc_vaz_500,
                         MD1_perc_500,
                         MD1_Priem_Hm_120,
                         MD1_Priem_Hm_210,
                         MD1_Priem_Hm_365,
                         MD1_Priem_Hm_500,
                         MD1_priem_ziv_prirastok_chov_120,
                         MD1_priem_ziv_prirastok_chov_210,
                         MD1_priem_ziv_prirastok_chov_365,
                         MD1_priem_ziv_prirastok_chov_500,
                         K2_poc,
                         K2_poc_120,
                         K2_perc_120,
                         K2_poc_210,
                         K2_perc_210,
                         K2_poc_365,
                         K2_perc_365,
                         K2_poc_500,
                         K2_perc_500,
                         K2_Priem_Hm_120,
                         K2_Priem_Hm_210,
                         K2_Priem_Hm_365,
                         K2_Priem_Hm_500,
                         K2_priem_ziv_prirastok_120,
                         K2_priem_ziv_prirastok_210,
                         K2_priem_ziv_prirastok_365,
                         K2_priem_ziv_prirastok_500,
                         K2_medziobd,
                         K2_vek_1_otel,
                         K2_priem_lakt,
                         K2_vyradene,
                         J_poc,
                         J_poc_vaz_120,
                         J_perc_120,
                         J_poc_vaz_210,
                         J_perc_210,
                         J_poc_vaz_365,
                         J_perc_365,
                         J_poc_vaz_500,
                         J_perc_500,
                         J_Priem_Hm_120,
                         J_Priem_Hm_210,
                         J_Priem_Hm_365,
                         J_Priem_Hm_500,
                         J_priem_ziv_prirastok_chov_120,
                         J_priem_ziv_prirastok_chov_210,
                         J_priem_ziv_prirastok_chov_365,
                         J_priem_ziv_prirastok_chov_500,
                         B_poc,
                         B_poc_vaz_120,
                         B_perc_120,
                         B_poc_vaz_210,
                         B_perc_210,
                         B_poc_vaz_365,
                         B_perc_365,
                         B_poc_vaz_500,
                         B_perc_500,
                         B_Priem_Hm_120,
                         B_Priem_Hm_210,
                         B_Priem_Hm_365,
                         B_Priem_Hm_500,
                         B_priem_ziv_prirastok_chov_120,
                         B_priem_ziv_prirastok_chov_210,
                         B_priem_ziv_prirastok_chov_365,
                         B_priem_ziv_prirastok_chov_500,
                         MD2_poc,
                         MD2_poc_vaz_120,
                         MD2_perc_120,
                         MD2_poc_vaz_210,
                         MD2_perc_210,
                         MD2_poc_vaz_365,
                         MD2_perc_365,
                         MD2_poc_vaz_500,
                         MD2_perc_500,
                         MD2_Priem_Hm_120,
                         MD2_Priem_Hm_210,
                         MD2_Priem_Hm_365,
                         MD2_Priem_Hm_500,
                         MD2_priem_ziv_prirastok_chov_120,
                         MD2_priem_ziv_prirastok_chov_210,
                         MD2_priem_ziv_prirastok_chov_365,
                         MD2_priem_ziv_prirastok_chov_500,
                         MD2_vyradene,
                         rok,
                         plem_podiel,
                         EKOCHOV
                       from Roc_MPHD_Tab_17
                       where rok = year(@datumOd) - 1
                             and kraj+okres+podnik in (select kraj+okres++podnik from Roc_MPHD_Tab_17 where rok = year(@datumOd) - 1 and len(chov) > 0 and len(mastal) > 0 group by kraj, okres, podnik having count(*) = 1)
                             and kraj+okres+podnik not in (select kraj+okres++podnik from Roc_MPHD_Tab_17 where rok = year(@datumOd) - 1 and len(chov) = 0 and len(mastal) = 0 )
                      ) as predch
        on akt.kraj = predch.kraj and akt.okres = predch.okres and akt.podnik = predch.podnik and akt.chov = predch.chov and
           akt.mastal = predch.mastal
    where akt.rok = year(@datumOd)
    order by akt.kraj, akt.okres, akt.podnik, akt.chov, akt.mastal
	end
go



----------------------------------------------------------------------------------------------------------


CREATE procedure [dbo].[Rocenka_MLHD_Tab_14]
    @rok varchar(4),
	@Plem_typ varchar(6),
	@Ml_B varchar(1)
	
as
begin

	
	select * 
	from plis.dbo.Roc_MLHD_Tab_14 as z
	where   z.rok = @rok and z. Plem_typ=@Plem_typ and z.Ml_B = @Ml_B 
  order by Por
end
go



-----------------------------------------------------------------------------------------------------------

CREATE procedure [dbo].[Rocenka_MPHD_17]
	--@chov varchar(9),
	@datumOd date

	as 
	begin

    select
      o.NAZOV                                                                                                       as Okres_nazov,
      pk.NAZOVSKR                                                                                                   as Podnik_nazov,
      ch.NAZOV                                                                                                      as Chov_nazov,
      pk.OBEC                                                                                                       as Sidlo,
      p.kraj,
      p.okres,
      p.podnik,
      p.chov,
      p.mastal,
      p.ekochov,
      p.plem_podiel,
      isnull(k.TITUL_PRED, '') + isnull(k.MENO, '') + ' ' + isnull(k.PRIEZVISKO, '') + ' ' + isnull(k.TITUL_ZA,
                                                                                                    '')             as predstavitel_1,
      isnull(k.FUNKCIA,
             '')                                                                                                    as funkcia_1,
      isnull(z.TITUL_PRED, '') + isnull(z.MENO, '') + ' ' + isnull(z.PRIEZVISKO, '') + ' ' + isnull(z.TITUL_ZA,
                                                                                                    '')             as predstavitel_2,
      isnull(z.FUNKCIA,
             '')                                                                                                    as funkcia_2,
      K1_poc,
      K1_poc_120,
      K1_perc_120,
      K1_poc_210,
      K1_perc_210,
      K1_poc_365,
      K1_perc_365,
      K1_poc_500,
      K1_perc_500,
      K1_Priem_Hm_120,
      K1_Priem_Hm_210,
      K1_Priem_Hm_365,
      K1_Priem_Hm_500,
      K1_priem_ziv_prir_120,
      K1_priem_ziv_prir_210,
      K1_priem_ziv_prir_365,
      K1_priem_ziv_prir_500,
      K1_medziobd,
      K1_vek_1_otel,
      K1_priem_lakt,
      MD1_poc,
      MD1_poc_vaz_120,
      MD1_perc_120,
      MD1_poc_vaz_210,
      MD1_perc_210,
      MD1_poc_vaz_365,
      MD1_perc_365,
      MD1_poc_vaz_500,
      MD1_perc_500,
      MD1_Priem_Hm_120,
      MD1_Priem_Hm_210,
      MD1_Priem_Hm_365,
      MD1_Priem_Hm_500,
      MD1_priem_ziv_prirastok_chov_120,
      MD1_priem_ziv_prirastok_chov_210,
      MD1_priem_ziv_prirastok_chov_365,
      MD1_priem_ziv_prirastok_chov_500,
      K2_poc,
      K2_poc_120,
      K2_perc_120,
      K2_poc_210,
      K2_perc_210,
      K2_poc_365,
      K2_perc_365,
      K2_poc_500,
      K2_Priem_Hm_120,
      K2_Priem_Hm_210,
      K2_Priem_Hm_365,
      K2_Priem_Hm_500,
      K2_perc_500,
      K2_priem_ziv_prirastok_120,
      K2_priem_ziv_prirastok_210,
      K2_priem_ziv_prirastok_365,
      K2_priem_ziv_prirastok_500,
      K2_medziobd,
      K2_vek_1_otel,
      K2_priem_lakt,
      K2_vyradene,
      J_poc,
      J_poc_vaz_120,
      nullif(J_perc_120,0) as J_perc_120,
      J_poc_vaz_210,
      nullif(J_perc_210,0) as J_perc_210,
      J_poc_vaz_365,
      nullif(J_perc_365,0) as J_perc_365,
      J_poc_vaz_500,
      nullif(J_perc_500,0) as J_perc_500,
      nullif(J_Priem_Hm_120,0) as J_Priem_Hm_120,
      nullif(J_Priem_Hm_210,0) as J_Priem_Hm_210,
      nullif(J_Priem_Hm_365,0) as J_Priem_Hm_365,
      nullif(J_Priem_Hm_500,0) as J_Priem_Hm_500,
      nullif(J_priem_ziv_prirastok_chov_120,0) as J_priem_ziv_prirastok_chov_120,
      nullif(J_priem_ziv_prirastok_chov_210,0) as J_priem_ziv_prirastok_chov_210,
      nullif(J_priem_ziv_prirastok_chov_365,0) as J_priem_ziv_prirastok_chov_365,
      nullif(J_priem_ziv_prirastok_chov_500,0) as J_priem_ziv_prirastok_chov_500,
      B_poc,
      B_poc_vaz_120,
      B_perc_120,
      B_poc_vaz_210,
      B_perc_210,
      B_poc_vaz_365,
      B_perc_365,
      B_poc_vaz_500,
      B_perc_500,
      B_Priem_Hm_120,
      B_Priem_Hm_210,
      B_Priem_Hm_365,
      B_Priem_Hm_500,
      B_priem_ziv_prirastok_chov_120,
      B_priem_ziv_prirastok_chov_210,
      B_priem_ziv_prirastok_chov_365,
      B_priem_ziv_prirastok_chov_500,
      MD2_poc,
      MD2_poc_vaz_120,
      MD2_perc_120,
      MD2_poc_vaz_210,
      MD2_perc_210,
      MD2_poc_vaz_365,
      MD2_perc_365,
      MD2_poc_vaz_500,
      MD2_perc_500,
      MD2_Priem_Hm_120,
      MD2_Priem_Hm_210,
      MD2_Priem_Hm_365,
      MD2_Priem_Hm_500,
      MD2_priem_ziv_prirastok_chov_120,
      MD2_priem_ziv_prirastok_chov_210,
      MD2_priem_ziv_prirastok_chov_365,
      MD2_priem_ziv_prirastok_chov_500,
      MD2_vyradene,
      rok


	
	from Roc_MPHD_Tab_17 as p
		  left join  NC_OKRES as o  on p.kraj+ p.okres  = o.kraj + o.okres 
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK = p.KRAJ + p.OKRES + p.PODNIK
		  left outer join NM_PODNIK as pk on pk.KRAJ + pk.OKRES + pk.PODNIK =  p.kraj + p.okres + p.podnik --LEFT(@chov,6)
		  left outer join NM_Konatel as k on k.ID = pk.ID_KONATEL
		  left outer join NM_Zootechnik as z on z.ID = ch.ID_ZOOTECHNIK
	where p.kraj + p.okres + p.podnik + p.chov + p.mastal =  ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV
		  and datepart(year,@datumOd) = p.rok
		  --and ch.KRAJ + ch.OKRES + ch.PODNIK + ch.CHOV = @chov
		and ch.TYPZV= 1
		and ch.chov not in ('010','700', '699') 
		and left(ch.chov,1) ='7'
		and (ch.ZRUS is null or(ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
        and ch.kraj + ch.okres + ch.podnik + ch.chov in (select kraj + okres + podnik + chov
                                                         from NM_HDDETAIL
                                                         where
                                                           SPVYKON = '4' and PRIZNAK = '01' /*AND TECHUSMD <> '00'*/)
	union
		select  o.NAZOV as Okres_nazov,  pk.NAZOVSKR as Podnik_nazov, '' as Chov_nazov, '' as Sidlo, 
			p.kraj, p.okres, p.podnik, '99' as Chov, '9' as mastal,  p.ekochov,'' as plem_podiel,
			'' as predstavitel_1, '' as funkcia_1,
			'' as predstavitel_2, '' as funkcia_2,
			K1_poc, K1_poc_120, K1_perc_120, K1_poc_210, K1_perc_210, K1_poc_365, K1_perc_365, K1_poc_500,
			K1_perc_500, K1_Priem_Hm_120, K1_Priem_Hm_210, K1_Priem_Hm_365, K1_Priem_Hm_500, K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365,
			K1_priem_ziv_prir_500, K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
			MD1_poc, MD1_poc_vaz_120, MD1_perc_120 , MD1_poc_vaz_210, MD1_perc_210, MD1_poc_vaz_365, MD1_perc_365,
			MD1_poc_vaz_500, MD1_perc_500, MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
			MD1_priem_ziv_prirastok_chov_500,
			K2_poc, K2_poc_120,	K2_perc_120, K2_poc_210, K2_perc_210, K2_poc_365, K2_perc_365, K2_poc_500,
			K2_Priem_Hm_120, K2_Priem_Hm_210, K2_Priem_Hm_365, K2_Priem_Hm_500,
			K2_perc_500, K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
			K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene, 
			J_poc, J_poc_vaz_120, J_perc_120, J_poc_vaz_210 , J_perc_210, J_poc_vaz_365, J_perc_365, J_poc_vaz_500,
			J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
			J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
			B_poc, B_poc_vaz_120, B_perc_120, B_poc_vaz_210, B_perc_210, B_poc_vaz_365, B_perc_365, B_poc_vaz_500,
			B_perc_500, B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
			B_priem_ziv_prirastok_chov_500 ,
			MD2_poc, MD2_poc_vaz_120 , MD2_perc_120, MD2_poc_vaz_210, MD2_perc_210, MD2_poc_vaz_365, MD2_perc_365, MD2_poc_vaz_500, MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
			MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene, rok
		from Roc_MPHD_Tab_17 as p
		  left join  NC_OKRES as o  on p.kraj+ p.okres  = o.kraj + o.okres 
		  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK = p.KRAJ + p.OKRES + p.PODNIK
		  left outer join NM_PODNIK as pk on pk.KRAJ + pk.OKRES + pk.PODNIK =  p.kraj + p.okres + p.podnik --LEFT(@chov,6)
		  left outer join NM_Konatel as k on k.ID = pk.ID_KONATEL
		  left outer join NM_Zootechnik as z on z.ID = ch.ID_ZOOTECHNIK
		
    where p.okres <> '' and p.Podnik <> '' and p.Chov = ''
          and ch.kraj + ch.okres + ch.podnik + ch.chov in (select kraj + okres + podnik + chov
                                                           from NM_HDDETAIL
                                                           where
                                                             SPVYKON = '4' and PRIZNAK = '01' /*AND TECHUSMD <> '00'*/)






  order by kraj, okres, podnik, chov,mastal
			
	end
go





---------------------------------------------------------------------------------------------



CREATE procedure [dbo].[Roc_MPHD_17]
	@chov varchar(9),
	@datumOd date,
	@datumDo date
	
as 
begin

delete from Roc_MPHD_Tab_17 where rok = DATEPART(year, @datumOd) and @chov = kraj + okres + podnik + chov + mastal
--declare @chov varchar(9) = '611003711'-- '201542701' -- '304152701'
--declare @datumOD date = '2018-01-01'

declare @hlavna table
(
	kraj varchar(1),
	okres varchar(2),
	podnik varchar(3),
	chov varchar(3),
	mastal varchar(1),
	ekochov varchar(4),
	K1_poc int,
	K1_poc_120 int,
	K1_poc_210 int,
	K1_poc_365 int,
	K1_poc_500 int,
	K1_Priem_Hm_120 real, 
	K1_Priem_Hm_210 real,
	K1_Priem_Hm_365 real,
	K1_Priem_Hm_500 real,
	K1_priem_ziv_prir_120 real,
	K1_priem_ziv_prir_210 real,
	K1_priem_ziv_prir_365 real,
	K1_priem_ziv_prir_500 real,
	K1_medziobd int,
	K1_vek_1_otel varchar(7),
	K1_priem_lakt real,
	MD1_poc int,
	MD1_poc_vaz_120 int,
	MD1_poc_vaz_210 int,
	MD1_poc_vaz_365 int,
	MD1_poc_vaz_500 int,
	MD1_Priem_Hm_120 real, 
	MD1_Priem_Hm_210 real,  
	MD1_Priem_Hm_365 real,  
	MD1_Priem_Hm_500 real,  
	MD1_priem_ziv_prirastok_chov_120 real,  
	MD1_priem_ziv_prirastok_chov_210 real,  
	MD1_priem_ziv_prirastok_chov_365 real,  
	MD1_priem_ziv_prirastok_chov_500 real,
	K2_poc int,   -----priemerny stav krav na chove v danom obdobi
	K2_poc_120 int,
	K2_poc_210 int,
	K2_poc_365 int,
	K2_poc_500 int,
	K2_Priem_Hm_120 real, 
	K2_Priem_Hm_210 real,
	K2_Priem_Hm_365 real,
	K2_Priem_Hm_500 real,
	K2_priem_ziv_prirastok_120 int,
	K2_priem_ziv_prirastok_210 int,
	K2_priem_ziv_prirastok_365 int,
	K2_priem_ziv_prirastok_500 int,
	K2_medziobd int,
	K2_vek_1_otel varchar(7),
	K2_priem_lakt real,
	K2_vyradene int,
	J_poc int,
	J_poc_vaz_120 int,
	J_poc_vaz_210 int,
	J_poc_vaz_365 int,
	J_poc_vaz_500 int,
	J_Priem_Hm_120 real, 
	J_Priem_Hm_210 real,  
	J_Priem_Hm_365 real,  
	J_Priem_Hm_500 real,  
	J_priem_ziv_prirastok_chov_120 real,  
	J_priem_ziv_prirastok_chov_210 real,  
	J_priem_ziv_prirastok_chov_365 real,  
	J_priem_ziv_prirastok_chov_500 real,
	B_poc int,
	B_poc_vaz_120 int,
	B_poc_vaz_210 int,
	B_poc_vaz_365 int,
	B_poc_vaz_500 int,
	B_Priem_Hm_120 real, 
	B_Priem_Hm_210 real,  
	B_Priem_Hm_365 real,  
	B_Priem_Hm_500 real,  
	B_priem_ziv_prirastok_chov_120 real,  
	B_priem_ziv_prirastok_chov_210 real,  
	B_priem_ziv_prirastok_chov_365 real,  
	B_priem_ziv_prirastok_chov_500 real,
	MD2_poc int,
	MD2_poc_vaz_120 int,
	MD2_poc_vaz_210 int,
	MD2_poc_vaz_365 int,
	MD2_poc_vaz_500 int,
	MD2_Priem_Hm_120 real, 
	MD2_Priem_Hm_210 real,  
	MD2_Priem_Hm_365 real,  
	MD2_Priem_Hm_500 real,  
	MD2_priem_ziv_prirastok_chov_120 real,  
	MD2_priem_ziv_prirastok_chov_210 real,  
	MD2_priem_ziv_prirastok_chov_365 real,  
	MD2_priem_ziv_prirastok_chov_500 real,
	MD2_vyradene int
)

/***** CHOV ****/
if (len(@chov) = 9)
	begin
	declare @eko varchar(4) -- ci je chov ekologicky alebo nie
		set @eko = (select case when EkoChov = 1 then 'eko' else ''end from NM_CHOVMAS where KRAJ + OKRES + podnik + CHOV = @chov)

	/**aktualny stav  Kravy  *****************/
	declare @poc_K1 int --pocet krav
		set @poc_K1 = (select count(*) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' 
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K1_120 int 
		set @poc_K1_120 = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm120 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_210 int
		set @poc_K1_210 = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm210 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_365 int
		set @poc_K1_365 = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm365 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_500 int
		set @poc_K1_500 = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm500 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	

	/**  STAVY ZA KONTROLNY ROK Kravy  *******/
	declare @poc_K2 int --priemerny stav krav na chove
		set @poc_K2 = (select sum(Pocet_dni_na_chove)/365 from Roc_MPHD_Tab_zaklad
						where kraj + okres + podnik + chov + mastal = @chov
							and KrJal='K'
							and rok = DATEPART(YEAR, @datumOd))		
		
	declare @poc_K2_120 int --pocet krav
		set @poc_K2_120 = (select count(Hm120) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_210 int
		set @poc_K2_210 = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_365 int
		set @poc_K2_365 = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_500 int
		set @poc_K2_500 = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))

	/**aktualny stav  MD Mlady dobytok  *****************/
	declare @poc_MD1 int --pocet
		set @poc_MD1 = (select count(*) 
								from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' 
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD1_120 int --pocet krav
		set @poc_MD1_120 = (select count(Hm120)	from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_210 int
		set @poc_MD1_210 = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal <> 'K' and Hm210 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_365 int
		set @poc_MD1_365 = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal <> 'K' and Hm365 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_500 int
		set @poc_MD1_500 = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal <> 'K' and Hm500 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))		

 /**  STAVY ZA KONTROLNY ROK MD Mlady dobytok  *****************/
	declare @poc_MD2 int --pocet krav
			set @poc_MD2 = (select count(*) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' 
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_120 int --pocet krav
			set @poc_MD2_120 = (select count(Hm120)	from Roc_MPHD_Tab_zaklad 
									where kraj + okres + podnik + chov + mastal = @chov
										and KrJal <> 'K' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_210 int
		set @poc_MD2_210 = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal <> 'K' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_365 int
		set @poc_MD2_365 = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal <> 'K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_500 int
		set @poc_MD2_500 = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal <> 'K' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))

	/**  STAVY ZA KONTROLNY ROK J Jalovice  *****************/
	declare @poc_J int --pocet jalovic
		set @poc_J = (select count(*) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + podnik + chov + mastal = @chov
							and KrJal ='J'
							and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_120 int --pocet jalovic
		set @poc_J_120 = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal ='J' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_210 int
		set @poc_J_210 = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal ='J' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_365 int
		set @poc_J_365 = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal ='J' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_500 int
		set @poc_J_500 = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal ='J' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))

	/**  STAVY ZA KONTROLNY ROK B Bycky *********************/
	declare @poc_B int --pocet byckov
		set @poc_B = (select count(*) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + podnik + chov + mastal = @chov
							and KrJal ='B' 
							and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_120 int --pocet byckov
		set @poc_B_120 = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal ='B' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_210 int
		set @poc_B_210 = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal ='B' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_365 int
		set @poc_B_365 = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal ='B' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_500 int
		set @poc_B_500 = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal ='B' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))
	/*
	vlozenie do dočasnej hlavnej tabulky
	*/
	 insert into @hlavna
		 (kraj, okres, podnik, chov, mastal, ekochov,
		 K1_poc, K1_poc_120, /*K1_perc_120, */K1_poc_210,/*K1_perc_210,*/K1_poc_365, /*K1_perc_365,*/ K1_poc_500,/*K1_perc_500,*/ 
		 K2_poc,K2_poc_120,/* K2_perc_120,*/ K2_poc_210, /*K2_perc_210,*/ K2_poc_365, /*K2_perc_365,*/ K2_poc_500, /*K2_perc_500, */
		 MD1_poc, MD1_poc_vaz_120,/* MD1_perc_120,*/ MD1_poc_vaz_210,/* MD1_perc_210,*/ MD1_poc_vaz_365, /*MD1_perc_365,*/ MD1_poc_vaz_500, /*MD1_perc_500,*/
		 MD2_poc, MD2_poc_vaz_120, /*MD2_perc_120,*/ MD2_poc_vaz_210,/* MD2_perc_210,*/ MD2_poc_vaz_365,/* MD2_perc_365,*/ MD2_poc_vaz_500, /*MD2_perc_500, */
		 J_poc, J_poc_vaz_120,/* J_perc_120,*/ J_poc_vaz_210,/* J_perc_210,*/ J_poc_vaz_365,/* J_perc_365,*/ J_poc_vaz_500,/* J_perc_500, */
		 B_poc, B_poc_vaz_120, /*B_perc_120,*/ B_poc_vaz_210,/* B_perc_210,*/ B_poc_vaz_365,/* B_perc_365,*/ B_poc_vaz_500 /*B_perc_500*/)
	 select left(@chov,1) as kraj, substring(@chov,2,2) as okres, substring(@chov,4,3) as podnik, substring(@chov,7,2) as chov, right(@chov,1) as mastal, @eko as ekochov,
		@poc_K1 as K1_poc,
		@poc_K1_120 as K1_poc_120,
		@poc_K1_210 as K1_poc_210,
		@poc_K1_365 as K1_poc_365,
		@poc_K1_500 as K1_poc_500,
		@poc_K2 as K2_poc,
		@poc_K2_120 as K2_poc_120,
		@poc_K2_210 as K2_poc_210,
		@poc_K2_365 as K2_poc_365,
		@poc_K2_500 as K2_poc_500,
		@poc_MD1 as MD1_poc,
		@poc_MD1_120 as MD1_poc_vaz_120,
		@poc_MD1_210 as MD1_poc_vaz_210,
		@poc_MD1_365 as MD1_poc_vaz_365,
		@poc_MD1_500 as MD1_poc_vaz_500,
		@poc_MD2 as MD2_poc,
		@poc_MD2_120 as MD2_poc_vaz_120,
		@poc_MD2_210 as MD2_poc_vaz_210,
		@poc_MD2_365 as MD2_poc_vaz_365,
		@poc_MD2_500 as MD2_poc_vaz_500,
		@poc_J as J_poc,
		@poc_J_120 as J_poc_vaz_120,
		@poc_J_210 as J_poc_vaz_210,
		@poc_J_365 as J_poc_vaz_365,
		@poc_J_500 as J_poc_vaz_500,
		@poc_B as B_poc,
		@poc_B_120 as B_poc_vaz_120,
		@poc_B_210 as B_poc_vaz_210,
		@poc_B_365 as B_poc_vaz_365,
		@poc_B_500 as B_poc_vaz_500
		
	/**aktualne stavy na chove**/			
	declare @spolu_K1_hm120 float
		set @spolu_K1_hm120 = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm210 float
		set @spolu_K1_hm210 = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm365 float
		set @spolu_K1_hm365 = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm500 float
		set @spolu_K1_hm500 = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_120 float
		set @hmotnar_K1_120 = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_210 float
		set @hmotnar_K1_210 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_365 float
		set @hmotnar_K1_365 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_500 float
		set @hmotnar_K1_500 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_priem_ziv_prir_120 = (select ((@spolu_K1_hm120 - @hmotnar_K1_120) / (120*nullif(@poc_K1_120,0))) *1000),-- as K1_priem_ziv_prir_120
	K1_priem_ziv_prir_210 = (select ((@spolu_K1_hm210 - @hmotnar_K1_210) / (210*nullif(@poc_K1_210,0))) *1000),-- as K1_priem_ziv_prir_210
	K1_priem_ziv_prir_365 = (select ((@spolu_K1_hm365 - @hmotnar_K1_365) / (365*nullif(@poc_K1_365,0))) *1000),-- as K1_priem_ziv_prir_365
	K1_priem_ziv_prir_500 = (select ((@spolu_K1_hm500 - @hmotnar_K1_500) / (500*nullif(@poc_K1_500,0))) *1000)-- as K1_priem_ziv_prir_500

	/** vybery pre prvy a druhy riadok		**/
	/******  --kravy  ******/
	
	/****		vek 1 oteleni K1....vypocet  ***/
	declare @vek1otel_K1 float 
	set @vek1otel_K1 = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + Podnik + chov + Mastal = @chov
									/*and Porlak = '1'*/ and Porlak is not null and datvyr is null and dovvyr is null /******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
									and rok = DATEPART(YEAR, @datumOd))

	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K1_vek_1_otel = dbo.toMesiacDen(@vek1otel_K1)--  AS  VEK_1_Otel

	--medziobdobie
	update @hlavna 
	set K1_medziobd = (select avg(medziobd) as Medziobdobie	from Roc_MPHD_Tab_zaklad 
						where kraj + okres + Podnik + chov + Mastal = @chov
								and Porlak > '1' and KrJal='K' 
								and datvyr is null and dovvyr is null
								and Medziobd > 100 and  Medziobd <= 1200
								and rok = DATEPART(YEAR, @datumOd))
	--priem.por.laktacie
	update @hlavna 
	set K1_priem_lakt = (select convert (decimal (5,2),avg(Porlak*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + Podnik + chov + Mastal = @chov 
								and Porlak is not null and KrJal='K' 
								and datvyr is null and dovvyr is null  
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' 
									and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_210 =(select convert (decimal (5,2),avg(Hm210*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' 
									and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' 
									and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal='K' 
							and Hm500 is not null
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))

	/*******	--mlady dobytok  *******/
	update @hlavna
	set MD1_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal<>'K'  
							and (Hm120 is not null or Hm120 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))	
	update @hlavna
	set MD1_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0)) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
								and KrJal<>'K' 
								and (Hm210 is not null or Hm210 <>0)
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal<>'K' 
							and (Hm365 is not null or Hm365 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal<>'K' 
							and (Hm500 is not null or Hm500 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
							
/**  STAVY ZA KONTROLNY ROK J  **********************************/
	update @hlavna
		set J_Priem_Hm_120 =( select convert (decimal (5,2),avg(Hm120*1.0))	from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
								and KrJal = 'J'   
								and (Hm120 is not null or Hm120 <>0)
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_210 = ( select convert (decimal (5,2),avg(Hm210*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal = 'J' 
							and (Hm210 is not null or Hm210 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))	from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal = 'J'  
							and(Hm365 is not null or Hm365 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal = 'J' 
							and (Hm500 is not null or Hm500 <>0)
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK B  **********************/
	update @hlavna
	set B_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal = 'B'   
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal = 'B' 
							and(Hm210 is not null or Hm210 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal = 'B'  
							and (Hm365 is not null or Hm365 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal = 'B' 
							and (Hm500 is not null or Hm500 <>0)
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK MD  **********************/	
	update @hlavna
	set MD2_vyradene =( select count(*) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal <> 'K'  
							and Datvyr >= @datumOD
							and rok = DATEPART(YEAR, @datumOd))		
	update @hlavna
	set MD2_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal <> 'K'  
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal <> 'K'
							and (Hm210 is not null or Hm210 <>0)
							and rok = DATEPART(YEAR, @datumOd))



	update @hlavna
	set MD2_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal <> 'K' 
							and (Hm365 is not null or Hm365 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal <> 'K'
							and (Hm500 is not null or Hm500 <>0)
							and rok = DATEPART(YEAR, @datumOd))

/**aktualny stav  MD Mlady dobytok  *****************/	
	declare @spolu_MD1_hm120 float
		set @spolu_MD1_hm120 = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm210 float
		set @spolu_MD1_hm210 = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))

	declare @spolu_MD1_hm365 float
		set @spolu_MD1_hm365 = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))

	declare @spolu_MD1_hm500 float
		set @spolu_MD1_hm500 = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_120 float
		set @hmotnar_MD1_120 = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))		
	declare @hmotnar_MD1_210 float
		set @hmotnar_MD1_210 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_365 float
		set @hmotnar_MD1_365 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_500 float
		set @hmotnar_MD1_500 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set MD1_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD1_hm120 - @hmotnar_MD1_120) / (120*nullif(@poc_MD1_120,0))) *1000),-- as MD1_priem_ziv_prirastok_chov_120
	 MD1_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD1_hm210 - @hmotnar_MD1_210) / (210*nullif(@poc_MD1_210,0))) *1000),-- as MD1_priem_ziv_prirastok_chov_210
	 MD1_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD1_hm365 - @hmotnar_MD1_365) / (365*nullif(@poc_MD1_365,0))) *1000),-- as MD1_priem_ziv_prirastok_chov_365
	 MD1_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD1_hm500 - @hmotnar_MD1_500) / (500*nullif(@poc_MD1_500,0))) *1000)-- as MD1_priem_ziv_prirastok_chov_500

	declare @spolu_J_hm120 float
		set @spolu_J_hm120 = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm210 float
		set @spolu_J_hm210 = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm365 float
		set @spolu_J_hm365 = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm500 float
		set @spolu_J_hm500 = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_120 float
		set @hmotnar_J_120 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_210 float
		set @hmotnar_J_210 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_365 float
		set @hmotnar_J_365 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_500 float
		set @hmotnar_J_500 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set J_priem_ziv_prirastok_chov_120 = (select ((@spolu_J_hm120 - @hmotnar_J_120) / (120*nullif(@poc_J_120,0))) *1000),
	 J_priem_ziv_prirastok_chov_210 = (select ((@spolu_J_hm210 - @hmotnar_J_210) / (210*nullif(@poc_J_210,0))) *1000),
	 J_priem_ziv_prirastok_chov_365 = (select ((@spolu_J_hm365 - @hmotnar_J_365) / (365*nullif(@poc_J_365,0))) *1000),
	 J_priem_ziv_prirastok_chov_500 = (select ((@spolu_J_hm500 - @hmotnar_J_500) / (500*nullif(@poc_J_500,0))) *1000)
	
	declare @spolu_B_hm120 float
		set @spolu_B_hm120 = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'B' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm210 float
		set @spolu_B_hm210 = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'B' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm365 float
		set @spolu_B_hm365 = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'B' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm500 float
		set @spolu_B_hm500 = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'B' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_120 float
		set @hmotnar_B_120 = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'B' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_210 float
		set @hmotnar_B_210 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'B' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_365 float
		set @hmotnar_B_365 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'B' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_500 float
		set @hmotnar_B_500 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal = 'B' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set B_priem_ziv_prirastok_chov_120 = (select ((@spolu_B_hm120 - @hmotnar_B_120) / (120*nullif(@poc_B_120,0))) *1000),
	 B_priem_ziv_prirastok_chov_210 = (select ((@spolu_B_hm210 - @hmotnar_B_210) / (210*nullif(@poc_B_210,0))) *1000),
	 B_priem_ziv_prirastok_chov_365 = (select ((@spolu_B_hm365 - @hmotnar_B_365) / (365*nullif(@poc_B_365,0))) *1000),
	 B_priem_ziv_prirastok_chov_500 = (select ((@spolu_B_hm500 - @hmotnar_B_500) / (500*nullif(@poc_B_500,0))) *1000)


	declare @spolu_MD2_hm120 float
		set @spolu_MD2_hm120 = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm210 float
		set @spolu_MD2_hm210 = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm365 float
		set @spolu_MD2_hm365 = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm500 float
		set @spolu_MD2_hm500 = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_120 float
		set @hmotnar_MD2_120 = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_210 float
		set @hmotnar_MD2_210 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_365 float
		set @hmotnar_MD2_365 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_500 float
		set @hmotnar_MD2_500 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set MD2_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD2_hm120 - @hmotnar_MD2_120) / (120*nullif(@poc_MD2_120,0))) *1000),
	 MD2_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD2_hm210 - @hmotnar_MD2_210) / (210*nullif(@poc_MD2_210,0))) *1000),
	 MD2_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD2_hm365 - @hmotnar_MD2_365) / (365*nullif(@poc_MD2_365,0))) *1000),
	 MD2_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD2_hm500 - @hmotnar_MD2_500) / (500*nullif(@poc_MD2_500,0))) *1000)
	 
/****		vek 1 oteleni K2....vypocet  ***/
	declare @vek1otel_K2 float 
	set @vek1otel_K2 = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + Podnik + chov + Mastal = @chov
									/*and Porlak = '1'*/and Porlak is not null /******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
									and rok = DATEPART(YEAR, @datumOd)) --and (datvyr is null or Datvyr >= @datumOD))

	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K2_vek_1_otel = dbo.toMesiacDen(@vek1otel_K2)--  AS  VEK_1_Otel

	update @hlavna 
	set K2_priem_lakt = ( select convert (decimal (5,2),avg(Porlak*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + Podnik + chov + Mastal = @chov 
								and Porlak is not null and KrJal='K' 
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_vyradene =( select count(*) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + podnik + chov + mastal = @chov
						and KrJal = 'K'  
						and Datvyr >= @datumOD
						and rok = DATEPART(YEAR, @datumOd))

	--medziobdobie
	update @hlavna 
	set K2_medziobd = (select avg(medziobd) as Medziobdobie	from Roc_MPHD_Tab_zaklad 
						where kraj + okres + Podnik + chov + Mastal = @chov
								and Porlak > '1' and KrJal='K'
								and Medziobd > 100 and  Medziobd <= 1200
								and rok = DATEPART(YEAR, @datumOd)) 
declare @spolu_K2_hm120 float
	set @spolu_K2_hm120 = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm210 float
	set @spolu_K2_hm210 = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm365 float
	set @spolu_K2_hm365 = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm500 float
	set @spolu_K2_hm500 = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_120 float
	set @hmotnar_K2_120 = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_210 float
	set @hmotnar_K2_210 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_365 float
	set @hmotnar_K2_365 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_500 float
	set @hmotnar_K2_500 = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal='K' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))
	Update @hlavna 
	set K2_priem_ziv_prirastok_120 = (select ((@spolu_K2_hm120 - @hmotnar_K2_120) / (120*nullif(@poc_K2_120,0))) *1000),-- as K2_priem_ziv_prirastok_120
	K2_priem_ziv_prirastok_210 = (select ((@spolu_K2_hm210 - @hmotnar_K2_210) / (210*nullif(@poc_K2_210,0))) *1000),--  as K2_priem_ziv_prirastok_210
	K2_priem_ziv_prirastok_365 = (select ((@spolu_K2_hm365 - @hmotnar_K2_365) / (365*nullif(@poc_K2_365,0))) *1000),--  as K2_priem_ziv_prirastok_365
	K2_priem_ziv_prirastok_500 = (select ((@spolu_K2_hm500 - @hmotnar_K2_500) / (500*nullif(@poc_K2_500,0))) *1000)--  as K2_priem_ziv_prirastok_500

	update @hlavna 
	set K2_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' 
									and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_210 =(select convert (decimal (5,2),avg(Hm210*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' 
									and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
									and KrJal='K' 
									and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
							and KrJal='K' 
							and Hm500 is not null 
							and rok = DATEPART(YEAR, @datumOd))
--zacata oprava 
--declare @datumOd date = '2018-01-01', @chov varchar(14) = '502101701'

/******podiel plemena na chove******/
		declare @podiely table				-----PL1 a ich podiel v chove
		(
			CHOVATEL varchar (9),
			PL1 varchar(3),
			KR1 float,
			PodielPerc float,
			spolu float
		)
		if ((select count(*) from Roc_MPHD_Tab_zaklad
		where  kraj + okres + podnik + Chov + Mastal = @chov
					 and KrJal = 'K') > 0)
			Insert into @podiely
			(PL1, CHOVATEL,  KR1, PodielPerc, spolu)

				select distinct	 z.pl1 as PL1,
													z.kraj + z.okres + z.podnik + z.Chov + z.Mastal as chovatel,
													sum(z.KR1)as KR1,
													(sum(z.KR1)/(select sum(k1.KR1)from Roc_MPHD_Tab_zaklad as k1
													where k1.kraj + k1.okres + k1.podnik + k1.Chov + k1.Mastal = z.kraj + z.okres + z.podnik + z.Chov + z.Mastal
																and KrJal = 'K'))*100 as PodielPerc,
													((select sum(k1.KR1)from Roc_MPHD_Tab_zaklad as k1
													where k1.kraj + k1.okres + k1.podnik + k1.Chov + k1.Mastal = z.kraj + z.okres + z.podnik + z.Chov + z.Mastal
																and KrJal = 'K')) as spolu

				from Roc_MPHD_Tab_zaklad as z
				where z.kraj + z.okres + z.podnik + z.chov + z.mastal = @chov
							and KrJal = 'K'
				group by z.PL1, z.kraj + z.okres + z.podnik + z.Chov + z.Mastal
		ELSE
			Insert into @podiely
			(PL1, CHOVATEL,  KR1, PodielPerc, spolu)

				select distinct	 z.pl1 as PL1,
													z.kraj + z.okres + z.podnik + z.Chov + z.Mastal  as chovatel,
													sum(z.KR1)as KR1,
													(sum(z.KR1)/(select sum(k1.KR1)from Roc_MPHD_Tab_zaklad as k1
													where k1.kraj + k1.okres + k1.podnik + k1.Chov + k1.Mastal = z.kraj + z.okres + z.podnik + z.Chov + z.Mastal
																and KrJal <> 'K'))*100 as PodielPerc,
													((select sum(k1.KR1)from Roc_MPHD_Tab_zaklad as k1
													where k1.kraj + k1.okres + k1.podnik + k1.Chov + k1.Mastal = z.kraj + z.okres + z.podnik + z.Chov + z.Mastal
																and KrJal <> 'K')) as spolu
				from Roc_MPHD_Tab_zaklad as z
				where z.kraj + z.okres + z.podnik + z.chov + z.mastal = @chov
							and KrJal <> 'K'
				group by z.PL1, z.kraj + z.okres + z.podnik + z.Chov + z.Mastal

/******podiel plemena na chove......povodny vypocet len podla krav
	declare @podiely table				-----PL1 a ich podiel v chove
			(
			CHOVATEL varchar (9),
			PL1 varchar(3),
			KR1 float,
			PodielPerc float--
			)
	
	Insert into @podiely
	 (PL1, CHOVATEL,  KR1, PodielPerc)
	select distinct	 z.pl1 as PL1, 
			z.kraj + z.okres + z.podnik + z.Chov + z.Mastal as chovatel,
			sum(z.KR1)as KR1,
			(sum(z.KR1)/(select sum(k1.KR1)from CM_Krava as k1 
										where k1.CHOVATEL = z.kraj + z.okres + z.podnik + z.Chov + z.Mastal
											and PRIZNAKKU = 2 
											and (k1.dovvyr is null or (k1.dovvyr is not null and k1.DATVYR >= @datumOd))))*100 as PodielPerc 
		from Roc_MPHD_Tab_zaklad as z
			group by z.PL1, z.kraj + z.okres + z.podnik + z.Chov + z.Mastal
	--select * from @podiely order by chovatel, kr1 desc
	******/	

	declare @counter int,  @chovatelia varchar(9)
	declare @plemena table
			(
			PL1 varchar(3),
			KR1 float,
			PodielPerc float,
			CHOVATEL varchar (9),
			por int
			)

	declare @ZoznamPL1 table
		(
		CHOVATEL VARCHAR(9),
		plem varchar(10), 
		cisteplem varchar(1)
		)
		
	DECLARE poradie_cursor CURSOR LOCAL
		FOR
			SELECT CHOVATEL FROM @podiely group by CHOVATEL
						
		OPEN poradie_cursor
		FETCH NEXT FROM poradie_cursor INTO @chovatelia
		WHILE @@FETCH_STATUS = 0
			BEGIN 			
				--print @chovatelia			
				delete from @plemena			
				insert into @plemena
					(PL1, KR1, PodielPerc, CHOVATEL, por)
					select PL1,KR1, PodielPerc, CHOVATEL,ROW_NUMBER() OVER (ORDER BY PodielPerc desc) as por from @podiely as p where p.PodielPerc >12.5 and CHOVATEL = @chovatelia
			
				declare @PL1 varchar(10) = ISNULL((select pl1 from @plemena where por=1),'') +' '+ isnull((select PL1 from @plemena where por=2),'') +' '+ isnull((select PL1  from @plemena where por=3),'')
				declare @cistPlem varchar(1) = (select case when max(PodielPerc) = 100 then '*' else '' end from @plemena)
		
				insert into @ZoznamPL1
				select @chovatelia,@PL1, @cistPlem
						
				FETCH NEXT FROM poradie_cursor INTO @chovatelia
			END

		CLOSE poradie_cursor
		DEALLOCATE poradie_cursor

		----select * from @ZoznamPl1

insert into  Roc_MPHD_Tab_17
(		kraj, okres, podnik, chov, mastal,K1_poc, 
		K1_poc_120, K1_perc_120, 
		K1_poc_210, K1_perc_210, 
		K1_poc_365, K1_perc_365, 
		K1_poc_500,	K1_perc_500, 
		K1_Priem_Hm_120, K1_Priem_Hm_210, K1_Priem_Hm_365, K1_Priem_Hm_500, 
		K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365, K1_priem_ziv_prir_500, 
		K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
		MD1_poc, MD1_poc_vaz_120, MD1_perc_120, 
		MD1_poc_vaz_210, MD1_perc_210, MD1_poc_vaz_365, MD1_perc_365, MD1_poc_vaz_500, MD1_perc_500, 
		MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
		MD1_priem_ziv_prirastok_chov_500,
		K2_poc, K2_poc_120,	K2_perc_120, 
		K2_poc_210, K2_perc_210, 
		K2_poc_365, K2_perc_365, 
		K2_poc_500, K2_perc_500, K2_Priem_Hm_120,K2_Priem_Hm_210, K2_Priem_Hm_365, K2_Priem_Hm_500,
		K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
		K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
		J_poc, J_poc_vaz_120, J_perc_120, J_poc_vaz_210, J_perc_210, J_poc_vaz_365,  J_perc_365, J_poc_vaz_500, J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
		J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
		B_poc, B_poc_vaz_120,  B_perc_120, B_poc_vaz_210, 
		B_perc_210, B_poc_vaz_365, 
		B_perc_365, B_poc_vaz_500,
		B_perc_500, 
		B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
		B_priem_ziv_prirastok_chov_500 ,
		MD2_poc, MD2_poc_vaz_120, MD2_perc_120, MD2_poc_vaz_210, MD2_perc_210, MD2_poc_vaz_365, MD2_perc_365, MD2_poc_vaz_500, MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
		MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
		rok, plem_podiel, ekochov
)

Select kraj, okres, podnik, chov, mastal,
		K1_poc, 
		K1_poc_120, 
		(K1_poc_120*1.0 / nullif(K1_poc,0))* 100 as K1_perc_120, 
		K1_poc_210, 
		(K1_poc_210*1.0 / nullif(K1_poc,0))* 100 as K1_perc_210, 
		K1_poc_365, 
		(K1_poc_365*1.0 / nullif(K1_poc,0))* 100 as K1_perc_365, 
		K1_poc_500,	
		(K1_poc_500*1.0 / nullif(K1_poc,0))* 100 as K1_perc_500, 
		K1_Priem_Hm_120 as K1_Priem_Hm_120,
		K1_Priem_Hm_210 as K1_Priem_Hm_210, 
		K1_Priem_Hm_365 as K1_Priem_Hm_365, 
		K1_Priem_Hm_500 as K1_Priem_Hm_500, 
		K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365, K1_priem_ziv_prir_500, 
		K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
		MD1_poc, MD1_poc_vaz_120, 
		(MD1_poc_vaz_120*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_120, 
		MD1_poc_vaz_210, 
		(MD1_poc_vaz_210*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_210, 
		MD1_poc_vaz_365, 
		(MD1_poc_vaz_365*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_365,
		MD1_poc_vaz_500, 
		(MD1_poc_vaz_500*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_500, 
		MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
		MD1_priem_ziv_prirastok_chov_500,
		K2_poc, K2_poc_120,	
		(K2_poc_120*1.0 / nullif(K2_poc,0))* 100 as K2_perc_120, 
		K2_poc_210, 
		(K2_poc_210*1.0 / nullif(K2_poc,0))* 100 as K2_perc_210, 
		K2_poc_365, 
		(K2_poc_365*1.0 / nullif(K2_poc,0))* 100 as K2_perc_365, 
		K2_poc_500,
		(K2_poc_500*1.0 / nullif(K2_poc,0))* 100 as K2_perc_500, 
		K2_Priem_Hm_120 as K2_Priem_Hm_120, 
		K2_Priem_Hm_210 as K2_Priem_Hm_210, 
		K2_Priem_Hm_365 as K2_Priem_Hm_365, 
		K2_Priem_Hm_500 as K2_Priem_Hm_500,
		K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
		K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
		J_poc, J_poc_vaz_120, 
		(J_poc_vaz_120*1.0 / nullif(J_poc,0))* 100 as J_perc_120, J_poc_vaz_210, 
		(J_poc_vaz_210*1.0 / nullif(J_poc,0))* 100 as J_perc_210, J_poc_vaz_365, 
		(J_poc_vaz_365*1.0 / nullif(J_poc,0))* 100 as J_perc_365, J_poc_vaz_500,
		(J_poc_vaz_500*1.0 / nullif(J_poc,0))* 100 as J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
		J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
		B_poc, B_poc_vaz_120, 
		(B_poc_vaz_120*1.0 / nullif(B_poc,0))* 100 as B_perc_120, B_poc_vaz_210, 
		(B_poc_vaz_210*1.0 / nullif(B_poc,0))* 100 as B_perc_210, B_poc_vaz_365, 
		(B_poc_vaz_365*1.0 / nullif(B_poc,0))* 100 as B_perc_365, B_poc_vaz_500,
		(B_poc_vaz_500*1.0 / nullif(B_poc,0))* 100 as B_perc_500, 
		B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
		B_priem_ziv_prirastok_chov_500 ,
		MD2_poc, MD2_poc_vaz_120 , 
		(MD2_poc_vaz_120*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_120, MD2_poc_vaz_210, 
		(MD2_poc_vaz_210*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_210, MD2_poc_vaz_365, 
		(MD2_poc_vaz_365*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_365, MD2_poc_vaz_500, 
		(MD2_poc_vaz_500*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
		MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
		DATEPART(YEAR,@datumOd) as rok,
		(z.plem + z.cisteplem)  as plem_podiel,
		h.ekochov as ekochov		
	from @hlavna as h 
		left outer join  @ZoznamPL1 as z on z.CHOVATEL = h.kraj + h.okres + h.podnik + h.chov + h.mastal
	where h.kraj + h.okres + h.podnik + h.chov + h.mastal = @chov

	end

if (len(@chov) = 6)
	begin

	/**aktualny stav  Kravy  *****************/
	declare @poc_K1_podnik int --pocet krav
		set @poc_K1_podnik = (select count(*) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' 
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K1_120_podnik int 
		set @poc_K1_120_podnik = (select count(Hm120) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm120 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_210_podnik int
		set @poc_K1_210_podnik = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm210 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_365_podnik int
		set @poc_K1_365_podnik = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm365 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_500_podnik int
		set @poc_K1_500_podnik = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm500 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	

	/**  STAVY ZA KONTROLNY ROK Kravy  *******/
	declare @poc_K2_podnik int --priemerny stav krav na chove
		set @poc_K2_podnik = (select sum(Pocet_dni_na_chove)/365 from Roc_MPHD_Tab_zaklad
								where kraj + okres + podnik = @chov
									and KrJal='K'
									and rok = DATEPART(YEAR, @datumOd))		
		----povodny vypocet som mala nastaveny ako pocet zijucich aj vyradenych krav na chov....no ukazalo sa, ze v rocenke tento udaj znamena priemerny pocet krav na chove
		/*(select count(*) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K'
								and rok = DATEPART(YEAR, @datumOd))*/
	declare @poc_K2_120_podnik int --pocet krav
		set @poc_K2_120_podnik = (select count(Hm120) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_210_podnik int
		set @poc_K2_210_podnik = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_365_podnik int
		set @poc_K2_365_podnik = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_500_podnik int
		set @poc_K2_500_podnik = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))

	/**aktualny stav  MD Mlady dobytok  *****************/
	declare @poc_MD1_podnik int --pocet
		set @poc_MD1_podnik = (select count(*) 
								from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' 
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD1_120_podnik int --pocet krav
		set @poc_MD1_120_podnik = (select count(Hm120)	from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_210_podnik int
		set @poc_MD1_210_podnik = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal <> 'K' and Hm210 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_365_podnik int
		set @poc_MD1_365_podnik = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal <> 'K' and Hm365 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_500_podnik int
		set @poc_MD1_500_podnik = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal <> 'K' and Hm500 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))		

 /**  STAVY ZA KONTROLNY ROK MD Mlady dobytok  *****************/
	declare @poc_MD2_podnik int --pocet krav
			set @poc_MD2_podnik = (select count(*) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' 
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_120_podnik int --pocet krav
			set @poc_MD2_120_podnik = (select count(Hm120)	from Roc_MPHD_Tab_zaklad 
									where kraj + okres + podnik = @chov
										and KrJal <> 'K' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_210_podnik int
		set @poc_MD2_210_podnik = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal <> 'K' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_365_podnik int
		set @poc_MD2_365_podnik = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal <> 'K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_500_podnik int
		set @poc_MD2_500_podnik = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal <> 'K' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))

	/**  STAVY ZA KONTROLNY ROK J Jalovice  *****************/
	declare @poc_J_podnik int --pocet jalovic
		set @poc_J_podnik = (select count(*) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + podnik = @chov
							and KrJal ='J'
							and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_120_podnik int --pocet jalovic
		set @poc_J_120_podnik = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik  = @chov
								and KrJal ='J' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_210_podnik int
		set @poc_J_210_podnik = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal ='J' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_365_podnik int
		set @poc_J_365_podnik = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal ='J' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_500_podnik int
		set @poc_J_500_podnik = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal ='J' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))

	/**  STAVY ZA KONTROLNY ROK B Bycky *********************/
	declare @poc_B_podnik int --pocet byckov
		set @poc_B_podnik = (select count(*) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + podnik = @chov
							and KrJal ='B' 
							and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_120_podnik int --pocet byckov
		set @poc_B_120_podnik = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal ='B' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_210_podnik int
		set @poc_B_210_podnik = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik + chov + mastal = @chov
								and KrJal ='B' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_365_podnik int
		set @poc_B_365_podnik = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal ='B' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_500_podnik int
		set @poc_B_500_podnik = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal ='B' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))
	/*
	vlozenie do dočasnej hlavnej tabulky
	*/
	 insert into @hlavna
		 (kraj, okres, podnik, chov, mastal, 
		 K1_poc, K1_poc_120, /*K1_perc_120, */K1_poc_210,/*K1_perc_210,*/K1_poc_365, /*K1_perc_365,*/ K1_poc_500,/*K1_perc_500,*/ 
		 K2_poc,K2_poc_120,/* K2_perc_120,*/ K2_poc_210, /*K2_perc_210,*/ K2_poc_365, /*K2_perc_365,*/ K2_poc_500, /*K2_perc_500, */
		 MD1_poc, MD1_poc_vaz_120,/* MD1_perc_120,*/ MD1_poc_vaz_210,/* MD1_perc_210,*/ MD1_poc_vaz_365, /*MD1_perc_365,*/ MD1_poc_vaz_500, /*MD1_perc_500,*/
		 MD2_poc, MD2_poc_vaz_120, /*MD2_perc_120,*/ MD2_poc_vaz_210,/* MD2_perc_210,*/ MD2_poc_vaz_365,/* MD2_perc_365,*/ MD2_poc_vaz_500, /*MD2_perc_500, */
		 J_poc, J_poc_vaz_120,/* J_perc_120,*/ J_poc_vaz_210,/* J_perc_210,*/ J_poc_vaz_365,/* J_perc_365,*/ J_poc_vaz_500,/* J_perc_500, */
		 B_poc, B_poc_vaz_120, /*B_perc_120,*/ B_poc_vaz_210,/* B_perc_210,*/ B_poc_vaz_365,/* B_perc_365,*/ B_poc_vaz_500 /*B_perc_500*/)
	 select left(@chov,1) as kraj, substring(@chov,2,2) as okres, substring(@chov,4,3) as podnik, '' as chov, '' as mastal,
		@poc_K1_podnik as K1_poc,
		@poc_K1_120_podnik as K1_poc_120,
		@poc_K1_210_podnik as K1_poc_210,
		@poc_K1_365_podnik as K1_poc_365,
		@poc_K1_500_podnik as K1_poc_500,
		@poc_K2_podnik as K2_poc,
		@poc_K2_120_podnik as K2_poc_120,
		@poc_K2_210_podnik as K2_poc_210,
		@poc_K2_365_podnik as K2_poc_365,
		@poc_K2_500_podnik as K2_poc_500,
		@poc_MD1_podnik as MD1_poc,
		@poc_MD1_120_podnik as MD1_poc_vaz_120,
		@poc_MD1_210_podnik as MD1_poc_vaz_210,
		@poc_MD1_365_podnik as MD1_poc_vaz_365,
		@poc_MD1_500_podnik as MD1_poc_vaz_500,
		@poc_MD2_podnik as MD2_poc,
		@poc_MD2_120_podnik as MD2_poc_vaz_120,
		@poc_MD2_210_podnik as MD2_poc_vaz_210,
		@poc_MD2_365_podnik as MD2_poc_vaz_365,
		@poc_MD2_500_podnik as MD2_poc_vaz_500,
		@poc_J_podnik as J_poc,
		@poc_J_120_podnik as J_poc_vaz_120,
		@poc_J_210_podnik as J_poc_vaz_210,
		@poc_J_365_podnik as J_poc_vaz_365,
		@poc_J_500_podnik as J_poc_vaz_500,
		@poc_B_podnik as B_poc,
		@poc_B_120_podnik as B_poc_vaz_120,
		@poc_B_210_podnik as B_poc_vaz_210,
		@poc_B_365_podnik as B_poc_vaz_365,
		@poc_B_500_podnik as B_poc_vaz_500
		
	/**aktualne stavy na chove**/			
	declare @spolu_K1_hm120_podnik float
		set @spolu_K1_hm120_podnik = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm210_podnik float
		set @spolu_K1_hm210_podnik = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm365_podnik float
		set @spolu_K1_hm365_podnik = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm500_podnik float
		set @spolu_K1_hm500_podnik = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_120_podnik float
		set @hmotnar_K1_120_podnik = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_210_podnik float
		set @hmotnar_K1_210_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_365_podnik float
		set @hmotnar_K1_365_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_500_podnik float
		set @hmotnar_K1_500_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_priem_ziv_prir_120 = (select ((@spolu_K1_hm120_podnik - @hmotnar_K1_120_podnik) / (120*nullif(@poc_K1_120_podnik,0))) *1000),-- as K1_priem_ziv_prir_120
	K1_priem_ziv_prir_210 = (select ((@spolu_K1_hm210_podnik - @hmotnar_K1_210_podnik) / (210*nullif(@poc_K1_210_podnik,0))) *1000),-- as K1_priem_ziv_prir_210
	K1_priem_ziv_prir_365 = (select ((@spolu_K1_hm365_podnik - @hmotnar_K1_365_podnik) / (365*nullif(@poc_K1_365_podnik,0))) *1000),-- as K1_priem_ziv_prir_365
	K1_priem_ziv_prir_500 = (select ((@spolu_K1_hm500_podnik - @hmotnar_K1_500_podnik) / (500*nullif(@poc_K1_500_podnik,0))) *1000)-- as K1_priem_ziv_prir_500

	/** vybery pre prvy a druhy riadok		**/
	/******  --kravy  ******/
	
	/****		vek 1 oteleni K1....vypocet  ***/
	declare @vek1otel_K1_podnik float 
	set @vek1otel_K1_podnik = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + Podnik = @chov
									/*and Porlak = '1'*/ and Porlak is not null and datvyr is null and dovvyr is null /******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
									and rok = DATEPART(YEAR, @datumOd))

	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K1_vek_1_otel = dbo.toMesiacDen(@vek1otel_K1_podnik)--  AS  VEK_1_Otel

	--medziobdobie
	update @hlavna 
	set K1_medziobd = (select avg(medziobd) as Medziobdobie	from Roc_MPHD_Tab_zaklad 
						where kraj + okres + Podnik = @chov
								and Porlak > '1' and KrJal='K' 
								and datvyr is null and dovvyr is null
								and Medziobd > 100 and  Medziobd <= 1200
								and rok = DATEPART(YEAR, @datumOd))
	--priem.por.laktacie
	update @hlavna 
	set K1_priem_lakt = (select convert (decimal (5,2),avg(Porlak*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + Podnik = @chov 
								and Porlak is not null and KrJal='K' 
								and datvyr is null and dovvyr is null  
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
									and KrJal='K' 
									and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_210 =(select convert (decimal (5,2),avg(Hm210*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
									and KrJal='K' 
									and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
									and KrJal='K' 
									and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal='K' 
							and Hm500 is not null
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))

	/*******	--mlady dobytok  *******/
	update @hlavna
	set MD1_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal<>'K'  
							and (Hm120 is not null or Hm120 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))	
	update @hlavna
	set MD1_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0)) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
								and KrJal<>'K' 
								and (Hm210 is not null or Hm210 <>0)
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal<>'K' 
							and (Hm365 is not null or Hm365 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal<>'K' 
							and (Hm500 is not null or Hm500 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
							
/**  STAVY ZA KONTROLNY ROK J  **********************************/
	update @hlavna
		set J_Priem_Hm_120 =( select convert (decimal (5,2),avg(Hm120*1.0))	from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
								and KrJal = 'J'   
								and (Hm120 is not null or Hm120 <>0)
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_210 = ( select convert (decimal (5,2),avg(Hm210*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal = 'J' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))	from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal = 'J'  
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal = 'J' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK B  **********************/
	update @hlavna
	set B_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal = 'B'   
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal = 'B' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal = 'B'  
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal = 'B' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK MD  **********************/	
	update @hlavna
	set MD2_vyradene =( select count(*) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal <> 'K'  
							and Datvyr >= @datumOD
							and rok = DATEPART(YEAR, @datumOd))		
	update @hlavna
	set MD2_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal <> 'K'  
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal <> 'K'
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal <> 'K' 
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal <> 'K'
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

/**aktualny stav  MD Mlady dobytok  *****************/	
	declare @spolu_MD1_hm120_podnik float
		set @spolu_MD1_hm120_podnik = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm210_podnik float
		set @spolu_MD1_hm210_podnik = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik + chov + mastal = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm365_podnik float
		set @spolu_MD1_hm365_podnik = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm500_podnik float
		set @spolu_MD1_hm500_podnik = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_120_podnik float
		set @hmotnar_MD1_120_podnik = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))		
	declare @hmotnar_MD1_210_podnik float
		set @hmotnar_MD1_210_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_365_podnik float
		set @hmotnar_MD1_365_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_500_podnik float
		set @hmotnar_MD1_500_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set MD1_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD1_hm120_podnik - @hmotnar_MD1_120_podnik) / (120*nullif(@poc_MD1_120_podnik,0))) *1000),-- as MD1_priem_ziv_prirastok_chov_120
	 MD1_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD1_hm210_podnik - @hmotnar_MD1_210_podnik) / (210*nullif(@poc_MD1_210_podnik,0))) *1000),-- as MD1_priem_ziv_prirastok_chov_210
	 MD1_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD1_hm365_podnik - @hmotnar_MD1_365_podnik) / (365*nullif(@poc_MD1_365_podnik,0))) *1000),-- as MD1_priem_ziv_prirastok_chov_365
	 MD1_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD1_hm500_podnik - @hmotnar_MD1_500_podnik) / (500*nullif(@poc_MD1_500_podnik,0))) *1000)-- as MD1_priem_ziv_prirastok_chov_500

	declare @spolu_J_hm120_podnik float
		set @spolu_J_hm120_podnik = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm210_podnik float
		set @spolu_J_hm210_podnik = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm365_podnik float
		set @spolu_J_hm365_podnik = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm500_podnik float
		set @spolu_J_hm500_podnik = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_120_podnik float
		set @hmotnar_J_120_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_210_podnik float
		set @hmotnar_J_210_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_365_podnik float
		set @hmotnar_J_365_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_500_podnik float
		set @hmotnar_J_500_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set J_priem_ziv_prirastok_chov_120 = (select ((@spolu_J_hm120_podnik - @hmotnar_J_120_podnik) / (120*nullif(@poc_J_120_podnik,0))) *1000),
	 J_priem_ziv_prirastok_chov_210 = (select ((@spolu_J_hm210_podnik - @hmotnar_J_210_podnik) / (210*nullif(@poc_J_210_podnik,0))) *1000),
	 J_priem_ziv_prirastok_chov_365 = (select ((@spolu_J_hm365_podnik - @hmotnar_J_365_podnik) / (365*nullif(@poc_J_365_podnik,0))) *1000),
	 J_priem_ziv_prirastok_chov_500 = (select ((@spolu_J_hm500_podnik - @hmotnar_J_500_podnik) / (500*nullif(@poc_J_500_podnik,0))) *1000)
	
	declare @spolu_B_hm120_podnik float
		set @spolu_B_hm120_podnik = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'B' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm210_podnik float
		set @spolu_B_hm210_podnik = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'B' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm365_podnik float
		set @spolu_B_hm365_podnik = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'B' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm500_podnik float
		set @spolu_B_hm500_podnik = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'B' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_120_podnik float
		set @hmotnar_B_120_podnik = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'B' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_210_podnik float
		set @hmotnar_B_210_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'B' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_365_podnik float
		set @hmotnar_B_365_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'B' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_500_podnik float
		set @hmotnar_B_500_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal = 'B' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set B_priem_ziv_prirastok_chov_120 = (select ((@spolu_B_hm120_podnik - @hmotnar_B_120_podnik) / (120*nullif(@poc_B_120_podnik,0))) *1000),
	 B_priem_ziv_prirastok_chov_210 = (select ((@spolu_B_hm210_podnik - @hmotnar_B_210_podnik) / (210*nullif(@poc_B_210_podnik,0))) *1000),
	 B_priem_ziv_prirastok_chov_365 = (select ((@spolu_B_hm365_podnik - @hmotnar_B_365_podnik) / (365*nullif(@poc_B_365_podnik,0))) *1000),
	 B_priem_ziv_prirastok_chov_500 = (select ((@spolu_B_hm500_podnik - @hmotnar_B_500_podnik) / (500*nullif(@poc_B_500_podnik,0))) *1000)


	declare @spolu_MD2_hm120_podnik float
		set @spolu_MD2_hm120_podnik = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm210_podnik float
		set @spolu_MD2_hm210_podnik = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm365_podnik float
		set @spolu_MD2_hm365_podnik = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm500_podnik float
		set @spolu_MD2_hm500_podnik = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_120_podnik float
		set @hmotnar_MD2_120_podnik = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_210_podnik float
		set @hmotnar_MD2_210_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_365_podnik float
		set @hmotnar_MD2_365_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_500_podnik float
		set @hmotnar_MD2_500_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres + podnik = @chov
									and KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set MD2_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD2_hm120_podnik - @hmotnar_MD2_120_podnik) / (120*nullif(@poc_MD2_120_podnik,0))) *1000),
	 MD2_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD2_hm210_podnik - @hmotnar_MD2_210_podnik) / (210*nullif(@poc_MD2_210_podnik,0))) *1000),
	 MD2_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD2_hm365_podnik - @hmotnar_MD2_365_podnik) / (365*nullif(@poc_MD2_365_podnik,0))) *1000),
	 MD2_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD2_hm500_podnik - @hmotnar_MD2_500_podnik) / (500*nullif(@poc_MD2_500_podnik,0))) *1000)
	 
/****		vek 1 oteleni K2....vypocet  ***/
	declare @vek1otel_K2_podnik float 
	set @vek1otel_K2_podnik = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + Podnik = @chov
									/*and Porlak = '1'*/and Porlak is not null /******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
									and rok = DATEPART(YEAR, @datumOd)) --and (datvyr is null or Datvyr >= @datumOD))

	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K2_vek_1_otel = dbo.toMesiacDen(@vek1otel_K2_podnik)--  AS  VEK_1_Otel

	update @hlavna 
	set K2_priem_lakt = ( select convert (decimal (5,2),avg(Porlak*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + Podnik = @chov 
								and Porlak is not null and KrJal='K' 
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_vyradene =( select count(*) from Roc_MPHD_Tab_zaklad 
						where kraj + okres + podnik = @chov
						and KrJal = 'K'  
						and Datvyr >= @datumOD
						and rok = DATEPART(YEAR, @datumOd))

	--medziobdobie
	update @hlavna 
	set K2_medziobd = (select avg(medziobd) as Medziobdobie	from Roc_MPHD_Tab_zaklad 
						where kraj + okres + Podnik = @chov
								and Porlak > '1' and KrJal='K'
								and Medziobd > 100 and  Medziobd <= 1200
								and rok = DATEPART(YEAR, @datumOd)) 
declare @spolu_K2_hm120_podnik float
	set @spolu_K2_hm120_podnik = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm210_podnik float
	set @spolu_K2_hm210_podnik = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm365_podnik float
	set @spolu_K2_hm365_podnik = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm500_podnik float
	set @spolu_K2_hm500_podnik = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_120_podnik float
	set @hmotnar_K2_120_podnik = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_210_podnik float
	set @hmotnar_K2_210_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_365_podnik float
	set @hmotnar_K2_365_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_500_podnik float
	set @hmotnar_K2_500_podnik = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
								and KrJal='K' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))
	Update @hlavna 
	set K2_priem_ziv_prirastok_120 = (select ((@spolu_K2_hm120 - @hmotnar_K2_120) / (120*nullif(@poc_K2_120,0)) *1000)),-- as K2_priem_ziv_prirastok_120
	K2_priem_ziv_prirastok_210 = (select ((@spolu_K2_hm210 - @hmotnar_K2_210) / (210*nullif(@poc_K2_210,0)) *1000)),--  as K2_priem_ziv_prirastok_210
	K2_priem_ziv_prirastok_365 = (select ((@spolu_K2_hm365 - @hmotnar_K2_365) / (365*nullif(@poc_K2_365,0)) *1000)),--  as K2_priem_ziv_prirastok_365
	K2_priem_ziv_prirastok_500 = (select ((@spolu_K2_hm500 - @hmotnar_K2_500) / (500*nullif(@poc_K2_500,0)) *1000))--  as K2_priem_ziv_prirastok_500

	update @hlavna 
	set K2_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
									and KrJal='K' 
									and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_210 =(select convert (decimal (5,2),avg(Hm210*1.0)) from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
									and KrJal='K' 
									and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
									and KrJal='K' 
									and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres + podnik = @chov
							and KrJal='K' 
							and Hm500 is not null 
							and rok = DATEPART(YEAR, @datumOd))

/******podiel plemena na chove******/
	declare @podiely_podnik table				-----PL1 a ich podiel v chove
			(
			CHOVATEL varchar (9),
			PL1 varchar(3),
			KR1 float,
			PodielPerc float--
			)

		Insert into @podiely_podnik
		(PL1, CHOVATEL,  KR1, PodielPerc)
			select distinct	 z.pl1 as PL1,
												z.kraj + z.okres + z.podnik as chovatel,
												sum(z.KR1)as KR1,
												(sum(z.KR1)/(select sum(k1.KR1)from Roc_MPHD_Tab_zaklad as k1
												where k1.kraj + k1.okres + k1.podnik = z.kraj + z.okres + z.podnik
															and (k1.dovvyr is null or (k1.dovvyr is not null and k1.DATVYR >= @datumOd))))*100 as PodielPerc
			from Roc_MPHD_Tab_zaklad as z
			where z.kraj + z.okres + z.podnik = @chov
			group by z.PL1, z.kraj + z.okres + z.podnik

	--select * from @podiely order by chovatel, kr1 desc
		
	declare @counter_podnik int,  @chovatelia_podnik varchar(9)
	declare @plemena_podnik table
			(
			PL1 varchar(3),
			KR1 float,
			PodielPerc float,
			CHOVATEL varchar (9),
			por int
			)

	declare @ZoznamPL1_podnik table
		(
		CHOVATEL VARCHAR(9),
		plem varchar(10)
		)
		
	DECLARE poradie_cursor CURSOR LOCAL
		FOR
			SELECT CHOVATEL FROM @podiely_podnik group by CHOVATEL
						
		OPEN poradie_cursor
		FETCH NEXT FROM poradie_cursor INTO @chovatelia_podnik
		WHILE @@FETCH_STATUS = 0
			BEGIN 			
				--print @chovatelia			
				delete from  @plemena_podnik			
				insert into @plemena_podnik
					(PL1, KR1, PodielPerc, CHOVATEL, por)
					select PL1,KR1, PodielPerc, CHOVATEL,ROW_NUMBER() OVER (ORDER BY PodielPerc desc) as por from @podiely_podnik as p where p.PodielPerc >12.5 and CHOVATEL = @chovatelia_podnik
			
				declare @PL1_podnik varchar(10) = ISNULL((select pl1 from @plemena_podnik where por=1),'') +' '+ isnull((select PL1 from @plemena_podnik where por=2),'') +' '+ isnull((select PL1  from @plemena_podnik where por=3),'') 
		
				insert into @ZoznamPL1_podnik
				select @chovatelia_podnik,@PL1_podnik
						
				FETCH NEXT FROM poradie_cursor INTO @chovatelia
			END

		CLOSE poradie_cursor
		DEALLOCATE poradie_cursor

insert into  Roc_MPHD_Tab_17
(		kraj, okres, podnik, chov, mastal,K1_poc, 
		K1_poc_120, K1_perc_120, 
		K1_poc_210, K1_perc_210, 
		K1_poc_365, K1_perc_365, 
		K1_poc_500,	K1_perc_500, 
		K1_Priem_Hm_120, K1_Priem_Hm_210, K1_Priem_Hm_365, K1_Priem_Hm_500, 
		K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365, K1_priem_ziv_prir_500, 
		K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
		MD1_poc, MD1_poc_vaz_120, MD1_perc_120, 
		MD1_poc_vaz_210, MD1_perc_210, MD1_poc_vaz_365, MD1_perc_365, MD1_poc_vaz_500, MD1_perc_500, 
		MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
		MD1_priem_ziv_prirastok_chov_500,
		K2_poc, K2_poc_120,	K2_perc_120, 
		K2_poc_210, K2_perc_210, 
		K2_poc_365, K2_perc_365, 
		K2_poc_500, K2_perc_500, K2_Priem_Hm_120,K2_Priem_Hm_210, K2_Priem_Hm_365, K2_Priem_Hm_500,
		K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
		K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
		J_poc, J_poc_vaz_120, J_perc_120, J_poc_vaz_210, J_perc_210, J_poc_vaz_365,  J_perc_365, J_poc_vaz_500, J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
		J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
		B_poc, B_poc_vaz_120,  B_perc_120, B_poc_vaz_210, 
		B_perc_210, B_poc_vaz_365, 
		B_perc_365, B_poc_vaz_500,
		B_perc_500, 
		B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
		B_priem_ziv_prirastok_chov_500 ,
		MD2_poc, MD2_poc_vaz_120, MD2_perc_120, MD2_poc_vaz_210, MD2_perc_210, MD2_poc_vaz_365, MD2_perc_365, MD2_poc_vaz_500, MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
		MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
		rok, plem_podiel, ekochov
)

Select kraj, okres, podnik, chov, mastal,
		K1_poc, K1_poc_120, 
		(K1_poc_120*1.0 / nullif(K1_poc,0))* 100 as K1_perc_120, 
		K1_poc_210, 
		(K1_poc_210*1.0 / nullif(K1_poc,0))* 100 as K1_perc_210, 
		K1_poc_365, 
		(K1_poc_365*1.0 / nullif(K1_poc,0))* 100 as K1_perc_365, 
		K1_poc_500,	
		(K1_poc_500*1.0 / nullif(K1_poc,0))* 100 as K1_perc_500, 
		K1_Priem_Hm_120 as K1_Priem_Hm_120,
		K1_Priem_Hm_210 as K1_Priem_Hm_210, 
		K1_Priem_Hm_365 as K1_Priem_Hm_365, 
		K1_Priem_Hm_500 as K1_Priem_Hm_500, 
		K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365, K1_priem_ziv_prir_500, 
		K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
		MD1_poc, MD1_poc_vaz_120, 
		(MD1_poc_vaz_120*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_120, 
		MD1_poc_vaz_210, 
		(MD1_poc_vaz_210*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_210, 
		MD1_poc_vaz_365, 
		(MD1_poc_vaz_365*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_365,
		MD1_poc_vaz_500, 
		(MD1_poc_vaz_500*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_500, 
		MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
		MD1_priem_ziv_prirastok_chov_500,
		K2_poc, K2_poc_120,	
		(K2_poc_120*1.0 / nullif(K2_poc,0))* 100 as K2_perc_120, 
		K2_poc_210, 
		(K2_poc_210*1.0 / nullif(K2_poc,0))* 100 as K2_perc_210, 
		K2_poc_365, 
		(K2_poc_365*1.0 / nullif(K2_poc,0))* 100 as K2_perc_365, 
		K2_poc_500,
		(K2_poc_500*1.0 / nullif(K2_poc,0))* 100 as K2_perc_500, 
		K2_Priem_Hm_120 as K2_Priem_Hm_120, K2_Priem_Hm_210 as K2_Priem_Hm_210, K2_Priem_Hm_365 as K2_Priem_Hm_365, K2_Priem_Hm_500 as K2_Priem_Hm_500,
		K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
		K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
		J_poc, J_poc_vaz_120, 
		(J_poc_vaz_120*1.0 / nullif(J_poc,0))* 100 as J_perc_120, J_poc_vaz_210, 
		(J_poc_vaz_210*1.0 / nullif(J_poc,0))* 100 as J_perc_210, J_poc_vaz_365, 
		(J_poc_vaz_365*1.0 / nullif(J_poc,0))* 100 as J_perc_365, J_poc_vaz_500,
		(J_poc_vaz_500*1.0 / nullif(J_poc,0))* 100 as J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
		J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
		B_poc, B_poc_vaz_120, 
		(B_poc_vaz_120*1.0 / nullif(B_poc,0))* 100 as B_perc_120, B_poc_vaz_210, 
		(B_poc_vaz_210*1.0 / nullif(B_poc,0))* 100 as B_perc_210, B_poc_vaz_365, 
		(B_poc_vaz_365*1.0 / nullif(B_poc,0))* 100 as B_perc_365, B_poc_vaz_500,
		(B_poc_vaz_500*1.0 / nullif(B_poc,0))* 100 as B_perc_500, 
		B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
		B_priem_ziv_prirastok_chov_500 ,
		MD2_poc, MD2_poc_vaz_120 , 
		(MD2_poc_vaz_120*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_120, MD2_poc_vaz_210, 
		(MD2_poc_vaz_210*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_210, MD2_poc_vaz_365, 
		(MD2_poc_vaz_365*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_365, MD2_poc_vaz_500, 
		(MD2_poc_vaz_500*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
		MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
		DATEPART(YEAR,@datumOd) as rok,
		z.plem as plem_podiel,
		'' as ekochov
	from @hlavna as h 
		left outer join  @ZoznamPL1_podnik as z on z.CHOVATEL = h.kraj + h.okres + h.podnik
	where h.kraj + h.okres + h.podnik = @chov

	end

else if (len(@chov) = 3)
	begin

	/**** OKRES ****/
	/**aktualny stav  Kravy  *****************/
	declare @poc_K1_Okres int --pocet krav
		set @poc_K1_Okres = (select count(*) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
								and KrJal='K' 
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K1_120_Okres int 
		set @poc_K1_120_Okres = (select count(Hm120) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
								and KrJal='K' and Hm120 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K1_210_Okres int
		set @poc_K1_210_Okres = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
								and KrJal='K' and Hm210 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K1_365_Okres int
		set @poc_K1_365_Okres = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
								and KrJal='K' and Hm365 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K1_500_Okres int
		set @poc_K1_500_Okres = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
								and KrJal='K' and Hm500 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	
	/**  STAVY ZA KONTROLNY ROK Kravy  *******/
	declare @poc_K2_Okres int --priemerny stav krav na chove
		set @poc_K2_Okres = (select sum(Pocet_dni_na_chove)/365 from Roc_MPHD_Tab_zaklad
								where kraj + okres = @chov
									and KrJal='K'
									and rok = DATEPART(YEAR, @datumOd))		
		----povodny vypocet som mala nastaveny ako pocet zijucich aj vyradenych krav na chov....no ukazalo sa, ze v rocenke tento udaj znamena priemerny pocet krav na chove
		/*(select count(*) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
								and KrJal='K' 
								and rok = DATEPART(YEAR, @datumOd))*/
	declare @poc_K2_120_Okres int --pocet krav
		set @poc_K2_120_Okres = (select count(Hm120) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_210_Okres int
		set @poc_K2_210_Okres = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm210 is not null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_365_Okres int
		set @poc_K2_365_Okres = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_500_Okres int
		set @poc_K2_500_Okres = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))

	/**aktualny stav  MD Mlady dobytok  *****************/
	declare @poc_MD1_Okres int --pocet
		set @poc_MD1_Okres = (select count(*) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' 
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD1_120_Okres int --pocet krav
		set @poc_MD1_120_Okres = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_210_Okres int
		set @poc_MD1_210_Okres = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_365_Okres int
		set @poc_MD1_365_Okres = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_500_Okres int
		set @poc_MD1_500_Okres = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
		
	 /**  STAVY ZA KONTROLNY ROK MD Mlady dobytok  *****************/
	declare @poc_MD2_Okres int --pocet krav
			set @poc_MD2_Okres = (select count(*) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal <> 'K' 
										and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_120_Okres int --pocet krav
			set @poc_MD2_120_Okres = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal <> 'K' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_210_Okres int
		set @poc_MD2_210_Okres = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_365_Okres int
		set @poc_MD2_365_Okres = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_500_Okres int
		set @poc_MD2_500_Okres = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))

	/**  STAVY ZA KONTROLNY ROK J Jalovice  *****************/
	declare @poc_J_Okres int --pocet jalovic
			set @poc_J_Okres = (select count(*) 
									from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal ='J' 
										and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_120_Okres int --pocet jalovic
			set @poc_J_120_Okres = (select count(Hm120)	from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal ='J' and Hm120 is not null
										and (datvyr is null or Datvyr >= @datumOD)
										and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_210_Okres int
		set @poc_J_210_Okres = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal ='J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_365_Okres int
		set @poc_J_365_Okres = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal ='J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_500_Okres int
		set @poc_J_500_Okres = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal ='J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))

	/**  STAVY ZA KONTROLNY ROK B Bycky *********************/
	declare @poc_B_Okres int --pocet byckov
			set @poc_B_Okres = (select count(*) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal ='B' 
										and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_120_Okres int --pocet byckov
			set @poc_B_120_Okres = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal ='B' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_210_Okres int
		set @poc_B_210_Okres = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal ='B' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_365_Okres int
		set @poc_B_365_Okres = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal ='B' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_500_Okres int
		set @poc_B_500_Okres = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal ='B' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	/*
	vlozenie do dočasnej hlavnej tabulky
	*/
	 insert into @hlavna
		 (kraj, okres, podnik, chov, mastal, 
		 K1_poc, K1_poc_120, /*K1_perc_120, */K1_poc_210,/*K1_perc_210,*/K1_poc_365, /*K1_perc_365,*/ K1_poc_500,/*K1_perc_500,*/ 
		 K2_poc,K2_poc_120,/* K2_perc_120,*/ K2_poc_210, /*K2_perc_210,*/ K2_poc_365, /*K2_perc_365,*/ K2_poc_500, /*K2_perc_500, */
		 MD1_poc, MD1_poc_vaz_120,/* MD1_perc_120,*/ MD1_poc_vaz_210,/* MD1_perc_210,*/ MD1_poc_vaz_365, /*MD1_perc_365,*/ MD1_poc_vaz_500, /*MD1_perc_500,*/
		 MD2_poc, MD2_poc_vaz_120, /*MD2_perc_120,*/ MD2_poc_vaz_210,/* MD2_perc_210,*/ MD2_poc_vaz_365,/* MD2_perc_365,*/ MD2_poc_vaz_500, /*MD2_perc_500, */
		 J_poc, J_poc_vaz_120,/* J_perc_120,*/ J_poc_vaz_210,/* J_perc_210,*/ J_poc_vaz_365,/* J_perc_365,*/ J_poc_vaz_500,/* J_perc_500, */
		 B_poc, B_poc_vaz_120, /*B_perc_120,*/ B_poc_vaz_210,/* B_perc_210,*/ B_poc_vaz_365,/* B_perc_365,*/ B_poc_vaz_500 /*B_perc_500*/)
	 select left(@chov,1) as kraj, substring(@chov,2,2) as okres, null as podnik, substring(@chov,7,2) as chov, null as mastal,
		@poc_K1_Okres as K1_poc,
		@poc_K1_120_Okres as K1_poc_120,
		@poc_K1_210_Okres as K1_poc_210,
		@poc_K1_365_Okres as K1_poc_365,
		@poc_K1_500_Okres as K1_poc_500,
		@poc_K2_Okres as K2_poc,
		@poc_K2_120_Okres as K2_poc_120,
		@poc_K2_210_Okres as K2_poc_210,
		@poc_K2_365_Okres as K2_poc_365,
		@poc_K2_500_Okres as K2_poc_500,
		@poc_MD1_Okres as MD1_poc,
		@poc_MD1_120_Okres as MD1_poc_vaz_120,
		@poc_MD1_210_Okres as MD1_poc_vaz_210,
		@poc_MD1_365_Okres as MD1_poc_vaz_365,
		@poc_MD1_500_Okres as MD1_poc_vaz_500,
		@poc_MD2_Okres as MD2_poc,
		@poc_MD2_120_Okres as MD2_poc_vaz_120,
		@poc_MD2_210_Okres as MD2_poc_vaz_210,
		@poc_MD2_365_Okres as MD2_poc_vaz_365,
		@poc_MD2_500_Okres as MD2_poc_vaz_500,
		@poc_J_Okres as J_poc,
		@poc_J_120_Okres as J_poc_vaz_120,
		@poc_J_210_Okres as J_poc_vaz_210,
		@poc_J_365_Okres as J_poc_vaz_365,
		@poc_J_500_Okres as J_poc_vaz_500,
		@poc_B_Okres as B_poc,
		@poc_B_120_Okres as B_poc_vaz_120,
		@poc_B_210_Okres as B_poc_vaz_210,
		@poc_B_365_Okres as B_poc_vaz_365,
		@poc_B_500_Okres as B_poc_vaz_500
								
declare @spolu_K1_hm120_Okres float
	set @spolu_K1_hm120_Okres = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K1_hm210_Okres float
	set @spolu_K1_hm210_Okres = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K1_hm365_Okres float
	set @spolu_K1_hm365_Okres = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K1_hm500_Okres float
	set @spolu_K1_hm500_Okres = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K1_120_Okres float
	set @hmotnar_K1_120_Okres = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K1_210_Okres float
	set @hmotnar_K1_210_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K1_365_Okres float
	set @hmotnar_K1_365_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K1_500_Okres float
	set @hmotnar_K1_500_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_priem_ziv_prir_120 = (select ((@spolu_K1_hm120_Okres - @hmotnar_K1_120_Okres) / Nullif((120*@poc_K1_120_Okres),0)) *1000),-- as K1_priem_ziv_prir_120
	K1_priem_ziv_prir_210 = (select ((@spolu_K1_hm210_Okres - @hmotnar_K1_210_Okres) / Nullif((210*@poc_K1_210_Okres),0)) *1000),-- as K1_priem_ziv_prir_210
	K1_priem_ziv_prir_365 = (select ((@spolu_K1_hm365_Okres - @hmotnar_K1_365_Okres) / Nullif((365*@poc_K1_365_Okres),0)) *1000),-- as K1_priem_ziv_prir_365
	K1_priem_ziv_prir_500 = (select ((@spolu_K1_hm500_Okres - @hmotnar_K1_500_Okres) / Nullif((500*@poc_K1_500_Okres),0)) *1000)-- as K1_priem_ziv_prir_500

/** vybery pre prvy a druhy riadok		**/
	/******  --kravy  ******/
	
	/****vek 1 oteleni K1....vypocet  ***/
	declare @vek1otel_K1_Okres float 
	set @vek1otel_K1_Okres = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
						where kraj + okres = @chov
									/*and Porlak = '1'*/ and Porlak is not null and datvyr is null and dovvyr is null /******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
									and rok = DATEPART(YEAR, @datumOd))
	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K1_vek_1_otel = dbo.toMesiacDen(@vek1otel_K1_Okres)--  AS  VEK_1_Otel

	--medziobdobie
	update @hlavna 
	set K1_medziobd = (select avg(medziobd) as Medziobdobie
						from Roc_MPHD_Tab_zaklad 
						where kraj + okres = @chov
								and Porlak > '1' and KrJal='K' 
								and datvyr is null and dovvyr is null
								and Medziobd > 100 and  Medziobd <= 1200
								and rok = DATEPART(YEAR, @datumOd))
	--priem.por.laktacie
	update @hlavna 
	set K1_priem_lakt = ( select convert (decimal (5,2),avg(Porlak*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov 
								and Porlak is not null and KrJal='K' 
								and datvyr is null and dovvyr is null  
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0))
		from Roc_MPHD_Tab_zaklad 
		where kraj + okres = @chov
				and KrJal='K' 
				and Hm120 is not null
				and datvyr is null and dovvyr is null
				and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_210 =(
	select convert (decimal (5,2),avg(Hm210*1.0)) 
		from Roc_MPHD_Tab_zaklad 
		where kraj + okres = @chov
				and KrJal='K' 
				and Hm210 is not null
				and datvyr is null and dovvyr is null
				and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
		from Roc_MPHD_Tab_zaklad 
		where kraj + okres  = @chov
				and KrJal='K' 
				and Hm365 is not null
				and datvyr is null and dovvyr is null
				and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_500 = (
	select convert (decimal (5,2),avg(Hm500*1.0))
		from Roc_MPHD_Tab_zaklad 
		where kraj + okres = @chov
		and KrJal='K' 
		and Hm500 is not null
		and datvyr is null and dovvyr is null
		and rok = DATEPART(YEAR, @datumOd))


	/*******	--mlady dobytok  *******/
	update @hlavna
	set MD1_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal<>'K'  
							and (Hm120 is not null or Hm120 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal<>'K' 
							and (Hm210 is not null or Hm210 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal<>'K' 
							and (Hm365 is not null or Hm365 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal<>'K' 
							and (Hm500 is not null or Hm500 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK J  **********************************/
	update @hlavna
		set J_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							--as MD1_Priem_Hm_120  
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal = 'J'   
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal = 'J' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal = 'J'  
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
	 						from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal = 'J' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK B  **********************/
	update @hlavna
	set B_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal = 'B'   
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal = 'B' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal = 'B'  
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal = 'B' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK MD  **********************/
	update @hlavna
	set MD2_vyradene =(select count(*) 
						from Roc_MPHD_Tab_zaklad 
						where kraj + okres = @chov
						and KrJal <> 'K' 
						and rok = DATEPART(YEAR, @datumOd)
						and Datvyr >= @datumOD)
	update @hlavna
	set MD2_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal <> 'K'  
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
								from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
								and KrJal <> 'K'
								and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal <> 'K' 
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal <> 'K'
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

	declare @spolu_MD1_hm120_Okres float
		set @spolu_MD1_hm120_Okres = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))		

	declare @spolu_MD1_hm210_Okres float
		set @spolu_MD1_hm210_Okres = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm365_Okres float
		set @spolu_MD1_hm365_Okres = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm500_Okres float
		set @spolu_MD1_hm500_Okres = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_120_Okres float
		set @hmotnar_MD1_120_Okres = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))		
	declare @hmotnar_MD1_210_Okres float
		set @hmotnar_MD1_210_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_365_Okres float
		set @hmotnar_MD1_365_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_500_Okres float
		set @hmotnar_MD1_500_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))

	update @hlavna 
	set MD1_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD1_hm120_Okres - @hmotnar_MD1_120_Okres) / Nullif((120*@poc_MD1_120_Okres),0)) *1000),-- as MD1_priem_ziv_prirastok_chov_120
		 MD1_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD1_hm210_Okres - @hmotnar_MD1_210_Okres) / Nullif((210*@poc_MD1_210_Okres),0)) *1000),-- as MD1_priem_ziv_prirastok_chov_210
		 MD1_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD1_hm365_Okres - @hmotnar_MD1_365_Okres) / Nullif((365*@poc_MD1_365_Okres),0)) *1000),-- as MD1_priem_ziv_prirastok_chov_365
		 MD1_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD1_hm500_Okres - @hmotnar_MD1_500_Okres) / Nullif((500*@poc_MD1_500_Okres),0)) *1000)-- as MD1_priem_ziv_prirastok_chov_500
	 	
	declare @spolu_J_hm120_Okres float
		set @spolu_J_hm120_Okres = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'J' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm210_Okres float
		set @spolu_J_hm210_Okres = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'J' and Hm210 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm365_Okres float
		set @spolu_J_hm365_Okres = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'J' and Hm365 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm500_Okres float
		set @spolu_J_hm500_Okres = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'J' and Hm500 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_120_Okres float
		set @hmotnar_J_120_Okres = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'J' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_210_Okres float
		set @hmotnar_J_210_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'J' and Hm210 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_365_Okres float
		set @hmotnar_J_365_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'J' and Hm365 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_500_Okres float
		set @hmotnar_J_500_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'J' and Hm500 is not null
										and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set J_priem_ziv_prirastok_chov_120 = (select ((@spolu_J_hm120_Okres - @hmotnar_J_120_Okres) / Nullif((120*@poc_J_120_Okres),0)) *1000),
	 J_priem_ziv_prirastok_chov_210 = (select ((@spolu_J_hm210_Okres - @hmotnar_J_210_Okres) / Nullif((210*@poc_J_210_Okres),0)) *1000),
	 J_priem_ziv_prirastok_chov_365 = (select ((@spolu_J_hm365_Okres - @hmotnar_J_365_Okres) / Nullif((365*@poc_J_365_Okres),0)) *1000),
	 J_priem_ziv_prirastok_chov_500 = (select ((@spolu_J_hm500_Okres - @hmotnar_J_500_Okres) / Nullif((500*@poc_J_500_Okres),0)) *1000)
	
	declare @spolu_B_hm120_Okres float
		set @spolu_B_hm120_Okres = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'B' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm210_Okres float
		set @spolu_B_hm210_Okres = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'B' and Hm210 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm365_Okres float
		set @spolu_B_hm365_Okres = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'B' and Hm365 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm500_Okres float
		set @spolu_B_hm500_Okres = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'B' and Hm500 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_120_Okres float
		set @hmotnar_B_120_Okres = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'B' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_210_Okres float
		set @hmotnar_B_210_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'B' and Hm210 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_365_Okres float
		set @hmotnar_B_365_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal = 'B' and Hm365 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_500_Okres float
		set @hmotnar_B_500_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
										where kraj + okres = @chov
										and KrJal = 'B' and Hm500 is not null
										and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set B_priem_ziv_prirastok_chov_120 = (select ((@spolu_B_hm120_Okres - @hmotnar_B_120_Okres) / Nullif((120*@poc_B_120_Okres),0)) *1000),
	 B_priem_ziv_prirastok_chov_210 = (select ((@spolu_B_hm210_Okres - @hmotnar_B_210_Okres) / Nullif((210*@poc_B_210_Okres),0)) *1000),
	 B_priem_ziv_prirastok_chov_365 = (select ((@spolu_B_hm365_Okres - @hmotnar_B_365_Okres) / Nullif((365*@poc_B_365_Okres),0)) *1000),
	 B_priem_ziv_prirastok_chov_500 = (select ((@spolu_B_hm500_Okres - @hmotnar_B_500_Okres) / Nullif((500*@poc_B_500_Okres),0)) *1000)

	declare @spolu_MD2_hm120_Okres float
		set @spolu_MD2_hm120_Okres = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
										where kraj + okres = @chov
										and KrJal <> 'K' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm210_Okres float
		set @spolu_MD2_hm210_Okres = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
										where kraj + okres = @chov
										and KrJal <> 'K' and Hm210 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm365_Okres float
		set @spolu_MD2_hm365_Okres = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
										where kraj + okres = @chov
										and KrJal <> 'K' and Hm365 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm500_Okres float
		set @spolu_MD2_hm500_Okres = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
										where kraj + okres = @chov
										and KrJal <> 'K' and Hm500 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_120_Okres float
		set @hmotnar_MD2_120_Okres = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
										where kraj + okres = @chov
										and KrJal <> 'K' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_210_Okres float
		set @hmotnar_MD2_210_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
										where kraj + okres = @chov
										and KrJal <> 'K' and Hm210 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_365_Okres float
		set @hmotnar_MD2_365_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
										where kraj + okres = @chov
										and KrJal <> 'K' and Hm365 is not null
										and rok = DATEPART(YEAR, @datumOd))									
	declare @hmotnar_MD2_500_Okres float
		set @hmotnar_MD2_500_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
										where kraj + okres = @chov
										and KrJal <> 'K' and Hm500 is not null
										and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set MD2_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD2_hm120_Okres - @hmotnar_MD2_120_Okres) / Nullif((120*@poc_MD2_120_Okres),0)) *1000),
	 MD2_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD2_hm210_Okres - @hmotnar_MD2_210_Okres) / Nullif((210*@poc_MD2_210_Okres),0)) *1000),
	 MD2_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD2_hm365_Okres - @hmotnar_MD2_365_Okres) / Nullif((365*@poc_MD2_365_Okres),0)) *1000),
	 MD2_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD2_hm500_Okres - @hmotnar_MD2_500_Okres) / Nullif((500*@poc_MD2_500_Okres),0)) *1000)

/****		vek 1 oteleni K2....vypocet  ***/
	declare @vek1otel_K2_Okres float 
	set @vek1otel_K2_Okres = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									/*and Porlak = '1'*/ and Porlak is not null/******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
									and rok = DATEPART(YEAR, @datumOd)) 
	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K2_vek_1_otel = dbo.toMesiacDen(@vek1otel_K2_Okres)

	update @hlavna 
	set K2_priem_lakt = ( select convert (decimal (5,2),avg(Porlak*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov 
								and Porlak is not null and KrJal='K' 
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_vyradene =( select count(*) from Roc_MPHD_Tab_zaklad 
						where kraj + okres = @chov
						and KrJal = 'K'  
						and rok = DATEPART(YEAR, @datumOd)
						and Datvyr >= @datumOD )

	--medziobdobie
	update @hlavna 
	set K2_medziobd = (select avg(medziobd) as Medziobdobie
						from Roc_MPHD_Tab_zaklad 
						where kraj + okres = @chov
								and Porlak > '1' and KrJal='K'
								and Medziobd > 100 and  Medziobd <= 1200
								and rok = DATEPART(YEAR, @datumOd))

declare @spolu_K2_hm120_Okres float
	set @spolu_K2_hm120_Okres = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm210_Okres float
	set @spolu_K2_hm210_Okres = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm365_Okres float
	set @spolu_K2_hm365_Okres = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm500_Okres float
	set @spolu_K2_hm500_Okres = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj + okres = @chov
									and KrJal='K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_120_Okres float
	set @hmotnar_K2_120_Okres = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal='K' and Hm120 is not null
										and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_210_Okres float
	set @hmotnar_K2_210_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
										and KrJal='K' and Hm210 is not null
										and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_365_Okres float
	set @hmotnar_K2_365_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
									and KrJal='K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_500_Okres float
	set @hmotnar_K2_500_Okres = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj + okres = @chov
									and KrJal='K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	Update @hlavna 
	set K2_priem_ziv_prirastok_120 = (select ((@spolu_K2_hm120_Okres - @hmotnar_K2_120_Okres) / Nullif((120*@poc_K2_120_Okres),0)) *1000),-- as K2_priem_ziv_prirastok_120
	K2_priem_ziv_prirastok_210 = (select ((@spolu_K2_hm210_Okres - @hmotnar_K2_210_Okres) / Nullif((210*@poc_K2_210_Okres),0)) *1000),--  as K2_priem_ziv_prirastok_210
	K2_priem_ziv_prirastok_365 = (select ((@spolu_K2_hm365_Okres - @hmotnar_K2_365_Okres) / Nullif((365*@poc_K2_365_Okres),0)) *1000),--  as K2_priem_ziv_prirastok_365
	K2_priem_ziv_prirastok_500 = (select ((@spolu_K2_hm500_Okres - @hmotnar_K2_500_Okres) / Nullif((500*@poc_K2_500_Okres),0)) *1000)--  as K2_priem_ziv_prirastok_500

	update @hlavna 
	set K2_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal='K' 
							and Hm120 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_210 =(select convert (decimal (5,2),avg(Hm210*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal='K' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal='K' 
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj + okres = @chov
							and KrJal='K' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))
		
insert into  Roc_MPHD_Tab_17
(	kraj, okres, podnik, chov, mastal,K1_poc, 
		K1_poc_120, K1_perc_120, 
		K1_poc_210, K1_perc_210, 
		K1_poc_365, K1_perc_365, 
		K1_poc_500,	K1_perc_500, 
		K1_Priem_Hm_120, K1_Priem_Hm_210, K1_Priem_Hm_365, K1_Priem_Hm_500, 
		K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365, K1_priem_ziv_prir_500, 
		K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
		MD1_poc, MD1_poc_vaz_120, MD1_perc_120, 
		MD1_poc_vaz_210, MD1_perc_210, MD1_poc_vaz_365, MD1_perc_365, MD1_poc_vaz_500, MD1_perc_500, 
		MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
		MD1_priem_ziv_prirastok_chov_500,
		K2_poc, K2_poc_120,	K2_perc_120, 
		K2_poc_210, K2_perc_210, 
		K2_poc_365, K2_perc_365, 
		K2_poc_500, K2_perc_500, K2_Priem_Hm_120,K2_Priem_Hm_210, K2_Priem_Hm_365, K2_Priem_Hm_500,
		K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
		K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
		J_poc, J_poc_vaz_120, J_perc_120, J_poc_vaz_210, J_perc_210, J_poc_vaz_365,  J_perc_365, J_poc_vaz_500, J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
		J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
		B_poc, B_poc_vaz_120,  B_perc_120, B_poc_vaz_210, 
		B_perc_210, B_poc_vaz_365, 
		B_perc_365, B_poc_vaz_500,
		B_perc_500, 
		B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
		B_priem_ziv_prirastok_chov_500 ,
		MD2_poc, MD2_poc_vaz_120, MD2_perc_120, MD2_poc_vaz_210, MD2_perc_210, MD2_poc_vaz_365, MD2_perc_365, MD2_poc_vaz_500, MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
		MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
		rok, plem_podiel, ekochov
)

Select kraj, okres, podnik, chov, mastal,
		K1_poc, K1_poc_120, 
		(K1_poc_120*1.0 / nullif(K1_poc,0))* 100 as K1_perc_120, 
		K1_poc_210, 
		(K1_poc_210*1.0 / nullif(K1_poc,0))* 100 as K1_perc_210, 
		K1_poc_365, 
		(K1_poc_365*1.0 / nullif(K1_poc,0))* 100 as K1_perc_365, 
		K1_poc_500,	
		(K1_poc_500*1.0 / nullif(K1_poc,0))* 100 as K1_perc_500, 
		K1_Priem_Hm_120 as K1_Priem_Hm_120,
		K1_Priem_Hm_210 as K1_Priem_Hm_210, 
		K1_Priem_Hm_365 as K1_Priem_Hm_365, 
		K1_Priem_Hm_500 as K1_Priem_Hm_500, 
		K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365, K1_priem_ziv_prir_500, 
		K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
		MD1_poc, MD1_poc_vaz_120, 
		(MD1_poc_vaz_120*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_120, 
		MD1_poc_vaz_210, 
		(MD1_poc_vaz_210*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_210, 
		MD1_poc_vaz_365, 
		(MD1_poc_vaz_365*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_365,
		MD1_poc_vaz_500, 
		(MD1_poc_vaz_500*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_500, 
		MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
		MD1_priem_ziv_prirastok_chov_500,
		K2_poc, K2_poc_120,	
		(K2_poc_120*1.0 / nullif(K2_poc,0))* 100 as K2_perc_120, 
		K2_poc_210, 
		(K2_poc_210*1.0 / nullif(K2_poc,0))* 100 as K2_perc_210, 
		K2_poc_365, 
		(K2_poc_365*1.0 / nullif(K2_poc,0))* 100 as K2_perc_365, 
		K2_poc_500,
		(K2_poc_500*1.0 / nullif(K2_poc,0))* 100 as K2_perc_500, 
		K2_Priem_Hm_120 as K2_Priem_Hm_120, K2_Priem_Hm_210 as K2_Priem_Hm_210, K2_Priem_Hm_365 as K2_Priem_Hm_365, K2_Priem_Hm_500 as K2_Priem_Hm_500,
		K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
		K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
		J_poc, J_poc_vaz_120, 
		(J_poc_vaz_120*1.0 / nullif(J_poc,0))* 100 as J_perc_120, J_poc_vaz_210, 
		(J_poc_vaz_210*1.0 / nullif(J_poc,0))* 100 as J_perc_210, J_poc_vaz_365, 
		(J_poc_vaz_365*1.0 / nullif(J_poc,0))* 100 as J_perc_365, J_poc_vaz_500,
		(J_poc_vaz_500*1.0 / nullif(J_poc,0))* 100 as J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
		J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
		B_poc, B_poc_vaz_120, 
		(B_poc_vaz_120*1.0 / nullif(B_poc,0))* 100 as B_perc_120, B_poc_vaz_210, 
		(B_poc_vaz_210*1.0 / nullif(B_poc,0))* 100 as B_perc_210, B_poc_vaz_365, 
		(B_poc_vaz_365*1.0 / nullif(B_poc,0))* 100 as B_perc_365, B_poc_vaz_500,
		(B_poc_vaz_500*1.0 / nullif(B_poc,0))* 100 as B_perc_500, 
		B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
		B_priem_ziv_prirastok_chov_500 ,
		MD2_poc, MD2_poc_vaz_120 , 
		(MD2_poc_vaz_120*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_120, MD2_poc_vaz_210, 
		(MD2_poc_vaz_210*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_210, MD2_poc_vaz_365, 
		(MD2_poc_vaz_365*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_365, MD2_poc_vaz_500, 
		(MD2_poc_vaz_500*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
		MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
		DATEPART(YEAR,@datumOd) as rok,
		''as plem_podiel,
		'' as ekochov
	from @hlavna where kraj + okres = @chov


	end
	else if (len(@chov) = 1)
	begin

	/*** Kraj ***/

	/**aktualny stav  Kravy  *****************/
	declare @poc_K1_Kraj int --pocet krav
		set @poc_K1_Kraj = (select count(*) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' 
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K1_120_Kraj int 
		set @poc_K1_120_Kraj = (select count(Hm120)  from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' and Hm120 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_210_Kraj int
		set @poc_K1_210_Kraj = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' and Hm210 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_365_Kraj int
		set @poc_K1_365_Kraj = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' and Hm365 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_500_Kraj int
		set @poc_K1_500_Kraj = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' and Hm500 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	

	/**  STAVY ZA KONTROLNY ROK Kravy  *******/
	declare @poc_K2_Kraj int --pocet krav
		set @poc_K2_Kraj = (select sum(Pocet_dni_na_chove)/365 from Roc_MPHD_Tab_zaklad
								where kraj = @chov
									and KrJal='K'
									and rok = DATEPART(YEAR, @datumOd))		
		----povodny vypocet som mala nastaveny ako pocet zijucich aj vyradenych krav na chov....no ukazalo sa, ze v rocenke tento udaj znamena priemerny pocet krav na chove
		/*(select count(*) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' 
								and rok = DATEPART(YEAR, @datumOd))*/
	declare @poc_K2_120_Kraj int --pocet krav
		set @poc_K2_120_Kraj = (select count(Hm120) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_210_Kraj int
		set @poc_K2_210_Kraj = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_365_Kraj int
		set @poc_K2_365_Kraj = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_500_Kraj int
		set @poc_K2_500_Kraj = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal='K' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))

	/**aktualny stav  MD Mlady dobytok  *****************/
	declare @poc_MD1_Kraj int --pocet
		set @poc_MD1_Kraj = (select count(*) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal <> 'K' 
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))

	declare @poc_MD1_120_Kraj int --pocet krav
		set @poc_MD1_120_Kraj = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
		
	declare @poc_MD1_210_Kraj int
		set @poc_MD1_210_Kraj = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD1_365_Kraj int
		set @poc_MD1_365_Kraj = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD1_500_Kraj int
		set @poc_MD1_500_Kraj = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))		

	 /**  STAVY ZA KONTROLNY ROK MD Mlady dobytok  *****************/
	declare @poc_MD2_Kraj int --pocet krav
		set @poc_MD2_Kraj = (select count(*) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal <> 'K' 
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_120_Kraj int --pocet krav
		set @poc_MD2_120_Kraj = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_210_Kraj int
		set @poc_MD2_210_Kraj = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_365_Kraj int
		set @poc_MD2_365_Kraj = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_500_Kraj int
		set @poc_MD2_500_Kraj = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK J Jalovice  *****************/
	declare @poc_J_Kraj int --pocet jalovic
			set @poc_J_Kraj = (select count(*) 
									from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal ='J' 
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_120_Kraj int --pocet jalovic
			set @poc_J_120_Kraj = (select count(Hm120)
									from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal ='J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_210_Kraj int
		set @poc_J_210_Kraj = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal ='J' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_365_Kraj int
		set @poc_J_365_Kraj = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal ='J' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_500_Kraj int
		set @poc_J_500_Kraj = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal ='J' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))

	/**  STAVY ZA KONTROLNY ROK B Bycky *********************/
	declare @poc_B_Kraj int --pocet byckov
		set @poc_B_Kraj = (select count(*) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal ='B' 
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_120_Kraj int --pocet byckov
		set @poc_B_120_Kraj = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal ='B' and Hm120 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_210_Kraj int
		set @poc_B_210_Kraj = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal ='B' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_365_Kraj int
		set @poc_B_365_Kraj = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal ='B' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_500_Kraj int
		set @poc_B_500_Kraj = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal ='B' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))		
	/*
	vlozenie do dočasnej hlavnej tabulky
	*/
	 insert into @hlavna
		 (kraj, okres, podnik, chov, mastal, 
		 K1_poc, K1_poc_120, /*K1_perc_120, */K1_poc_210,/*K1_perc_210,*/K1_poc_365, /*K1_perc_365,*/ K1_poc_500,/*K1_perc_500,*/ 
		 K2_poc,K2_poc_120,/* K2_perc_120,*/ K2_poc_210, /*K2_perc_210,*/ K2_poc_365, /*K2_perc_365,*/ K2_poc_500, /*K2_perc_500, */
		 MD1_poc, MD1_poc_vaz_120,/* MD1_perc_120,*/ MD1_poc_vaz_210,/* MD1_perc_210,*/ MD1_poc_vaz_365, /*MD1_perc_365,*/ MD1_poc_vaz_500, /*MD1_perc_500,*/
		 MD2_poc, MD2_poc_vaz_120, /*MD2_perc_120,*/ MD2_poc_vaz_210,/* MD2_perc_210,*/ MD2_poc_vaz_365,/* MD2_perc_365,*/ MD2_poc_vaz_500, /*MD2_perc_500, */
		 J_poc, J_poc_vaz_120,/* J_perc_120,*/ J_poc_vaz_210,/* J_perc_210,*/ J_poc_vaz_365,/* J_perc_365,*/ J_poc_vaz_500,/* J_perc_500, */
		 B_poc, B_poc_vaz_120, /*B_perc_120,*/ B_poc_vaz_210,/* B_perc_210,*/ B_poc_vaz_365,/* B_perc_365,*/ B_poc_vaz_500 /*B_perc_500*/)
	 select @chov as kraj, null as okres, null as podnik, null as chov, null as mastal,
		@poc_K1_Kraj as K1_poc,
		@poc_K1_120_Kraj as K1_poc_120,
		@poc_K1_210_Kraj as K1_poc_210,
		@poc_K1_365_Kraj as K1_poc_365,
		@poc_K1_500_Kraj as K1_poc_500,
		@poc_K2_Kraj as K2_poc,
		@poc_K2_120_Kraj as K2_poc_120,
		@poc_K2_210_Kraj as K2_poc_210,
		@poc_K2_365_Kraj as K2_poc_365,
		@poc_K2_500_Kraj as K2_poc_500,
		@poc_MD1_Kraj as MD1_poc,
		@poc_MD1_120_Kraj as MD1_poc_vaz_120,
		@poc_MD1_210_Kraj as MD1_poc_vaz_210,
		@poc_MD1_365_Kraj as MD1_poc_vaz_365,
		@poc_MD1_500_Kraj as MD1_poc_vaz_500,
		@poc_MD2_Kraj as MD2_poc,
		@poc_MD2_120_Kraj as MD2_poc_vaz_120,
		@poc_MD2_210_Kraj as MD2_poc_vaz_210,
		@poc_MD2_365_Kraj as MD2_poc_vaz_365,
		@poc_MD2_500_Kraj as MD2_poc_vaz_500,
		@poc_J_Kraj as J_poc,
		@poc_J_120_Kraj as J_poc_vaz_120,
		@poc_J_210_Kraj as J_poc_vaz_210,
		@poc_J_365_Kraj as J_poc_vaz_365,
		@poc_J_500_Kraj as J_poc_vaz_500,
		@poc_B_Kraj as B_poc,
		@poc_B_120_Kraj as B_poc_vaz_120,
		@poc_B_210_Kraj as B_poc_vaz_210,
		@poc_B_365_Kraj as B_poc_vaz_365,
		@poc_B_500_Kraj as B_poc_vaz_500
		
			
	declare @spolu_K1_hm120_Kraj float
		set @spolu_K1_hm120_Kraj = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm210_Kraj float
		set @spolu_K1_hm210_Kraj = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj= @chov
									and KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm365_Kraj float
		set @spolu_K1_hm365_Kraj = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm500_Kraj float
		set @spolu_K1_hm500_Kraj = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_120_Kraj float
		set @hmotnar_K1_120_Kraj = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_210_Kraj float
		set @hmotnar_K1_210_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_365_Kraj float
		set @hmotnar_K1_365_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_500_Kraj float
		set @hmotnar_K1_500_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_priem_ziv_prir_120 = (select ((@spolu_K1_hm120_Kraj - @hmotnar_K1_120_Kraj) / Nullif((120*@poc_K1_120_Kraj),0)) *1000),-- as K1_priem_ziv_prir_120
	K1_priem_ziv_prir_210 = (select ((@spolu_K1_hm210_Kraj - @hmotnar_K1_210_Kraj) / Nullif((210*@poc_K1_210_Kraj),0)) *1000),-- as K1_priem_ziv_prir_210
	K1_priem_ziv_prir_365 = (select ((@spolu_K1_hm365_Kraj - @hmotnar_K1_365_Kraj) / Nullif((365*@poc_K1_365_Kraj),0)) *1000),-- as K1_priem_ziv_prir_365
	K1_priem_ziv_prir_500 = (select ((@spolu_K1_hm500_Kraj - @hmotnar_K1_500_Kraj) / Nullif((500*@poc_K1_500_Kraj),0)) *1000)-- as K1_priem_ziv_prir_500

	/** vybery pre prvy a druhy riadok		**/
	/******  --kravy  ******/
	
	/****		vek 1 oteleni K1....vypocet  ***/
	declare @vek1otel_K1_Kraj float 
	set @vek1otel_K1_Kraj = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
						where kraj = @chov
									/*and Porlak = '1'*/ and Porlak is not null and datvyr is null and dovvyr is null /******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
									and rok = DATEPART(YEAR, @datumOd))

	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K1_vek_1_otel = dbo.toMesiacDen(@vek1otel_K1_Kraj)--  AS  VEK_1_Otel

	--medziobdobie
	update @hlavna 
	set K1_medziobd = (select avg(medziobd) as Medziobdobie
						from Roc_MPHD_Tab_zaklad 
						where kraj  = @chov
								and Porlak > '1' and KrJal='K' 
								and datvyr is null and dovvyr is null
								and Medziobd > 100 and  Medziobd <= 1200
									and rok = DATEPART(YEAR, @datumOd))
	--priem.por.laktacie
	update @hlavna 
	set K1_priem_lakt = ( select convert (decimal (5,2),avg(Porlak*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov 
								and Porlak is not null and KrJal='K' 
								and datvyr is null and dovvyr is null  
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0))
		from Roc_MPHD_Tab_zaklad 
		where kraj = @chov
				and KrJal='K' 
				and Hm120 is not null
				and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_210 =(select convert (decimal (5,2),avg(Hm210*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
									and KrJal='K' 
									and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
									and KrJal='K' 
									and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
								and KrJal='K' 
								and Hm500 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))

	/*******	--mlady dobytok  *******/
	update @hlavna
	set MD1_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal<>'K'  
							and (Hm120 is not null or Hm120 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal<>'K' 
							and (Hm210 is not null or Hm210 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal<>'K' 
							and (Hm365 is not null or Hm365 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
								from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal<>'K' 
								and (Hm500 is not null or Hm500 <>0)
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK J  **********************************/
	update @hlavna
		set J_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
								from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal = 'J'   
								and (Hm120 is not null or Hm120 <>0)
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal = 'J' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal = 'J'  
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
	 						from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal = 'J' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK B  **********************/
	update @hlavna
	set B_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal = 'B'   
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal = 'B' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal = 'B'  
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal = 'B' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK MD  **********************/
	update @hlavna
	set MD2_vyradene =( select count(*) 
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal <> 'K'  
							and rok = DATEPART(YEAR, @datumOd)
							and Datvyr >= @datumOD)		
	update @hlavna
	set MD2_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
								from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal <> 'K'  
								and (Hm120 is not null or Hm120 <>0)
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
								from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal <> 'K'
								and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
								from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal <> 'K' 
								and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								and KrJal <> 'K'
								and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm120_Kraj float
		set @spolu_MD1_hm120_Kraj = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm210_Kraj float
		set @spolu_MD1_hm210_Kraj = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm365_Kraj float
		set @spolu_MD1_hm365_Kraj = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm500_Kraj float
		set @spolu_MD1_hm500_Kraj = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_120_Kraj float
		set @hmotnar_MD1_120_Kraj = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_210_Kraj float
		set @hmotnar_MD1_210_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_365_Kraj float
		set @hmotnar_MD1_365_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
										and KrJal <> 'K' and Hm365 is not null
										and datvyr is null and dovvyr is null 
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_500_Kraj float
		set @hmotnar_MD1_500_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
										where kraj = @chov
										and KrJal <> 'K' and Hm500 is not null
										and datvyr is null and dovvyr is null 
										and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set MD1_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD1_hm120_Kraj - @hmotnar_MD1_120_Kraj) / nullif((120*@poc_MD1_120_Kraj),0)) *1000),-- as MD1_priem_ziv_prirastok_chov_120
	 MD1_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD1_hm210_Kraj - @hmotnar_MD1_210_Kraj) / nullif((210*@poc_MD1_210_Kraj),0)) *1000),-- as MD1_priem_ziv_prirastok_chov_210
	 MD1_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD1_hm365_Kraj - @hmotnar_MD1_365_Kraj) / nullif((365*@poc_MD1_365_Kraj),0)) *1000),-- as MD1_priem_ziv_prirastok_chov_365
	 MD1_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD1_hm500_Kraj - @hmotnar_MD1_500_Kraj) / nullif((500*@poc_MD1_500_Kraj),0)) *1000)-- as MD1_priem_ziv_prirastok_chov_500

	
	declare @spolu_J_hm120_Kraj float
		set @spolu_J_hm120_Kraj = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm210_Kraj float
		set @spolu_J_hm210_Kraj = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm365_Kraj float
		set @spolu_J_hm365_Kraj = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm500_Kraj float
		set @spolu_J_hm500_Kraj = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_120_Kraj float
		set @hmotnar_J_120_Kraj = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_210_Kraj float
		set @hmotnar_J_210_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_365_Kraj float
		set @hmotnar_J_365_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_500_Kraj float
		set @hmotnar_J_500_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))

	update @hlavna 
	set J_priem_ziv_prirastok_chov_120 = (select ((@spolu_J_hm120_Kraj - @hmotnar_J_120_Kraj) / nullif((120*@poc_J_120_Kraj),0)) *1000),
		 J_priem_ziv_prirastok_chov_210 = (select ((@spolu_J_hm210_Kraj - @hmotnar_J_210_Kraj) / nullif((210*@poc_J_210_Kraj),0)) *1000),
		 J_priem_ziv_prirastok_chov_365 = (select ((@spolu_J_hm365_Kraj - @hmotnar_J_365_Kraj) / nullif((365*@poc_J_365_Kraj),0)) *1000),
		 J_priem_ziv_prirastok_chov_500 = (select ((@spolu_J_hm500_Kraj - @hmotnar_J_500_Kraj) / nullif((500*@poc_J_500_Kraj),0)) *1000)
	
	 declare @spolu_B_hm120_Kraj float
		set @spolu_B_hm120_Kraj = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'B' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm210_Kraj float
		set @spolu_B_hm210_Kraj = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'B' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm365_Kraj float
		set @spolu_B_hm365_Kraj = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'B' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm500_Kraj float
		set @spolu_B_hm500_Kraj = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'B' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_120_Kraj float
		set @hmotnar_B_120_Kraj = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'B' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_210_Kraj float
		set @hmotnar_B_210_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'B' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_365_Kraj float
		set @hmotnar_B_365_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'B' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_500_Kraj float
		set @hmotnar_B_500_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal = 'B' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set B_priem_ziv_prirastok_chov_120 = (select ((@spolu_B_hm120_Kraj - @hmotnar_B_120_Kraj) / nullif((120*@poc_B_120_Kraj),0)) *1000),
	 B_priem_ziv_prirastok_chov_210 = (select ((@spolu_B_hm210_Kraj - @hmotnar_B_210_Kraj) / nullif((210*@poc_B_210_Kraj),0)) *1000),
	 B_priem_ziv_prirastok_chov_365 = (select ((@spolu_B_hm365_Kraj - @hmotnar_B_365_Kraj) / nullif((365*@poc_B_365_Kraj),0)) *1000),
	 B_priem_ziv_prirastok_chov_500 = (select ((@spolu_B_hm500_Kraj - @hmotnar_B_500_Kraj) / nullif((500*@poc_B_500_Kraj),0)) *1000)

	declare @spolu_MD2_hm120_Kraj float
		set @spolu_MD2_hm120_Kraj = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm210_Kraj float
		set @spolu_MD2_hm210_Kraj = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm365_Kraj float
		set @spolu_MD2_hm365_Kraj = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm500_Kraj float
		set @spolu_MD2_hm500_Kraj = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_120_Kraj float
		set @hmotnar_MD2_120_Kraj = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_210_Kraj float
		set @hmotnar_MD2_210_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_365_Kraj float
		set @hmotnar_MD2_365_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_500_Kraj float
		set @hmotnar_MD2_500_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
									where kraj = @chov
									and KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set MD2_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD2_hm120_Kraj - @hmotnar_MD2_120_Kraj) / nullif((120*@poc_MD2_120_Kraj),0)) *1000),
	 MD2_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD2_hm210_Kraj - @hmotnar_MD2_210_Kraj) / nullif((210*@poc_MD2_210_Kraj),0)) *1000),
	 MD2_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD2_hm365_Kraj - @hmotnar_MD2_365_Kraj) / nullif((365*@poc_MD2_365_Kraj),0)) *1000),
	 MD2_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD2_hm500_Kraj - @hmotnar_MD2_500_Kraj) / nullif((500*@poc_MD2_500_Kraj),0)) *1000)
	 
/****		vek 1 oteleni K2....vypocet  ***/
	declare @vek1otel_K2_Kraj float 
	set @vek1otel_K2_Kraj = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
								/*and Porlak = '1'*/ and Porlak is not null/******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
								and rok = DATEPART(YEAR, @datumOd))

	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K2_vek_1_otel = dbo.toMesiacDen(@vek1otel_K2_Kraj)--  AS  VEK_1_Otel

	update @hlavna 
	set K2_priem_lakt = (select convert (decimal (5,2),avg(Porlak*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov 
								and Porlak is not null and KrJal='K' 
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_vyradene =(select count(*) 
						from Roc_MPHD_Tab_zaklad 
						where kraj  = @chov
						and KrJal = 'K'  
						and rok = DATEPART(YEAR, @datumOd)
						and Datvyr >= @datumOD )
	--medziobdobie
	update @hlavna 
	set K2_medziobd = (select avg(medziobd) as Medziobdobie
						from Roc_MPHD_Tab_zaklad 
						where kraj = @chov
								and Porlak > '1' and KrJal='K' 
								and Medziobd > 100 and  Medziobd <= 1200
								and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm120_Kraj float
	set @spolu_K2_hm120_Kraj = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm210_Kraj float
	set @spolu_K2_hm210_Kraj = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm365_Kraj float
	set @spolu_K2_hm365_Kraj = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm500_Kraj float
	set @spolu_K2_hm500_Kraj = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_120_Kraj float
	set @hmotnar_K2_120_Kraj = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_210_Kraj float
	set @hmotnar_K2_210_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_365_Kraj float
	set @hmotnar_K2_365_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj  = @chov
									and KrJal='K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_500_Kraj float
	set @hmotnar_K2_500_Kraj = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where kraj = @chov
									and KrJal='K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	Update @hlavna 
	set K2_priem_ziv_prirastok_120 = (select ((@spolu_K2_hm120_Kraj - @hmotnar_K2_120_Kraj) / nullif((120*@poc_K2_120_Kraj),0)) *1000),-- as K2_priem_ziv_prirastok_120
	K2_priem_ziv_prirastok_210 = (select ((@spolu_K2_hm210_Kraj - @hmotnar_K2_210_Kraj) / nullif((210*@poc_K2_210_Kraj),0)) *1000),--  as K2_priem_ziv_prirastok_210
	K2_priem_ziv_prirastok_365 = (select ((@spolu_K2_hm365_Kraj - @hmotnar_K2_365_Kraj) / nullif((365*@poc_K2_365_Kraj),0)) *1000),--  as K2_priem_ziv_prirastok_365
	K2_priem_ziv_prirastok_500 = (select ((@spolu_K2_hm500_Kraj - @hmotnar_K2_500_Kraj) / nullif((500*@poc_K2_500_Kraj),0)) *1000)--  as K2_priem_ziv_prirastok_500

	update @hlavna 
	set K2_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal='K' 
							and Hm120 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_210 =(select convert (decimal (5,2), avg(Hm210*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal='K' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_365 = (select convert (decimal (5,2), avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal='K' 
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_500 = (select convert (decimal (5,2), avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where kraj = @chov
							and KrJal='K' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

insert into  Roc_MPHD_Tab_17
(	kraj, okres, podnik, chov, mastal,K1_poc, 
		K1_poc_120, K1_perc_120, 
		K1_poc_210, K1_perc_210, 
		K1_poc_365, K1_perc_365, 
		K1_poc_500,	K1_perc_500, 
		K1_Priem_Hm_120, K1_Priem_Hm_210, K1_Priem_Hm_365, K1_Priem_Hm_500, 
		K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365, K1_priem_ziv_prir_500, 
		K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
		MD1_poc, MD1_poc_vaz_120, MD1_perc_120, 
		MD1_poc_vaz_210, MD1_perc_210, MD1_poc_vaz_365, MD1_perc_365, MD1_poc_vaz_500, MD1_perc_500, 
		MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
		MD1_priem_ziv_prirastok_chov_500,
		K2_poc, K2_poc_120,	K2_perc_120, 
		K2_poc_210, K2_perc_210, 
		K2_poc_365, K2_perc_365, 
		K2_poc_500, K2_perc_500, K2_Priem_Hm_120,K2_Priem_Hm_210, K2_Priem_Hm_365, K2_Priem_Hm_500,
		K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
		K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
		J_poc, J_poc_vaz_120, J_perc_120, J_poc_vaz_210, J_perc_210, J_poc_vaz_365,  J_perc_365, J_poc_vaz_500, J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
		J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
		B_poc, B_poc_vaz_120,  B_perc_120, B_poc_vaz_210, 
		B_perc_210, B_poc_vaz_365, 
		B_perc_365, B_poc_vaz_500,
		B_perc_500, 
		B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
		B_priem_ziv_prirastok_chov_500 ,
		MD2_poc, MD2_poc_vaz_120, MD2_perc_120, MD2_poc_vaz_210, MD2_perc_210, MD2_poc_vaz_365, MD2_perc_365, MD2_poc_vaz_500, MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
		MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
		rok, plem_podiel, ekochov
)

Select kraj, okres, podnik, chov, mastal,
		K1_poc, K1_poc_120, 
		(K1_poc_120*1.0 / nullif(K1_poc,0))* 100 as K1_perc_120, 
		K1_poc_210, 
		(K1_poc_210*1.0 / nullif(K1_poc,0))* 100 as K1_perc_210, 
		K1_poc_365, 
		(K1_poc_365*1.0 / nullif(K1_poc,0))* 100 as K1_perc_365, 
		K1_poc_500,	
		(K1_poc_500*1.0 / nullif(K1_poc,0))* 100 as K1_perc_500, 
		K1_Priem_Hm_120 as K1_Priem_Hm_120,
		K1_Priem_Hm_210 as K1_Priem_Hm_210, 
		K1_Priem_Hm_365 as K1_Priem_Hm_365, 
		K1_Priem_Hm_500 as K1_Priem_Hm_500, 
		K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365, K1_priem_ziv_prir_500, 
		K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
		MD1_poc, MD1_poc_vaz_120, 
		(MD1_poc_vaz_120*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_120, 
		MD1_poc_vaz_210, 
		(MD1_poc_vaz_210*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_210, 
		MD1_poc_vaz_365, 
		(MD1_poc_vaz_365*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_365,
		MD1_poc_vaz_500, 
		(MD1_poc_vaz_500*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_500, 
		MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
		MD1_priem_ziv_prirastok_chov_500,
		K2_poc, K2_poc_120,	
		(K2_poc_120*1.0 / nullif(K2_poc,0))* 100 as K2_perc_120, 
		K2_poc_210, 
		(K2_poc_210*1.0 / nullif(K2_poc,0))* 100 as K2_perc_210, 
		K2_poc_365, 
		(K2_poc_365*1.0 / nullif(K2_poc,0))* 100 as K2_perc_365, 
		K2_poc_500,
		(K2_poc_500*1.0 / nullif(K2_poc,0))* 100 as K2_perc_500, 
		K2_Priem_Hm_120 as K2_Priem_Hm_120, K2_Priem_Hm_210 as K2_Priem_Hm_210, K2_Priem_Hm_365 as K2_Priem_Hm_365, K2_Priem_Hm_500 as K2_Priem_Hm_500,
		K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
		K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
		J_poc, J_poc_vaz_120, 
		(J_poc_vaz_120*1.0 / nullif(J_poc,0))* 100 as J_perc_120, J_poc_vaz_210, 
		(J_poc_vaz_210*1.0 / nullif(J_poc,0))* 100 as J_perc_210, J_poc_vaz_365, 
		(J_poc_vaz_365*1.0 / nullif(J_poc,0))* 100 as J_perc_365, J_poc_vaz_500,
		(J_poc_vaz_500*1.0 / nullif(J_poc,0))* 100 as J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
		J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
		B_poc, B_poc_vaz_120, 
		(B_poc_vaz_120*1.0 / nullif(B_poc,0))* 100 as B_perc_120, B_poc_vaz_210, 
		(B_poc_vaz_210*1.0 / nullif(B_poc,0))* 100 as B_perc_210, B_poc_vaz_365, 
		(B_poc_vaz_365*1.0 / nullif(B_poc,0))* 100 as B_perc_365, B_poc_vaz_500,
		(B_poc_vaz_500*1.0 / nullif(B_poc,0))* 100 as B_perc_500, 
		B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
		B_priem_ziv_prirastok_chov_500 ,
		MD2_poc, MD2_poc_vaz_120 , 
		(MD2_poc_vaz_120*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_120, MD2_poc_vaz_210, 
		(MD2_poc_vaz_210*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_210, MD2_poc_vaz_365, 
		(MD2_poc_vaz_365*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_365, MD2_poc_vaz_500, 
		(MD2_poc_vaz_500*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
		MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
		DATEPART(YEAR,@datumOd) as rok,
		''as plem_podiel,
		'' as ekochov
	from @hlavna where kraj = @chov
		
	end
else if @chov is null
	begin 
	/*** SR ***/
	/**aktualny stav  Kravy  *****************/
	declare @poc_K1_SR int --pocet krav
		set @poc_K1_SR = (select count(*) from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K1_120_SR int 
		set @poc_K1_120_SR = (select count(Hm120)  from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm120 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K1_210_SR int
		set @poc_K1_210_SR = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm210 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_365_SR int
		set @poc_K1_365_SR = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm365 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K1_500_SR int
		set @poc_K1_500_SR = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm500 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	

	/**  STAVY ZA KONTROLNY ROK Kravy  *******/
	declare @poc_K2_SR int --pocet krav
		set @poc_K2_SR = (select sum(Pocet_dni_na_chove)/365 from Roc_MPHD_Tab_zaklad
								where KrJal='K'
									and rok = DATEPART(YEAR, @datumOd))		
		----povodny vypocet som mala nastaveny ako pocet zijucich aj vyradenych krav na chov....no ukazalo sa, ze v rocenke tento udaj znamena priemerny pocet krav na chove
		/*(select count(*) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
								and rok = DATEPART(YEAR, @datumOd))*/
	declare @poc_K2_120_SR int --pocet krav
		set @poc_K2_120_SR = (select count(Hm120) /*as Vaz_K_120*/ from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_210_SR int
		set @poc_K2_210_SR = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_K2_365_SR int
		set @poc_K2_365_SR = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_K2_500_SR int
		set @poc_K2_500_SR = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))

	/**aktualny stav  MD Mlady dobytok  *****************/
	declare @poc_MD1_SR int --pocet
		set @poc_MD1_SR = (select count(*) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' 
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD1_120_SR int --pocet krav
		set @poc_MD1_120_SR = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_210_SR int
		set @poc_MD1_210_SR = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm210 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))	
	declare @poc_MD1_365_SR int
		set @poc_MD1_365_SR = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm365 is not null
								and datvyr is null and dovvyr is null
								and rok = DATEPART(YEAR, @datumOd))		
	declare @poc_MD1_500_SR int
		set @poc_MD1_500_SR = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))

	 /**  STAVY ZA KONTROLNY ROK MD Mlady dobytok  *****************/
	declare @poc_MD2_SR int --pocet krav
		set @poc_MD2_SR = (select count(*) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' 
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_120_SR int --pocet krav
		set @poc_MD2_120_SR = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
								where  KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_210_SR int
		set @poc_MD2_210_SR = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_365_SR int
		set @poc_MD2_365_SR = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_MD2_500_SR int
		set @poc_MD2_500_SR = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK J Jalovice  *****************/
	declare @poc_J_SR int --pocet jalovic
			set @poc_J_SR = (select count(*) from Roc_MPHD_Tab_zaklad 
									where KrJal ='J' 
										and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_120_SR int --pocet jalovic
		set @poc_J_120_SR = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
								where KrJal ='J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_210_SR int
		set @poc_J_210_SR = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal ='J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_365_SR int
		set @poc_J_365_SR = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal ='J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_J_500_SR int
		set @poc_J_500_SR = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal ='J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))

	/**  STAVY ZA KONTROLNY ROK B Bycky *********************/
	declare @poc_B_SR int --pocet byckov
			set @poc_B_SR = (select count(*) from Roc_MPHD_Tab_zaklad 
									where KrJal ='B' 
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_120_SR int --pocet byckov
		set @poc_B_120_SR = (select count(Hm120) from Roc_MPHD_Tab_zaklad 
									where KrJal ='B' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_210_SR int
		set @poc_B_210_SR = (select count(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal ='B' and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_365_SR int
		set @poc_B_365_SR = (select count(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal ='B' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
	declare @poc_B_500_SR int
		set @poc_B_500_SR = (select count(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal ='B' and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))
		
	/*
	vlozenie do dočasnej hlavnej tabulky
	*/
	 insert into @hlavna
		 (kraj, okres, podnik, chov, mastal, 
		 K1_poc, K1_poc_120, /*K1_perc_120, */K1_poc_210,/*K1_perc_210,*/K1_poc_365, /*K1_perc_365,*/ K1_poc_500,/*K1_perc_500,*/ 
		 K2_poc,K2_poc_120,/* K2_perc_120,*/ K2_poc_210, /*K2_perc_210,*/ K2_poc_365, /*K2_perc_365,*/ K2_poc_500, /*K2_perc_500, */
		 MD1_poc, MD1_poc_vaz_120,/* MD1_perc_120,*/ MD1_poc_vaz_210,/* MD1_perc_210,*/ MD1_poc_vaz_365, /*MD1_perc_365,*/ MD1_poc_vaz_500, /*MD1_perc_500,*/
		 MD2_poc, MD2_poc_vaz_120, /*MD2_perc_120,*/ MD2_poc_vaz_210,/* MD2_perc_210,*/ MD2_poc_vaz_365,/* MD2_perc_365,*/ MD2_poc_vaz_500, /*MD2_perc_500, */
		 J_poc, J_poc_vaz_120,/* J_perc_120,*/ J_poc_vaz_210,/* J_perc_210,*/ J_poc_vaz_365,/* J_perc_365,*/ J_poc_vaz_500,/* J_perc_500, */
		 B_poc, B_poc_vaz_120, /*B_perc_120,*/ B_poc_vaz_210,/* B_perc_210,*/ B_poc_vaz_365,/* B_perc_365,*/ B_poc_vaz_500 /*B_perc_500*/)
	 select '9' as kraj, '99' as okres, '999' as podnik, '99' as chov, '9' as mastal,
		@poc_K1_SR as K1_poc,
		@poc_K1_120_SR as K1_poc_120,
		@poc_K1_210_SR as K1_poc_210,
		@poc_K1_365_SR as K1_poc_365,
		@poc_K1_500_SR as K1_poc_500,
		
		@poc_K2_SR as K2_poc,
		@poc_K2_120_SR as K2_poc_120,
		@poc_K2_210_SR as K2_poc_210,
		@poc_K2_365_SR as K2_poc_365,
		@poc_K2_500_SR as K2_poc_500,
		
		@poc_MD1_SR as MD1_poc,
		@poc_MD1_120_SR as MD1_poc_vaz_120,
		@poc_MD1_210_SR as MD1_poc_vaz_210,
		@poc_MD1_365_SR as MD1_poc_vaz_365,
		@poc_MD1_500_SR as MD1_poc_vaz_500,
		
		@poc_MD2_SR as MD2_poc,
		@poc_MD2_120_SR as MD2_poc_vaz_120,
		@poc_MD2_210_SR as MD2_poc_vaz_210,
		@poc_MD2_365_SR as MD2_poc_vaz_365,
		@poc_MD2_500_SR as MD2_poc_vaz_500,
		
		@poc_J_SR as J_poc,
		@poc_J_120_SR as J_poc_vaz_120,
		@poc_J_210_SR as J_poc_vaz_210,
		@poc_J_365_SR as J_poc_vaz_365,
		@poc_J_500_SR as J_poc_vaz_500,
		
		@poc_B_SR as B_poc,
		@poc_B_120_SR as B_poc_vaz_120,
		@poc_B_210_SR as B_poc_vaz_210,
		@poc_B_365_SR as B_poc_vaz_365,
		@poc_B_500_SR as B_poc_vaz_500
		
				
	declare @spolu_K1_hm120_SR float
		set @spolu_K1_hm120_SR = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm210_SR float
		set @spolu_K1_hm210_SR = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm365_SR float
		set @spolu_K1_hm365_SR = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_K1_hm500_SR float
		set @spolu_K1_hm500_SR = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_120_SR float
		set @hmotnar_K1_120_SR = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_210_SR float
		set @hmotnar_K1_210_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_365_SR float
		set @hmotnar_K1_365_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm365 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_K1_500_SR float
		set @hmotnar_K1_500_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm500 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_priem_ziv_prir_120 = (select ((@spolu_K1_hm120_SR - @hmotnar_K1_120_SR) / nullif((120*@poc_K1_120_SR),0)) *1000),-- as K1_priem_ziv_prir_120
	K1_priem_ziv_prir_210 = (select ((@spolu_K1_hm210_SR - @hmotnar_K1_210_SR) / nullif((210*@poc_K1_210_SR),0)) *1000),-- as K1_priem_ziv_prir_210
	K1_priem_ziv_prir_365 = (select ((@spolu_K1_hm365_SR - @hmotnar_K1_365_SR) / nullif((365*@poc_K1_365_SR),0)) *1000),-- as K1_priem_ziv_prir_365
	K1_priem_ziv_prir_500 = (select ((@spolu_K1_hm500_SR - @hmotnar_K1_500_SR) / nullif((500*@poc_K1_500_SR),0)) *1000)-- as K1_priem_ziv_prir_500

	/** vybery pre prvy a druhy riadok		**/
	/******  --kravy  ******/
	
	/****		vek 1 oteleni K1....vypocet  ***/
	declare @vek1otel_K1_SR float 
	set @vek1otel_K1_SR = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
							where /* Porlak = '1'*/  Porlak is not null and datvyr is null and dovvyr is null/******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
								and rok = DATEPART(YEAR, @datumOd))

	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K1_vek_1_otel = dbo.toMesiacDen(@vek1otel_K1_SR)--  AS  VEK_1_Otel

	--medziobdobie
	update @hlavna 
	set K1_medziobd = (select avg(medziobd) as Medziobdobie
						from Roc_MPHD_Tab_zaklad 
						where Porlak > '1' and KrJal='K' 
						and datvyr is null and dovvyr is null
						and Medziobd > 100 and  Medziobd <= 1200
						and rok = DATEPART(YEAR, @datumOd))
	--priem.por.laktacie
	update @hlavna 
	set K1_priem_lakt = (select convert (decimal (5,2),avg(Porlak*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where Porlak is not null and KrJal='K' 
							and datvyr is null and dovvyr is null  
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set K1_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
							and Hm120 is not null
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
							and Hm210 is not null
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
							and Hm365 is not null
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K1_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
							and Hm500 is not null
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))

	/*******	--mlady dobytok  *******/
	update @hlavna
	set MD1_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where KrJal<>'K'  
							and (Hm120 is not null or Hm120 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal<>'K' 
							and (Hm210 is not null or Hm210 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal<>'K' 
							and (Hm365 is not null or Hm365 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD1_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal<>'K' 
							and (Hm500 is not null or Hm500 <>0)
							and datvyr is null and dovvyr is null
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK J  **********************************/
	update @hlavna
	set J_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where KrJal = 'J'   
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal = 'J' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal = 'J'  
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set J_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
	 						from Roc_MPHD_Tab_zaklad 
							where KrJal = 'J' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))

/**  STAVY ZA KONTROLNY ROK B  **********************/
	update @hlavna
	set B_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where KrJal = 'B'   
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_210 = (select convert (decimal (5,2),avg(Hm210*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal = 'B' 
							and Hm210 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal = 'B'  
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set B_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal = 'B' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))
		
/**  STAVY ZA KONTROLNY ROK MD  **********************/
	update @hlavna
	set MD2_vyradene = (select count(*) 
						from Roc_MPHD_Tab_zaklad 
						where KrJal <> 'K'  
						and rok = DATEPART(YEAR, @datumOd)
						and Datvyr >= @datumOD)
	update @hlavna
	set MD2_Priem_Hm_120 =(select convert (decimal (5,2),avg(Hm120*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where KrJal <> 'K'  
							and (Hm120 is not null or Hm120 <>0)
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_210 = ( select convert (decimal (5,2),avg(Hm210*1.0))
								from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K'
								and Hm210 is not null
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal <> 'K' 
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set MD2_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
								from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K'
								and Hm500 is not null
								and rok = DATEPART(YEAR, @datumOd))
			
	declare @spolu_MD1_hm120_SR float
		set @spolu_MD1_hm120_SR = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm210_SR float
		set @spolu_MD1_hm210_SR = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm365_SR float
		set @spolu_MD1_hm365_SR = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD1_hm500_SR float
		set @spolu_MD1_hm500_SR = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_120_SR float
		set @hmotnar_MD1_120_SR = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm120 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_210_SR float
		set @hmotnar_MD1_210_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm210 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD1_365_SR float
		set @hmotnar_MD1_365_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm365 is not null
									and datvyr is null and dovvyr is null
									and rok = DATEPART(YEAR, @datumOd) )
	declare @hmotnar_MD1_500_SR float
		set @hmotnar_MD1_500_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm500 is not null
									and datvyr is null and dovvyr is null 
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set MD1_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD1_hm120_SR - @hmotnar_MD1_120_SR) / nullif((120*@poc_MD1_120_SR),0)) *1000),-- as MD1_priem_ziv_prirastok_chov_120
	 MD1_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD1_hm210_SR - @hmotnar_MD1_210_SR) / nullif((210*@poc_MD1_210_SR),0)) *1000),-- as MD1_priem_ziv_prirastok_chov_210
	 MD1_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD1_hm365_SR - @hmotnar_MD1_365_SR) / nullif((365*@poc_MD1_365_SR),0)) *1000),-- as MD1_priem_ziv_prirastok_chov_365
	 MD1_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD1_hm500_SR - @hmotnar_MD1_500_SR) / nullif((500*@poc_MD1_500_SR),0)) *1000)-- as MD1_priem_ziv_prirastok_chov_500

	
	declare @spolu_J_hm120_SR float
		set @spolu_J_hm120_SR = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm210_SR float
		set @spolu_J_hm210_SR = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm365_SR float
		set @spolu_J_hm365_SR = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_J_hm500_SR float
		set @spolu_J_hm500_SR = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_120_SR float
		set @hmotnar_J_120_SR = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where KrJal = 'J' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_210_SR float
		set @hmotnar_J_210_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'J' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_365_SR float
		set @hmotnar_J_365_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'J' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_J_500_SR float
		set @hmotnar_J_500_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'J' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set J_priem_ziv_prirastok_chov_120 = (select ((@spolu_J_hm120_SR - @hmotnar_J_120_SR) / nullif((120*@poc_J_120_SR),0)) *1000),
		 J_priem_ziv_prirastok_chov_210 = (select ((@spolu_J_hm210_SR - @hmotnar_J_210_SR) / nullif((210*@poc_J_210_SR),0)) *1000),
		 J_priem_ziv_prirastok_chov_365 = (select ((@spolu_J_hm365_SR - @hmotnar_J_365_SR) / nullif((365*@poc_J_365_SR),0)) *1000),
		 J_priem_ziv_prirastok_chov_500 = (select ((@spolu_J_hm500_SR - @hmotnar_J_500_SR) / nullif((500*@poc_J_500_SR),0)) *1000)
	
	declare @spolu_B_hm120_SR float
		set @spolu_B_hm120_SR = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'B' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm210_SR float
		set @spolu_B_hm210_SR = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'B' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm365_SR float
		set @spolu_B_hm365_SR = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'B' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_B_hm500_SR float
		set @spolu_B_hm500_SR = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'B' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_120_SR float
		set @hmotnar_B_120_SR = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where KrJal = 'B' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_210_SR float
		set @hmotnar_B_210_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'B' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_365_SR float
		set @hmotnar_B_365_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'B' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_B_500_SR float
		set @hmotnar_B_500_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal = 'B' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))

	update @hlavna 
	set B_priem_ziv_prirastok_chov_120 = (select ((@spolu_B_hm120_SR - @hmotnar_B_120_SR) / nullif((120*@poc_B_120_SR),0)) *1000),
	 B_priem_ziv_prirastok_chov_210 = (select ((@spolu_B_hm210_SR - @hmotnar_B_210_SR) / nullif((210*@poc_B_210_SR),0)) *1000),
	 B_priem_ziv_prirastok_chov_365 = (select ((@spolu_B_hm365_SR - @hmotnar_B_365_SR) / nullif((365*@poc_B_365_SR),0)) *1000),
	 B_priem_ziv_prirastok_chov_500 = (select ((@spolu_B_hm500_SR - @hmotnar_B_500_SR) / nullif((500*@poc_B_500_SR),0)) *1000)
	 
	declare @spolu_MD2_hm120_SR float
		set @spolu_MD2_hm120_SR = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm210_SR float
		set @spolu_MD2_hm210_SR = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
									where KrJal <> 'K' and Hm210 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm365_SR float
		set @spolu_MD2_hm365_SR = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @spolu_MD2_hm500_SR float
		set @spolu_MD2_hm500_SR = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
									where KrJal <> 'K' and Hm500 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_120_SR float
		set @hmotnar_MD2_120_SR = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_210_SR float
		set @hmotnar_MD2_210_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm210 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_365_SR float
		set @hmotnar_MD2_365_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm365 is not null
										and rok = DATEPART(YEAR, @datumOd))
	declare @hmotnar_MD2_500_SR float
		set @hmotnar_MD2_500_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal <> 'K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna 
	set MD2_priem_ziv_prirastok_chov_120 = (select ((@spolu_MD2_hm120_SR - @hmotnar_MD2_120_SR) / (120*nullif(@poc_MD2_120_SR,0)) *1000)),
	 MD2_priem_ziv_prirastok_chov_210 = (select ((@spolu_MD2_hm210_SR - @hmotnar_MD2_210_SR) / (210*nullif(@poc_MD2_210_SR,0)) *1000)),
	 MD2_priem_ziv_prirastok_chov_365 = (select ((@spolu_MD2_hm365_SR - @hmotnar_MD2_365_SR) / (365*nullif(@poc_MD2_365_SR,0)) *1000)),
	 MD2_priem_ziv_prirastok_chov_500 = (select ((@spolu_MD2_hm500_SR - @hmotnar_MD2_500_SR) / (500*nullif(@poc_MD2_500_SR,0)) *1000))


/****		vek 1 oteleni K2....vypocet  ***/
	declare @vek1otel_K2_SR float 
	set @vek1otel_K2_SR = (select AVG(Vek_otel_dni) from Roc_MPHD_Tab_zaklad 
							 where rok = DATEPART(YEAR, @datumOd) and Porlak is not null)
								/*and Porlak = '1'*/	/******* maju to byt priemery za vsettky prve otelenia krav na chove, aj ked uz maju vyssie poradie laktacie ********/
	
	--vypocet pre vek pri 1 oteleni
	update @hlavna 
	set K2_vek_1_otel = dbo.toMesiacDen(@vek1otel_K2_SR)--  AS  VEK_1_Otel

	update @hlavna 
	set K2_priem_lakt = (select convert (decimal (5,2),avg(Porlak*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where Porlak is not null and KrJal='K' 
								and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_vyradene =( select count(*) 
						from Roc_MPHD_Tab_zaklad 
						where KrJal = 'K'  
						and Datvyr >= @datumOD
						and rok = DATEPART(YEAR, @datumOd))
	--medziobdobie
	update @hlavna 
	set K2_medziobd = (select avg(medziobd) as Medziobdobie
						from Roc_MPHD_Tab_zaklad 
						where Porlak > '1' and KrJal='K' 
								and Medziobd > 100 and  Medziobd <= 1200
									and rok = DATEPART(YEAR, @datumOd))

declare @spolu_K2_hm120_SR float
	set @spolu_K2_hm120_SR = (select sum(Hm120) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm210_SR float
	set @spolu_K2_hm210_SR = (select sum(Hm210) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm365_SR float
	set @spolu_K2_hm365_SR = (select sum(Hm365) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm365 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @spolu_K2_hm500_SR float
	set @spolu_K2_hm500_SR = (select sum(Hm500) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_120_SR float
	set @hmotnar_K2_120_SR = (select sum(Hmotnar) as Vaz_K_120 from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm120 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_210_SR float
	set @hmotnar_K2_210_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_365_SR float
	set @hmotnar_K2_365_SR = (select sum(Hmotnar) 
								from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm365 is not null
								and rok = DATEPART(YEAR, @datumOd))
declare @hmotnar_K2_500_SR float
	set @hmotnar_K2_500_SR = (select sum(Hmotnar) from Roc_MPHD_Tab_zaklad 
								where KrJal='K' and Hm500 is not null
									and rok = DATEPART(YEAR, @datumOd))
								
	Update @hlavna 
	set K2_priem_ziv_prirastok_120 = (select ((@spolu_K2_hm120_SR - @hmotnar_K2_120_SR) / (120*nullif(@poc_K2_120_SR,0))) *1000),-- as K2_priem_ziv_prirastok_120
	K2_priem_ziv_prirastok_210 = (select ((@spolu_K2_hm210_SR - @hmotnar_K2_210_SR) / (210*nullif(@poc_K2_210_SR,0))) *1000),--  as K2_priem_ziv_prirastok_210
	K2_priem_ziv_prirastok_365 = (select ((@spolu_K2_hm365_SR - @hmotnar_K2_365_SR) / (365*nullif(@poc_K2_365_SR,0))) *1000),--  as K2_priem_ziv_prirastok_365
	K2_priem_ziv_prirastok_500 = (select ((@spolu_K2_hm500_SR - @hmotnar_K2_500_SR) / (500*nullif(@poc_K2_500_SR,0))) *1000)--  as K2_priem_ziv_prirastok_500

	update @hlavna 
	set K2_Priem_Hm_120 = (select convert (decimal (5,2),avg(Hm120*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
							and Hm120 is not null
							and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_210 =(select convert (decimal (5,2),avg(Hm210*1.0)) 
							from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
									and Hm210 is not null
									and rok = DATEPART(YEAR, @datumOd))
	update @hlavna
	set K2_Priem_Hm_365 = (select convert (decimal (5,2),avg(Hm365*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
							and Hm365 is not null
							and rok = DATEPART(YEAR, @datumOd))
				
	update @hlavna
	set K2_Priem_Hm_500 = (select convert (decimal (5,2),avg(Hm500*1.0))
							from Roc_MPHD_Tab_zaklad 
							where KrJal='K' 
							and Hm500 is not null
							and rok = DATEPART(YEAR, @datumOd))
		
insert into  Roc_MPHD_Tab_17
(	kraj, okres, podnik, chov, mastal,K1_poc, 
		K1_poc_120, K1_perc_120, 
		K1_poc_210, K1_perc_210, 
		K1_poc_365, K1_perc_365, 
		K1_poc_500,	K1_perc_500, 
		K1_Priem_Hm_120, K1_Priem_Hm_210, K1_Priem_Hm_365, K1_Priem_Hm_500, 
		K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365, K1_priem_ziv_prir_500, 
		K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
		MD1_poc, MD1_poc_vaz_120, MD1_perc_120, 
		MD1_poc_vaz_210, MD1_perc_210, MD1_poc_vaz_365, MD1_perc_365, MD1_poc_vaz_500, MD1_perc_500, 
		MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
		MD1_priem_ziv_prirastok_chov_500,
		K2_poc, K2_poc_120,	K2_perc_120, 
		K2_poc_210, K2_perc_210, 
		K2_poc_365, K2_perc_365, 
		K2_poc_500, K2_perc_500, K2_Priem_Hm_120,K2_Priem_Hm_210, K2_Priem_Hm_365, K2_Priem_Hm_500,
		K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
		K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
		J_poc, J_poc_vaz_120, J_perc_120, J_poc_vaz_210, J_perc_210, J_poc_vaz_365,  J_perc_365, J_poc_vaz_500, J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
		J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,
		B_poc, B_poc_vaz_120,  B_perc_120, B_poc_vaz_210, 
		B_perc_210, B_poc_vaz_365, 
		B_perc_365, B_poc_vaz_500,
		B_perc_500, 
		B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
		B_priem_ziv_prirastok_chov_500 ,
		MD2_poc, MD2_poc_vaz_120, MD2_perc_120, MD2_poc_vaz_210, MD2_perc_210, MD2_poc_vaz_365, MD2_perc_365, MD2_poc_vaz_500, MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
		MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
		rok, plem_podiel, ekochov
)

Select kraj, okres, podnik, chov, mastal,
	K1_poc, K1_poc_120, (K1_poc_120*1.0 / nullif(K1_poc,0))* 100 as K1_perc_120, 
	K1_poc_210, (K1_poc_210*1.0 / nullif(K1_poc,0))* 100 as K1_perc_210, 
	K1_poc_365, (K1_poc_365*1.0 / nullif(K1_poc,0))* 100 as K1_perc_365, 
	K1_poc_500,	(K1_poc_500*1.0 / nullif(K1_poc,0))* 100 as K1_perc_500, 
	K1_Priem_Hm_120, K1_Priem_Hm_210, K1_Priem_Hm_365, K1_Priem_Hm_500, K1_priem_ziv_prir_120, K1_priem_ziv_prir_210 , K1_priem_ziv_prir_365,
	K1_priem_ziv_prir_500, K1_medziobd , K1_vek_1_otel, K1_priem_lakt, 
	MD1_poc, MD1_poc_vaz_120, 
	(MD1_poc_vaz_120*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_120, 
	MD1_poc_vaz_210, 
	(MD1_poc_vaz_210*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_210, MD1_poc_vaz_365, 
	(MD1_poc_vaz_365*1.0 / nullif(MD1_poc,0))* 100 as MD1_perc_365,
	MD1_poc_vaz_500, 
	(MD1_poc_vaz_500*1.0 / MD1_poc)* 100 as MD1_perc_500, MD1_Priem_Hm_120, MD1_Priem_Hm_210, MD1_Priem_Hm_365,	MD1_Priem_Hm_500 , MD1_priem_ziv_prirastok_chov_120, MD1_priem_ziv_prirastok_chov_210, MD1_priem_ziv_prirastok_chov_365,  
	MD1_priem_ziv_prirastok_chov_500,
	K2_poc, K2_poc_120,	
	(K2_poc_120*1.0 / nullif(K2_poc,0))* 100 as K2_perc_120, K2_poc_210, 
	(K2_poc_210*1.0 / nullif(K2_poc,0))* 100 as K2_perc_210, K2_poc_365, 
	(K2_poc_365*1.0 / nullif(K2_poc,0))* 100 as K2_perc_365, K2_poc_500,
	(K2_poc_500*1.0 / nullif(K2_poc,0))* 100 as K2_perc_500, 
	K2_Priem_Hm_120, K2_Priem_Hm_210, K2_Priem_Hm_365, K2_Priem_Hm_500,
	K2_priem_ziv_prirastok_120, K2_priem_ziv_prirastok_210, K2_priem_ziv_prirastok_365,
	K2_priem_ziv_prirastok_500, K2_medziobd, K2_vek_1_otel, K2_priem_lakt, K2_vyradene,
	J_poc, J_poc_vaz_120, 
	(J_poc_vaz_120*1.0 / nullif(J_poc,0))* 100 as J_perc_120, J_poc_vaz_210, 
	(J_poc_vaz_210*1.0 / nullif(J_poc,0))* 100 as J_perc_210, J_poc_vaz_365, 
	(J_poc_vaz_365*1.0 / nullif(J_poc,0))* 100 as J_perc_365, J_poc_vaz_500,
	(J_poc_vaz_500*1.0 / nullif(J_poc,0))* 100 as J_perc_500, J_Priem_Hm_120, J_Priem_Hm_210, J_Priem_Hm_365, J_Priem_Hm_500, J_priem_ziv_prirastok_chov_120,  
	J_priem_ziv_prirastok_chov_210, J_priem_ziv_prirastok_chov_365, J_priem_ziv_prirastok_chov_500,

	B_poc, B_poc_vaz_120, 
	(B_poc_vaz_120*1.0 / nullif(B_poc,0))* 100 as B_perc_120, B_poc_vaz_210, 
	(B_poc_vaz_210*1.0 / nullif(B_poc,0))* 100 as B_perc_210, B_poc_vaz_365, 
	(B_poc_vaz_365*1.0 / nullif(B_poc,0))* 100 as B_perc_365, B_poc_vaz_500,
	(B_poc_vaz_500*1.0 / nullif(B_poc,0))* 100 as B_perc_500, 
	B_Priem_Hm_120, B_Priem_Hm_210 , B_Priem_Hm_365,  B_Priem_Hm_500, B_priem_ziv_prirastok_chov_120, B_priem_ziv_prirastok_chov_210, B_priem_ziv_prirastok_chov_365,  
	B_priem_ziv_prirastok_chov_500 ,

	MD2_poc, MD2_poc_vaz_120 , 
	(MD2_poc_vaz_120*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_120, MD2_poc_vaz_210, 
	(MD2_poc_vaz_210*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_210, MD2_poc_vaz_365, 
	(MD2_poc_vaz_365*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_365, MD2_poc_vaz_500, 
	(MD2_poc_vaz_500*1.0 / nullif(MD2_poc,0))*100 as MD2_perc_500, MD2_Priem_Hm_120, MD2_Priem_Hm_210, 
	MD2_Priem_Hm_365, MD2_Priem_Hm_500,	MD2_priem_ziv_prirastok_chov_120, MD2_priem_ziv_prirastok_chov_210, MD2_priem_ziv_prirastok_chov_365, MD2_priem_ziv_prirastok_chov_500,	MD2_vyradene,
	DATEPART(YEAR,@datumOd) as rok, 
	'' as plem_podiel,
	'' as ekochov
	from @hlavna --where kraj = @chov

	end
	
	End
go



-------------------------------------------------------------------------------------------



/****** Script for SelectTopNRows command from SSMS  ******/
/** Rocenka MLHD ----PREHLAD VYSLEDKOV PODLA KRAJOV ---str 13 **/
/** prisposobene fakturacii, preto  tie zakomentovane casti.**/
CREATE procedure  [dbo].[Roc_MLHD_4]
	
	@datumOd date,
	@datumDo date, 
	@datumFakturOd date,  --niektore udaje su prisposobene fakturacii, preto tento datum ---!!!! ide o obdobie, v ktorom mohli byt vyradene kravy, ktore sa este do fakturacie ratali ale nam by sa do plisu neratali!!!!!
	@datumFakturDo date
--declare @datumod date ='2017-01-01'
--declare @datumdo date ='2017-12-31'
--declare @datumFakturOd date ='2017-12-13'
--declare @datumFakturDo date ='2018-01-04'
	as 
	begin


/*******pocet chovov + pocet zapojenych krav za chov******/
/***povodny vypocet***
		select  ch.kraj,p.NAZOV ,count( distinct substring(k.CHOVATEL,1,8) ) as pocet_chovov,count(distinct k.CISKRAVY) as pocet_krav_kraj
			from NM_CHOVMAS as ch left outer join CM_Krava as k on ch.kraj = SUBSTRING(k.chovatel,1,1) 
			join NC_KRAJ p on p.KRAJ = ch.kraj
			where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1' 
			and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
			group by ch.kraj,p.NAZOV

		select count( distinct substring(k.CHOVATEL,1,8) ) as SR_pocet_chovov, count(distinct k.CISKRAVY) as SR_pocet_krav
			from NM_CHOVMAS as ch left outer join CM_Krava as k on ch.kraj = SUBSTRING(k.chovatel,1,1) 
			join NC_KRAJ p on p.KRAJ = ch.kraj
			where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1' 
			and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd))
		***/
/***vypocet prisposobeny fakturacii...aby sedeli pocty***/
    select distinct
      c.KRAJ,
      p.NAZOV,
      count(distinct substring(h.kraj + h.OKRES + h.PODNIK + h.CHOV, 1, 8)) as pocet_chovov,
      count(distinct k.ciskravy)                                            as pocet_krav ---kraje
    from NM_CHOVMAS as c
      inner join NM_HDDETAIL as h on h.kraj + h.OKRES + h.PODNIK + h.CHOV = c.kraj + c.OKRES + c.PODNIK + c.CHOV and
                                     h.PRIZNAK = '01' and h.SPVYKON not in ('0', '4', '5') and h.TECHUSMD = '00'
      inner join CM_Krava as k on c.kraj + c.OKRES + c.PODNIK + c.CHOV = k.CHOVATEL and (k.DOVVYR is null)
                                  and k.datzar <= @datumFakturDo
      /*'2018-01-04'*/
      left outer join NC_KRAJ p on p.KRAJ = c.kraj
    where c.TYPZV = '1'
          and c.ZRUS is null
    group by c.kraj, p.NAZOV
    order by c.KRAJ
    /**za SR**/	
	select distinct  count( distinct substring(h.kraj+h.OKRES+h.PODNIK+h.CHOV,1,8)) as SR_pocet_chovov, count( distinct k.ciskravy ) as SR_pocet_krav---SLOVENSKO
		from NM_CHOVMAS as c
			inner join NM_HDDETAIL as h on h.kraj+h.OKRES+h.PODNIK+h.CHOV=c.kraj+c.OKRES+ c.PODNIK+c.CHOV and h.PRIZNAK='01' and h.SPVYKON not in ('0','4','5') and h.TECHUSMD ='00'
	  		inner join CM_Krava as k on c.kraj+c.OKRES+ c.PODNIK+c.CHOV = k.CHOVATEL and (k.DOVVYR is null) and k.datzar <=@datumFakturDo/*'2018-01-04'*/ 
			left outer join NC_KRAJ p on p.KRAJ = c.kraj
		where  c.TYPZV='1'
			and c.ZRUS is null

/******priemerna velkost chovu******/

/***povodny vypocet***
	select asd.kraj, k.NAZOV, AVG(asd.pocet) as priem_velkost_chovu
		from (select  substring(k.CHOVATEL,1,8) as asas, count(distinct ciskravy)  as pocet, kraj 
				from NM_CHOVMAS as ch 
					left outer join CM_Krava as k on ch.kraj = SUBSTRING(k.chovatel,1,1) 
				where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) 
					and k.PRIZNAKKU = '1'
					and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
				group by substring(k.CHOVATEL,1,8), kraj) as asd
		join NC_KRAJ k on k.KRAJ = asd.kraj
	group by asd.kraj, k.NAZOV
/**za SR**/
	select AVG(asd.pocet) as SR_priem_velkost_chovu
		from (select  substring(k.CHOVATEL,1,8) as asas ,count(distinct ciskravy)  as pocet, kraj 
				from NM_CHOVMAS as ch left outer join CM_Krava as k on ch.kraj = SUBSTRING(k.chovatel,1,1) 
				where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
						and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
				group by substring(k.CHOVATEL,1,8), kraj) as asd
		join NC_KRAJ k on k.KRAJ = asd.kraj
***/
/***vypocet prisposobeny fakturacii...aby sedeli pocty***/
		select
			asd.kraj,
			k.NAZOV,
			AVG(asd.pocet) as priem_velkost_chovu
		from (select
						substring(k.CHOVATEL, 1, 8) as asas,
						count(distinct ciskravy)    as pocet,
						c.kraj
					from NM_CHOVMAS as c
						inner join NM_HDDETAIL as h on h.kraj + h.OKRES + h.PODNIK + h.CHOV = c.kraj + c.OKRES + c.PODNIK + c.CHOV
																					 and h.PRIZNAK = '01' and h.SPVYKON not in ('0', '4', '5') and
																					 h.TECHUSMD = '00'
						inner join CM_Krava as k on c.kraj + c.OKRES + c.PODNIK + c.CHOV = k.CHOVATEL and (k.DOVVYR is null) and
																				k.datzar <= @datumFakturDo /*'2018-01-04'*/
					where c.TYPZV = '1'
								and c.ZRUS is null
					group by substring(k.CHOVATEL, 1, 8), c.kraj) as asd
			join NC_KRAJ k on k.KRAJ = asd.kraj
		group by asd.kraj, k.NAZOV
		order by asd.KRAJ
/**za SR**/
	select AVG(asd.pocet) as SR_priem_velkost_chovu
		from (select  substring(k.CHOVATEL,1,8) as asas ,count(distinct ciskravy)  as pocet, c.kraj 
				from NM_CHOVMAS as c
					inner join NM_HDDETAIL as h on h.kraj+h.OKRES+h.PODNIK+h.CHOV=c.kraj+c.OKRES+ c.PODNIK+c.CHOV and h.PRIZNAK='01' and h.SPVYKON not in ('0','4','5') and h.TECHUSMD ='00'
	  				inner join CM_Krava as k on c.kraj+c.OKRES+ c.PODNIK+c.CHOV = k.CHOVATEL and (k.DOVVYR is null) and k.datzar <=@datumFakturDo/*'2018-01-04'*/ 
				where  c.TYPZV='1'
					
					and c.ZRUS is null
					
					
				group by substring(k.CHOVATEL,1,8), c.kraj) as asd
		join NC_KRAJ k on k.KRAJ = asd.kraj

/**priemerna uzitkovost mlieka, tuku, bielkovin**/
	select datepart(year,@datumOd) as ROK
		,Filter as kraj
		,MliekNorCelk as priem_uzit_ML
		,TukNorCelk as priem_uzit_TUK
		,BielkNorCelk as priem_uzit_BIELK
	from  CR_LaktacneZostavy_Opr as l
		where @datumOd = l.DatumOd 
			and @datumDo = l.DatumDo
			and Filter = Oznacenie
			and (Filter ='SR' or len(Filter)=1)
	order by filter

/*****************************
	/****upravene aby to sedelo s tabulkou 1***/
		/**priemerna uzitkovost mlieka**/
			select  ch.kraj,p.NAZOV ,avg(l.MLIEKCEL)  as priem_uz_mlieka
				from NM_CHOVMAS as ch 
					left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
					left outer join CM_Laktacie as l on l.CISKRAVY=k.CISKRAVY
					join NC_KRAJ p on p.KRAJ = ch.kraj
				   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
					and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
					and l.DATUKONL >@datumod and l.DATUKONL <@datumdo			 
				group by  ch.kraj ,p.NAZOV
				order by ch.kraj
		/**za SR**/
			select avg(l.MLIEKCEL)  as SR_priem_uz_mlieka
				from NM_CHOVMAS as ch 
					left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
					left outer join CM_Laktacie as l on l.CISKRAVY=k.CISKRAVY
					join NC_KRAJ p on p.KRAJ = ch.kraj
				   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
					and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
					and l.DATUKONL >@datumod and l.DATUKONL <@datumdo	

		/**priemerna uzitkovost tuku**/
			select   ch.kraj,p.NAZOV ,avg(l.TUKCEL) as priem_uz_tuku
				from NM_CHOVMAS as ch 
					left outer join CM_Krava as k on  ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
					left outer join CM_Laktacie as l on l.CISKRAVY=k.CISKRAVY
					join NC_KRAJ p on p.KRAJ = ch.kraj
				   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
					and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
					and DATUKONL >@datumod and DATUKONL <@datumdo			 
				group by  ch.kraj ,p.NAZOV
				order by ch.kraj
		/**za SR**/
			select  avg(l.TUKCEL) as SR_priem_uz_tuku
				from NM_CHOVMAS as ch 
					left outer join CM_Krava as k on  ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
					left outer join CM_Laktacie as l on l.CISKRAVY=k.CISKRAVY
					join NC_KRAJ p on p.KRAJ = ch.kraj
				   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
					and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
					and DATUKONL >@datumod and DATUKONL <@datumdo		
		
		/**priemerna uzitkovost bielkovin**/
			select   ch.kraj,p.NAZOV ,avg(l.BIELKCEL)  as priem_uz_bielk
			from NM_CHOVMAS as ch 
				left outer join CM_Krava as k on  ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
				left outer join CM_Laktacie as l on l.CISKRAVY=k.CISKRAVY
				join NC_KRAJ p on p.KRAJ = ch.kraj
			   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
				and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
				and DATUKONL >@datumod and DATUKONL <@datumdo			 
				group by  ch.kraj ,p.NAZOV
				order by ch.kraj
		/**za SR**/
			select avg(l.BIELKCEL)  as SR_priem_uz_bielk
			from NM_CHOVMAS as ch 
				left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
				left outer join CM_Laktacie as l on l.CISKRAVY=k.CISKRAVY
				join NC_KRAJ p on p.KRAJ = ch.kraj
			   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
				and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
				and DATUKONL >@datumod and DATUKONL <@datumdo	
	*****************************/

/** priemerne poradie prebiehajucej laktacie**/
	select   ch.kraj,p.NAZOV ,avg(Cast(l.PORLAK as float)) as por_preb_lakt
		 from NM_CHOVMAS as ch left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
			left outer join CM_Naplak as l on l.CISKRAVY=k.CISKRAVY
			join NC_KRAJ p on p.KRAJ = ch.kraj
		   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
			and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
			and DATUKONL >@datumod 	and l.DATUKONL <@datumdo		 
		group by  ch.kraj ,p.NAZOV
		order by ch.kraj
/**za SR**/
	select avg(Cast(l.PORLAK as float)) as SR_por_preb_lakt
	 from NM_CHOVMAS as ch left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
		left outer join CM_Naplak as l on l.CISKRAVY=k.CISKRAVY
		join NC_KRAJ p on p.KRAJ = ch.kraj
	   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
		and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
		and DATUKONL >@datumod 	and l.DATUKONL <@datumdo

/** priemerne poradie ukoncenej laktacie**/
	select   ch.kraj,p.NAZOV ,avg(Cast(lakt.PORLAK as float)) as por_ukon_lakt
		from NM_CHOVMAS as ch 
			left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
			left outer join dbo.View_CP_LaktaciePreZostavy as lakt on lakt.CISKRAVY=k.CISKRAVY
			join NC_KRAJ p on p.KRAJ = ch.kraj
		   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
			and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
			and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd)
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))	
					and lakt.ZMENA in('30','40') 
		group by  ch.kraj ,p.NAZOV
		order by ch.kraj
/**za SR**/	
	select avg(Cast(lakt.PORLAK as float)) as SR_por_ukon_lakt
		from NM_CHOVMAS as ch 
			left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
			left outer join CM_Laktacie as lakt on lakt.CISKRAVY=k.CISKRAVY
			join NC_KRAJ p on p.KRAJ = ch.kraj
			where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
			and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
			and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd)
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))	
					and lakt.ZMENA between 30 and 40 
		
/**priemerna dlzka statia na sucho**/
	select   distinct ch.kraj,p.NAZOV ,  avg(cast (datediff (dd,( dateadd(day,lakt.LAKTDNI,lakt.DATOTEL)),l.DATOTEL)as bigint)) as  priem_dlzka_statia
	   from NM_CHOVMAS as ch
		   left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
		   left outer join CM_Naplak as l on l.CISKRAVY=k.CISKRAVY
		   left outer join CM_Laktacie lakt on lakt.CISKRAVY =k.CISKRAVY
		   join NC_KRAJ p on p.KRAJ = ch.kraj
			 where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
				 and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd))
				 and lakt.DATUKONL >@datumod 	and lakt.DATUKONL <@datumdo		
				 and l.DATOTEL>lakt.DATOTEL    
				 and datediff (dd,( dateadd(day,lakt.LAKTDNI,lakt.DATOTEL)),l.DATOTEL) <1000
	  group by  ch.kraj ,p.NAZOV
	  order by ch.kraj
/**za SR**/
	select distinct avg(cast (datediff (dd,( dateadd(day,lakt.LAKTDNI,lakt.DATOTEL)),l.DATOTEL)as bigint)) as  SR_priem_dlzka_statia
	   from NM_CHOVMAS as ch
		   left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
		   left outer join CM_Naplak as l on l.CISKRAVY=k.CISKRAVY
		   left outer join CM_Laktacie lakt on lakt.CISKRAVY =k.CISKRAVY
		   join NC_KRAJ p on p.KRAJ = ch.kraj
			 where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
				 and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd))
				 and lakt.DATUKONL >@datumod 	and lakt.DATUKONL <@datumdo		
				 and l.DATOTEL>lakt.DATOTEL    
				 and datediff (dd,( dateadd(day,lakt.LAKTDNI,lakt.DATOTEL)),l.DATOTEL) <1000

/** priemerna dlzka medziobdobia**/
	select   ch.kraj,p.NAZOV ,avg(Cast(lakt.MEDZIOBD as float)) as priem_medziobd
	from NM_CHOVMAS as ch left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
		left outer join CM_Laktacie as lakt on lakt.CISKRAVY=k.CISKRAVY
		join NC_KRAJ p on p.KRAJ = ch.kraj
	   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
		and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
		and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd)
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
		and lakt.ZMENA between 30 and 40
		and Lakt.PORLAK > 1
					
		group by  ch.kraj ,p.NAZOV
		order by ch.kraj
/**za SR**/
	select avg(Cast(lakt.MEDZIOBD as float)) as SR_priem_medziobd
	from NM_CHOVMAS as ch left outer join CM_Krava as k on ch.kraj+ch.okres+ch.podnik+ch.chov = k.chovatel
		left outer join CM_Laktacie as lakt on lakt.CISKRAVY=k.CISKRAVY
		join NC_KRAJ p on p.KRAJ = ch.kraj
	   where (k.DOVVYR is null or(k.DOVVYR is not null and k.DATVYR > @datumOd)) and k.PRIZNAKKU = '1'
		and (ch.ZRUS is null or(ch.ZRUS is not null and datumZrusenia > @datumOd)) 
		and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd)
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
	  and lakt.ZMENA between 30 and 40
		and Lakt.PORLAK > 1
					
/*****priemerny interval za kraje****/
select left(z.KROK,1) as kraj , sum(PINT) / count(*) as 'Interval' from CM_ZSI as z
	left outer join CM_Insvyk as i on i.iplca = z.plca
	where z.KRJA = 1
		and i.IPOIN = 1
		and i.IDAIN >= @datumOd and i.IDAIN <= @datumDo
		and i.IVYSE not in ('1','2')
		and z.PINT > 0 
		and z.plca in (select ciskravy from CM_Krava where priznakKU = 1
					union 
						select cistelata from CM_Telata where priznakKu = 1 and cistelata not in (select ciskravy from CM_Krava))
	group by left(z.KROK,1)
	order by left(z.KROK,1)

/*****priemerny interval za SR****/
select sum(PINT) / count(*) as 'Interval_SR' from CM_ZSI as z
	left outer join CM_Insvyk as i on i.iplca = z.plca
	where z.KRJA = 1
		and i.IPOIN = 1
		and i.IDAIN >= @datumOd and i.IDAIN <= @datumDo
		and i.IVYSE not in ('1','2')
		and z.PINT > 0 
		and z.plca in (select ciskravy from CM_Krava where priznakKU = 1
					union 
						select cistelata from CM_Telata where priznakKu = 1 and cistelata not in (select ciskravy from CM_Krava))

/****servis perioda za kraje***/
select left(z.KROK,1) as kraj , sum(PSER) / count(*) as 'Serv_per' from CM_ZSI as z
	left outer join CM_Insvyk as i on i.iplca = z.plca
	where z.KRJA = 1
		and i.IDAIN >= @datumOd and i.IDAIN <= @datumDo
		and i.IVYSE > 6
		and i.IPOIN <> 99
		and z.PSER > 0 
		and z.plca in (select ciskravy from CM_Krava where priznakKU = 1
					union 
						select cistelata from CM_Telata where priznakKu = 1 and cistelata not in (select ciskravy from CM_Krava))
	group by left(z.KROK,1)
	order by left(z.KROK,1)

/****servis perioda za SR***/
	select sum(PSER) / count(*) as 'Serv_per_SR' from CM_ZSI as z
	left outer join CM_Insvyk as i on i.iplca = z.plca
	where z.KRJA = 1
		and i.IDAIN >= @datumOd and i.IDAIN <= @datumDo
		and i.IVYSE > 6
		and i.IPOIN <> 99
		and z.PSER > 0 
		and z.plca in (select ciskravy from CM_Krava where priznakKU = 1
					union 
						select cistelata from CM_Telata where priznakKu = 1 and cistelata not in (select ciskravy from CM_Krava))

end
go











----------------------------------------------------------------


CREATE procedure  [dbo].[Roc_MLHD_11]
	@datumOd date,
	@datumDo date

	as
	begin
		
	delete from Roc_MLHD_Tab_11 where rok = datepart(YEAR, @datumOd);


	insert Roc_MLHD_Tab_11 (
				Expr1,
				Por,
				rozmedzie_od,
				rozmedzie_do,
				pocet,
				pocet100,
				mlieko100,
				pBielko100,
				pTuk100,
				pocet200,
				mlieko200,
				pBielk200,
				pTuk200,
				pocet305,
				mlieko305,
				pTuk305,
				pBielk305,
				rok
		)
	SELECT 'do 24' AS Expr1,
			1 as por,
			'0' as rozmedzie_od,
			'24' as rozmedzie_do,
			COUNT(*) AS pocet_vsetkych_pvostok,
			COUNT(l.mlieko100) as pocet_pvostok_100,
			AVG(l.MLIEKO100) AS mlieko1000,
			AVG(l.BIELK100) * 100 / AVG(nullif(l.MLIEKO100,0)) AS pBielko100,
			AVG(l.TUK100) * 100 / AVG(nullif(l.MLIEKO100,0)) AS pTuk100,
			COUNT(l.mlieko200) as pocet_pvostok_200,
			AVG(l.MLIEKO200) AS mlieko200,
			AVG(l.BIELK200) * 100 / AVG(nullif(l.MLIEKO200,0)) AS pBielk200,
			AVG(l.TUK200) * 100 / AVG(nullif(l.MLIEKO200,0)) AS pTuk200,
			COUNT(u.MLIEKNOR) as pocet_pvostok_305,
			AVG(u.MLIEKNOR) AS mlieko305,
			AVG(u.TUKNOR) * 100 / AVG(nullif(u.MLIEKNOR,0)) AS pTuk305,
			AVG(u.BIELKNOR) * 100 / AVG(nullif(u.MLIEKNOR,0)) AS pBielk305,
			datepart(YEAR, @datumOd) as rok
		FROM CM_Krava AS k
			INNER JOIN CM_Naplak AS l ON k.CISKRAVY = l.CISKRAVY
			LEFT OUTER JOIN cp_kravy_305Udaje AS u ON k.CISKRAVY = u.CISKRAVY
		WHERE (k.DOVVYR IS NULL) AND (k.PORPREBLAK = 1) AND (k.POCVSETLAK <= 1) AND (k.PRIZNAKKU = '1')
			AND (k.PRIZNAKKU = '1')
			and k.DATNAR<@datumDo and l.DATOTEL<=@datumDo
			AND (DATEDIFF(day, k.DATNAR, l.DATOTEL) / 30.42 <= 24) AND (k.DATNAR IS NOT NULL)

 UNION

	 SELECT 'do 25' AS Expr1,
		  2 as por,
		 '24.0000000000000001' as rozmedzie_od,
		 '25' as rozmedzie_do,
		 COUNT(*) AS pocet,
		 COUNT(l.mlieko100) as pocet_pvostok_100,
		 AVG(l.MLIEKO100) AS mlieko1000,
		 AVG(l.BIELK100) * 100 / AVG(l.MLIEKO100) AS pBielko100,
		 AVG(l.TUK100) * 100 / AVG(l.MLIEKO100) AS pTuk100,
		 COUNT(l.mlieko200) as pocet_pvostok_200, AVG(l.MLIEKO200) AS mlieko200,
		 AVG(l.BIELK200) * 100 / AVG(l.MLIEKO200) AS pBielk200,
		 AVG(l.TUK200) * 100 / AVG(l.MLIEKO200) AS pTuk200,
		 COUNT(u.MLIEKNOR) as pocet_pvostok_305,
		 AVG(u.MLIEKNOR) AS mlieko305,
		 AVG(u.TUKNOR) * 100 / AVG(u.MLIEKNOR) AS pTuk305,
		 AVG(u.BIELKNOR) * 100 / AVG(u.MLIEKNOR) AS pBielk305,
		datepart(YEAR, @datumOd) as rok
	  FROM CM_Krava AS k
		  INNER JOIN CM_Naplak AS l ON k.CISKRAVY = l.CISKRAVY
		  LEFT OUTER JOIN cp_kravy_305Udaje AS u ON k.CISKRAVY = u.CISKRAVY
	  WHERE (k.DOVVYR IS NULL) AND (k.PORPREBLAK = 1) AND (k.POCVSETLAK <= 1) AND (k.PRIZNAKKU = '1')
			AND (k.PRIZNAKKU = '1')
			and k.DATNAR<@datumDo and l.DATOTEL<=@datumDo and
			(DATEDIFF(day, k.DATNAR, l.DATOTEL) / 30.42 BETWEEN 24.0000000000000001 AND 25) AND (k.DATNAR IS NOT NULL)

  UNION

	SELECT 'do 26' AS Expr1,
		3 as por,
		'25.0000000000000001' as rozmedzie_od,
		'26' as rozmedzie_do,
		COUNT(*) AS pocet, COUNT(l.mlieko100) as pocet_pvostok_100,
		AVG(l.MLIEKO100) AS mlieko1000,
		AVG(l.BIELK100) * 100 / AVG(l.MLIEKO100) AS pBielko100,
		AVG(l.TUK100) * 100 / AVG(l.MLIEKO100) AS pTuk100,
		COUNT(l.mlieko200) as pocet_pvostok_200,
		AVG(l.MLIEKO200) AS mlieko200,
		AVG(l.BIELK200) * 100 / AVG(l.MLIEKO200) AS pBielk200,
		AVG(l.TUK200) * 100 / AVG(l.MLIEKO200) AS pTuk200,
		COUNT(u.MLIEKNOR) as pocet_pvostok_305,
		AVG(u.MLIEKNOR) AS mlieko305,
		AVG(u.TUKNOR) * 100 / AVG(u.MLIEKNOR) AS pTuk305,
		AVG(u.BIELKNOR) * 100 / AVG(u.MLIEKNOR) AS pBielk305,
		datepart(YEAR, @datumOd) as rok
	 FROM CM_Krava AS k
	   INNER JOIN CM_Naplak AS l ON k.CISKRAVY = l.CISKRAVY
	   LEFT OUTER JOIN cp_kravy_305Udaje AS u ON k.CISKRAVY = u.CISKRAVY
	 WHERE (k.DOVVYR IS NULL) AND (k.PORPREBLAK = 1) AND (k.POCVSETLAK <= 1) AND (k.PRIZNAKKU = '1')
			AND (k.PRIZNAKKU = '1')
			and k.DATNAR<@datumDo and l.DATOTEL<=@datumDo and
			(DATEDIFF(day, k.DATNAR, l.DATOTEL) / 30.42 BETWEEN 25.0000000000000001 AND 26) AND (k.DATNAR IS NOT NULL)

UNION

   SELECT 'do 27' AS Expr1,
		 4 as por,
		'26.0000000000000001' as rozmedzie_od,
		'27' as rozmedzie_do,
		COUNT(*) AS pocet, COUNT(l.mlieko100) as pocet_pvostok_100,
		AVG(l.MLIEKO100) AS mlieko1000,
		AVG(l.BIELK100) * 100 / AVG(l.MLIEKO100) AS pBielko100,
		AVG(l.TUK100) * 100 / AVG(l.MLIEKO100) AS pTuk100,
		COUNT(l.mlieko200) as pocet_pvostok_200,
		AVG(l.MLIEKO200) AS mlieko200,
		AVG(l.BIELK200) * 100 / AVG(l.MLIEKO200) AS pBielk200,
		AVG(l.TUK200) * 100 / AVG(l.MLIEKO200) AS pTuk200,
		COUNT(u.MLIEKNOR) as pocet_pvostok_305,
		AVG(u.MLIEKNOR) AS mlieko305,
		AVG(u.TUKNOR) * 100 / AVG(u.MLIEKNOR) AS pTuk305,
		AVG(u.BIELKNOR) * 100 / AVG(u.MLIEKNOR) AS pBielk305,
		datepart(YEAR, @datumOd) as rok
	FROM CM_Krava AS k
	   INNER JOIN CM_Naplak AS l ON k.CISKRAVY = l.CISKRAVY
	   LEFT OUTER JOIN cp_kravy_305Udaje AS u ON k.CISKRAVY = u.CISKRAVY
   WHERE (k.DOVVYR IS NULL) AND (k.PORPREBLAK = 1) AND (k.POCVSETLAK <= 1) AND (k.PRIZNAKKU = '1')
			AND (k.PRIZNAKKU = '1')
			and k.DATNAR<@datumDo and l.DATOTEL<=@datumDo and
		(DATEDIFF(day, k.DATNAR, l.DATOTEL) / 30.42 BETWEEN 26.0000000000000001 AND 27) AND (k.DATNAR IS NOT NULL)

UNION

   SELECT 'do 28' AS Expr1,
		 5 as por,
		'27.0000000000000001' as rozmedzie_od,
		'28' as rozmedzie_do,
		COUNT(*) AS pocet,
		COUNT(l.mlieko100) as pocet_pvostok_100,
		AVG(l.MLIEKO100) AS mlieko1000,
		AVG(l.BIELK100) * 100 / AVG(l.MLIEKO100) AS pBielko100,
		AVG(l.TUK100) * 100 / AVG(l.MLIEKO100) AS pTuk100,
		COUNT(l.mlieko200) as pocet_pvostok_200,
		AVG(l.MLIEKO200) AS mlieko200,
		AVG(l.BIELK200) * 100 / AVG(l.MLIEKO200) AS pBielk200,
		AVG(l.TUK200) * 100 / AVG(l.MLIEKO200) AS pTuk200,
		COUNT(u.MLIEKNOR) as pocet_pvostok_305,
		AVG(u.MLIEKNOR) AS mlieko305,
		AVG(u.TUKNOR) * 100 / AVG(u.MLIEKNOR) AS pTuk305,
		AVG(u.BIELKNOR) * 100 / AVG(u.MLIEKNOR) AS pBielk305,
		datepart(YEAR, @datumOd) as rok
		FROM CM_Krava AS k
		INNER JOIN CM_Naplak AS l ON k.CISKRAVY = l.CISKRAVY
		LEFT OUTER JOIN cp_kravy_305Udaje AS u ON k.CISKRAVY = u.CISKRAVY
   WHERE (k.DOVVYR IS NULL) AND (k.PORPREBLAK = 1) AND (k.POCVSETLAK <= 1) AND (k.PRIZNAKKU = '1')
			AND (k.PRIZNAKKU = '1')
			and k.DATNAR<@datumDo and l.DATOTEL<=@datumDo and
		(DATEDIFF(day, k.DATNAR, l.DATOTEL) / 30.42 BETWEEN 27.0000000000000001 AND 28) AND (k.DATNAR IS NOT NULL)

UNION

   SELECT 'do 29' AS Expr1,
		 6 as por,
		'28.0000000000000001' as rozmedzie_od,
		'29' as rozmedzie_do,
		COUNT(*) AS pocet,
		COUNT(l.mlieko100) as pocet_pvostok_100,
		AVG(l.MLIEKO100) AS mlieko1000,
		AVG(l.BIELK100) * 100 / AVG(l.MLIEKO100) AS pBielko100,
		AVG(l.TUK100) * 100 / AVG(l.MLIEKO100) AS pTuk100,
		COUNT(l.mlieko200) as pocet_pvostok_200,
		AVG(l.MLIEKO200) AS mlieko200,
		AVG(l.BIELK200) * 100 / AVG(l.MLIEKO200) AS pBielk200,
		AVG(l.TUK200) * 100 / AVG(l.MLIEKO200) AS pTuk200,
		COUNT(u.MLIEKNOR) as pocet_pvostok_305,
		AVG(u.MLIEKNOR) AS mlieko305,
		AVG(u.TUKNOR) * 100 / AVG(u.MLIEKNOR) AS pTuk305,
		AVG(u.BIELKNOR) * 100 / AVG(u.MLIEKNOR) AS pBielk305,
		datepart(YEAR, @datumOd) as rok
	FROM CM_Krava AS k
	   INNER JOIN CM_Naplak AS l ON k.CISKRAVY = l.CISKRAVY
	   LEFT OUTER JOIN cp_kravy_305Udaje AS u ON k.CISKRAVY = u.CISKRAVY
   WHERE (k.DOVVYR IS NULL) AND (k.PORPREBLAK = 1) AND (k.POCVSETLAK <= 1) AND (k.PRIZNAKKU = '1')
			AND (k.PRIZNAKKU = '1')
			and k.DATNAR<@datumDo and l.DATOTEL<=@datumDo
		AND (DATEDIFF(day, k.DATNAR, l.DATOTEL) / 30.42 BETWEEN 28.0000000000000001 AND 29) AND (k.DATNAR IS NOT NULL)

UNION

   SELECT 'do 30' AS Expr1,
		7 as por,
		'29.0000000000000001' as rozmedzie_od,
		'30' as rozmedzie_do, COUNT(*) AS pocet,
		COUNT(l.mlieko100) as pocet_pvostok_100,
		AVG(l.MLIEKO100) AS mlieko1000,
		AVG(l.BIELK100) * 100 / AVG(l.MLIEKO100) AS pBielko100,
		AVG(l.TUK100) * 100 / AVG(l.MLIEKO100) AS pTuk100,
		COUNT(l.mlieko200) as pocet_pvostok_200,
		AVG(l.MLIEKO200) AS mlieko200,
		AVG(l.BIELK200) * 100 / AVG(l.MLIEKO200) AS pBielk200,
		AVG(l.TUK200) * 100 / AVG(l.MLIEKO200) AS pTuk200,
		COUNT(u.MLIEKNOR) as pocet_pvostok_305,
		AVG(u.MLIEKNOR) AS mlieko305,
		AVG(u.TUKNOR) * 100 / AVG(u.MLIEKNOR) AS pTuk305,
		AVG(u.BIELKNOR) * 100 / AVG(u.MLIEKNOR) AS pBielk305,
		datepart(YEAR, @datumOd) as rok
	FROM CM_Krava AS k
		INNER JOIN CM_Naplak AS l ON k.CISKRAVY = l.CISKRAVY
	   LEFT OUTER JOIN cp_kravy_305Udaje AS u ON k.CISKRAVY = u.CISKRAVY
	WHERE (k.DOVVYR IS NULL) AND (k.PORPREBLAK = 1) AND (k.POCVSETLAK <= 1) AND (k.PRIZNAKKU = '1')
			AND (k.PRIZNAKKU = '1')
			and k.DATNAR<@datumDo and l.DATOTEL<=@datumDo and
		 (DATEDIFF(day, k.DATNAR, l.DATOTEL) / 30.42 BETWEEN 29.0000000000000001 AND 30) AND (k.DATNAR IS NOT NULL)

UNION

   SELECT 'nad 30' AS Expr1,
		 8 as por,
		'30.0000000000000001' as rozmedzie_od,
		'1000' as rozmedzie_do,
		COUNT(*) AS pocet,
		COUNT(l.mlieko100) as pocet_pvostok_100,
		AVG(l.MLIEKO100) AS mlieko1000,
		AVG(l.BIELK100) * 100 / AVG(l.MLIEKO100) AS pBielko100,
		AVG(l.TUK100) * 100 / AVG(l.MLIEKO100) AS pTuk100,
		COUNT(l.mlieko200) as pocet_pvostok_200,
		AVG(l.MLIEKO200) AS mlieko200,
		AVG(l.BIELK200) * 100 / AVG(l.MLIEKO200) AS pBielk200,
		AVG(l.TUK200) * 100 / AVG(l.MLIEKO200) AS pTuk200,
		COUNT(u.MLIEKNOR) as pocet_pvostok_305,
		AVG(u.MLIEKNOR) AS mlieko305,
		AVG(u.TUKNOR) * 100 / AVG(u.MLIEKNOR) AS pTuk305,
		AVG(u.BIELKNOR) * 100 / AVG(u.MLIEKNOR) AS pBielk305,
		datepart(YEAR, @datumOd) as rok
	FROM CM_Krava AS k
		INNER JOIN CM_Naplak AS l ON k.CISKRAVY = l.CISKRAVY
		LEFT OUTER JOIN cp_kravy_305Udaje AS u ON k.CISKRAVY = u.CISKRAVY
   WHERE (k.DOVVYR IS NULL) AND (k.PORPREBLAK = 1) AND (k.POCVSETLAK <= 1) AND (k.PRIZNAKKU = '1')
			AND (k.PRIZNAKKU = '1')
			and k.DATNAR<@datumDo and l.DATOTEL<=@datumDo and
		(DATEDIFF(day, k.DATNAR, l.DATOTEL) / 30.42 > 30.0000000000000001) AND (k.DATNAR IS NOT NULL)

UNION

	SELECT 'SPOLU/PRIEMER' AS Expr1,
		 9 as por,
		'0' as rozmedzie_od,
		'1000' as rozmedzie_do,
		COUNT(*) AS pocet,
		COUNT(l.mlieko100) as pocet_pvostok_100,
		AVG(l.MLIEKO100) AS mlieko1000,
		AVG(l.BIELK100) * 100 / AVG(l.MLIEKO100) AS pBielko100,
		AVG(l.TUK100) * 100 / AVG(l.MLIEKO100) AS pTuk100,
		COUNT(l.mlieko200) as pocet_pvostok_200,
		AVG(l.MLIEKO200) AS mlieko200,
		AVG(l.BIELK200) * 100 / AVG(l.MLIEKO200) AS pBielk200,
		AVG(l.TUK200) * 100 / AVG(l.MLIEKO200) AS pTuk200,
		COUNT(u.MLIEKNOR) as pocet_pvostok_305,
		AVG(u.MLIEKNOR) AS mlieko305,
		AVG(u.TUKNOR) * 100 / AVG(u.MLIEKNOR) AS pTuk305,
		AVG(u.BIELKNOR) * 100 / AVG(u.MLIEKNOR) AS pBielk305,
		datepart(YEAR, @datumOd) as rok
	FROM CM_Krava AS k
		INNER JOIN CM_Naplak AS l ON k.CISKRAVY = l.CISKRAVY LEFT OUTER JOIN cp_kravy_305Udaje AS u ON k.CISKRAVY = u.CISKRAVY
   WHERE (k.DOVVYR IS NULL) AND (k.PORPREBLAK = 1) AND (k.POCVSETLAK <= 1) AND (k.PRIZNAKKU = '1')
			AND (k.PRIZNAKKU = '1')
			and k.DATNAR<@datumDo and l.DATOTEL<=@datumDo

End
go


-------------------------------------------------------------------------------------------------------------

/***masova rocenka - reprodukcne ukazovatele - podla plemennych typov
Masova rocenka 2017 - od str.6 ....vypocitane na zaklade tab Roc_MPHD_6 zo str.33 **/
 CREATE procedure [dbo].[Roc_MPHD_6_plemTYP]
	@datumOd date ,
	@datumDo date 

as 
begin
--declare @datumOd date = '2018-01-01', @datumDo date = '2018-09-30'

delete from Roc_MPHD_Tab_6_plemTYP where rok = DATEPART (year,@datumOd)

declare @zaklad table
	(
	ciskravy varchar(14),
	porpreblak varchar(2),
	datnar date, 
	datvyr date, 
	medziobd int, 
	cistelata varchar(14),
	porlak_tela varchar(2),
	datnar_tela date,
	--medz int, 
	vek1OT int,
	vek1OTzTel int,
	plemtyp int
	)

	insert into @zaklad
		(ciskravy, porpreblak, datnar, datvyr, medziobd, cistelata, porlak_tela, datnar_tela, /*medz,*/ vek1OT, vek1OTzTel, plemtyp  )
	SELECT k.CISKRAVY, k.PORPREBLAK, k.DATNAR,k.datvyr,
			case when k.PORPREBLAK = 1 then null else  m.medziobd end as medziobd,/* m.porpreblak,*/t.CISTELATA, t.PORLAK, t.DATNAR, 
			--case when k.PORPREBLAK = 1 then (select DATEDIFF(DAY,k.DATNAR,t.DATNAR))
			--		else null end as medz,
			DATEDIFF(day, k.DATNAR, tp.Datotel) AS vek1OT,
			case when t.PORLAK = '1' then (DATEDIFF(day, k.DATNAR, t.DATNAR)) else null end AS vek1OTzTel,
			k.TYPPLEM as plemtyp
		FROM CM_Krava AS k 
		LEFT OUTER JOIN Cp_Meso_TelataPoLaktacii AS tp ON k.CISKRAVY = tp.Ciskrava AND tp.PorLakt = '01' and tp.Medziobd is null
		LEFT OUTER JOIN CP_MedziObdMesove AS m ON k.CISKRAVY = m.kravcislo and m.PORPREBLAK = k.porpreblak 
		left outer join CM_Telata as t on t.MATKA = k.CISKRAVY and t.PORLAK = m.porpreblak and t.PORLAK = k.PORPREBLAK
		WHERE (k.DOVVYR IS NULL or (k.DATVYR>= @datumOd and k.DATVYR <= @datumDo)) 
			and (k.PRIZNAKKU = '2')
			and k.TYPPLEM in (--'101','102','103','104','105',	---- BBM
						'111','112','113','114','115',		---- AA
						'121','122','123','124','125',		---- BdA
						'131',								---- Gal
						'141','142','143','144','145',		---- Hem
						'151',								---- High
						'161','162','163','164','165',		---- Char
						'171','172','173','174','175',		---- Lim
						--'181',							---- SDM
						'201','202','203','204','205',		---- Sim_maso
						--'191','192','193','194','195',	---- Piem
						'51','53','54',						---- Pin
						'11','13','14')						---- Slst
			and m.medziobd > 100 and m.medziobd <= 1200
		  ORDER BY m.porpreblak

--select * from @zaklad order by plemtyp--porlak_tela, /*vek1OT desc,*/ plemeno


declare @otel_1 table
(
plemeno varchar(10),
dni_1otel int
)

declare @otel_1_tel table
(
plemeno varchar(10),
dni_1otel_tel int
)

declare @otel_2 table
(
plemeno varchar(10),
medz_2otel int
)

declare @otel_3 table
(
plemeno varchar(10),
medz_3otel int
)

declare @otel_4 table
(
plemeno varchar(10),
medz_4otel int
)

declare @otel_5 table
(
plemeno varchar(10),
medz_5otel int
)

declare @otel_celkom table
(
plemeno varchar(10),
medz_celk_otel int
)

insert into @otel_1(plemeno, dni_1otel)
	select plemtyp, avg(vek1OT) as dni_1otel
			from @zaklad
			where  vek1OT < 2200
			group by plemtyp

insert into @otel_1_tel  (plemeno, dni_1otel_tel)
	select plemtyp, avg(vek1OTzTel) as dni_1otel_tel
			from @zaklad
			where  vek1OTzTel < 2200
			group by plemtyp

	insert into @otel_2 (plemeno, medz_2otel)
		select plemtyp, avg(medziobd) as medz_2otel
			from @zaklad
			where porpreblak = '2'
			group by plemtyp

	insert into @otel_3 (plemeno, medz_3otel)
		select plemtyp, avg(medziobd) as medz_3otel
			from @zaklad
			where porpreblak = '3'
			group by plemtyp

	insert into @otel_4 (plemeno, medz_4otel)
		select plemtyp, avg(medziobd) as medz_4otel
			from @zaklad
			where porpreblak = '4'
			group by plemtyp

	insert into @otel_5 
	(plemeno, medz_5otel)
		select plemtyp, avg(medziobd) as medz_5otel
			from @zaklad
			where porpreblak = '5'
			group by plemtyp

	insert into @otel_celkom 
	(plemeno, medz_celk_otel)
		select  plemtyp, avg(medziobd) as medz_celk_otel
			from @zaklad
			where porpreblak in ('2','3','4','5')
			group by plemtyp

declare @vek_1_otel table
	(
	plemeno varchar(10),
	vek_1OT varchar(8)
	)
	insert into @vek_1_otel
		(plemeno, vek_1OT)
		select plemeno, dbo.toMesiacDen(AVG(dni_1otel)) AS vek_1OT
		 from @otel_1
		 group by plemeno
		 
 --create table Roc_MPHD_Tab_6_plemTYP
	--(
	--plemtyp int,
	--plemeno varchar(10),
	--vek_1OT varchar(8),
	--medz_2otel int,
	--medz_3otel int,
	--medz_4otel int,
	--medz_5otel int,
	--medz_celk_otel int,
	--rok int
	--)

	insert into Roc_MPHD_Tab_6_plemTYP
		(plemtyp,plemeno, vek_1OT, medz_2otel, medz_3otel, medz_4otel, medz_5otel, medz_celk_otel, rok)
	select distinct z.plemtyp,
		case --when z.plemtyp in ('101','102','103','104','105') then 'BBM' 
			when z.plemtyp in ('111','112','113','114','115') then 'AA'
			when z.plemtyp in ('121','122','123','124','125') then 'BdA'
			when z.plemtyp = '131' then 'Gal'
			when z.plemtyp in ('141','142','143','144','145') then 'HEM'
			when z.plemtyp = '151' then 'High'
			when z.plemtyp in ('161','162','163','164','165') then 'Char'
			when z.plemtyp in ('171','172','173','174','175') then 'Lim'
			--when z.plemtyp = '181' then 'SDM'
			when z.plemtyp in ('201','202','203','204','205') then 'Sim_maso'
			--when z.plemtyp in ('191','192','193','194','195') then 'Piem'
			when z.plemtyp in ('51','53','54') then 'Pin'
			when z.plemtyp in ('11','13','14') then 'Slst'
		end as plemeno,
		vek_1OT,	medz_2otel, medz_3otel, medz_4otel, medz_5otel, 
		--(case when medz_2otel is null and medz_3otel is null and medz_4otel is null and medz_5otel is null then null else  medz_celk_otel end) as 
		medz_celk_otel, DATEPART(YEAR, @datumOd) as rok
	from  @zaklad as z
	left outer join @otel_2 as o2 on o2.plemeno = z.plemtyp
	left outer join @vek_1_otel as o1 on o1.plemeno = z.plemtyp
	left outer join @otel_3 as o3 on o3.plemeno = z.plemtyp
	left outer join @otel_4 as o4 on o4.plemeno = z.plemtyp
	left outer join @otel_5 as o5 on o5.plemeno = z.plemtyp
	left outer join @otel_celkom as oc on oc.plemeno = z.plemtyp
			
End
go

CREATE procedure [dbo].[Rocenka_OV_Tab_Prir]
    @Zameranie varchar(2),
	@TypChovu varchar(2),
	@Plem_typ varchar(6), 
	@rok varchar(4)
	
	
as
begin

	
	--select z.* ,p.NAZOVD
	--from plis.dbo.SP_Rocenka_PrirStr as z
	--left outer join plis.dbo.SC_Plemena as p on p.KODPL2 = z.Plemeno
	--	where   z.rok = @rok and 
	--z. TypPlem = @Plem_typ and z.Zameranie = @Zameranie and z.TypChovu= @TypChovu 

	-- 19.01.2018 oprava, zmena tabulky plemena
	select z.* ,p.Nazov as NAZOVD
	from dbo.SP_Rocenka_PrirStr as z
	left outer join plis.dbo.SC_Plemena_N as p on p.KodPl = z.Plemeno
		where   z.rok = @rok and 
	z.TypPlem = @Plem_typ and z.Zameranie = @Zameranie and z.TypChovu= @TypChovu 
end

--	  exec [Rocenka_OV_Tab_Prir] 'ML', '2', 'C', 2017

--	  exec [Rocenka_OV_Tab_Prir] 'MP', '1', 'C', 2017
go


-------------------------------------------------------------------------------------------------------------

/***masova rocenka - reprodukcne ukazovatele - podla plemien
Masova rocenka 2017 - str.33 **/
 CREATE procedure [dbo].[Roc_MPHD_6]
	@datumOd date ,
	@datumDo date 

as 
begin
--declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31'
delete from Roc_MPHD_Tab_6 where rok = DATEPART (year,@datumOd)

declare @zaklad table
	(
	ciskravy varchar(14),
	porpreblak varchar(2),
	datnar date, 
	datvyr date, 
	medziobd int, 
	cistelata varchar(14),
	porlak_tela varchar(2),
	datnar_tela date,
	--medz int, 
	vek1OT int,
	vek1OTzTel int,
	plemeno varchar(10)
	)

	insert into @zaklad
		(ciskravy, porpreblak, datnar, datvyr, medziobd, cistelata, porlak_tela, datnar_tela, /*medz,*/ vek1OT, vek1OTzTel, plemeno  )
	SELECT k.CISKRAVY, k.PORPREBLAK, k.DATNAR,k.datvyr,
			case when k.PORPREBLAK = 1 then null else  m.medziobd end as medziobd,/* m.porpreblak,*/t.CISTELATA, t.PORLAK, t.DATNAR, 
			--case when k.PORPREBLAK = 1 then (select DATEDIFF(DAY,k.DATNAR,t.DATNAR))
			--		else null end as medz,
			DATEDIFF(day, k.DATNAR, tp.Datotel) AS vek1OT,
			case when t.PORLAK = '1' then (DATEDIFF(day, k.DATNAR, t.DATNAR)) else null end AS vek1OTzTel,
			case --when t.TYPPLEM in ('101','102','103','104','105') then 'BBM' 
				when k.TYPPLEM in ('111','112','113','114','115') then 'AA'
				when k.TYPPLEM in ('121','122','123','124','125') then 'BdA'
				when k.TYPPLEM = '131' then 'Gal'
				when k.TYPPLEM in ('141','142','143','144','145') then 'HEM'
				when k.TYPPLEM = '151' then 'High'
				when k.TYPPLEM in ('161','162','163','164','165') then 'Char'
				when k.TYPPLEM in ('171','172','173','174','175') then 'Lim'
				--when k.TYPPLEM = '181' then 'SDM'
				when k.TYPPLEM in ('201','202','203','204','205') then 'Sim_maso'
				--when k.TYPPLEM in ('191','192','193','194','195') then 'Piem'
				when k.TYPPLEM in ('51','53','54') then 'Pin'
				when k.TYPPLEM in ('11','13','14') then 'Slst'
				when ((k.TYPPLEM is null and k.PL1 is null) 
						or (k.TYPPLEM is null and k.PL1<>'X') 
						or (k.TYPPLEM not in (--'101','102','103','104','105'
											'111','112','113','114','115',
											'121','122','123','124','125', 
											'131', 
											'151', 
											'161','162','163','164','165', 
											'171','172','173','174','175', 
											--'181',
											'201','202','203','204','205',
											--'191','192','193','194','195', 
											'51','53','54', 
											'11','13','14' ) and k.PL1<>'X')) then 'Osta'
				when k.PL1 = 'X' then 'Nez'
			end as plemeno
			
	FROM CM_Krava AS k 
		LEFT OUTER JOIN Cp_Meso_TelataPoLaktacii AS tp ON k.CISKRAVY = tp.Ciskrava AND tp.PorLakt = '01' and tp.Medziobd is null
		LEFT OUTER JOIN CP_MedziObdMesove AS m ON k.CISKRAVY = m.kravcislo and m.PORPREBLAK = k.porpreblak 
		left outer join CM_Telata as t on t.MATKA = k.CISKRAVY and t.PORLAK = m.porpreblak and t.PORLAK = k.PORPREBLAK
		WHERE (k.DOVVYR IS NULL or (k.DATVYR>= @datumOd and k.DATVYR <= @datumDo)) 
			and (k.PRIZNAKKU = '2')
			--and k.PORPREBLAK is not null 
			--and (k.typplem is null or k.TYPPLEM in (--'101','102','103','104','105',	---- BBM
			--										'111','112','113','114','115',		---- AA
			--										'121','122','123','124','125',		---- BdA
			--										'131',								---- Gal
			--										'141','142','143','144','145',		---- Hem
			--										'151',								---- High
			--										'161','162','163','164','165',		---- Char
			--										'171','172','173','174','175',		---- Lim
			--										--'181',							---- SDM
			--										'201','202','203','204','205',		---- Sim_maso
			--										--'191','192','193','194','195',	---- Piem
			--										'51','53','54',						---- Pin
			--										'11','13','14'))					---- Slst'
			--										--'999'))
			and m.medziobd > 100 and m.medziobd <= 1200
		  --ORDER BY m.porpreblak
union 
	SELECT k.CISKRAVY, k.PORPREBLAK, k.DATNAR,k.datvyr,
			case when k.PORPREBLAK = 1 then null else  m.medziobd end as medziobd,/* m.porpreblak,*/t.CISTELATA, t.PORLAK, t.DATNAR, 
			DATEDIFF(day, k.DATNAR, tp.Datotel) AS vek1OT,
			case when t.PORLAK = '1' then (DATEDIFF(day, k.DATNAR, t.DATNAR)) else null end AS vek1OTzTel,
			'SR' as plemeno
	FROM CM_Krava AS k 
		LEFT OUTER JOIN Cp_Meso_TelataPoLaktacii AS tp ON k.CISKRAVY = tp.Ciskrava AND tp.PorLakt = '01' and tp.Medziobd is null
		LEFT OUTER JOIN CP_MedziObdMesove AS m ON k.CISKRAVY = m.kravcislo and m.PORPREBLAK = k.porpreblak 
		left outer join CM_Telata as t on t.MATKA = k.CISKRAVY and t.PORLAK = m.porpreblak and t.PORLAK = k.PORPREBLAK
		WHERE (k.DOVVYR IS NULL or (k.DATVYR>= @datumOd and k.DATVYR <= @datumDo)) 
			and (k.PRIZNAKKU = '2')
			--and (k.typplem is null or k.TYPPLEM in (--'101','102','103','104','105',	---- BBM
			--										'111','112','113','114','115',		---- AA
			--										'121','122','123','124','125',		---- BdA
			--										'131',								---- Gal
			--										'141','142','143','144','145',		---- Hem
			--										'151',								---- High
			--										'161','162','163','164','165',		---- Char
			--										'171','172','173','174','175',		---- Lim
			--										--'181',							---- SDM
			--										'201','202','203','204','205',		---- Sim_maso
			--										--'191','192','193','194','195',	---- Piem
			--										'51','53','54',						---- Pin
			--										'11','13','14'))					---- Slst'
			--										--'999'))
			and m.medziobd > 100 and m.medziobd <= 1200
		  --ORDER BY m.porpreblak
--select * from @zaklad order by porlak_tela, /*vek1OT desc,*/ plemeno


declare @otel_1 table
(
plemeno varchar(10),
dni_1otel int
)

declare @otel_1_tel table
(
plemeno varchar(10),
dni_1otel_tel int
)

declare @otel_2 table
(
plemeno varchar(10),
medz_2otel int
)

declare @otel_3 table
(
plemeno varchar(10),
medz_3otel int
)

declare @otel_4 table
(
plemeno varchar(10),
medz_4otel int
)

declare @otel_5 table
(
plemeno varchar(10),
medz_5otel int
)

declare @otel_celkom table
(
plemeno varchar(10),
medz_celk_otel int
)

insert into @otel_1(plemeno, dni_1otel)
	select plemeno, avg(vek1OT) as dni_1otel
			from @zaklad
			where  vek1OT < 2200
			group by plemeno

insert into @otel_1_tel  (plemeno, dni_1otel_tel)
	select plemeno, avg(vek1OTzTel) as dni_1otel_tel
			from @zaklad
			where  vek1OTzTel < 2200
			group by plemeno

	insert into @otel_2 (plemeno, medz_2otel)
		select plemeno, avg(medziobd) as medz_2otel
			from @zaklad
			where porpreblak = '2'
			group by plemeno
	--union 
	--	select 'SR' as plemeno, avg(medziobd) as medz_2otel
	--		from @zaklad
	--		where porpreblak = '2'

	insert into @otel_3 (plemeno, medz_3otel)
		select plemeno, avg(medziobd) as medz_3otel
			from @zaklad
			where porpreblak = '3'
			group by plemeno
	--union 
	--	select 'SR' as plemeno, avg(medziobd) as medz_3otel
	--		from @zaklad
	--		where porpreblak = '3'

	insert into @otel_4 (plemeno, medz_4otel)
		select plemeno, avg(medziobd) as medz_4otel
			from @zaklad
			where porpreblak = '4'
			group by plemeno
	--union 
	--	select 'SR' as plemeno, avg(medziobd) as medz_4otel
	--		from @zaklad
	--		where porpreblak = '4' 

	insert into @otel_5 
	(plemeno, medz_5otel)
		select plemeno, avg(medziobd) as medz_5otel
			from @zaklad
			where porpreblak = '5'
			group by plemeno
	--union 
	--	select 'SR' as plemeno, avg(medziobd) as medz_5otel
	--		from @zaklad
	--		where porpreblak = '5'

	insert into @otel_celkom 
	(plemeno, medz_celk_otel)
		select  plemeno, avg(medziobd) as medz_celk_otel
			from @zaklad
			where porpreblak in ( '2','3','4','5')
			group by plemeno
	--union 
	--	select 'SR' as plemeno, avg(medziobd) as medz_celk_otel
	--		from @zaklad

declare @vek_1_otel table
	(
	plemeno varchar(10),
	vek_1OT varchar(8)
	)
	insert into @vek_1_otel
		(plemeno, vek_1OT)
		select plemeno, dbo.toMesiacDen(AVG(dni_1otel)) AS vek_1OT
		 from @otel_1
		 group by plemeno
	--union 
	--	select 'SR' as plemeno, 
	--		convert(varchar(3),convert(int,AVG(dni_1otel) / 30.42)) +' / '+ convert(varchar(3),convert(int,AVG(dni_1otel) % 30.42)) AS vek_1OT
	--	 from @otel_1

		 
 --create table Roc_MPHD_Tab_6
	--(
	--plemeno varchar(10),
	--vek_1OT varchar(8),
	--medz_2otel int,
	--medz_3otel int,
	--medz_4otel int,
	--medz_5otel int,
	--medz_celk_otel int,
	--rok int
	--)

	insert into Roc_MPHD_Tab_6
		(plemeno, vek_1OT, medz_2otel, medz_3otel, medz_4otel, medz_5otel, medz_celk_otel, rok)
	select distinct z.plemeno, vek_1OT,	medz_2otel, medz_3otel, medz_4otel, medz_5otel, oc.medz_celk_otel, DATEPART(YEAR, @datumOd) as rok
	from @zaklad as z
	left outer join @otel_2 as o2 on o2.plemeno = z.plemeno
	left outer join @vek_1_otel as o1 on o1.plemeno = z.plemeno
	left outer join @otel_3 as o3 on o3.plemeno = z.plemeno
	left outer join @otel_4 as o4 on o4.plemeno = z.plemeno
	left outer join @otel_5 as o5 on o5.plemeno = z.plemeno
	left outer join @otel_celkom as oc on oc.plemeno = z.plemeno
			
End
go


-----------------------------------------------------------------------------------

CREATE procedure [dbo].[Roc_MLHD_23]
	@chov varchar(9),
	@datumOd date,
	@datumDo date

  --use plis

 --Declare @datumOd date, @datumDo date, @chov varchar(9), 
 --  set @datumOd ='2017-01-01'
 -- set @datumDo ='2017-10-15'
 -- set @chov = '301701031'

as 
begin
delete from Roc_MLHD_Tab_23A where rok = DATEPART(year,@datumOd) and KRAJ + OKRES + PODNIK = substring(@chov,1,6)

declare @porlak float
 Declare @tab23 TABLE
	  (
	  KRAJ VARCHAR(1)NULL,
	  OKRES VARCHAR(2)NULL,
	  PODNIK VARCHAR(3)NULL,
	  OKRES_NAZOV VARCHAR(30)NULL,
	  SIDLO VARCHAR(30)NULL,
	  PREDSTAVITEL_1 VARCHAR(100)NULL,
	  FUNKCIA_1 VARCHAR(50)NULL,
	  PREDSTAVITEL_2 VARCHAR(100)NULL,
	  FUNKCIA_2 VARCHAR(50)NULL,
	  STAV_KRAV_AKT INT,
	  STAV_KRAV_MIN INT,
	  VYR_KRAV INT,
	  ZAR_PRVOSTOK INT,
	  NAR_TELIAT INT,
	  PR_VEKvROKOCH VARCHAR(8)NULL,
	  PR_VEKvMES VARCHAR(8)NULL,
	  PR_LAKT FLOAT,
	  ROK VARCHAR(4)
	   )

   INSERT INTO @tab23
   (kraj, okres, podnik,OKRES_NAZOV, sidlo, PREDSTAVITEL_1, FUNKCIA_1, PREDSTAVITEL_2, FUNKCIA_2,ROK)


  select n.kraj, n.okres, n.podnik, o.NAZOV, n.OBEC,
	isnull(k.TITUL_PRED,'') + isnull(k.MENO,'')  +' '+  isnull(k.PRIEZVISKO,'') +' '+ isnull(k.TITUL_ZA,'') as predstavitel_1, isnull(k.FUNKCIA,'') as funkcia_1,
	isnull(z.TITUL_PRED,'') + isnull(z.MENO,'')  +' '+  isnull(z.PRIEZVISKO,'') +' '+ isnull(z.TITUL_ZA,'') as predstavitel_2, isnull(z.FUNKCIA,'') as funkcia_2,
	datepart (year, @datumOd) as rok
  from NM_PODNIK as n
	  left outer join NM_Konatel as k on k.ID = n.ID_KONATEL
	  left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK = n.KRAJ + n.OKRES + n.PODNIK
	  left outer join NM_Zootechnik as z on z.ID = ch.ID_ZOOTECHNIK
	  left outer join NC_OKRES as o on o.KRAJ + o.OKRES = n.KRAJ + n.OKRES
	where n.kraj + n.okres + n.PODNIK =  substring(@chov,1,6)
		and ch.KRAJ + ch.OKRES + ch.PODNIK + CHOV=@chov
		and ch.TYPZV=1
		and (ch.ZRUS is null or(ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
  
declare @kravyNAchove int, @vyradeneKravy int, @narodeneTelata int, @prvostky int, @stavKravMinRok int 
set @kravyNAchove = (select count(*) from CM_Krava 
										where substring(CHOVATEL,1,6) = substring(@chov,1,6) and dovvyr is null and PRIZNAKKU = '1')--(dovvyr is null or (dovvyr is not null and DATVYR>=@datumOd)))  -- stav krav na chove
set @vyradeneKravy = (select count(*) from CM_Krava 
										where substring(CHOVATEL,1,6) = substring(@chov,1,6) and dovvyr is not null and DATVYR>=@datumOd and PRIZNAKKU = '1') --vyradene kravy   
set @narodeneTelata = (select count(*) from CM_Telata
										where substring(CHOVATEL,1,6) = substring(@chov,1,6) and DATNAR>= @datumOd and DATNAR <= @datumDo and PRIZNAKKU = '1' and len(CISTELATA) > 0) --narodenych teliat
set @prvostky = (select count(*) from CM_Krava where substring(CHOVATEL,1,6) = substring(@chov,1,6) and DATZAR > @datumOd and DOVVYR is null and PRIZNAKKU = '1' and PORPREBLAK > 0)
			
set @porlak = (select convert(decimal(5,2),AVG(PORLAK *1.0)) from CM_Laktacie				--priem poradie laktacie
				 where ZMENA in ('30','40') 
					and ((DATUKONL >= @datumOd and DATUKONL <= @datumDo) and (DATUKNORL is null or DATUKNORL >= @datumOd) 
								or (DATUKNORL >= @datumOd and DATUKNORL <= @datumDo))
					and substring(CHOVATEL,1,6) = substring(@chov,1,6))

set @stavKravMinRok = (select stav_krav_1 from Roc_MLHD_Tab_23A where KRAJ + OKRES + PODNIK = substring(@chov,1,6) and rok= datepart(year,(dateadd(year,-1, @datumOd))))


update @tab23 set
STAV_KRAV_AKT = @kravyNAchove, NAR_TELIAT=@narodeneTelata, VYR_KRAV=@vyradeneKravy, PR_LAKT = @porlak, ZAR_PRVOSTOK = @prvostky, STAV_KRAV_MIN = @stavKravMinRok

	--	--vek krav v rokoch

	declare @vek_v_rokoch int, @vek_v_mesiacoch int
	 
	SELECT 
		@vek_v_rokoch = avg(krav_vek_dni) /365 ,
		@vek_v_mesiacoch = (avg(krav_vek_dni) %365)/30.42 
	  	from (
			select 
				l.ciskravy, k.DATNAR, k. DATVYR,  
				(DATEDIFF(day,k.DATNAR,(select (case when  k.datvyr is  null  then @datumDo 
													else k.datvyr end )
													from CM_Krava as k where k.ciskravy = l.ciskravy))) AS krav_vek_dni,
				(DATEDIFF(month,k.DATNAR,(select (case when  k.datvyr is  null  then @datumDo 
													else k.datvyr end )
													from CM_Krava as k where k.ciskravy = l.ciskravy))) AS krav_vek_mesiac
				from CM_Laktacie as l
					left outer join CM_Krava as k on k.CISKRAVY = l.ciskravy
					 where ZMENA in ('30','40') 
						and ((DATUKONL >= @datumOd and DATUKONL <= @datumDo) and (DATUKNORL is null or DATUKNORL >= @datumOd) 
									or (DATUKNORL >= @datumOd and DATUKNORL <= @datumDo))
						and substring(l.CHOVATEL,1,6) = substring(@chov,1,6)
						and (k.DATVYR is null or k.DATVYR > @datumOd)
						group by l.CISKRAVY, DATNAR, DATVYR
					) as v

	update @tab23 set
	PR_VEKvROKOCH = @vek_v_rokoch, PR_VEKvMES = @vek_v_mesiacoch

insert into Roc_MLHD_Tab_23A
		(KRAJ,OKRES,PODNIK,Okres_nazov,Sidlo,predstavitel_1,funkcia_1,predstavitel_2,funkcia_2,stav_krav_1,stav_krav_2,vyr_kravy
		  ,zar_prvostok,nar_teliat,pr_vek_rok,pr_vek_mesiac,priem_lakt,rok)
   select distinct
		KRAJ,
		OKRES,
		PODNIK,
		OKRES_NAZOV, SIDLO,
		PREDSTAVITEL_1,
		FUNKCIA_1,
		PREDSTAVITEL_2,
		FUNKCIA_2,
		STAV_KRAV_AKT,
		STAV_KRAV_MIN,
		VYR_KRAV,
		ZAR_PRVOSTOK,
		NAR_TELIAT,
		PR_VEKvROKOCH,
		PR_VEKvMES,
		PR_LAKT,
		ROK
   from @tab23

	end
go



------------------------------------------------------------------------------------------------------------



/***masova rocenka - priebeh porodov v roku - podla plemien
Masova rocenka 2017 - str.32 **/
 CREATE procedure [dbo].[Roc_MPHD_5]
	
	@datumOd date ,
	@datumDo date 

as 
begin

delete from Roc_MPHD_Tab_5 where rok = DATEPART(YEAR, @datumOd)

--declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31'

declare @telata table
	(
	cistelata varchar(14),
	datnar date, 
	typplem varchar(3),
	plemeno varchar(10),
	priebpor varchar(1)
	)

	insert into @telata
	(cistelata , datnar, typplem, plemeno, priebpor)
	select CISTELATA,DATNAR,TYPPLEM,
			case--when t.TYPPLEM in ('101','102','103','104','105') then 'BBM' 
				when TYPPLEM in ('111','112','113','114','115') then 'AA'
				when TYPPLEM in ('121','122','123','124','125') then 'BdA'
				when TYPPLEM = '131' then 'Gal'
				when TYPPLEM in ('141','142','143','144','145') then 'HEM'
				when TYPPLEM = '151' then 'High'
				when TYPPLEM in ('161','162','163','164','165') then 'Char'
				when TYPPLEM in ('171','172','173','174','175') then 'Lim'
				--when t.TYPPLEM = '181' then 'SDM'
				when TYPPLEM in ('201','202','203','204','205') then 'Sim_maso'
				--when t.TYPPLEM in ('191','192','193','194','195') then 'Piem'
				when TYPPLEM in ('51','53','54') then 'Pin'
				when TYPPLEM in ('11','13','14') then 'Slst'
				when ((TYPPLEM is null and PL1 is null) 
								or (TYPPLEM is null and PL1<>'X') 
								or (TYPPLEM not in (--'101','102','103','104','105',
														'111','112','113','114','115',
														'121','122','123','124','125', 
														'131',
														'141','142','143','144','145', 
														'151', 
														'161','162','163','164','165', 
														'171','172','173','174','175', 
														--'181',
														'201','202','203','204','205',
														--'191','192','193','194','195', 
														'51','53','54', 
														'11','13','14') and PL1<>'X')) then 'Osta'
				when PL1 = 'X' then 'Nez'
			end as plemeno,
			-------------------povodny vzorec
			----case when TYPPLEM in ('111','112','113','114','115') then 'AA'
			----		when TYPPLEM in ('121','122','123','124','125') then 'BdA'
			----		when TYPPLEM = '131' then 'Gal'
			----		when TYPPLEM = '151' then 'High'
			----		when TYPPLEM in ('161','162','163','164','165') then 'Char'
			----		when TYPPLEM in ('171','172','173','174','175') then 'Lim'
			----		when TYPPLEM in ('201','202','203','204','205') then 'Sim_maso'
			----		when TYPPLEM in ('191','192','193','194','195') then 'Piem'
			----		when TYPPLEM in ('51','53','54') then 'Pin'
			----		when TYPPLEM in ('11','13','14') then 'Slst'
			----		when TYPPLEM = '999' then 'Osta'
			----		when TYPPLEM is null then 'Nez' end as plemeno,
			PRIEBPOR 
	from CM_Telata 
	where datnar >= @datumOd and DATNAR <= @datumDo 
		and PRIZNAKKU = '2'
--		and (typplem is null or TYPPLEM in (--'101','102','103','104','105',
--											'111','112','113','114','115',
--											'121','122','123','124','125', 
--											'131', 
--											'141','142','143','144','145', 
--											'151', 
--											'161','162','163','164','165', 
--											'171','172','173','174','175', 
--											--'181',
--											'201','202','203','204','205',
--											--'191','192','193','194','195', 
--											'51','53','54', 
--											'11','13','14',
--											'999'))
	--select * from @telata


	declare @prieb_por table
	(
	plemeno varchar(10), 
	nezist int,
	lahky int,
	stred int,
	tazky int, 
	operacia int,
	rok int	
	)


	--create table Roc_MPHD_Tab_5
	--(
	--plemeno varchar(10), 
	--nezist int,
	--nezist_p decimal(5,2),
	--lahky int,
	--lahky_p decimal(5,2),
	--stred int,
	--stred_p decimal(5,2),
	--tazky int, 
	--tazky_p decimal(5,2), 
	--operacia int,
	--operacia_p decimal(5,2),
	--rok int	
	--)

	insert into @prieb_por 
	(plemeno, nezist, lahky, stred, tazky, operacia, rok)
		select 'AA' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'AA' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'AA' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'AA' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'AA' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'AA' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	union 
		select 'BdA' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'BdA' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'BdA' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'BdA' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'BdA' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'BdA' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	/*
	union 
		select 'BBM' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'BBM' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'BBM' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'BBM' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'BBM' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'BBM' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	*/
	union 
		select 'Gal' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'Gal' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'Gal' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'Gal' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'Gal' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'Gal' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	union 
		select 'HEM' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'HEM' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'HEM' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'HEM' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'HEM' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'HEM' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	union 
		select 'High' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'High' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'High' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'High' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'High' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'High' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	union 
		select 'Char' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'Char' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'Char' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'Char' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'Char' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'Char' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	union 
		select 'Lim' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'Lim' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'Lim' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'Lim' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'Lim' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'Lim' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	/*
	union 
		select 'Piem' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'Piem' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'Piem' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'Piem' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'Piem' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'Piem' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	*/
	union 
		select 'Pin' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'Pin' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'Pin' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'Pin' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'Pin' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'Pin' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	/*
	union 
		select 'SDM' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'SDM' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'SDM' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'SDM' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'SDM' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'SDM' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	*/
	union 
		select 'Sim_maso' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'Sim_maso' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'Sim_maso' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'Sim_maso' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'Sim_maso' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'Sim_maso' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	union 
		select 'Slst' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'Slst' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'Slst' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'Slst' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'Slst' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'Slst' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	union 
		select 'Osta' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'Osta' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'Osta' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'Osta' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'Osta' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'Osta' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	union 
		select 'Nez' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) and plemeno = 'Nez' then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' and plemeno = 'Nez' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' and plemeno = 'Nez' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' and plemeno = 'Nez' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' and plemeno = 'Nez' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata
	union 
		select 'SR' as plemeno, 
			sum(case when (priebpor = '0' or priebpor is null) or priebpor is null then 1 else 0 end) as nezist,
			sum(case when priebpor = '1' then 1 else 0 end) as lahky,
			sum(case when priebpor = '2' then 1 else 0 end) as stred,
			sum(case when priebpor = '3' then 1 else 0 end) as tazky,
			sum(case when priebpor = '4' then 1 else 0 end) as operacia,
			datepart(YEAR,@datumOd) as rok
		from @telata

	--select * from @prieb_por

	declare @AA_p int
	set @AA_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'AA')
	--declare @BBM_p int
	--set @BBM_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'BBM')
	declare @BdA_p int
	set @BdA_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'BdA')
	declare @Gal_p int
	set @Gal_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Gal')
	declare @Hem_p int
	set @Hem_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Hem')
	declare @High_p int
	set @High_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'High')
	declare @Char_p int
	set @Char_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Char')
	declare @Lim_p int
	set @Lim_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Lim')
	--declare @SDM_p int
	--set @SDM_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'SDM')
	declare @Sim_maso_p int
	set @Sim_maso_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Sim_maso')
	--declare @Piem_p int
	--set @Piem_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Piem')
	declare @Pin_p int
	set @Pin_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Pin')
	declare @Slst_p int
	set @Slst_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Slst')
	declare @Osta_p int
	set @Osta_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Osta')
	declare @Nez_p int
	set @Nez_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'Nez')
	declare @SR_p int
	set @SR_p = (select (nezist+lahky+stred+tazky+operacia) from @prieb_por where plemeno = 'SR')


	

	--declare @prieb_por_fin table
	--(
	--plemeno varchar(10), 
	--nezist int,
	--nezist_p decimal(5,2),
	--lahky int,
	--lahky_p decimal(5,2),
	--stred int,
	--stred_p decimal(5,2),
	--tazky int, 
	--tazky_p decimal(5,2), 
	--operacia int,
	--operacia_p decimal(5,2),
	--rok int	
	--)

	
	insert into Roc_MPHD_Tab_5
	(plemeno, nezist, nezist_p, lahky, lahky_p, stred, stred_p, tazky, tazky_p, operacia, operacia_p, rok, spolu)
		select 
			plemeno as plemeno,
			nezist as nezist, 
			nezist * 100.0  / nullif(@AA_p,0) as nezist_p,
			lahky as lahky,
			lahky * 100.0  / nullif(@AA_p,0) as lahky_p,
			stred as stred,
			stred * 100.0  / nullif(@AA_p,0) as stred_p,
			tazky as tazky,
			tazky * 100.0  / nullif(@AA_p,0) as tazky_p,
			operacia as operacia,
			operacia * 100.0  / nullif(@AA_p,0) as operacia_p,
			rok,
			@AA_p as spolu
		 from @prieb_por
			where plemeno = 'AA'
	/*
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@BBM_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@BBM_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@BBM_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@BBM_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@BBM_p,0) as operacia_p,
			rok,
			@BBM_p as spolu
		 from @prieb_por
			where plemeno = 'BBM'
	*/
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@BdA_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@BdA_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@BdA_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@BdA_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@BdA_p,0) as operacia_p,
			rok,
			@BdA_p as spolu
		 from @prieb_por
			where plemeno = 'BdA'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Gal_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Gal_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Gal_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Gal_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Gal_p,0) as operacia_p,
			rok,
			@Gal_p as spolu
		 from @prieb_por
			where plemeno = 'Gal'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Hem_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Hem_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Hem_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Hem_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Hem_p,0) as operacia_p,
			rok,
			@Hem_p as spolu
		 from @prieb_por
			where plemeno = 'Hem'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@High_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@High_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@High_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@High_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@High_p,0) as operacia_p,
			rok,
			@High_p as spolu
		 from @prieb_por
			where plemeno = 'High'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Char_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Char_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Char_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Char_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Char_p,0) as operacia_p,
			rok,
			@Char_p as spolu
		 from @prieb_por
			where plemeno = 'Char'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Lim_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Lim_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Lim_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Lim_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Lim_p,0) as operacia_p,
			rok,
			@Lim_p as spolu
		 from @prieb_por
			where plemeno = 'Lim'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Sim_maso_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Sim_maso_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Sim_maso_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Sim_maso_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Sim_maso_p,0) as operacia_p,
			rok,
			@Sim_maso_p as spolu
		 from @prieb_por
			where plemeno = 'Sim_maso'
	/*
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Piem_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Piem_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Piem_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Piem_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Piem_p,0) as operacia_p,
			rok,
			@Piem_p as spolu
		 from @prieb_por
			where plemeno = 'Piem'
	*/
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Pin_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Pin_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Pin_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Pin_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Pin_p,0) as operacia_p,
			rok,
			@Pin_p as spolu
		 from @prieb_por
			where plemeno = 'Pin'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Slst_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Slst_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Slst_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Slst_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Slst_p,0) as operacia_p,
			rok,
			@Slst_p as spolu
		 from @prieb_por
			where plemeno = 'Slst'
	--union 
	--	select 
	--		plemeno,
	--		nezist, 
	--		nezist * 100.0  / nullif(@SDM_p,0) as nezist_p,
	--		lahky,
	--		lahky * 100.0  / nullif(@SDM_p,0) as lahky_p,
	--		stred,
	--		stred * 100.0  / nullif(@SDM_p,0) as stred_p,
	--		tazky,
	--		tazky * 100.0  / nullif(@SDM_p,0) as tazky_p,
	--		operacia,
	--		operacia * 100.0  / nullif(@SDM_p,0) as operacia_p,
	--		rok,
	--		@SDM_p as spolu
	--	 from @prieb_por
	--		where plemeno = 'SDM'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Osta_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Osta_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Osta_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Osta_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Osta_p,0) as operacia_p,
			rok,
			@Osta_p as spolu
		 from @prieb_por
			where plemeno = 'Osta'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@Nez_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@Nez_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@Nez_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@Nez_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@Nez_p,0) as operacia_p,
			rok,
			@Nez_p as spolu
		 from @prieb_por
			where plemeno = 'Nez'
	union 
		select 
			plemeno,
			nezist, 
			nezist * 100.0  / nullif(@SR_p,0) as nezist_p,
			lahky,
			lahky * 100.0  / nullif(@SR_p,0) as lahky_p,
			stred,
			stred * 100.0  / nullif(@SR_p,0) as stred_p,
			tazky,
			tazky * 100.0  / nullif(@SR_p,0) as tazky_p,
			operacia,
			operacia * 100.0  / nullif(@SR_p,0) as operacia_p,
			rok,
			@SR_p as spolu
		 from @prieb_por
			where plemeno = 'SR'

		--select * from @prieb_por_fin 

	end
go


---------------------------------------------------------------------------------------------------



CREATE PROCEDURE [dbo].[Roc_MPHD_17_prepocet] 
@datumOd date,
@datumDo date=''

AS
BEGIN
delete from Roc_MPHD_Tab_17 where rok = DATEPART(year, @datumOd)


DECLARE @counter INT
DECLARE @chov VARCHAR(9)

SET @counter = 0;

-- prepocet pre chov
DECLARE prepocet_cursor CURSOR
FOR
SELECT DISTINCT kraj + okres + podnik + chov + Mastal from Roc_MPHD_Tab_zaklad

    OPEN prepocet_cursor
   FETCH NEXT FROM prepocet_cursor INTO @chov

   WHILE @@FETCH_STATUS = 0
       BEGIN
           SET @counter = @counter + 1;                    
            
			PRINT 'Prepocitavam chovy: ' + CONVERT (VARCHAR, @counter) + ' '+ @chov
			EXEC Roc_MPHD_17 @chov, @datumOd, @datumDo
			

           FETCH NEXT FROM prepocet_cursor INTO @chov

       END



CLOSE prepocet_cursor
DEALLOCATE prepocet_cursor


--SET @counter = 0;

-- prepocet pre podnik
declare  @podnik table
(
podnik varchar(6),
pocet_ch int
)
insert @podnik
  Select Kraj + okres + Podnik, count(*) as pocet_ch from Roc_MPHD_Tab_17 where chov <> '' and rok = year(@datumOd) group by  Kraj + okres + Podnik having count(*) > 1

DECLARE prepocet_cursor CURSOR
FOR
SELECT podnik from @podnik


   OPEN prepocet_cursor
   FETCH NEXT FROM prepocet_cursor INTO @chov

   WHILE @@FETCH_STATUS = 0
       BEGIN
           SET @counter = @counter + 1;
                    
            
                            PRINT 'Prepocitavam podnik: ' + CONVERT (VARCHAR, @counter) + ' '+ @chov
                             EXEC Roc_MPHD_17 @chov, @datumOd, @datumDo

           FETCH NEXT FROM prepocet_cursor INTO @chov

       END
CLOSE prepocet_cursor
DEALLOCATE prepocet_cursor

	   --SET @counter = 0;
	 
-- prepocet pre okres
DECLARE prepocet_cursor CURSOR
FOR
SELECT DISTINCT kraj + okres from Roc_MPHD_Tab_zaklad

    OPEN prepocet_cursor
   FETCH NEXT FROM prepocet_cursor INTO @chov

   WHILE @@FETCH_STATUS = 0
       BEGIN
           SET @counter = @counter + 1;
                    
            
                            PRINT 'Prepocitavam okres: ' + CONVERT (VARCHAR, @counter) + ' '+ @chov
                            EXEC Roc_MPHD_17 @chov, @datumOd, @datumDo

           FETCH NEXT FROM prepocet_cursor INTO @chov

       END


	   SET @counter = 0;
CLOSE prepocet_cursor
DEALLOCATE prepocet_cursor

-- prepocet pre kraj
DECLARE prepocet_cursor CURSOR
FOR
SELECT DISTINCT kraj from Roc_MPHD_Tab_zaklad



    OPEN prepocet_cursor
   FETCH NEXT FROM prepocet_cursor INTO @chov

   WHILE @@FETCH_STATUS = 0
       BEGIN
           SET @counter = @counter + 1;
                    
            
                            PRINT 'Prepocitavam kraj: ' + CONVERT (VARCHAR, @counter) + ' '+ @chov
                            EXEC Roc_MPHD_17 @chov, @datumOd, @datumDo

           FETCH NEXT FROM prepocet_cursor INTO @chov

       END

CLOSE prepocet_cursor
DEALLOCATE prepocet_cursor

-- prepocet za SR
set @chov=null
	PRINT 'Prepocitavam Slovensko'
	EXEC Roc_MPHD_17 @chov, @datumOd, @datumDo

	
END
go


-----------------------------------------------------------------



/****** Script for SelectTopNRows command from SSMS  ******/
-- rocenka mlieko ---ulozene do Roc_MLHD_Tab_13 - nasledne sa do rocenky vytiahne reportom
----mastale s najlepsou uzitkovostou krav podla kg BIELKOVIN - cistokrvne ---str 28
-- Exec Roc_MLHD_13 '2017-01-01', '2017-12-31'

CREATE procedure  [dbo].[Roc_MLHD_13]
	@datumOd date,
	@datumDo date

	as 
	begin

		SET ANSI_WARNINGS  OFF;
--declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31'

/***mastale s najlepsou uzitkovostou krav podla kg BIELKOVIN - cistokrvne ***/

		delete from Roc_MLHD_Tab_13 where rok = datepart(year,@datumOd);
		
	--holstein
	declare @mastale_H table(
		chov varchar(9),
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float,
		vek_otel varchar(7)
		)
	--slovenske strakate
	declare @mastale_S table( 
		chov varchar(9),
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float,
		vek_otel varchar(7)
		)
	--Pinzgauske
		declare @mastale_P table( 
		chov varchar(9),
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float,
		vek_otel varchar(7)
		)


insert into @mastale_H 
(chov, okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk_P, tuk, bielk_P, bielk, medziobd,vek_otel )
		select top 50 lakt.Oznacenie as chov, 
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				Lakt.PocLakNcelk as pocet_N_lakt,
				Lakt.LakDniNCelk as lakt_dni,
				Lakt.MliekNorCelk  as mlieko,
				round((Lakt.TukNorCelk*100)/Lakt.MliekNorCelk,2) as tuk_P,
				Lakt.TukNorCelk  as tuk,
				round((Lakt.BielkNorCelk*100)/Lakt.MliekNorCelk,2) as bielk_P,
				Lakt.BielkNorCelk as bielk,
				Lakt.MedziobdL2 as medziobd,
				Lakt.MedziobdL1 as vek_otel


		
		FROM CR_LaktacneZostavy_Opr as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= Oznacenie)
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.Oznacenie,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.Oznacenie,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.Oznacenie
							left outer join NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.Oznacenie
						 where  len(Oznacenie)=9 and Oznacenie = Filter
							and Lakt.DatumOd = @datumOd and Lakt.DatumDo = @datumDo
							and r.rok = DATEPART(YEAR,@datumOd)
							and r.stpec_5 in ('H','R')
							and eko.ZRUS is null AND eko.TYPZV='1'
							
					group by lakt.Oznacenie, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV,r.stpec_5,Lakt.PocLakNcelk, 
						Lakt.LakDniNCelk,Lakt.MliekNorCelk,  Lakt.TukNorCelk, Lakt.BielkNorCelk, Lakt.MedziobdL2 , Lakt.MedziobdL1
					order by ROUND(BielkNorCelk,2) desc
	--select * from @prvostky_H

	insert into @mastale_S 
(chov, okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk_P, tuk, bielk_P, bielk, medziobd,vek_otel )
		select top 50 lakt.Oznacenie as chov, 
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				Lakt.PocLakNcelk as pocet_N_lakt,
				Lakt.LakDniNCelk as lakt_dni,
				Lakt.MliekNorCelk  as mlieko,
				round((Lakt.TukNorCelk*100)/Lakt.MliekNorCelk,2) as tuk_P,
				Lakt.TukNorCelk  as tuk,
				round((Lakt.BielkNorCelk*100)/Lakt.MliekNorCelk,2) as bielk_P,
				Lakt.BielkNorCelk as bielk,
				Lakt.MedziobdL2 as medziobd,
				Lakt.MedziobdL1 as vek_otel
		FROM CR_LaktacneZostavy_Opr as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= Oznacenie)
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.Oznacenie,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.Oznacenie,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.Oznacenie
							left outer join NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.Oznacenie
						 where  len(Oznacenie)=9 and Oznacenie = Filter
							and Lakt.DatumOd = @datumOd and Lakt.DatumDo = @datumDo
							and r.rok = DATEPART(YEAR,@datumOd)
							and r.stpec_5  in ('S ','MB')
							and eko.ZRUS is null AND eko.TYPZV='1'
																	
					group by lakt.Oznacenie, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV,r.stpec_5,Lakt.PocLakNcelk, 
						Lakt.LakDniNCelk,Lakt.MliekNorCelk,  Lakt.TukNorCelk, Lakt.BielkNorCelk, Lakt.MedziobdL2 , Lakt.MedziobdL1
					order by ROUND(BielkNorCelk,2) desc
	
	insert into @mastale_P 
	(chov, okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk_P, tuk, bielk_P, bielk, medziobd,vek_otel )
		select top 50 lakt.Oznacenie as chov, 
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
				r.stpec_5 as plem,
				Lakt.PocLakNcelk as pocet_N_lakt,
				Lakt.LakDniNCelk as lakt_dni,
				Lakt.MliekNorCelk  as mlieko,
				round((Lakt.TukNorCelk*100)/Lakt.MliekNorCelk,2) as tuk_P,
				Lakt.TukNorCelk  as tuk,
				round((Lakt.BielkNorCelk*100)/Lakt.MliekNorCelk,2) as bielk_P,
				Lakt.BielkNorCelk as bielk,
				Lakt.MedziobdL2 as medziobd,
				Lakt.MedziobdL1 as vek_otel
		
		FROM CR_LaktacneZostavy_Opr as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= Oznacenie)
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.Oznacenie,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.Oznacenie,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.Oznacenie
							left outer join NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.Oznacenie
						 where  len(Oznacenie)=9 and Oznacenie = Filter
							and Lakt.DatumOd = @datumOd and Lakt.DatumDo = @datumDo
							and r.rok = DATEPART(YEAR,@datumOd)
							and r.stpec_5 ='P'
							and eko.ZRUS is null AND eko.TYPZV='1'
							
					group by lakt.Oznacenie, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV,r.stpec_5,Lakt.PocLakNcelk, 
						Lakt.LakDniNCelk,Lakt.MliekNorCelk,  Lakt.TukNorCelk, Lakt.BielkNorCelk, Lakt.MedziobdL2 , Lakt.MedziobdL1
					order by ROUND(BielkNorCelk,2) desc
	
	----insert into @prvostky_B
	----(chov,pocet_krav_na_chove, /*bielk_max, */okres, podnik, mastal, char_ust, plem,pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
	----	select top 100 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
	----			o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
	----			r.stpec_5 as plem,
	----			ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,	
	----			ROUND(AVG(Lakt.LAKTDNI),2) as lakt_dni,
	----			ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
	----			ROUND(AVG(Lakt.TUKNOR),2) as tuk,
	----			ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
	----			ROUND(AVG(MEDZIOBD),2) as medziobd 
		
	----	FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
	----						left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
	----						left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
	----						--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
	----						left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
	----						left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
	----						left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
	----						left outer join  NC_CharUst as u on u.KOD = h.CHARUS
	----						left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
	----					 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
	----							or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
	----						and r.rok = DATEPART(YEAR,@datumOd)
	----						and r.stpec_5 = 'B'
	----						and eko.ZRUS is null 
	----						AND eko.TYPZV='1'
	----						and Lakt.MLIEKCEL <>''
	----						and Lakt.ZMENA in ('30','40')
							
							
										
	----				group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV, r.stpec_5 --, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'')
	----				having count(lakt.CISKRAVY) >10
	----				order by ROUND(AVG(Lakt.BIELKNOR),2) desc


	insert into Roc_MLHD_Tab_13
			(Por,Okres,Podnik,Mastal,Mastal_cis,CharUst,Prev_plem,Poc_n_lakt,LaktDni,mlieko,tuk_P
		,tuk_KG,bielk_P,bielk_KG,medziobd,vek_otel,rok ,Plem_typ)
			
		select ROW_NUMBER() OVER(ORDER BY bielk desc) AS Por,
			okres as Okres, podnik as Podnik, mastal as Mastal,substring(chov,7,3) as Mastal_cis,
			(case when char_ust = '1' then 'VÄZ-BEZ'
					when char_ust = '2' then 'VÄZ-DOJ'
					else 'VOĽNÁ' end) as CharUst, 
			plem as Prev_plem, pocet_N_lakt as Poc_n_lakt, round(lakt_dni,0) as LaktDni, round(mlieko,0) as mlieko,
			tuk_P as tuk_P, round(tuk,0) as tuk_KG, bielk_P as bielk_P, round(bielk,0) as bielk_KG,round(medziobd,0) as medziobd, vek_otel as  vek_otel ,
			datepart(year,@datumOd) as rok,
			'Hol' as Plem_typ
		from @mastale_H
	
	insert into Roc_MLHD_Tab_13
			(Por,Okres,Podnik,Mastal,Mastal_cis,CharUst,Prev_plem,Poc_n_lakt,LaktDni,mlieko,tuk_P
		,tuk_KG,bielk_P,bielk_KG,medziobd,vek_otel,rok ,Plem_typ)

		select ROW_NUMBER() OVER(ORDER BY bielk desc) AS Por,
			 okres as Okres, podnik as Podnik, mastal as Mastal,substring(chov,7,3) as Mastal_cis,
			(case when char_ust = '1' then 'VÄZ-BEZ'
					when char_ust = '2' then 'VÄZ-DOJ'
					else 'VOĽNÁ' end) as CharUst,
			plem as Prev_plem, pocet_N_lakt as Poc_n_lakt, round(lakt_dni,0) as LaktDni, round(mlieko,0) as mlieko,
			tuk_P as tuk_P, round(tuk,0) as tuk_KG, bielk_P as bielk_P, round(bielk,0) as bielk_KG,round(medziobd,0) as medziobd, vek_otel as  vek_otel ,
			datepart(year,@datumOd) as rok,
			'SLst' as Plem_typ
		from @mastale_S

insert into Roc_MLHD_Tab_13
			(Por,Okres,Podnik,Mastal,Mastal_cis,CharUst,Prev_plem,Poc_n_lakt,LaktDni,mlieko,tuk_P
		,tuk_KG,bielk_P,bielk_KG,medziobd,vek_otel,rok ,Plem_typ)

			select ROW_NUMBER() OVER(ORDER BY bielk desc) AS Por,
			okres as Okres, podnik as Podnik, mastal as Mastal,substring(chov,7,3) as Mastal_cis,
			(case when char_ust = '1' then 'VÄZ-BEZ'
					when char_ust = '2' then 'VÄZ-DOJ'
					else 'VOĽNÁ' end) as CharUst,
				plem as Prev_plem, pocet_N_lakt as Poc_n_lakt, round(lakt_dni,0) as LaktDni, round(mlieko,0) as mlieko,
				tuk_P as tuk_P, round(tuk,0) as tuk_KG, bielk_P as bielk_P, round(bielk,0) as bielk_KG,round(medziobd,0) as medziobd, vek_otel as  vek_otel ,
			datepart(year,@datumOd) as rok,
			'Pin' as Plem_typ
		from @mastale_P

	
/***mastale s najlepsou uzitkovostou krav podla kg BIELKOVIN - krizence ***/

	--holstein
	declare @mastale_Hk table(
		chov varchar(9),
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float,
		vek_otel varchar(7)
		)
	--slovenske strakate
	declare @mastale_Sk table( 
		chov varchar(9),
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float,
		vek_otel varchar(7)
		)
	--Pinzgauske
		declare @mastale_Pk table( 
		chov varchar(9),
		okres varchar(100),
		podnik varchar(100),
		mastal  varchar(100),
		char_ust  varchar(30),
		plem  varchar(10),
		pocet_N_lakt float,
		lakt_dni float,
		mlieko float, 
		tuk_P float,
		tuk float,
		bielk_P float,
		bielk float,
		medziobd float,
		vek_otel varchar(7)
		)


insert into @mastale_Hk 
(chov, okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk_P, tuk, bielk_P, bielk, medziobd,vek_otel )
		select top 50 lakt.Oznacenie as chov, 
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.KOD as char_ust,
				r.stpec_5 as plem,
				Lakt.PocLakNcelk as pocet_N_lakt,
				Lakt.LakDniNCelk as lakt_dni,
				Lakt.MliekNorCelk  as mlieko,
				round((Lakt.TukNorCelk*100)/Lakt.MliekNorCelk,2) as tuk_P,
				Lakt.TukNorCelk  as tuk,
				round((Lakt.BielkNorCelk*100)/Lakt.MliekNorCelk,2) as bielk_P,
				Lakt.BielkNorCelk as bielk,
				Lakt.MedziobdL2 as medziobd,
				Lakt.MedziobdL1 as vek_otel


		
		FROM CR_LaktacneZostavy_Opr as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= Oznacenie)
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.Oznacenie,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.Oznacenie,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.Oznacenie
							left outer join NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.Oznacenie
						 where  len(Oznacenie)=9 and Oznacenie = Filter
							and Lakt.DatumOd = @datumOd and Lakt.DatumDo = @datumDo
							and r.rok = DATEPART(YEAR,@datumOd)
							and r.stpec_5 not in ('H','R')
							and SUBSTRING(r.stpec_5,1,1) in ('H','R')
							and eko.ZRUS is null AND eko.TYPZV='1'
							
					group by lakt.Oznacenie, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.KOD,r.stpec_5,Lakt.PocLakNcelk, 
						Lakt.LakDniNCelk,Lakt.MliekNorCelk,  Lakt.TukNorCelk, Lakt.BielkNorCelk, Lakt.MedziobdL2 , Lakt.MedziobdL1
					order by ROUND(BielkNorCelk,2) desc
	--select * from @prvostky_H

	insert into @mastale_Sk 
(chov, okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk_P, tuk, bielk_P, bielk, medziobd,vek_otel )
		select top 50 lakt.Oznacenie as chov, 
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.KOD as char_ust,
				r.stpec_5 as plem,
				Lakt.PocLakNcelk as pocet_N_lakt,
				Lakt.LakDniNCelk as lakt_dni,
				Lakt.MliekNorCelk  as mlieko,
				round((Lakt.TukNorCelk*100)/Lakt.MliekNorCelk,2) as tuk_P,
				Lakt.TukNorCelk  as tuk,
				round((Lakt.BielkNorCelk*100)/Lakt.MliekNorCelk,2) as bielk_P,
				Lakt.BielkNorCelk as bielk,
				Lakt.MedziobdL2 as medziobd,
				Lakt.MedziobdL1 as vek_otel
		FROM CR_LaktacneZostavy_Opr as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= Oznacenie)
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.Oznacenie,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.Oznacenie,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.Oznacenie
							left outer join NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.Oznacenie
						 where  len(Oznacenie)=9 and Oznacenie = Filter
							and Lakt.DatumOd = @datumOd and Lakt.DatumDo = @datumDo
							and r.rok = DATEPART(YEAR,@datumOd)
							and r.stpec_5 not in ('S','MB')
							and SUBSTRING(r.stpec_5,1,2) in ('S ','MB')
							and eko.ZRUS is null AND eko.TYPZV='1'
																	
					group by lakt.Oznacenie, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.KOD,r.stpec_5,Lakt.PocLakNcelk, 
						Lakt.LakDniNCelk,Lakt.MliekNorCelk,  Lakt.TukNorCelk, Lakt.BielkNorCelk, Lakt.MedziobdL2 , Lakt.MedziobdL1
					order by ROUND(BielkNorCelk,2) desc
	
	insert into @mastale_Pk 
	(chov, okres, podnik, mastal, char_ust, plem, pocet_N_lakt, lakt_dni, mlieko, tuk_P, tuk, bielk_P, bielk, medziobd,vek_otel )
		select top 50 lakt.Oznacenie as chov, 
				o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.KOD as char_ust,
				r.stpec_5 as plem,
				Lakt.PocLakNcelk as pocet_N_lakt,
				Lakt.LakDniNCelk as lakt_dni,
				Lakt.MliekNorCelk  as mlieko,
				round((Lakt.TukNorCelk*100)/Lakt.MliekNorCelk,2) as tuk_P,
				Lakt.TukNorCelk  as tuk,
				round((Lakt.BielkNorCelk*100)/Lakt.MliekNorCelk,2) as bielk_P,
				Lakt.BielkNorCelk as bielk,
				Lakt.MedziobdL2 as medziobd,
				Lakt.MedziobdL1 as vek_otel
		
		FROM CR_LaktacneZostavy_Opr as Lakt	 
							left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= Oznacenie)
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.Oznacenie,1,6)
							left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.Oznacenie,1,3)
							left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.Oznacenie
							left outer join NC_CharUst as u on u.KOD = h.CHARUS
							left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.Oznacenie
						 where  len(Oznacenie)=9 and Oznacenie = Filter
 							and Lakt.DatumOd = @datumOd and Lakt.DatumDo = @datumDo
							and r.rok = DATEPART(YEAR,@datumOd)
							and r.stpec_5 <>'P'
							and SUBSTRING(r.stpec_5,1,1) ='P'
							and eko.ZRUS is null AND eko.TYPZV='1'
							
					group by lakt.Oznacenie, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.KOD,r.stpec_5,Lakt.PocLakNcelk, 
						Lakt.LakDniNCelk,Lakt.MliekNorCelk,  Lakt.TukNorCelk, Lakt.BielkNorCelk, Lakt.MedziobdL2 , Lakt.MedziobdL1
					order by ROUND(BielkNorCelk,2) desc
	
	----insert into @prvostky_Bk
	----(chov,pocet_krav_na_chove, /*bielk_max, */okres, podnik, mastal, char_ust, plem,pocet_N_lakt, lakt_dni, mlieko, tuk, bielk, medziobd )
	----	select top 100 lakt.CHOVATEL as chov, count(lakt.CISKRAVY) as pocet_prvostok_na_chove, /*max(lakt.BIELKNOR) as bielk_max,*/
	----			o.NAZOV as okres, p.NAZOVSKR as podnik, eko.NAZOV as mastal, u.NAZOV as char_ust,
	----			r.stpec_5 as plem,
	----			ROUND(AVG(Lakt.LAKDNIN),2)as pocet_N_lakt,	
	----			ROUND(AVG(Lakt.LAKTDNI),2) as lakt_dni,
	----			ROUND(AVG(Lakt.MLIEKNOR),2) as mlieko,
	----			ROUND(AVG(Lakt.TUKNOR),2) as tuk,
	----			ROUND(AVG(Lakt.BIELKNOR),2) as bielk,
	----			ROUND(AVG(MEDZIOBD),2) as medziobd 
		
	----	FROM dbo.View_CP_LaktaciePreZostavy as Lakt	 
	----						left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
	----						left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
	----						--left outer join CR_LaktacneZostavy_Opr as lo on lo.Filter = k.CHOVATEL
	----						left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
	----						left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
	----						left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.CHOVATEL
	----						left outer join  NC_CharUst as u on u.KOD = h.CHARUS
	----						left outer join Roc_MLHD_Tab_22A as r on r.KRAJ + r.OKRES + r.PODNIK + r.stlpec_6c = Lakt.CHOVATEL
	----					 where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
	----							or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
	----						and r.rok = DATEPART(YEAR,@datumOd)
	----						and r.stpec_5 = 'B'
	----						and eko.ZRUS is null 
	----						AND eko.TYPZV='1'
	----						and Lakt.MLIEKCEL <>''
	----						and Lakt.ZMENA in ('30','40')
							
							
										
	----				group by lakt.CHOVATEL, o.NAZOV, p.NAZOVSKR, eko.NAZOV, u.NAZOV, r.stpec_5 --, k.PL1 + ' '+ isnull(k.PL2,'') + ' '+ isnull(k.PL3,'')
	----				having count(lakt.CISKRAVY) >10
	----				order by ROUND(AVG(Lakt.BIELKNOR),2) desc

	--declare @kravy_fin table(
	--	Por bigint,
	--	--chov varchar(9),
	--	Okres varchar(100),
	--	Podnik varchar(100),
	--	Mastal  varchar(100),
	--	Mastal_cis varchar(5),
	--	CharUst  varchar(30),
	--	Prev_plem  varchar(10),
	--	Poc_n_lakt float,
	--	LaktDni float,
	--	mlieko float, 
	--	tuk_P float,
	--	tuk_KG int,
	--	bielk_P float,
	--	bielk_KG int,
	--	medziobd int,
	--	vek_otel varchar(8),
	--	rok varchar(4),
	--	Plem_typ varchar(6)
	--	)
	insert into Roc_MLHD_Tab_13
			(Por,Okres,Podnik,Mastal,Mastal_cis,CharUst,Prev_plem,Poc_n_lakt,LaktDni,mlieko,tuk_P
		,tuk_KG,bielk_P,bielk_KG,medziobd,vek_otel,rok ,Plem_typ)
			
		select ROW_NUMBER() OVER(ORDER BY bielk desc) AS Por,
			okres as Okres, podnik as Podnik, mastal as Mastal,substring(chov,7,3) as Mastal_cis,
			(case when char_ust = '1' then 'VÄZ-BEZ'
					when char_ust = '2' then 'VÄZ-DOJ'
					else 'VOĽNÁ' end) as CharUst,
			plem as Prev_plem, pocet_N_lakt as Poc_n_lakt, round(lakt_dni,0) as LaktDni, round(mlieko,0) as mlieko,
			tuk_P as tuk_P, round(tuk,0) as tuk_KG, bielk_P as bielk_P, round(bielk,0) as bielk_KG,round(medziobd,0) as medziobd, vek_otel as  vek_otel ,
			datepart(year,@datumOd) as rok,
			'Hol+K' as Plem_typ
		from @mastale_Hk
		--order by bielk desc
	
	insert into Roc_MLHD_Tab_13
			(Por,Okres,Podnik,Mastal,Mastal_cis,CharUst,Prev_plem,Poc_n_lakt,LaktDni,mlieko,tuk_P
		,tuk_KG,bielk_P,bielk_KG,medziobd,vek_otel,rok ,Plem_typ)

		select ROW_NUMBER() OVER(ORDER BY bielk desc) AS Por,
			 okres as Okres, podnik as Podnik, mastal as Mastal,substring(chov,7,3) as Mastal_cis,
			(case when char_ust = '1' then 'VÄZ-BEZ'
					when char_ust = '2' then 'VÄZ-DOJ'
					else 'VOĽNÁ' end) as CharUst,
			plem as Prev_plem, pocet_N_lakt as Poc_n_lakt, round(lakt_dni,0) as LaktDni, round(mlieko,0) as mlieko,
			tuk_P as tuk_P, round(tuk,0) as tuk_KG, bielk_P as bielk_P, round(bielk,0) as bielk_KG,round(medziobd,0) as medziobd, vek_otel as  vek_otel ,
			datepart(year,@datumOd) as rok,
			'SLst+K' as Plem_typ
		from @mastale_Sk
		

	insert into Roc_MLHD_Tab_13
			(Por,Okres,Podnik,Mastal,Mastal_cis,CharUst,Prev_plem,Poc_n_lakt,LaktDni,mlieko,tuk_P
		,tuk_KG,bielk_P,bielk_KG,medziobd,vek_otel,rok ,Plem_typ)

		select ROW_NUMBER() OVER(ORDER BY bielk desc) AS Por,
			okres as Okres, podnik as Podnik, mastal as Mastal,substring(chov,7,3) as Mastal_cis,
			(case when char_ust = '1' then 'VÄZ-BEZ'
					when char_ust = '2' then 'VÄZ-DOJ'
					else 'VOĽNÁ' end) as CharUst,
			plem as Prev_plem, pocet_N_lakt as Poc_n_lakt, round(lakt_dni,0) as LaktDni, round(mlieko,0) as mlieko,
			tuk_P as tuk_P, round(tuk,0) as tuk_KG, bielk_P as bielk_P, round(bielk,0) as bielk_KG,round(medziobd,0) as medziobd, vek_otel as  vek_otel ,
			datepart(year,@datumOd) as rok,
			'Pin+K' as Plem_typ
		from @mastale_Pk

		SET ANSI_WARNINGS ON;
End
go

----------------------------------------------------------------------------------------------


CREATE procedure [dbo].[Roc_MPHD_Najchov]
		@podnik varchar(6),
		@datumOd date,
		@datumDo date

as
	begin
		--declare @datumOd date = '2018-01-01', @datumDo date = '2018-09-30', @podnik varchar(6) = '106704'

		if @podnik is null
			begin  /****za SR***/
				/**priem_stav_krav**/
				declare @pocetKrav_SR int
				set @pocetKrav_SR = (select count(*) as priem_stav_krav from Roc_MPHD_Tab_zaklad
														 where KrJal='K'
															 and rok = DATEPART(YEAR, @datumOd)
															 and (Datvyr is null or Datvyr >= @datumOd))


				/**priem_stav_MD**/
				declare @pocetMD_SR int
				set @pocetMD_SR = (select count(*) as priem_stav_MD from Roc_MPHD_Tab_zaklad
													 where KrJal <>'K'
														 and rok = DATEPART(YEAR, @datumOd)
														 and (Datvyr is null or Datvyr >= @datumOd))


				/****pocet_vaz_v_210_dnoch**/
				declare @pocetVazenych210_SR int
				set @pocetVazenych210_SR = (select count(*) as pocet_vaz_v_210_dnoch from Roc_MPHD_Tab_zaklad ----pocet vazenych v
																		where KrJal <> 'K'
																			and rok = DATEPART(YEAR, @datumOd)
																			and Hm210 is not null
																			and CisloZv not in (select ciskravy from CM_Krava))

				/***priem_hmot_v_210_dnoch***/
				declare @HM_210_SR int
				set @HM_210_SR = (select AVG(Hm210) as priem_hmot_v_210_dnoch from Roc_MPHD_Tab_zaklad ----pocet vazenych v
													where KrJal <> 'K'
														and rok = DATEPART(YEAR, @datumOd)
														and Hm210 is not null
														and CisloZv not in (select ciskravy from CM_Krava))


				/***Medziobdobie****/
				declare @medziobd_SR float
				set @medziobd_SR = (select avg(medziobd) as Medziobdobie	from Roc_MPHD_Tab_zaklad
														where Porlak > '1' and KrJal='K'
															and Medziobd > 100 and  Medziobd <= 1200
															and rok = DATEPART(YEAR, @datumOd))

				/***index***/
				declare @index_SR float
				set @index_SR = @HM_210_SR*(365/ @medziobd_SR)

				insert Roc_MPHD_Tab_Najchov
				select 'SR' as KrajOkr,
							 null as Podnik,
							 null as Podnik_nazov,
							 null as Prev_plem,
							 @pocetKrav_SR,
							 @pocetMD_SR,
							 @pocetVazenych210_SR,
							 @HM_210_SR,
							 @medziobd_SR,
							 @index_SR,
							 DATEPART(year,@datumOd)

			end
		else
			begin
				/******za chovy****/
				/**priem_stav_krav**/
				declare @pocetKrav int
				set @pocetKrav = (select count(*) as priem_stav_krav from Roc_MPHD_Tab_zaklad
													where kraj + okres + podnik  = @podnik
														and KrJal='K'
														and rok = DATEPART(YEAR, @datumOd)
														and (Datvyr is null or Datvyr >= @datumOd))


				/**priem_stav_MD**/
				declare @pocetMD int
				set @pocetMD = (select count(*) as priem_stav_MD from Roc_MPHD_Tab_zaklad
												where kraj + okres + podnik  = @podnik
													and KrJal <>'K'
													and rok = DATEPART(YEAR, @datumOd)
													and (Datvyr is null or Datvyr >= @datumOd))


				/****pocet_vaz_v_210_dnoch**/
				declare @pocetVazenych210 int
				set @pocetVazenych210 = (select count(*) as pocet_vaz_v_210_dnoch from Roc_MPHD_Tab_zaklad ----pocet vazenych v
																 where kraj + okres + podnik  = @podnik
																	 and KrJal <> 'K'
																	 and rok = DATEPART(YEAR, @datumOd)
																	 and Hm210 is not null
																	 and CisloZv not in (select ciskravy from CM_Krava))

				/***priem_hmot_v_210_dnoch***/
				declare @HM_210 int
				set @HM_210 = (select AVG(Hm210) as priem_hmot_v_210_dnoch from Roc_MPHD_Tab_zaklad ----pocet vazenych v
											 where kraj + okres + podnik  = @podnik
												 and KrJal <> 'K'
												 and rok = DATEPART(YEAR, @datumOd)
												 and Hm210 is not null
												 and CisloZv not in (select ciskravy from CM_Krava))


				/***Medziobdobie****/
				declare @medziobd float
				set @medziobd = (select avg(medziobd) as Medziobdobie	from Roc_MPHD_Tab_zaklad
												 where kraj + okres + Podnik  = @podnik
													 and Porlak > '1' and KrJal='K'
													 and Medziobd > 100 and  Medziobd <= 1200
													 and rok = DATEPART(YEAR, @datumOd))

				/***index***/
				declare @index float
				set @index = @HM_210*(365/ @medziobd)

				/******podiel plemena na chove******/ ---tu sa do podielu rataju aj kravy aj mlady dobytok
				declare @KR1 int
				set @kr1 = (select sum(kr1) from Roc_MPHD_Tab_zaklad where rok = datepart(year, @datumOd) and Kraj+Okres+Podnik =  @podnik)

				declare @podiely table				-----PL1 a ich podiel v chove
				(
					Podnik varchar (6),
					PL1 varchar(3),
					KR1 float,
					PodielPerc float
				)

				Insert into @podiely
						(PL1, Podnik,  KR1, PodielPerc)

				select distinct	 z.pl1 as PL1,
													z.kraj + z.okres + z.podnik  as podnik,
													sum(z.KR1)as KR1,
													(sum(z.KR1)*100.0 / @KR1) as PodielPerc
				from Roc_MPHD_Tab_zaklad as z
				where z.kraj + z.okres + z.podnik = @podnik
					and rok = DATEPART(YEAR, @datumOd)
				group by z.PL1, z.kraj + z.okres + z.podnik


				declare @counter int,  @podniky varchar(6)
				declare @plemena table
				(
					PL1 varchar(3),
					KR1 float,
					PodielPerc float,
					Podnik varchar (9),
					por int
				)

				declare @ZoznamPL1 table
				(
					Podnik VARCHAR(9),
					plem varchar(10)
				--cisteplem varchar(1)
				)

				DECLARE poradie_cursor CURSOR LOCAL
				FOR
					SELECT Podnik FROM @podiely group by Podnik

				OPEN poradie_cursor
				FETCH NEXT FROM poradie_cursor INTO @Podniky
				WHILE @@FETCH_STATUS = 0
					BEGIN
						--print @chovatelia
						delete from @plemena
						insert into @plemena
								(PL1, KR1, PodielPerc, Podnik, por)
						select PL1,KR1, PodielPerc, Podnik,ROW_NUMBER() OVER (ORDER BY PodielPerc desc) as por from @podiely as p where p.PodielPerc >12.5 and Podnik = @podniky

						declare @PL1 varchar(10) = ISNULL((select pl1 from @plemena where por=1),'') +' '+ isnull((select PL1 from @plemena where por=2),'') +' '+ isnull((select PL1  from @plemena where por=3),'')
						--declare @cistPlem varchar(1) = (select case when PodielPerc = 100 then '*' else '' end from @plemena)

						insert into @ZoznamPL1
						select @podniky,@PL1--, @cistPlem

						FETCH NEXT FROM poradie_cursor INTO @podniky
					END

				CLOSE poradie_cursor
				DEALLOCATE poradie_cursor

				declare @plemeno varchar(10)
				set @plemeno = (select plem  from @ZoznamPL1  where Podnik = @podnik)


				--declare @najchov_KUMP table
				--create table Roc_MPHD_Tab_Najchov
				--(
				--KrajOkr varchar(3),
				--Podnik varchar(3),
				--Podnik_nazov varchar(35),
				--Prev_plem varchar(10),
				--Priem_stav_krav int,
				--Priem_stav_MD int,
				--poc_vaz_210 int,
				--Hm210 int,
				--Medziobd float,
				--Inde_x float,
				--rok int
				--)

				insert Roc_MPHD_Tab_Najchov
				select SUBSTRING(@podnik,1,3),
							 SUBSTRING(@podnik,4,3),
							 (select NAZOVSKR from NM_PODNIK where KRAJ + OKRES + PODNIK = @podnik),
							 @plemeno,
							 @pocetKrav,
							 @pocetMD,
							 @pocetVazenych210,
							 @HM_210,
							 @medziobd,
							 @index,
							 DATEPART(year,@datumOd)

			end
	end
go



---------------------------------------------------------------------------------------------------------------------



-- =============================================
-- Author:		PSSR, š.p.
-- Create date: 25.9.2017
-- Description:	Vyber udajov do reportu Rocenka MLHD tabulka 1 (Vysledky kontroly mliekovej uzitkovosti za Slovensko)
-- za rok 2017 - bol datumOd = '2017-01-01' a datumDo = '2018-02-05'
-- =============================================
CREATE procedure 
  [dbo].[Roc_MLHD_Tab1_rocenka_prepocet]
	@datumOd date,
	@datumDo date
	
as	
begin
  
  delete from Roc_MLHD_Tab_1_rocenka where rok = datepart (year,@datumOd);
  
insert into Roc_MLHD_Tab_1_rocenka
 ([oblast]
      ,[stpec_7]
      ,[stpec_8]
      ,[stpec_9]
      ,[stpec_10]
      ,[stpec_11]
      ,[stpec_12]
      ,[stpec_13]
      
      ,[stpec_15]
      ,[stpec_16]
      ,[stpec_17]
      ,[stpec_18]
      ,[stpec_19]
      ,[stpec_20]
      ,[stpec_21]
      ,[stpec_22]
      ,[stpec_23]
      ,[stpec_24]
      ,[stpec_25]
      ,[stpec_26]
      ,[stpec_27]
      ,[stpec_28]
      ,[stpec_29]
      ,[rok]
      ,[Por]
      ,[DatumOd]
      ,[DatumDo]
      ,[datumGenerovania]
	  ,[stpec_14]
	  )
select 
  (case when filter = 'SR' then 'SLOVENSKO'
   when filter = 'SR,Obl1' then 'ZA VÝROBNÚ OBLASŤ 1'
   when filter = 'SR,Obl2' then 'ZA VÝROBNÚ OBLASŤ 2'
   when filter = 'SR,ChZ1' then 'ZA ŠĽACHTIT. CHOVY STRAKATÉ'	
   when filter = 'SR,ChZ2' then 'ZA ŠĽACHTIT. CHOVY PINZGAU'
   when filter = 'SR,ChZ3' then 'ZA ŠĽACHTIT. CHOVY HOLSTEIN'
   when filter = 'SR,ChZ5' then 'ZA ŠĽACHTIT. CHOVY BRAUNVIEH'
   when filter = 'SR,ChZ0' then 'OSTATNÉ CHOVY'
   when filter = 'SR, ,S01' then 'POĽNOHOSP. DRUŽSTVÁ'
   when filter = 'SR, ,S02' then 'ŠTÁTNE MAJETKY'
   when filter = 'SR, ,S03' then 'POĽNOHOSP. ŠKOLY'
   when filter = 'SR, ,S08' then 'SÚKROMNÝ SEKTOR'
   --when filter = 'SR, ,S00' then 'OSTATNÉ SEKTORY'
   when filter = 'SR,KUst2' then 'ZA MAŠTALE DO 20'
   when filter = 'SR,KUst3' then 'MAŠT. 21-50'
   when filter = 'SR,KUst4' then 'MAŠT. 51-100'
   when filter = 'SR,KUst5' then 'MAŠT. 101-220'
   when filter = 'SR,KUst6' then 'MAŠT. 221-500'
   when filter = 'SR,KUst7' then 'MAŠT. 501 A VIAC'
  else ''
  END  ) as oblast

  , PocLakN1 as stpec_7
      ,round(LakdniNL1,0) as stpec_8
      ,round(MliekNorL1,0) as stpec_9
      , round((TukNorL1*100)/MliekNorL1,2) as stpec_10
      ,round(TukNorL1,0) as stpec_11
      ,round((BielkNorL1*100)/MliekNorL1,2) as stpec_12
      ,round(BielkNorL1,0) as stpec_13
      --,as stpec_14Den
      --,as stpec_14Mesiac
      ,PocLakN2 as stpec_15
      ,round(LakDniNL2,0) as stpec_16
      ,round(MliekNorL2,0) as stpec_17
      ,round((TukNorL2*100)/MliekNorL2,2) as stpec_18
	  
      ,round(TukNorL2,0) as stpec_19
      ,round((BielkNorL2*100)/MliekNorL2,2) as stpec_20
      ,round(BielkNorL2,0) as stpec_21
      ,round(MedziobdL2,0) as stpec_22
      ,PocLakNcelk as stpec_23      
	  ,round(LakDniNCelk,0) as stpec_24
      ,round(MliekNorCelk,0) as stpec_25
      ,round((TukNorCelk*100)/MliekNorCelk,2) as stpec_26
      ,round(TukNorCelk,0) as stpec_27
      ,round((BielkNorCelk*100)/MliekNorCelk,2) as stpec_28
      ,round(BielkNorCelk,0) as stpec_29
      ,datepart (year,@datumOd)as rok
     ,(case when filter = 'SR' then '1'
   when filter = 'SR,Obl1' then '2'
   when filter = 'SR,Obl2' then '3'
   when filter = 'SR,ChZ1' then '4'	
   when filter = 'SR,ChZ2' then '5'
   when filter = 'SR,ChZ3' then '6'
   when filter = 'SR,ChZ5' then '7'
   when filter = 'SR,ChZ0' then '8'
   when filter = 'SR, ,S01' then '9'
   when filter = 'SR, ,S02' then '10'
   when filter = 'SR, ,S03' then '11'
   when filter = 'SR, ,S08' then '12'
   --when filter = 'SR, ,S00' then '13'
   when filter = 'SR,KUst2' then '13'
   when filter = 'SR,KUst3' then '14'
   when filter = 'SR,KUst4' then '15'
   when filter = 'SR,KUst5' then '16'
   when filter = 'SR,KUst6' then '17'
   when filter = 'SR,KUst7' then '18'
  else ''
  END  ) as Por
      ,DatumOd as DatumOd
      ,DatumDo as DatumDo
      ,datumGenerovania as datumGenerovania
	  ,MedziobdL1 as stpec_14
	  FROM CR_LaktacneZostavy_Opr where DatumOd = @datumOd and DatumDo = @datumDo 
	  and Filter in ('SR','SR,Obl1','SR,Obl2','SR,ChZ1','SR,ChZ2' ,'SR,ChZ3' ,'SR,ChZ5','SR,ChZ0' ,'SR, ,S01','SR, ,S02','SR, ,S03','SR, ,S08',
	  'SR,KUst2' ,'SR,KUst3' , 'SR,KUst4','SR,KUst5' , 'SR,KUst6','SR,KUst7') 


end
go


--------------------------------------------------------



CREATE procedure [dbo].[Rocenka_MPHD_9_plemTYP]
	
	@rok int
	--@plemeno varchar(9)

	as 
	begin

	select 	
    plemeno,
    isnull(prir_byk,0) as prir_byk,
    isnull(ins_byk,0) as ins_byk,
    isnull(nezn_byk,0) as nezn_byk,
    isnull(prir_tela,0) as prir_tela,
    isnull(ins_tela,0) as ins_tela,
    isnull(nezn_tela,0) as nezn_tela,
    isnull(prir_priem,0) as prir_priem,
    isnull(ins_priem,0) as ins_priem,
    isnull(nezn_priem,0) as nezn_priem,
    rok 
  from Roc_MPHD_Tab_9_plemTYP
	where @rok = rok 
	--@plemeno = plemeno
	 
	
		end
go


-----------------------------------------------------------------------


/***masova rocenka - -- hmotnost byckov a jaloviciek podla plemien a pohlavia graf strana  43 rok 2017**/
CREATE procedure [dbo].[Roc_MPHD_GRAF_HMOT_120_240]

    @datumOd date ,
    @datumDo date

as
  begin


    declare @dniVaz table (den int);
    insert @dniVaz(den) values(120),(210);

    declare @vaz table (den int, PLEMPRIS varchar(2), pohlavie int, hmotnost float, pocet int);


    DECLARE cursorDen CURSOR
    FOR SELECT den FROM @dniVaz
    OPEN cursorDen
    declare @den int;
    FETCH NEXT FROM cursorDen into @den
    WHILE (@@FETCH_STATUS = 0)
      BEGIN
        PRINT @den;
        insert into @vaz
          select @den as den, isnull(CC_PlemTyp.PLEMPRIS, 'XX') as PLEMPRIS, RIGHT(CM_Telata.POHLAVIE, 1) as pohlavie, avg(HMOTPREPOC) as hmotnost, count(*) as pocet from CM_Vazenia
            inner join CM_Telata on CM_Vazenia.CISTELATA = CM_Telata.CISTELATA and CM_Vazenia.PRIZNAKKU = 2 and DATVAZ between @datumOd and @datumDo and DNIPREPOC = @den and RIGHT (CM_Telata.POHLAVIE, 1) in (1, 2)
            left outer join CC_PlemTyp on TYPPLEM = CC_PlemTyp.TYPC

          group by RIGHT (CM_Telata.POHLAVIE, 1), CC_PlemTyp.PLEMPRIS

          union

          select
            @den as den,
            'SR'                         as PLEMPRIS,
            RIGHT(CM_Telata.POHLAVIE, 1) as pohlavie,
            avg(HMOTPREPOC)              as hmotnost,
            count(*)                     as pocet
          from CM_Vazenia
            inner join CM_Telata on CM_Vazenia.CISTELATA = CM_Telata.CISTELATA and CM_Vazenia.PRIZNAKKU = 2 and
                                    DATVAZ between @datumOd and @datumDo and DNIPREPOC = @den and
                                    RIGHT(CM_Telata.POHLAVIE, 1) in (1, 2)

          group by RIGHT(CM_Telata.POHLAVIE, 1)


        FETCH NEXT FROM cursorDen
        INTO @den;
      END

    select * from @vaz;




  End
go


---------------------------------------------------------------------------------


/****** Script for SelectTopNRows command from SSMS  ******/
-- rocenka mlieko ---ulozene do Roc_MLHD_Tab_16 - nasledne sa do rocenky vytiahne reportom
----NAjlepsie kravy podla dosiahnutych vysledkov v celozivotnej uzitkovosti podla kg MLIEKA ---str. 55
-- Exec Roc_MLHD_18 '2017-01-01', '2017-12-31'

CREATE procedure  [dbo].[Roc_MLHD_17]
	@datumOd date,
	@datumDo date

	as 
	begin
	
		delete from Roc_MLHD_Tab_17 where rok = datepart(year,@datumOd);
		
--declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31'
declare @kravyB table(
	ciskravy varchar(14)
	)
	insert into @kravyB 
		select distinct Lakt.CISKRAVY
		from  dbo.View_CP_LaktaciePreZostavy as Lakt
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				and Lakt.PLEM in ('B0','B1','B2','B3')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
	--select * from @kravy
	/**braunvieh**/
	declare @kravyB2 table
	( ciskravy varchar(14),
	CHOVATEL varchar(9),
	plem_typ varchar(3),
	pocet_lakt int, 
	mlieko_nor int,
	tuk int,
	tuk_P float,
	bielk int,
	bielk_P float,
	lakt_dni int,
	MLK_L float
		)
	insert into @kravyB2
		select distinct top 10 kr.ciskravy,
			l.CHOVATEL,
			l.PLEM as PlemTyp,
			count(l.PORLAK) as pocet_lakt, 
			sum(l.MLIEKNOR)as mlieko_nor,
			round(sum(l.TUKNOR),0) as tuk,
			sum(l.TUKNOR)/sum(l.MLIEKNOR) *100 as tuk_P,
      round(sum(l.BIELKNOR),0) as bielk,
			sum(l.BIELKNOR)/sum(l.MLIEKNOR) *100 as bielk_P,
			sum(l.LAKDNIN) as lakt_dni,
			round(sum(l.MLIEKNOR)/ count(l.PORLAK),0) as MLK_L

		from @kravyB as kr
			inner join dbo.View_CP_LaktaciePreZostavy  as l on l.ciskravy = kr.ciskravy
			left outer join CM_Krava as k on k.ciskravy = kr.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(l.CHOVATEL,1,6)
			--where l.ZMENA in ('30','40')
			group by kr.ciskravy,l.CHOVATEL,l.PLEM
			order by sum(l.MLIEKNOR) desc
			
insert into Roc_MLHD_Tab_17 

	select ROW_NUMBER() OVER(ORDER BY mlieko_nor desc) AS Por,
		--substring(kr2.ciskravy, 1,2) + ' ' +substring(kr2.ciskravy, 3,3)+ ' ' +substring(kr2.ciskravy, 6,3)+ ' ' +substring(kr2.ciskravy, 9,3)+ ' ' +substring(kr2.ciskravy, 12,3) as Ciskravy,
			kr2.ciskravy as Ciskravy,
			plem_typ as PlTyp,
			ISNULL(k.PL1 + '-' + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(ISNULL(k.PL2, '') + '-' + CONVERT(varchar, k.KR2), '') +  ISNULL(k.PL3 +  CONVERT(varchar, k.KR3), '') +  ISNULL(k.PL4 + '-' + CONVERT(varchar, k.KR4), '') 
						+  ISNULL(k.PL5 + '-' + CONVERT(varchar, 100 - (k.KR1 + k.KR2 + k.KR3 + k.KR4)), '') as Plemeno,
			o.NAZOV as Okres,
			p.NAZOVSKR as Podnik,
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			 kr2.pocet_lakt as Poc_lakt,
			 kr2.mlieko_nor as mlieko,
			 kr2.tuk as tuk_KG,
			 round(kr2.tuk_P,2,2) as tuk_P,
			 kr2.bielk as bielk_KG,
			 round(kr2.bielk_P,2,2) as bielk_P,
			 kr2.lakt_dni as Lakt_dni,
			 convert(int,kr2.MLK_L) as MLK_PocL,
			 (select datepart(year,@datumOd)) as rok,
			 'Brau' as Plem_typ

	from @kravyB2 as kr2
		left outer join CM_Krava as k on k.ciskravy = kr2.ciskravy
		left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
		left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(kr2.CHOVATEL,1,6)
		left outer join NC_OKRES as o on o.kraj + o.OKRES = p.KRAJ + p.OKRES 
	order by mlieko_nor desc
		

/**Slovenske strakate**/
declare @kravyS table(
	ciskravy varchar(14)
	)
	insert into @kravyS 
		select distinct Lakt.CISKRAVY
		from  dbo.View_CP_LaktaciePreZostavy as Lakt
		LEFT OUTER JOIN CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				--and Lakt.PLEM in ('S0','S1','S2','S3')
				and k.TYPPLEM IN ('11','12','13','14')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
	--select * from @kravy

	declare @kravyS2 table
	( ciskravy varchar(14),
	CHOVATEL varchar(9),
	plem_typ varchar(3),
	pocet_lakt int, 
	mlieko_nor int,
	tuk int,
	tuk_P float,
	bielk int,
	bielk_P float,
	lakt_dni int,
	MLK_L float
		)
	insert into @kravyS2
		select distinct top 30 kr.ciskravy,
			l.CHOVATEL,
			l.PLEM as PlemTyp,
      count(l.PORLAK) as pocet_lakt,
      sum(l.MLIEKNOR)as mlieko_nor,
      round(sum(l.TUKNOR),0) as tuk,
      sum(l.TUKNOR)/sum(l.MLIEKNOR) *100 as tuk_P,
      round(sum(l.BIELKNOR),0) as bielk,
      sum(l.BIELKNOR)/sum(l.MLIEKNOR) *100 as bielk_P,
      sum(l.LAKDNIN) as lakt_dni,
			round(sum(l.MLIEKNOR)/ count(l.PORLAK),0) as MLK_L
	
		from @kravyS as kr
			inner join dbo.View_CP_LaktaciePreZostavy  as l on l.ciskravy = kr.ciskravy
			left outer join CM_Krava as k on k.ciskravy = kr.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(l.CHOVATEL,1,6)
			where l.ZMENA in ('30','40')
			group by kr.ciskravy,l.CHOVATEL,l.PLEM
			order by sum(l.MLIEKNOR) desc

	insert into Roc_MLHD_Tab_17 
		select ROW_NUMBER() OVER(ORDER BY mlieko_nor desc) AS Por,
		--substring(kr2.ciskravy, 1,2) + ' ' +substring(kr2.ciskravy, 3,3)+ ' ' +substring(kr2.ciskravy, 6,3)+ ' ' +substring(kr2.ciskravy, 9,3)+ ' ' +substring(kr2.ciskravy, 12,3) as Ciskravy,
			kr2.ciskravy as Ciskravy,
			plem_typ as PlTyp,
			ISNULL(k.PL1 + '-' + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(ISNULL(k.PL2, '') + '-' + CONVERT(varchar, k.KR2), '') +  ISNULL(k.PL3 +  CONVERT(varchar, k.KR3), '') +  ISNULL(k.PL4 + '-' + CONVERT(varchar, k.KR4), '') 
						+  ISNULL(k.PL5 + '-' + CONVERT(varchar, 100 - (k.KR1 + k.KR2 + k.KR3 + k.KR4)), '') as Plemeno,
			o.NAZOV as Okres,
			p.NAZOVSKR as Podnik,
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			 kr2.pocet_lakt as Poc_lakt,
			 kr2.mlieko_nor as mlieko,
			 kr2.tuk as tuk_KG,
			 round(kr2.tuk_P,2,2) as tuk_P,
			 kr2.bielk as bielk_KG,
			 round(kr2.bielk_P,2,2) as bielk_P,
			 kr2.lakt_dni as Lakt_dni,
			 convert(int,kr2.MLK_L) as MLK_PocL,
			 (select datepart(year,@datumOd)) as rok,
			 'SLst' as Plem_typ
	from @kravyS2 as kr2
		left outer join CM_Krava as k on k.ciskravy = kr2.ciskravy
		left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
		left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(kr2.CHOVATEL,1,6)
		left outer join NC_OKRES as o on o.kraj + o.OKRES = p.KRAJ + p.OKRES 
	order by mlieko_nor desc

	/**Slov. pinzgau**/

		
declare @kravyP table(
	ciskravy varchar(14)
	)
	insert into @kravyP 
		select distinct Lakt.CISKRAVY
		from  dbo.View_CP_LaktaciePreZostavy as Lakt
		left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				and Lakt.PLEM in ('P0','P1','P2','P3')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
				and k.OTECLIN not in ('NEZ','RER','TUR','PGR','TIT')
	--select * from @kravy

	declare @kravyP2 table
	( ciskravy varchar(14),
	CHOVATEL varchar(9),
	plem_typ varchar(3),
	pocet_lakt int, 
	mlieko_nor int,
	tuk int,
	tuk_P float,
	bielk int,
	bielk_P float,
	lakt_dni int,
	MLK_L float
		)
	insert into @kravyP2
		select distinct top 20 kr.ciskravy,
			l.CHOVATEL,
			l.PLEM as PlemTyp,
      count(l.PORLAK) as pocet_lakt,
      sum(l.MLIEKNOR)as mlieko_nor,
      round(sum(l.TUKNOR),0) as tuk,
      sum(l.TUKNOR)/sum(l.MLIEKNOR) *100 as tuk_P,
      round(sum(l.BIELKNOR),0) as bielk,
      sum(l.BIELKNOR)/sum(l.MLIEKNOR) *100 as bielk_P,
      sum(l.LAKDNIN) as lakt_dni,
			round(sum(l.MLIEKNOR)/ count(l.PORLAK),0) as MLK_L
	
		from @kravyP as kr
			inner join dbo.View_CP_LaktaciePreZostavy  as l on l.ciskravy = kr.ciskravy
			left outer join CM_Krava as k on k.ciskravy = kr.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(l.CHOVATEL,1,6)
			where l.ZMENA in ('30','40')
			group by kr.ciskravy,l.CHOVATEL,l.PLEM
			order by sum(l.MLIEKNOR) desc

			
	insert into Roc_MLHD_Tab_17 

	select ROW_NUMBER() OVER(ORDER BY mlieko_nor desc) AS Por,
		--substring(kr2.ciskravy, 1,2) + ' ' +substring(kr2.ciskravy, 3,3)+ ' ' +substring(kr2.ciskravy, 6,3)+ ' ' +substring(kr2.ciskravy, 9,3)+ ' ' +substring(kr2.ciskravy, 12,3) as Ciskravy,
			kr2.ciskravy as Ciskravy,
			plem_typ as PlTyp,
			ISNULL(k.PL1 + '-' + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(ISNULL(k.PL2, '') + '-' + CONVERT(varchar, k.KR2), '') +  ISNULL(k.PL3 +  CONVERT(varchar, k.KR3), '') +  ISNULL(k.PL4 + '-' + CONVERT(varchar, k.KR4), '') 
						+  ISNULL(k.PL5 + '-' + CONVERT(varchar, 100 - (k.KR1 + k.KR2 + k.KR3 + k.KR4)), '') as Plemeno,
			o.NAZOV as Okres,
			p.NAZOVSKR as Podnik,
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			 kr2.pocet_lakt as Poc_lakt,
			 kr2.mlieko_nor as mlieko,
			 kr2.tuk as tuk_KG,
			 round(kr2.tuk_P,2,2) as tuk_P,
			 kr2.bielk as bielk_KG,
			 round(kr2.bielk_P,2,2) as bielk_P,
			 kr2.lakt_dni as Lakt_dni,
			 convert(int,kr2.MLK_L) as MLK_PocL,
			 (select datepart(year,@datumOd)) as rok,
			 'Pin' as Plem_typ
	from @kravyP2 as kr2
		left outer join CM_Krava as k on k.ciskravy = kr2.ciskravy
		left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
		left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(kr2.CHOVATEL,1,6)
		left outer join NC_OKRES as o on o.kraj + o.OKRES = p.KRAJ + p.OKRES 
	order by mlieko_nor desc

	/**Holstein**/

	declare @kravyH table(
	ciskravy varchar(14)
	)
	insert into @kravyH 
		select distinct Lakt.CISKRAVY
		from  dbo.View_CP_LaktaciePreZostavy as Lakt
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				and Lakt.PLEM in ('H0','H1','H2','H3')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
	--select * from @kravy

	declare @kravyH2 table
	( ciskravy varchar(14),
	CHOVATEL varchar(9),
	plem_typ varchar(3),
	pocet_lakt int, 
	mlieko_nor int,
	tuk int,
	tuk_P float,
	bielk int,
	bielk_P float,
	lakt_dni int,
	MLK_L float
		)
	insert into @kravyH2
		select distinct top 40 kr.ciskravy,
			l.CHOVATEL,
			l.PLEM as PlemTyp,
      count(l.PORLAK) as pocet_lakt,
      sum(l.MLIEKNOR)as mlieko_nor,
      round(sum(l.TUKNOR),0) as tuk,
      sum(l.TUKNOR)/sum(l.MLIEKNOR) *100 as tuk_P,
      round(sum(l.BIELKNOR),0) as bielk,
      sum(l.BIELKNOR)/sum(l.MLIEKNOR) *100 as bielk_P,
      sum(l.LAKDNIN) as lakt_dni,
      round(sum(l.MLIEKNOR)/ count(l.PORLAK),0) as MLK_L
	
		from @kravyH as kr
			inner join dbo.View_CP_LaktaciePreZostavy  as l on l.ciskravy = kr.ciskravy
			left outer join CM_Krava as k on k.ciskravy = kr.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(l.CHOVATEL,1,6)
			where l.ZMENA in ('30','40')
			group by kr.ciskravy,l.CHOVATEL,l.PLEM
			order by sum(l.MLIEKNOR) desc
			
	insert into Roc_MLHD_Tab_17 
	select ROW_NUMBER() OVER(ORDER BY mlieko_nor desc) AS Por,
		--substring(kr2.ciskravy, 1,2) + ' ' +substring(kr2.ciskravy, 3,3)+ ' ' +substring(kr2.ciskravy, 6,3)+ ' ' +substring(kr2.ciskravy, 9,3)+ ' ' +substring(kr2.ciskravy, 12,3) as Ciskravy,
			kr2.ciskravy as Ciskravy,
			plem_typ as PlTyp,
			ISNULL(k.PL1 + '-' + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(ISNULL(k.PL2, '') + '-' + CONVERT(varchar, k.KR2), '') +  ISNULL(k.PL3 +  CONVERT(varchar, k.KR3), '') +  ISNULL(k.PL4 + '-' + CONVERT(varchar, k.KR4), '') 
						+  ISNULL(k.PL5 + '-' + CONVERT(varchar, 100 - (k.KR1 + k.KR2 + k.KR3 + k.KR4)), '') as Plemeno,
			o.NAZOV as Okres,
			p.NAZOVSKR as Podnik,
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			 kr2.pocet_lakt as Poc_lakt,
			 kr2.mlieko_nor as mlieko,
			 kr2.tuk as tuk_KG,
			 round(kr2.tuk_P,2,2) as tuk_P,
			 kr2.bielk as bielk_KG,
			 round(kr2.bielk_P,2,2) as bielk_P,
			 kr2.lakt_dni as Lakt_dni,
			 convert(int,kr2.MLK_L) as MLK_PocL,
			 (select datepart(year,@datumOd)) as rok,
			 'Hol' as Plem_typ
	from @kravyH2 as kr2
		left outer join CM_Krava as k on k.ciskravy = kr2.ciskravy
		left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
		left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(kr2.CHOVATEL,1,6)
		left outer join NC_OKRES as o on o.kraj + o.OKRES = p.KRAJ + p.OKRES 
	order by mlieko_nor desc
		




		End
go


-------------------------------------------------------------------------------------------------


/***masova rocenka - -- prirastok byckov a jaloviciek podla plemien a pohlavia graf strana  44 rok 2017**/
CREATE procedure [dbo].[Roc_MPHD_GRAF_PRIR_120_240]

    @datumOd date ,
    @datumDo date

as
  begin


    declare @dniVaz table (den int);
    insert @dniVaz(den) values(120),(210);

    declare @vaz table (den int, PLEMPRIS varchar(2), pohlavie int, prirastok float, pocet int);


    DECLARE cursorDen CURSOR
    FOR SELECT den FROM @dniVaz
    OPEN cursorDen
    declare @den int;
    FETCH NEXT FROM cursorDen into @den
    WHILE (@@FETCH_STATUS = 0)
      BEGIN
        PRINT @den;
        insert into @vaz
          select @den as den, isnull(CC_PlemTyp.PLEMPRIS, 'XX') as PLEMPRIS, RIGHT(CM_Telata.POHLAVIE, 1) as pohlavie, avg(PRIRPREPOC) as prirastok, count(*) as pocet from CM_Vazenia
            inner join CM_Telata on CM_Vazenia.CISTELATA = CM_Telata.CISTELATA and CM_Vazenia.PRIZNAKKU = 2 and DATVAZ between @datumOd and @datumDo and DNIPREPOC = @den and RIGHT (CM_Telata.POHLAVIE, 1) in (1, 2)
            left outer join CC_PlemTyp on TYPPLEM = CC_PlemTyp.TYPC

          group by RIGHT (CM_Telata.POHLAVIE, 1), CC_PlemTyp.PLEMPRIS

          union

          select
            @den as den,
            'SR'                         as PLEMPRIS,
            RIGHT(CM_Telata.POHLAVIE, 1) as pohlavie,
            avg(PRIRPREPOC)              as prirastok,
            count(*)                     as pocet
          from CM_Vazenia
            inner join CM_Telata on CM_Vazenia.CISTELATA = CM_Telata.CISTELATA and CM_Vazenia.PRIZNAKKU = 2 and
                                    DATVAZ between @datumOd and @datumDo and DNIPREPOC = @den and
                                    RIGHT(CM_Telata.POHLAVIE, 1) in (1, 2)

          group by RIGHT(CM_Telata.POHLAVIE, 1)


        FETCH NEXT FROM cursorDen
        INTO @den;
      END

    select * from @vaz ORDER BY pohlavie, den, PLEMPRIS;




  End
go


-----------------------------------------------------------------------------------------------------------

CREATE procedure [dbo].[Rocenka_MPHD_6_plemTYP]
	
	@rok int
	--@plemeno varchar(9)

	as 
	begin

	--select 	* from Roc_MPHD_Tab_6_plemTYP
	--where @rok = rok and @plemeno = plemeno
	 
	select plemeno, plemtyp, 
		case --when plemtyp = '101' then 'BBM1'  
		--when plemtyp = '102'then 'BBM2'  
		--	when plemtyp = '103' then 'BBM3'  
		--	when plemtyp = '104' then 'BBM4'  
		--	when plemtyp = '105' then 'BBM5'  
		when plemtyp ='111' then 'AAM1'
			when plemtyp ='112' then 'AAM2'
			when plemtyp ='113' then 'AAM3'
			when plemtyp ='114' then 'AAM4'
			when plemtyp ='115' then 'AAM5'
		when plemtyp ='121' then 'BAM1'
			when plemtyp ='122' then 'BAM2'
			when plemtyp ='123' then 'BAM3'
			when plemtyp ='124' then 'BAM4'
			when plemtyp ='125' then 'BAM5' 
		when plemtyp ='131' then 'GLM1'
		when plemtyp ='141' then 'HEM1'
			when plemtyp ='142' then 'HEM2'
			when plemtyp ='143' then 'HEM3'
			when plemtyp ='144' then 'HEM4'
			when plemtyp ='145' then 'HEM5'
		when plemtyp ='151' then 'HLM1'
		when plemtyp ='161' then 'CHM1'
			when plemtyp ='162' then 'CHM2'
			when plemtyp ='163' then 'CHM3'
			when plemtyp ='164' then 'CHM4'
			when plemtyp ='165' then 'CHM5'
		when plemtyp ='171' then 'LIM1'
			when plemtyp ='172' then 'LIM2'
			when plemtyp ='173' then 'LIM3'
			when plemtyp ='174' then 'LIM4'
			when plemtyp ='175' then 'LIM5'
		when plemtyp ='201' then 'SMM1'
			when plemtyp ='202' then 'SMM2'
			when plemtyp ='203' then 'SMM3'
			when plemtyp ='204' then 'SMM4'
			when plemtyp ='205' then 'SMM5'
		when plemtyp ='191' then 'PIM1'
			when plemtyp ='192' then 'PIM2'
			when plemtyp ='193' then 'PIM3'
			when plemtyp ='194' then 'PIM4'
			when plemtyp ='195' then 'PIM5'
		when plemtyp ='51' then 'PM0'
			when plemtyp ='53' then 'PM1'
			when plemtyp ='54' then 'PM2'
		when plemtyp ='11' then 'SM0'
			when plemtyp ='13' then 'SM1'
		when plemtyp ='14' then 'SM2' end as plemeno_nazov,
						vek_1OT, 
		isnull(medz_2otel, 0) as medz_2otel, 
		isnull(medz_3otel, 0) as medz_3otel, 
		isnull(medz_4otel, 0) as medz_4otel, 
		isnull(medz_5otel, 0) as medz_5otel, 
		isnull(medz_celk_otel, 0) as medz_celk_otel, 
		rok 
	from Roc_MPHD_Tab_6_plemTYP as pt 
  	--where pt.plemeno= @plemeno
union

select plemeno,'999'as plemtyp, 'spolu' as plemeno_nazov, vek_1OT, 
	isnull(medz_2otel, 0) as medz_2otel, 
	isnull(medz_3otel, 0) as medz_3otel, 
	isnull(medz_4otel, 0) as medz_4otel, 
	isnull(medz_5otel, 0) as medz_5otel, 
	isnull(medz_celk_otel, 0) as medz_celk_otel, 
	rok
from Roc_MPHD_Tab_6 as roc 
  			where roc.plemeno not in ('SR','Nez','Osta')
					 




		end
go


--------------------------------------------------------------------------------------------



-- =============================================
-- Author:		PSSR, š.p.
-- Create date: 20.01.2018
-- Description:Udaje za plemena pre rocenku - tabulka: VYSLEDKY KONTROLY UZITKOVOSTI PODLA PLEMEIEN
-- spusi sa prepocet *Roc_MLHD_ZostavaLaktacie_TypPlem_prepocet* a nasledne sa spusta procedura *Roc_MLHD_2*
-- Holesova
-- =============================================
CREATE procedure [dbo].[Roc_MLHD_ZostavaLaktacie_TypPlem]
	@chov varchar(9)='',
	@datumOd date,
	@datumDo date ='',
	@region varchar(2)=''

as	
begin

if @datumDo is null
begin 
set @datumDo = GETDATE () 
end 

Declare @Laktacie table(
--CREATE TABLE @Laktacie(
	  [PORLAK][int],
      [CHOVATEL][varchar] (9) null,
	  [Region] [varchar](2) NULL,
	  [ZMENA][varchar] (2) null,
      [MEDZIOBD][float] NULL,  
      [LAKTDNI][float] NULL,
      [LAKDNIN][float] NULL,
      [MLIEKNOR][float] NULL,
      [TUKNOR][float] NULL,
      [BIELKNOR][float] NULL,
      [LAKTOZAN] [float] NULL,
	  [INDPER] [float] NULL,
	  [typPlem] [varchar] (5) null,
      [DOVVYR][varchar] (2) null,
      [DATVYR][date] null,
	  [EkoChov][varchar](1) NULL
	  
      ) --ON [PRIMARY]
	  
declare @kravy table                                 
	(
		[CHOV] [varchar](9) NULL,
		[Region] [varchar](2) NULL,
		[typPlem] [varchar] (5) Null,
		ciskravy varchar(14),
		PORPREBLAK int
		--[PocZapojL1] int NULL
	)


if (@region is null) 
begin
	if (len(@chov) = 1)
	begin
		insert into @Laktacie
			 SELECT
 				 PORLAK, Lakt.CHOVATEL,(select region from NC_OKRES reg where (reg.KRAJ + reg.OKRES)= Lakt.okres),--Region,
				 ZMENA, MEDZIOBD, LAKTDNI,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, 
				
				 --(case when PLEM is null then 'BEZ' 
					--else case when PLEM not in ('B0','B1','B2','H0','H1','H2','H3','MN','P0','P1','P2','PL','RM','S0','S1','S2', 'BEZ')
					--THEN 'OSTA' else PLEM end end)as Plem, 					
				(case when TYPPLEM in('11','13','14','51','53','54','21','22','23') then TYPPLEM  
					when TYPPLEM in('95', '99') then '99'
						when TYPPLEM in('84','88','94','98') then '98'
						when TYPPLEM in('73','77','83','87','93','97') then '97'
						when TYPPLEM in('92','96','76','82','86','62','66','72') then '96'
						when (PL2='S' or PL2='MB') and KR2=50 then '14'
						when PL2='P' and KR2=50 then '54'
						when (PL2='H' or PL2='R') and KR2=50 then '96'
						when PL2='B' and KR2=50 then '23'
						else '0000'
						end ) as typPlem,
				
				Lakt.DOVVYR, Lakt.DATVYR,
				 (select case when @chov = (eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV) and eko.EkoChov='1' then '1' 
							else null end)as EkoChov
			 FROM View_CP_LaktaciePreZostavy as Lakt
			 left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
			---- left outer join  NC_OKRES as reg on ((reg.KRAJ + reg.OKRES)= substring(CHOVATEL, 1, 3))
			 left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV)= Lakt.CHOVATEL)

				where 
					--(Lakt.CHOVATEL in (select chov from CP_ZoznamChovov)) -- chovy, ktoré sú v kontrole úžitkovosti
					lakt.kraj = @chov	
					and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd 
						and Lakt.DATUKNORL <= @datumDo))
					and (eko.ZRUS is null or(eko.ZRUS is not null and (select cast(eko.datumZrusenia as date)) > @datumOd))
					and (Lakt.CHOVATEL in (select chov from CP_ZoznamChovov))
						and eko.TYPZV = 1
					and lakt.MLIEKCEL <>''

	end
	else if (len(@chov) = 3)
	begin
		insert into @Laktacie
			 SELECT
 				 PORLAK, Lakt.CHOVATEL,(select region from NC_OKRES reg where (reg.KRAJ + reg.OKRES)= lakt.okres),--Region,
				 ZMENA, MEDZIOBD, LAKTDNI,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, 
				 (case when TYPPLEM in('11','13','14','51','53','54','21','22','23') then TYPPLEM  
					when TYPPLEM in('95', '99') then '99'
						when TYPPLEM in('84','88','94','98') then '98'
						when TYPPLEM in('73','77','83','87','93','97') then '97'
						when TYPPLEM in('92','96','76','82','86','62','66','72') then '96'
						when (PL2='S' or PL2='MB') and KR2=50 then '14'
						when PL2='P' and KR2=50 then '54'
						when (PL2='H' or PL2='R') and KR2=50 then '96'
						when PL2='B' and KR2=50 then '23'
						else '0000'
						end ) as typPlem,
				Lakt.DOVVYR, Lakt.DATVYR,
				 (select case when @chov = (eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV) and eko.EkoChov='1' then '1' 
							else null end)as EkoChov
			 FROM View_CP_LaktaciePreZostavy as Lakt
				 left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
				 left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV)= Lakt.CHOVATEL)

				where
					lakt.okres = @chov	
					and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd 
						and Lakt.DATUKNORL <= @datumDo))
					and (eko.ZRUS is null or(eko.ZRUS is not null and (select cast(eko.datumZrusenia as date)) > @datumOd))
					and (Lakt.CHOVATEL in (select chov from CP_ZoznamChovov))
						and eko.TYPZV = 1
					and MLIEKCEL <>''
	end
	else if (len(@chov) = 6)
	begin
		insert into @Laktacie
			 SELECT
 				 PORLAK, Lakt.CHOVATEL,(select region from NC_OKRES reg where (reg.KRAJ + reg.OKRES)= lakt.okres),--Region,
				 ZMENA, MEDZIOBD, LAKTDNI,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, 
				 --(case when PLEM is null then 'BEZ' 
					--else case when  PLEM not in ('B0','B1','B2','H0','H1','H2','H3','MN','P0','P1','P2','PL','RM','S0','S1','S2', 'BEZ')  --and PLEM is not null
					--THEN 'ZVYS' else PLEM end end)as Plem, 
						--THEN 'OSTA' else PLEM end end)as Plem, 					
				(case when TYPPLEM in('11','13','14','51','53','54','21','22','23') then TYPPLEM  
					when TYPPLEM in('95', '99') then '99'
						when TYPPLEM in('84','88','94','98') then '98'
						when TYPPLEM in('73','77','83','87','93','97') then '97'
						when TYPPLEM in('92','96','76','82','86','62','66','72') then '96'
						when (PL2='S' or PL2='MB') and KR2=50 then '14'
						when PL2='P' and KR2=50 then '54'
						when (PL2='H' or PL2='R') and KR2=50 then '96'
						when PL2='B' and KR2=50 then '23'
						else '0000'
						end ) as typPlem,
				Lakt.DOVVYR, Lakt.DATVYR,
				 (select case when @chov = (eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV) and eko.EkoChov='1' then '1' 
							else null end)as EkoChov
			 FROM View_CP_LaktaciePreZostavy as Lakt
				 left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
				 left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV)= Lakt.CHOVATEL)

				where 
					 --(Lakt.CHOVATEL in (select chov from CP_ZoznamChovov)) -- chovy, ktoré sú v kontrole úžitkovosti
					lakt.podnik = @chov	
					--and (PLEM=@plem or @plem is null)
					and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd 
						and Lakt.DATUKNORL <= @datumDo))
					--and eko.ZRUS is null and eko.TYPZV='1'
					and (eko.ZRUS is null or(eko.ZRUS is not null and cast(eko.datumZrusenia as date) > @datumOd))
					and (Lakt.CHOVATEL in (select chov from CP_ZoznamChovov))
						and eko.TYPZV = 1
					and MLIEKCEL <>''
	end
	else if (len(@chov) = 9)
	begin
		insert into @Laktacie
			 SELECT
 				 PORLAK, Lakt.CHOVATEL,(select region from NC_OKRES reg where (reg.KRAJ + reg.OKRES)= lakt.okres),--Region,
				 ZMENA, MEDZIOBD, LAKTDNI,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, 
				
				 --(case when PLEM is null then 'BEZ' 
					--else case when PLEM not in ('B0','B1','B2','H0','H1','H2','H3','MN','P0','P1','P2','PL','RM','S0','S1','S2', 'BEZ') --and PLEM is not null 
					--THEN 'OSTA' else PLEM end end)as Plem, 
						--THEN 'OSTA' else PLEM end end)as Plem, 					
				(case when TYPPLEM in('11','13','14','51','53','54','21','22','23') then TYPPLEM  
					when TYPPLEM in('95', '99') then '99'
						when TYPPLEM in('84','88','94','98') then '98'
						when TYPPLEM in('73','77','83','87','93','97') then '97'
						when TYPPLEM in('92','96','76','82','86','62','66','72') then '96'
						when (PL2='S' or PL2='MB') and KR2=50 then '14'
						when PL2='P' and KR2=50 then '54'
						when (PL2='H' or PL2='R') and KR2=50 then '96'
						when PL2='B' and KR2=50 then '23'
						else '0000'
						end ) as typPlem,
				Lakt.DOVVYR, Lakt.DATVYR,
				 (select case when @chov = (eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV) and eko.EkoChov='1' then '1' 
							else null end)as EkoChov
			 FROM View_CP_LaktaciePreZostavy as Lakt
				 left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
				 left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV)= Lakt.CHOVATEL)

				where 
					--(Lakt.CHOVATEL in (select chov from CP_ZoznamChovov)) -- chovy, ktoré sú v kontrole úžitkovosti
					lakt.chovatel = @chov
					--and (PLEM=@plem or @plem is null)
					and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd 
						and Lakt.DATUKNORL <= @datumDo))
					--and eko.ZRUS is null and eko.TYPZV='1'
					and (eko.ZRUS is null or(eko.ZRUS is not null and  cast(eko.datumZrusenia as date) > @datumOd))
					and (Lakt.CHOVATEL in (select chov from CP_ZoznamChovov))
						and eko.TYPZV = 1
					and MLIEKCEL <>''
	end
	else 
	begin
		insert into @Laktacie
			 SELECT
 				 PORLAK, Lakt.CHOVATEL,(select region from NC_OKRES reg where (reg.KRAJ + reg.OKRES)= lakt.okres),--Region,
				 ZMENA, MEDZIOBD, LAKTDNI,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, 
				 
				 --(case when PLEM is null then 'BEZ' 
					--else case when PLEM not in ('B0','B1','B2','H0','H1','H2','H3','MN','P0','P1','P2','PL','RM','S0','S1','S2', 'BEZ')-- and PLEM is not null 
					--THEN 'OSTA' else PLEM end end)as Plem,  
						--THEN 'OSTA' else PLEM end end)as Plem, 					
				(case when TYPPLEM in('11','13','14','51','53','54','21','22','23') then TYPPLEM  
					when TYPPLEM in('95', '99') then '99'
						when TYPPLEM in('84','88','94','98') then '98'
						when TYPPLEM in('73','77','83','87','93','97') then '97'
						when TYPPLEM in('92','96','76','82','86','62','66','72') then '96'
						when (PL2='S' or PL2='MB') and KR2=50 then '14'
						when PL2='P' and KR2=50 then '54'
						when (PL2='H' or PL2='R') and KR2=50 then '96'
						when PL2='B' and KR2=50 then '23'
						else '0000'
						end ) as typPlem,
				Lakt.DOVVYR, Lakt.DATVYR,
				 (select case when @chov = (eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV) and eko.EkoChov='1' then '1' 
							else null end)as EkoChov
			 FROM View_CP_LaktaciePreZostavy as Lakt
				 left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
				 left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV)= Lakt.CHOVATEL)

				where 
					--(Lakt.CHOVATEL in (select chov from CP_ZoznamChovov)) -- chovy, ktoré sú v kontrole úžitkovosti
					--and (PLEM=@plem or @plem is null)
					((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd 
						and Lakt.DATUKNORL <= @datumDo))
					--and eko.ZRUS is null and eko.TYPZV='1'
					and (eko.ZRUS is null or(eko.ZRUS is not null and  cast(eko.datumZrusenia as date) > @datumOd))
					and (Lakt.CHOVATEL in (select chov from CP_ZoznamChovov))
						and eko.TYPZV = 1
					and MLIEKCEL <>''

	end
	
	insert @kravy
	select 
		@chov as CHOV, 
		@region as Region,
		--(Select distinct case when pl.TYPS is null then 'BEZ' 
		--			else case when pl.TYPS not in ('B0','B1','B2','H0','H1','H2','H3','MN','P0','P1','P2','PL','RM','S0','S1','S2', 'BEZ') --and pl.TYPS is not null 
		--			THEN 'OSTA' else pl.TYPS end end), 
				--THEN 'OSTA' else PLEM end end)as Plem, 					
				(case when TYPPLEM in('11','13','14','51','53','54','21','22','23') then TYPPLEM  
					when TYPPLEM in('95', '99') then '99'
						when TYPPLEM in('84','88','94','98') then '98'
						when TYPPLEM in('73','77','83','87','93','97') then '97'
						when TYPPLEM in('92','96','76','82','86','62','66','72') then '96'
						when (PL2='S' or PL2='MB') and KR2=50 then '14'
						when PL2='P' and KR2=50 then '54'
						when (PL2='H' or PL2='R') and KR2=50 then '96'
						when PL2='B' and KR2=50 then '23'
						else '0000'
						end ) as typPlem,
		k.ciskravy,
		PORPREBLAK
	from CM_Krava as k
		--inner join CC_PlemTyp as pl on(case when pl.TYPC is null then '0' else pl.TYPC end = case when k.TYPPLEM is null then '0' else k.TYPPLEM end)
											
		where (k.CHOVATEL in (select distinct CHOVATEL from @Laktacie)) 
				--and	k.DOVVYR is null 
				and (k.DOVVYR is null or(k.DOVVYR is not null and k.Datvyr > @datumOd))
				and k.PRIZNAKKU='1' 
				--and (pl.TYPS=@plem or @plem is null)	


 end
 ELSE
 begin 
	insert into @Laktacie			
	 SELECT
 		 PORLAK, Lakt.CHOVATEL,Region,
		 ZMENA, MEDZIOBD, LAKTDNI,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, 
			(case when TYPPLEM in('11','13','14','51','53','54','21','22','23') then TYPPLEM  
					when TYPPLEM in('95', '99') then '99'
						when TYPPLEM in('84','88','94','98') then '98'
						when TYPPLEM in('73','77','83','87','93','97') then '97'
						when TYPPLEM in('92','96','76','82','86','62','66','72') then '96'
						when (PL2='S' or PL2='MB') and KR2=50 then '14'
						when PL2='P' and KR2=50 then '54'
						when (PL2='H' or PL2='R') and KR2=50 then '96'
						when PL2='B' and KR2=50 then '23'
						else '0000'
						end ) as typPlem,
		 Lakt.DOVVYR, Lakt.DATVYR,
		 (select case when @chov = (eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV) and eko.EkoChov='1' then '1' 
					else null end)as EkoChov
	 FROM View_CP_LaktaciePreZostavy as Lakt
	 left outer join CM_Krava as k on k.CISKRAVY = Lakt.CISKRAVY
	 left outer join  NC_OKRES as reg on ((reg.KRAJ + reg.OKRES)= substring(Lakt.CHOVATEL, 1, 3))
	 left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV)= Lakt.CHOVATEL)

		where 
		(reg.REGION=@region or @region is null) 
		--and (Lakt.CHOVATEL in (select chov from CP_ZoznamChovov)) -- chovy, ktoré sú v kontrole úžitkovosti
		--and (PLEM=@plem or @plem is null)
		and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd 
						and Lakt.DATUKNORL <= @datumDo))
		--and eko.ZRUS is null and eko.TYPZV='1'
		and (eko.ZRUS is null or(eko.ZRUS is not null and  cast(eko.datumZrusenia as date) > @datumOd))
		and (Lakt.CHOVATEL in (select chov from CP_ZoznamChovov))
		and eko.TYPZV = 1
		and MLIEKCEL <>''


	insert @kravy
		select 
			@chov as CHOV, 
			@region as Region,
			(case when TYPPLEM in('11','13','14','51','53','54','21','22','23') then TYPPLEM  
					when TYPPLEM in('95', '99') then '99'
						when TYPPLEM in('84','88','94','98') then '98'
						when TYPPLEM in('73','77','83','87','93','97') then '97'
						when TYPPLEM in('92','96','76','82','86','62','66','72') then '96'
						when (PL2='S' or PL2='MB') and KR2=50 then '14'
						when PL2='P' and KR2=50 then '54'
						when (PL2='H' or PL2='R') and KR2=50 then '96'
						when PL2='B' and KR2=50 then '23'
						else '0000'
						end ) as typPlem,
			k.ciskravy,
			PORPREBLAK
		from CM_Krava as k
			inner join CC_PlemTyp as pl on(case when pl.TYPC is null then '0' else pl.TYPC end = case when k.TYPPLEM is null then '0' else k.TYPPLEM end)
										
			left outer join  NC_OKRES as reg on ((reg.KRAJ + reg.OKRES)= substring(CHOVATEL, 1, 3))
			where (k.CHOVATEL in (select distinct CHOVATEL from @Laktacie)) 
					and (reg.REGION=@region or @region is null)
					--and	k.DOVVYR is null 
				and (k.DOVVYR is null or(k.DOVVYR is not null and k.datvyr > @datumOd))
				and k.PRIZNAKKU='1' 
					--and (pl.TYPS=@plem or @plem is null)	
end

Declare @Laktacie_Vs table(
--CREATE TABLE @Laktacie(
	  [PORLAK][int],
      [CHOVATEL][varchar] (9) null,
	  [Region] [varchar](2) NULL,
	  [ZMENA][varchar] (2) null,
      [MEDZIOBD][float] NULL,  
      [LAKTDNI][float] NULL,
      [LAKDNIN][float] NULL,
      [MLIEKNOR][float] NULL,
      [TUKNOR][float] NULL,
      [BIELKNOR][float] NULL,
      [LAKTOZAN] [float] NULL,
	  [INDPER] [float] NULL,
	  [typPlem] [varchar] (5) null,
      [DOVVYR][varchar] (2) null,
      [DATVYR][date] null,
	  [EkoChov][varchar](1) NULL
	  
      ) --ON [PRIMARY]
	  
declare @kravy_Vs table                                 
	(
		[CHOV] [varchar](9) NULL,
		[Region] [varchar](2) NULL,
		[typPlem] [varchar] (5) Null,
		ciskravy varchar(14),
		PORPREBLAK int
		--[PocZapojL1] int NULL
	)

	insert into @Laktacie_Vs
			 SELECT
 				 PORLAK, CHOVATEL,Region,
				 ZMENA, MEDZIOBD, LAKTDNI,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, 
				(case when typPlem in('11','13','14') then 'SlStr' 
						else case when TYPPLEM in('51', '53','54') then 'SlPin'
						else case when TYPPLEM in('96','97','98','99') then 'Hol'
						else case when TYPPLEM in('21','22','23') then 'Brau'
						end end end end ) as typPlem,
				DOVVYR, DATVYR, EkoChov
				From @Laktacie

	insert into @kravy_Vs
			select chov, region, 
			(case when typPlem in('11','13','14') then 'SlStr' 
						else case when TYPPLEM in('51', '53','54') then 'SlPin'
						else case when TYPPLEM in('96','97','98','99') then 'Hol'
						else case when TYPPLEM in('21','22','23') then 'Brau'
						end end end end ) as typPlem,
			ciskravy, porpreblak
			from @kravy




--select * from @kravy where typPlem='0000'

--select * from @Laktacie where typPlem='0000'

declare @PocZapojL1 table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocZapojL1] int NULL
	)

	Insert @PocZapojL1
	select 
		@chov as CHOV, 
		@region as Region,
		typPlem as typPlem, 
		count(k.ciskravy) as PocZapojL1
	--from CM_Krava as k
	from @kravy as k

	 where 	k.PORPREBLAK ='1'
 	group by 
		case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(k.CHOV, 1, len(@chov))) end end,typPlem
		
----select * from @PocZapojL1 

declare @PocZapojL2 table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocZapojL2] int NULL
	)

	Insert @PocZapojL2
	select 
		@chov as CHOV, 
		@region as Region,
		typPlem as typPlem, 
		count(k.ciskravy) as PocZapojL2
	from @kravy as k
	

	where k.PORPREBLAK >='2'
 	
	group by 
		case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(k.CHOV, 1, len(@chov))) end end,typPlem 

----select * from @PocZapojL2 

declare @PocZapojLCelk table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocZapojLCelk] int NULL
	)

	Insert @PocZapojLCelk
	select 
		@chov as CHOV, 
		@region as Region,
		typPlem as typPlem, 
		count(k.ciskravy) as PocZapojLCelk

	from @kravy as k

	group by 
		case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(k.CHOV, 1, len(@chov))) end end,typPlem

----select * from @PocZapojL1 


declare @pocLAKV1 table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakV1] [float](4) NULL
)

	Insert @pocLAKV1
	select 
	@chov as CHOV, 
	@region as Region,
	typPlem as typPlem, 
	count(*) as PocLakV1

	from @Laktacie as l	where PORLAK = '1'

	group by  case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem

	--select * from @pocLAKV1 


declare @pocLAKV2 table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakV2] [float](4) NULL
)
	Insert @pocLAKV2
	select 
	@chov as CHOV, 
	@region as Region,
	typPlem as typPlem, 
	count(*) as PocLakV2

	from @Laktacie as l	where PORLAK >= '2'

	group by case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem

	--select * from @pocLAKV2

declare @pocLAKVCelk table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakVCelk] [float](4) NULL
)

	Insert @pocLAKVCelk
	select 
	@chov as CHOV, 
	@region as Region,
	typPlem as typPlem, 
	count(*) as PocLakVCelk

	from @Laktacie as l
		
	group by  case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem

	--select * from @pocLAKVCelk 

Declare @lakt1 table
	
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakN1] [float](4) NULL,
	[MedziobdL1] [float](7) NULL,
    [LakdniL1] [float](7) NULL,
    [LakdniNL1] [float](7) NULL,	
    [MliekNorL1] [float](9) NULL,
    [TukNorL1] [float](7) NULL,
    [BielkNorL1] [float](7) NULL,
    [LaktozaNL1] [float](7) NULL, 
	[IPZL1] [float](5) NULL,
	[VyrZootechL1] [varchar](4) NULL,
	[VyrZdravDovL1] [varchar](4) NULL
	)

	Insert into @lakt1
	(CHOV,Region,typPlem, PocLakN1, MedziobdL1, LakdniL1, LakdniNL1, MliekNorL1, TukNorL1, BielkNorL1, LaktozaNL1, IPZL1, 
	VyrZootechL1,VyrZdravDovL1 )
	
select 
	@chov as CHOV, 
	@region as Region,
	l.typPlem as typPlem,
	count(*)  as PocLakN1, 
	ROUND(AVG(MEDZIOBD),2)  as MedziobdL1,
	ROUND(AVG(LAKTDNI),2) as LaktdniL1,
	ROUND(AVG(LAKDNIN),2)as LakdniNL1,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorL1,
	ROUND(AVG(TUKNOR),2)as TukNorL1,
	ROUND(AVG(BIELKNOR),2) as BielkNorL1,
	ROUND(AVG(LAKTOZAN),2) as LaktozaNL1,
	AVG(INDPER) as IPZL1,
	Sum(case when (l.DOVVYR='54' or l.DOVVYR='53' or l. DOVVYR='52' or l.DOVVYR='51' ) then 1 else 0 end) as VyrZootechL1,
	Sum(case when (l.DOVVYR='55' or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61' or l.DOVVYR='62' ) then 1 else 0 end) as VyrZdravDovL1

	from @Laktacie as l
		where  PORLAK = '1'
		and (l.ZMENA = '30' or l.ZMENA='40') 

	group by  case when @chov is null and @region is null then @chov	
				   else
					case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem
	
	--select * from @lakt1  
	
  Declare @lakt2 table
  ( [CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	--[PocLakV2] [float](4) NULL,
	[PocLakN2] [float](4) NULL,
	[MedziobdL2] [float](7) NULL,
    [LaktDniL2] [float](7) NULL,
    [LakDniNL2] [float](7) NULL,	
    [MliekNorL2] [float](9) NULL,
    [TukNorL2] [float](7) NULL,
    [BielkNorL2] [float](7) NULL,
    [LaktozaNL2] [float](7) NULL,
	[IPZL2] [float](5) NULL,
	[VyrZootechL2] [varchar](4) NULL,
	[VyrZdravDovL2] [varchar](4) NULL
	)
 insert @lakt2
 select
	@chov as CHOV, 
	@region as Region,
	l.typPlem as typPlem,
	count(*) as PocLakN2, 
	ROUND(AVG(MEDZIOBD),2) as MedziobdL2,
	ROUND(AVG(LAKTDNI),2)as LaktdniL2,
	ROUND(AVG(LAKDNIN),2)as LakdniNL2,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorL2,
	ROUND(AVG(TUKNOR),2)as TukNorL2,
	ROUND(AVG(BIELKNOR),2) as BielkNorL2,
	ROUND(AVG(LAKTOZAN),2) as LaktozaNL2,
	AVG(INDPER) as IPZL2,
	Sum(case when (l.DOVVYR='54' or l.DOVVYR='53' or l.DOVVYR='52' or l.DOVVYR='51' ) then 1 else 0 end) as VyrZootechL2,
	Sum(case when (l.DOVVYR='55' or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61' or l.DOVVYR='62') then 1 else 0 end) as VyrZdravDovL2

	from @Laktacie as l
	where 
	PORLAK >= '2'
	and (l.ZMENA = '30' or l.ZMENA='40') 

	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem
	
 --select * from @lakt2 order by CHOV

  Declare @laktCelkom table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakNcelk] [float] NULL,
	[MedziobdCelk] [float] NULL,
    [LaktDniCelk] [float] NULL,
    [LakDniNCelk] [float] NULL,	
    [MliekNorCelk] [float] NULL,
    [TukNorCelk] [float] NULL,
    [BielkNorCelk] [float] NULL,
    [LaktozaNCelk] [float] NULL,
	[IPZCelk] [float](5) NULL,
	[VyrZootechCelk] [varchar](4) NULL,
	[VyrZdravDovCelk] [varchar](4) NULL
	)

insert @laktCelkom
select
	@chov as CHOV, 
	@region as Region,
	l.typPlem as typPlem,
	count(*) as PocLakCelk, 
	ROUND(AVG(MEDZIOBD),2) as MedziobdCelk,
	ROUND(AVG(LAKTDNI),2) as LaktdniCelk,
	ROUND(AVG(LAKDNIN),2) as LakdniNCelk,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorCelk,
	ROUND(AVG(TUKNOR),2) as TukNorCelk,
	ROUND(AVG(BIELKNOR),2) as BielkNorCelk,
	ROUND(AVG(LAKTOZAN),2) as LaktozaNCelk,
	AVG(INDPER) as IPZCelk,
	Sum(case when (l.DOVVYR='54' or l.DOVVYR='53' or l.DOVVYR='52' or l.DOVVYR='51' ) then 1 else 0 end) as VyrZootechCelk,
	Sum(case when (l.DOVVYR='55' or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61' or l.DOVVYR='62' ) then 1 else 0 end) as VyrZdravDovCelk

	from @Laktacie as l
	
	where (l.ZMENA = '30' or l.ZMENA='40') 

	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem
	
 --select * from @laktCelkom order by CHOV
  
  Declare @NormLak1 table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Do3500L1] [float](4) NULL,
	[Do4000L1] [float](4) NULL,
	[Do4500L1] [float](4) NULL,
	[Do5000L1] [float](4) NULL,
	[Do5500L1] [float](4) NULL,
	[Do6000L1] [float](4) NULL,
	[Do6500L1] [float](4) NULL,
	[Do7000L1] [float](4) NULL,
	[Do7500L1] [float](4) NULL,
	[Do8000L1] [float](4) NULL,
	[Do8500L1] [float](4) NULL,
	[Do9000L1] [float](4) NULL,
	[Do9500L1] [float](4) NULL,
	[Do10000L1] [float](4) NULL,
	[Do10500L1] [float](4) NULL,
	[Do11000L1] [float](4) NULL,
	[Do11500L1] [float](4) NULL,
	[Do12000L1] [float](4) NULL,
	[Do12500L1] [float](4) NULL,
	[Do13000L1] [float](4) NULL,
	[Do13500L1] [float](4) NULL,
	[Do14000L1] [float](4) NULL,
	[Od14000L1] [float](4) NULL
	)
	
	insert @NormLak1
	select 
	@chov as CHOV, 
	@region as Region,
	l.typPlem as typPlem,
	Sum(case when l.MLIEKNOR<='3500' then 1 else 0 end) as Do3500L1, 
	Sum(case when (l.MLIEKNOR>'3500' and l.MLIEKNOR<='4000') then 1 else 0 end) as Do4000L1, 
	Sum(case when (l.MLIEKNOR>'4000' and l.MLIEKNOR<='4500') then 1 else 0 end) as Do4500L1, 
	Sum(case when (l.MLIEKNOR>'4500' and l.MLIEKNOR<='5000') then 1 else 0 end) as Do5000L1, 
	Sum(case when (l.MLIEKNOR>'5000' and l.MLIEKNOR<='5500') then 1 else 0 end) as Do5500L1, 
	Sum(case when (l.MLIEKNOR>'5500' and l.MLIEKNOR<='6000') then 1 else 0 end) as Do6000L1, 
	Sum(case when (l.MLIEKNOR>'6000' and l.MLIEKNOR<='6500') then 1 else 0 end) as Do6500L1, 
	Sum(case when (l.MLIEKNOR>'6500' and l.MLIEKNOR<='7000') then 1 else 0 end) as Do7000L1, 
	Sum(case when (l.MLIEKNOR>'7000' and l.MLIEKNOR<='7500') then 1 else 0 end) as Do7500L1, 
	Sum(case when (l.MLIEKNOR>'7500' and l.MLIEKNOR<='8000') then 1 else 0 end) as Do8000L1, 
	Sum(case when (l.MLIEKNOR>'8000' and l.MLIEKNOR<='8500') then 1 else 0 end) as Do8500L1, 
	Sum(case when (l.MLIEKNOR>'8500' and l.MLIEKNOR<='9000') then 1 else 0 end) as Do9000L1, 
	Sum(case when (l.MLIEKNOR>'9000' and l.MLIEKNOR<='9500') then 1 else 0 end) as Do9500L1, 
	Sum(case when (l.MLIEKNOR>'9500' and l.MLIEKNOR<='10000') then 1 else 0 end) as Do10000L1, 
	Sum(case when (l.MLIEKNOR>'10000' and l.MLIEKNOR<='10500') then 1 else 0 end) as Do10500L1, 
	Sum(case when (l.MLIEKNOR>'10500' and l.MLIEKNOR<='11000') then 1 else 0 end) as Do11000L1, 
	Sum(case when (l.MLIEKNOR>'11000' and l.MLIEKNOR<='11500') then 1 else 0 end) as Do11500L1, 
	Sum(case when (l.MLIEKNOR>'11500' and l.MLIEKNOR<='12000') then 1 else 0 end) as Do12000L1, 
	Sum(case when (l.MLIEKNOR>'12000' and l.MLIEKNOR<='12500') then 1 else 0 end) as Do12500L1, 
	Sum(case when (l.MLIEKNOR>'12500' and l.MLIEKNOR<='13000') then 1 else 0 end) as Do13000L1, 
	Sum(case when (l.MLIEKNOR>'13000' and  l.MLIEKNOR<='13500') then 1 else 0 end) as DO13500L1, 
	Sum(case when (l.MLIEKNOR>'13500' and l.MLIEKNOR<='14000') then 1 else 0 end) as DO14000L1, 
	Sum(case when l.MLIEKNOR>'14000' then 1 else 0 end) as Od14000L1 
	
	from @Laktacie as l
	
	where 
	l.PORLAK = '1'
	and (l.ZMENA = '30' or l.ZMENA='40')
	
	group by case when @chov is null and @region is null then @chov else
	 case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem
	
	--select * from @NormLak1 order by CHOV

	Declare @NormLak2 table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Do3500L2] [float](4) NULL,
	[Do4000L2] [float](4) NULL,
	[Do4500L2] [float](4) NULL,
	[Do5000L2] [float](4) NULL,
	[Do5500L2] [float](4) NULL,
	[Do6000L2] [float](4) NULL,
	[Do6500L2] [float](4) NULL,
	[Do7000L2] [float](4) NULL,
	[Do7500L2] [float](4) NULL,
	[Do8000L2] [float](4) NULL,
	[Do8500L2] [float](4) NULL,
	[Do9000L2] [float](4) NULL,
	[Do9500L2] [float](4) NULL,
	[Do10000L2] [float](4) NULL,
	[Do10500L2] [float](4) NULL,
	[Do11000L2] [float](4) NULL,
	[Do11500L2] [float](4) NULL,
	[Do12000L2] [float](4) NULL,
	[Do12500L2] [float](4) NULL,
	[Do13000L2] [float](4) NULL,
	[Do13500L2] [float](4) NULL,
	[Do14000L2] [float](4) NULL,
	[Od14000L2] [float](4) NULL
	)
	insert @NormLak2
	select
	@chov as CHOV, 
	@region as Region,
	l.typPlem as typPlem,
	Sum(case when l.MLIEKNOR<='3500' then 1 else 0 end) as Do3500L2, 
	Sum(case when (l.MLIEKNOR>'3500' and l.MLIEKNOR<='4000') then 1 else 0 end) as Do4000L2, 
	Sum(case when (l.MLIEKNOR>'4000' and l.MLIEKNOR<='4500') then 1 else 0 end) as Do4500L2, 
	Sum(case when (l.MLIEKNOR>'4500' and l.MLIEKNOR<='5000') then 1 else 0 end) as Do5000L2, 
	Sum(case when (l.MLIEKNOR>'5000' and l.MLIEKNOR<='5500') then 1 else 0 end) as Do5500L2, 
	Sum(case when (l.MLIEKNOR>'5500' and l.MLIEKNOR<='6000') then 1 else 0 end) as Do6000L2, 
	Sum(case when (l.MLIEKNOR>'6000' and l.MLIEKNOR<='6500') then 1 else 0 end) as Do6500L2, 
	Sum(case when (l.MLIEKNOR>'6500' and l.MLIEKNOR<='7000') then 1 else 0 end) as Do7000L2, 
	Sum(case when (l.MLIEKNOR>'7000' and l.MLIEKNOR<='7500') then 1 else 0 end) as Do7500L2, 
	Sum(case when (l.MLIEKNOR>'7500' and l.MLIEKNOR<='8000') then 1 else 0 end) as Do8000L2, 
	Sum(case when (l.MLIEKNOR>'8000' and l.MLIEKNOR<='8500') then 1 else 0 end) as Do8500L2, 
	Sum(case when (l.MLIEKNOR>'8500' and l.MLIEKNOR<='9000') then 1 else 0 end) as Do9000L2, 
	Sum(case when (l.MLIEKNOR>'9000' and l.MLIEKNOR<='9500') then 1 else 0 end) as Do9500L2, 
	Sum(case when (l.MLIEKNOR>'9500' and l.MLIEKNOR<='10000') then 1 else 0 end) as Do10000L2, 
	Sum(case when (l.MLIEKNOR>'10000' and l.MLIEKNOR<='10500') then 1 else 0 end) as Do10500L2, 
	Sum(case when (l.MLIEKNOR>'10500' and l.MLIEKNOR<='11000') then 1 else 0 end) as Do11000L2, 
	Sum(case when (l.MLIEKNOR>'11000' and l.MLIEKNOR<='11500') then 1 else 0 end) as Do11500L2, 
	Sum(case when (l.MLIEKNOR>'11500' and l.MLIEKNOR<='12000') then 1 else 0 end) as Do12000L2, 
	Sum(case when (l.MLIEKNOR>'12000' and l.MLIEKNOR<='12500') then 1 else 0 end) as Do12500L2, 
	Sum(case when (l.MLIEKNOR>'12500' and l.MLIEKNOR<='13000') then 1 else 0 end) as Do13000L2, 
	Sum(case when (l.MLIEKNOR>'13000' and  l.MLIEKNOR<='13500') then 1 else 0 end) as DO13500L2, 
	Sum(case when (l.MLIEKNOR>'13500' and l.MLIEKNOR<='14000') then 1 else 0 end) as DO14000L2, 
	Sum(case when  l.MLIEKNOR>'14000' then 1 else 0 end) as Od14000L2 
	
	from @Laktacie as l
	
	where 
	l.PORLAK >= '2'
	and (l.ZMENA = '30' or l.ZMENA='40')
	
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem
	
	--select * from @NormLak2 order by CHOV
	
	Declare @NormLakCelk table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Do3500Celk] [float](4) NULL,
	[Do4000Celk] [float](4) NULL,
	[Do4500Celk] [float](4) NULL,
	[Do5000Celk] [float](4) NULL,
	[Do5500Celk] [float](4) NULL,
	[Do6000Celk] [float](4) NULL,
	[Do6500Celk] [float](4) NULL,
	[Do7000Celk] [float](4) NULL,
	[Do7500Celk] [float](4) NULL,
	[Do8000Celk] [float](4) NULL,
	[Do8500Celk] [float](4) NULL,
	[Do9000Celk] [float](4) NULL,
	[Do9500Celk] [float](4) NULL,
	[Do10000Celk] [float](4) NULL,
	[Do10500Celk] [float](4) NULL,
	[Do11000Celk] [float](4) NULL,
	[Do11500Celk] [float](4) NULL,
	[Do12000Celk] [float](4) NULL,
	[Do12500Celk] [float](4) NULL,
	[Do13000Celk] [float](4) NULL,
	[Do13500Celk] [float](4) NULL,
	[Do14000Celk] [float](4) NULL,
	[Od14000Celk] [float](4) NULL
	)

	insert @NormLakCelk
	select
	@chov as CHOV, 
	@region as Region,
	l.typPlem as typPlem,
	Sum(case when l.MLIEKNOR<='3500' then 1 else 0 end) as Do3500Celk, 
	Sum(case when (l.MLIEKNOR>'3500' and l.MLIEKNOR<='4000') then 1 else 0 end) as Do4000Celk, 
	Sum(case when (l.MLIEKNOR>'4000' and l.MLIEKNOR<='4500') then 1 else 0 end) as Do4500Celk, 
	Sum(case when (l.MLIEKNOR>'4500' and l.MLIEKNOR<='5000') then 1 else 0 end) as Do5000Celk, 
	Sum(case when (l.MLIEKNOR>'5000' and l.MLIEKNOR<='5500') then 1 else 0 end) as Do5500Celk, 
	Sum(case when (l.MLIEKNOR>'5500' and l.MLIEKNOR<='6000') then 1 else 0 end) as Do6000Celk, 
	Sum(case when (l.MLIEKNOR>'6000' and l.MLIEKNOR<='6500') then 1 else 0 end) as Do6500Celk, 
	Sum(case when (l.MLIEKNOR>'6500' and l.MLIEKNOR<='7000') then 1 else 0 end) as Do7000Celk, 
	Sum(case when (l.MLIEKNOR>'7000' and l.MLIEKNOR<='7500') then 1 else 0 end) as Do7500Celk, 
	Sum(case when (l.MLIEKNOR>'7500' and l.MLIEKNOR<='8000') then 1 else 0 end) as Do8000Celk, 
	Sum(case when (l.MLIEKNOR>'8000' and l.MLIEKNOR<='8500') then 1 else 0 end) as Do8500Celk, 
	Sum(case when (l.MLIEKNOR>'8500' and l.MLIEKNOR<='9000') then 1 else 0 end) as Do9000Celk, 
	Sum(case when (l.MLIEKNOR>'9000' and l.MLIEKNOR<='9500') then 1 else 0 end) as Do9500Celk, 
	Sum(case when (l.MLIEKNOR>'9500' and l.MLIEKNOR<='10000') then 1 else 0 end) as Do10000Celk, 
	Sum(case when (l.MLIEKNOR>'10000' and l.MLIEKNOR<='10500') then 1 else 0 end) as Do10500Celk, 
	Sum(case when (l.MLIEKNOR>'10500' and l.MLIEKNOR<='11000') then 1 else 0 end) as Do11000Celk, 
	Sum(case when (l.MLIEKNOR>'11000' and l.MLIEKNOR<='11500') then 1 else 0 end) as Do11500Celk, 
	Sum(case when (l.MLIEKNOR>'11500' and l.MLIEKNOR<='12000') then 1 else 0 end) as Do12000Celk, 
	Sum(case when (l.MLIEKNOR>'12000' and l.MLIEKNOR<='12500') then 1 else 0 end) as Do12500Celk, 
	Sum(case when (l.MLIEKNOR>'12500' and l.MLIEKNOR<='13000') then 1 else 0 end) as Do13000Celk, 
	Sum(case when (l.MLIEKNOR>'13000' and  l.MLIEKNOR<='13500') then 1 else 0 end) as DO13500Celk, 
	Sum(case when (l.MLIEKNOR>'13500' and l.MLIEKNOR<='14000') then 1 else 0 end) as DO14000Celk, 
	Sum(case when l.MLIEKNOR>'14000' then 1 else 0 end) as Od14000Celk 
	
	from @Laktacie as l
	
	where 
	(l.ZMENA = '30' or l.ZMENA='40')
	
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem
	
	--select * from @NormLakCelk order by CHOV

	Declare @ZmenaL1 table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Zmena10L1] [float](4) NULL,
	[Zmena30L1] [float](4) NULL,
	[Zmena31L1] [float](4) NULL,
	[Zmena40L1] [float](4) NULL,
	[Zmena41L1] [float](4) NULL,
	[Zmena42L1] [float](4) NULL,
	[Zmena43L1] [float](4) NULL,
	[ZmenaCelk1L1] [float](4) NULL,
	[Zmena51L1] [float](4) NULL,
	[Zmena52L1] [float](4) NULL,
	[Zmena53L1] [float](4) NULL,
	[Zmena54L1] [float](4) NULL,
	[Zmena55L1] [float](4) NULL,
	[Zmena56L1] [float](4) NULL,
	[Zmena57L1] [float](4) NULL,
	[Zmena58L1] [float](4) NULL,
	[Zmena59L1] [float](4) NULL,
	[Zmena60L1] [float](4) NULL,
	[Zmena61L1] [float](4) NULL,
	[Zmena62L1] [float](4) NULL,
	[ZmenaCelk2L1] [float](4) NULL
	)
	insert @ZmenaL1
	select
	@chov as CHOV, 
	@region as Region,
	l.typPlem as typPlem,
	Sum(case when l.ZMENA='10' then 1 else 0 end) as Zmena10L1, 
	Sum(case when l.ZMENA='30' then 1 else 0 end) as Zmena30L1, 
	Sum(case when l.ZMENA='31' then 1 else 0 end) as Zmena31L1, 
	Sum(case when l.ZMENA='40' then 1 else 0 end) as Zmena40L1, 
	Sum(case when l.ZMENA='41' then 1 else 0 end) as Zmena41L1, 
	Sum(case when l.ZMENA='42' then 1 else 0 end) as Zmena42L1, 
	Sum(case when l.ZMENA='43' then 1 else 0 end) as Zmena43L1, 
	Sum(case when (l.ZMENA='10' or l.ZMENA='30' or l.ZMENA='31' or l.ZMENA='40' or l.ZMENA='41' 
	or l.ZMENA='42' or l.ZMENA='43') then 1 else 0 end) as ZmenaCelk1L1, 
	Sum(case when l.DOVVYR='51' then 1 else 0 end) as Zmena51L1, 
	Sum(case when l.DOVVYR='52' then 1 else 0 end) as Zmena52L1, 
	Sum(case when l.DOVVYR='53' then 1 else 0 end) as Zmena53L1, 
	Sum(case when l.DOVVYR='54' then 1 else 0 end) as Zmena54L1, 
	Sum(case when l.DOVVYR='55' then 1 else 0 end) as Zmena55L1, 
	Sum(case when l.DOVVYR='56' then 1 else 0 end) as Zmena56L1, 
	Sum(case when l.DOVVYR='57' then 1 else 0 end) as Zmena57L1, 
	Sum(case when l.DOVVYR='58' then 1 else 0 end) as Zmena58L1, 
	Sum(case when l.DOVVYR='59' then 1 else 0 end) as Zmena59L1, 
	Sum(case when l.DOVVYR='60' then 1 else 0 end) as Zmena60L1, 
	Sum(case when l.DOVVYR='61' then 1 else 0 end) as Zmena61L1, 
	Sum(case when l.DOVVYR='62' then 1 else 0 end) as Zmena62L1, 
	Sum(case when (l.DOVVYR='51' or l.DOVVYR='52' or l.DOVVYR='53' or l.DOVVYR='54' or l.DOVVYR='55' 
	or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61' or l.DOVVYR='62' ) then 1 else 0 end) as ZmenaCelk2L1 

	from @Laktacie as l
	
	where 
	PORLAK='1'
	 
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem
	
	--select * from @ZmenaL1 order by CHOV
	
	Declare @ZmenaL2 table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Zmena10L2] [float](4) NULL,
	[Zmena30L2] [float](4) NULL,
	[Zmena31L2] [float](4) NULL,
	[Zmena40L2] [float](4) NULL,
	[Zmena41L2] [float](4) NULL,
	[Zmena42L2] [float](4) NULL,
	[Zmena43L2] [float](4) NULL,
	[ZmenaCelk1L2] [float](4) NULL,
	[Zmena51L2] [float](4) NULL,
	[Zmena52L2] [float](4) NULL,
	[Zmena53L2] [float](4) NULL,
	[Zmena54L2] [float](4) NULL,
	[Zmena55L2] [float](4) NULL,
	[Zmena56L2] [float](4) NULL,
	[Zmena57L2] [float](4) NULL,
	[Zmena58L2] [float](4) NULL,
	[Zmena59L2] [float](4) NULL,
	[Zmena60L2] [float](4) NULL,
	[Zmena61L2] [float](4) NULL,
	[Zmena62L2] [float](4) NULL,
	[ZmenaCelk2L2] [float](4) NULL
	)
	insert @ZmenaL2
	select
	@chov as CHOV, 
	@region as Region,
	l.typPlem as typPlem,

	Sum(case when l.ZMENA='10' then 1 else 0 end) as Zmena10L2, 
	Sum(case when l.ZMENA='30' then 1 else 0 end) as Zmena30L2, 
	Sum(case when l.ZMENA='31' then 1 else 0 end) as Zmena31L2, 
	Sum(case when l.ZMENA='40' then 1 else 0 end) as Zmena40L2, 
	Sum(case when l.ZMENA='41' then 1 else 0 end) as Zmena41L2, 
	Sum(case when l.ZMENA='42' then 1 else 0 end) as Zmena42L2, 
	Sum(case when l.ZMENA='43' then 1 else 0 end) as Zmena43L2, 
	Sum(case when (l.ZMENA='10' or l.ZMENA='30' or l.ZMENA='31' or l.ZMENA='40' or l.ZMENA='41' 
	or l.ZMENA='42' or l.ZMENA='43') then 1 else 0 end) as ZmenaCelk1L2, 
	Sum(case when l.DOVVYR='51' then 1 else 0 end) as Zmena51L2, 
	Sum(case when l.DOVVYR='52' then 1 else 0 end) as Zmena52L2, 
	Sum(case when l.DOVVYR='53' then 1 else 0 end) as Zmena53L2, 
	Sum(case when l.DOVVYR='54' then 1 else 0 end) as Zmena54L2, 
	Sum(case when l.DOVVYR='55' then 1 else 0 end) as Zmena55L2, 
	Sum(case when l.DOVVYR='56' then 1 else 0 end) as Zmena56L2, 
	Sum(case when l.DOVVYR='57' then 1 else 0 end) as Zmena57L2, 
	Sum(case when l.DOVVYR='58' then 1 else 0 end) as Zmena58L2, 
	Sum(case when l.DOVVYR='59' then 1 else 0 end) as Zmena59L2, 
	Sum(case when l.DOVVYR='60' then 1 else 0 end) as Zmena60L2, 
	Sum(case when l.DOVVYR='61' then 1 else 0 end) as Zmena61L2, 
	Sum(case when l.DOVVYR='62' then 1 else 0 end) as Zmena62L2, 
	Sum(case when (l.DOVVYR='51' or l.DOVVYR='52' or l.DOVVYR='53' or l.DOVVYR='54' or l.DOVVYR='55' 
	or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61' or l.DOVVYR='62') then 1 else 0 end) as ZmenaCelk2L2 

	from @Laktacie as l
	
	where 
	PORLAK>='2'
	
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end,l.typPlem
	
	--select * from @ZmenaL2 order by CHOV

	Declare @ZmenaCelk table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Zmena10Celk] [float](4) NULL,
	[Zmena30Celk] [float](4) NULL,
	[Zmena31Celk] [float](4) NULL,
	[Zmena40Celk] [float](4) NULL,
	[Zmena41Celk] [float](4) NULL,
	[Zmena42Celk] [float](4) NULL,
	[Zmena43Celk] [float](4) NULL,
	[ZmenaCelk1Celk] [float](4) NULL,
	[Zmena51Celk] [float](4) NULL,
	[Zmena52Celk] [float](4) NULL,
	[Zmena53Celk] [float](4) NULL,
	[Zmena54Celk] [float](4) NULL,
	[Zmena55Celk] [float](4) NULL,
	[Zmena56Celk] [float](4) NULL,
	[Zmena57Celk] [float](4) NULL,
	[Zmena58Celk] [float](4) NULL,
	[Zmena59Celk] [float](4) NULL,
	[Zmena60Celk] [float](4) NULL,
	[Zmena61Celk] [float](4) NULL,
	[Zmena62Celk] [float](4) NULL,
	[ZmenaCelk2Celk] [float](4) NULL
	)

	insert @ZmenaCelk
	select
	@chov as CHOV, 
	@region as Region,
	l.typPlem as typPlem,
	Sum(case when l.ZMENA='10' then 1 else 0 end) as Zmena10Celk, 
	Sum(case when l.ZMENA='30' then 1 else 0 end) as Zmena30Celk, 
	Sum(case when l.ZMENA='31' then 1 else 0 end) as Zmena31Celk, 
	Sum(case when l.ZMENA='40' then 1 else 0 end) as Zmena40Celk, 
	Sum(case when l.ZMENA='41' then 1 else 0 end) as Zmena41Celk, 
	Sum(case when l.ZMENA='42' then 1 else 0 end) as Zmena42Celk, 
	Sum(case when l.ZMENA='43' then 1 else 0 end) as Zmena43Celk, 
	Sum(case when (l.ZMENA='10' or l.ZMENA='30' or l.ZMENA='31' or l.ZMENA='40' or l.ZMENA='41' 
	or l.ZMENA='42' or l.ZMENA='43') then 1 else 0 end) as ZmenaCelk1Celk, 
	Sum(case when l.DOVVYR='51' then 1 else 0 end) as Zmena51Celk, 
	Sum(case when l.DOVVYR='52' then 1 else 0 end) as Zmena52Celk, 
	Sum(case when l.DOVVYR='53' then 1 else 0 end) as Zmena53Celk, 
	Sum(case when l.DOVVYR='54' then 1 else 0 end) as Zmena54Celk, 
	Sum(case when l.DOVVYR='55' then 1 else 0 end) as Zmena55Celk, 
	Sum(case when l.DOVVYR='56' then 1 else 0 end) as Zmena56Celk, 
	Sum(case when l.DOVVYR='57' then 1 else 0 end) as Zmena57Celk, 
	Sum(case when l.DOVVYR='58' then 1 else 0 end) as Zmena58Celk, 
	Sum(case when l.DOVVYR='59' then 1 else 0 end) as Zmena59Celk, 
	Sum(case when l.DOVVYR='60' then 1 else 0 end) as Zmena60Celk, 
	Sum(case when l.DOVVYR='61' then 1 else 0 end) as Zmena61Celk, 
	Sum(case when l.DOVVYR='62' then 1 else 0 end) as Zmena62Celk, 
	Sum(case when (l.DOVVYR='51' or l.DOVVYR='52' or l.DOVVYR='53' or l.DOVVYR='54' or l.DOVVYR='55' 
	or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61' or l.DOVVYR='62') then 1 else 0 end) as ZmenaCelk2Celk 

	from @Laktacie as l
	
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l.CHOVATEL, 1, len(@chov))) end end, l.typPlem
	
	--select * from @ZmenaCelk order by CHOV


insert CR_LaktacneZostavy_Opr
	(
	Oznacenie,DatumOd,DatumDo,Filter, datumGenerovania, Region,PlemTyp, EkoChov,

	PocZapojL1, PocLakV1, PocLakN1, MedziobdL1,LakdniL1,LakdniNL1,MliekNorL1,TukNorL1, BielkNorL1,	LaktozaNL1, IPZL1, VyrZootechL1, VyrZdravDovL1,
	
	PocZapojL2, PocLakV2,PocLakN2,MedziobdL2,LaktDniL2,LakDniNL2,MliekNorL2,TukNorL2, BielkNorL2, LaktozaNL2, IPZL2, VyrZootechL2, VyrZdravDovL2,

	PocZapojCelk,PocLakVcelk,PocLakNcelk,MedziobdCelk,LaktDniCelk, LakDniNCelk, MliekNorCelk,TukNorCelk, BielkNorCelk, LaktozaNCelk, IPZCelk, VyrZootechCelk, VyrZdravDovCelk,

	Do3500L1,Do4000L1,Do4500L1, Do5000L1,Do5500L1, Do6000L1, Do6500L1, Do7000L1, Do7500L1, Do8000L1, Do8500L1,
	Do9000L1, Do9500L1, Do10000L1, Do10500L1, Do11000L1, Do11500L1,Do12000L1,Do12500L1, Do13000L1,Do13500L1, Do14000L1, Od14000L1,
	 
	Do3500L2, Do4000L2, Do4500L2, Do5000L2, Do5500L2, Do6000L2, Do6500L2, Do7000L2, Do7500L2, Do8000L2,Do8500L2, Do9000L2,Do9500L2, 
	Do10000L2, Do10500L2, Do11000L2, Do11500L2, Do12000L2, Do12500L2, Do13000L2,Do13500L2, Do14000L2, Od14000L2,
	 
	Do3500Celk, Do4000Celk, Do4500Celk, Do5000Celk, Do5500Celk, Do6000Celk, Do6500Celk, Do7000Celk,	Do7500Celk, Do8000Celk, Do8500Celk,
	Do9000Celk, Do9500Celk,Do10000Celk, Do10500Celk,Do11000Celk, Do11500Celk,Do12000Celk, Do12500Celk, Do13000Celk, Do13500Celk, Do14000Celk, Od14000Celk,

	Zmena10L1, Zmena30L1,Zmena31L1,Zmena40L1,Zmena41L1,	Zmena42L1,Zmena43L1,ZmenaCelk1L1,Zmena51L1,Zmena52L1,Zmena53L1,Zmena54L1,Zmena55L1,Zmena56L1,Zmena57L1,
	Zmena58L1,Zmena59L1,Zmena60L1,Zmena61L1,Zmena62L1,ZmenaCelk2L1,

	Zmena10L2, Zmena30L2,Zmena31L2,Zmena40L2,Zmena41L2,	Zmena42L2,Zmena43L2,ZmenaCelk1L2,Zmena51L2,Zmena52L2,Zmena53L2,Zmena54L2,Zmena55L2,Zmena56L2,Zmena57L2,
	Zmena58L2,Zmena59L2,Zmena60L2,Zmena61L2,Zmena62L2,ZmenaCelk2L2,
	
	Zmena10Celk, Zmena30Celk,Zmena31Celk,Zmena40Celk,Zmena41Celk,	Zmena42Celk,Zmena43Celk,ZmenaCelk1Celk,Zmena51Celk,Zmena52Celk,Zmena53Celk,Zmena54Celk,Zmena55Celk,Zmena56Celk,Zmena57Celk,
	Zmena58Celk,Zmena59Celk,Zmena60Celk,Zmena61Celk,Zmena62Celk,ZmenaCelk2Celk
	)

	select distinct
	
	(Select distinct case when @chov is null and @region is null then ('SR') else
	case when @chov is null then ('R'+ @region) else  @chov end end)as Oznacenie,
	@datumOd as DatumOd,
	@datumDo as DatumDo,
	
	(Select distinct case when @chov is null and @region is null then ('SR') else
	case when @chov is null then ('R'+ @region) else  @chov end end) +','+l.typPlem as Filer,
	getdate() as datumGenerovania,
	@region as Region,
	
	l.typPlem as PlemTyp,
	l.EkoChov as EkoChov,
	ZapojL1.PocZapojL1 as PocZapojL1,
	ROUND(LAKV1.PocLakV1,2) as PocLakV1, 
	ROUND(L1.PocLakN1,2) as PocLakN1, 
	convert(varchar, round(L1.MEDZIOBDL1 / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, L1.MedziobdL1) % 30.42, 0)) ) AS  MedziobdL1,
	ROUND(L1.LakdniL1,2) as LakdniL1,
	ROUND(L1.LakdniNL1,2) as LakdniNL1,
	ROUND(L1.MliekNorL1,2) as MliekNorL1,
	ROUND(L1.TukNorL1,2) as TukNorL1,
	ROUND(L1.BielkNorL1,2) as BielkNorL1 ,
	ROUND(L1.LaktozaNL1,2) as LaktozaNL1, 
	ROUND(L1.IPZL1,2) as IPZL1,
	L1.VyrZootechL1 as VyrZootechL1,
	L1.VyrZdravDovL1 as VyrZdravDovL1,

	ZapojL2.PocZapojL2 as PocZapojL2, 
	ROUND(LAKV2.PocLakV2,2) as PocLakV2,
	ROUND(L2.PocLakN2,2) as PocLakN2,
	ROUND(L2.MedziobdL2,2) as MedziobdL2,
	ROUND(L2.LaktDniL2,2) as LaktDniL2,
	ROUND(L2.LakDniNL2,2) as LakDniNL2,
	ROUND(L2.MliekNorL2,2) as MliekNorL2,
	ROUND(L2.TukNorL2,2) as TukNorL2,
	ROUND(L2.BielkNorL2,2) as BielkNorL2,
	ROUND(L2.LaktozaNL2,2) as LaktozaNL2,
	ROUND(L2.IPZL2,2) as IPZL2,
	L2.VyrZootechL2 as VyrZootechL2,
	L2.VyrZdravDovL2 as VyrZdravDovL2,

	ZapojLCelk.PocZapojLCelk as PocZapojCelk, 
	ROUND(LAKVC.PocLakVcelk,2) as PocLakVcelk,
	ROUND(lCelk.PocLakNcelk,2) as PocLakNcelk,
	ROUND(lCelk.MedziobdCelk,2) as MedziobdCelk,
	ROUND(lCelk.LaktDniCelk,2) as LaktDniCelk,
	ROUND(lCelk.LakDniNCelk,2) as LakDniNCelk,
	ROUND(lCelk.MliekNorCelk,2) as MliekNorCelk,
	ROUND(lCelk.TukNorCelk,2) as TukNorCelk,
	ROUND(lCelk.BielkNorCelk,2) as BielkNorCelk,
	ROUND(lCelk.LaktozaNCelk,2) as LaktozaNCelk,
	ROUND(lCelk.IPZCelk,2) as IPZCelk,
	lCelk.VyrZootechCelk as VyrZootechCelk,
	lCelk.VyrZdravDovCelk as VyrZdravDovCelk,

	NL1.Do3500L1 AS Do3500L1,
	NL1.Do4000L1 as Do4000L1,
	NL1.Do4500L1 as Do4500L1,
	NL1.Do5000L1 as Do5000L1,
	NL1.Do5500L1 as Do5500L1,
	NL1.Do6000L1 as Do6000L1,
	NL1.Do6500L1 as Do6500L1,
	NL1.Do7000L1 as Do7000L1,
	NL1.Do7500L1 as Do7500L1,
	NL1.Do8000L1 as Do8000L1,
	NL1.Do8500L1 as Do8500L1,
	NL1.Do9000L1 as Do9000L1,
	NL1.Do9500L1 as Do9500L1,
	NL1.Do10000L1 as Do10000L1,
	NL1.Do10500L1 as Do10500L1,
	NL1.Do11000L1 as Do11000L1,
	NL1.Do11500L1 as Do11500L1,
	NL1.Do12000L1 as Do12000L1,
	NL1.Do12500L1 as Do12500L1,
	NL1.Do13000L1 as Do13000L1,
	NL1.Do13500L1 as Do13500L1,
	NL1.Do14000L1 as Do14000L1,
	NL1.Od14000L1 as Od14000L1,
	 
	NL2.Do3500L2 AS Do3500L2,
	NL2.Do4000L2 as Do4000L2,
	NL2.Do4500L2 as Do4500L2,
	NL2.Do5000L2 as Do5000L2,
	NL2.Do5500L2 as Do5500L2,
	NL2.Do6000L2 as Do6000L2,
	NL2.Do6500L2 as Do6500L2,
	NL2.Do7000L2 as Do7000L2,
	NL2.Do7500L2 as Do7500L2,
	NL2.Do8000L2 as Do8000L2,
	NL2.Do8500L2 as Do8500L2,
	NL2.Do9000L2 as Do9000L2,
	NL2.Do9500L2 as Do9500L2,
	NL2.Do10000L2 as Do10000L2,
	NL2.Do10500L2 as Do10500L2,
	NL2.Do11000L2 as Do11000L2,
	NL2.Do11500L2 as Do11500L2,
	NL2.Do12000L2 as Do12000L2,
	NL2.Do12500L2 as Do12500L2,
	NL2.Do13000L2 as Do13000L2,
	NL2.Do13500L2 as Do13500L2,
	NL2.Do14000L2 as Do14000L2,
	NL2.Od14000L2 as Od14000L2,
	 
	NlCelk.Do3500Celk AS Do3500Celk,
	NlCelk.Do4000Celk as Do4000Celk,
	NlCelk.Do4500Celk as Do4500Celk,
	NlCelk.Do5000Celk as Do5000Celk,
	NlCelk.Do5500Celk as Do5500Celk,
	NlCelk.Do6000Celk as Do6000Celk,
	NlCelk.Do6500Celk as Do6500Celk,
	NlCelk.Do7000Celk as Do7000Celk,
	NlCelk.Do7500Celk as Do7500Celk,
	NlCelk.Do8000Celk as Do8000Celk,
	NlCelk.Do8500Celk as Do8500Celk,
	NlCelk.Do9000Celk as Do9000Celk,
	NlCelk.Do9500Celk as Do9500Celk,
	NlCelk.Do10000Celk as Do10000Celk,
	NlCelk.Do10500Celk as Do10500Celk,
	NlCelk.Do11000Celk as Do11000Celk,
	NlCelk.Do11500Celk as Do11500Celk,
	NlCelk.Do12000Celk as Do12000Celk,
	NlCelk.Do12500Celk as Do12500Celk,
	NlCelk.Do13000Celk as Do13000Celk,
	NlCelk.Do13500Celk as Do13500Celk,
	NlCelk.Do14000Celk as Do14000Celk,
	NlCelk.Od14000Celk as Od14000Celk, 

	ZL1.Zmena10L1 as Zmena10L1, 
	ZL1.Zmena30L1 as Zmena30L1,
	ZL1.Zmena31L1 as Zmena31L1,
	ZL1.Zmena40L1 as Zmena40L1,
	ZL1.Zmena41L1 as Zmena41L1,	
	ZL1.Zmena42L1 as Zmena42L1,
	ZL1.Zmena43L1 as Zmena43L1,
	ZL1.ZmenaCelk1L1 as ZmenaCelk1L1,
	ZL1.Zmena51L1 as Zmena51L1,
	ZL1.Zmena52L1 as Zmena52L1,
	ZL1.Zmena53L1 as Zmena53L1,
	ZL1.Zmena54L1 as Zmena54L1,
	ZL1.Zmena55L1 as Zmena55L1,
	ZL1.Zmena56L1 as Zmena56L1,
	ZL1.Zmena57L1 as Zmena57L1,
	ZL1.Zmena58L1 as Zmena58L1,
	ZL1.Zmena59L1 as Zmena59L1,
	ZL1.Zmena60L1 as Zmena60L1,
	ZL1.Zmena61L1 as Zmena61L1,
	ZL1.Zmena62L1 as Zmena62L1,
	ZL1.ZmenaCelk2L1 asZmenaCelk2L1,

	ZL2.Zmena10L2 as Zmena10L2, 
	ZL2.Zmena30L2 as Zmena30L2,
	ZL2.Zmena31L2 as Zmena31L2,
	ZL2.Zmena40L2 as Zmena40L2,
	ZL2.Zmena41L2 as Zmena41L2,	
	ZL2.Zmena42L2 as Zmena42L2,
	ZL2.Zmena43L2 as Zmena43L2,
	ZL2.ZmenaCelk1L2 as ZmenaCelk1L2,
	ZL2.Zmena51L2 as Zmena51L2,
	ZL2.Zmena52L2 as Zmena52L2,
	ZL2.Zmena53L2 as Zmena53L2,
	ZL2.Zmena54L2 as Zmena54L2,
	ZL2.Zmena55L2 as Zmena55L2,
	ZL2.Zmena56L2 as Zmena56L2,
	ZL2.Zmena57L2 as Zmena57L2,
	ZL2.Zmena58L2 as Zmena58L2,
	ZL2.Zmena59L2 as Zmena59L2,
	ZL2.Zmena60L2 as Zmena60L2,
	ZL2.Zmena61L2 as Zmena61L2,
	ZL2.Zmena62L2 as Zmena62L2,
	ZL2.ZmenaCelk2L2 asZmenaCelk2L2,

	ZCelk.Zmena10Celk as Zmena10Celk, 
	ZCelk.Zmena30Celk as Zmena30Celk,
	ZCelk.Zmena31Celk as Zmena31Celk,
	ZCelk.Zmena40Celk as Zmena40Celk,
	ZCelk.Zmena41Celk as Zmena41Celk,	
	ZCelk.Zmena42Celk as Zmena42Celk,
	ZCelk.Zmena43Celk as Zmena43Celk,
	ZCelk.ZmenaCelk1Celk as ZmenaCelk1Celk,
	ZCelk.Zmena51Celk as Zmena51Celk,
	ZCelk.Zmena52Celk as Zmena52Celk,
	ZCelk.Zmena53Celk as Zmena53Celk,
	ZCelk.Zmena54Celk as Zmena54Celk,
	ZCelk.Zmena55Celk as Zmena55Celk,
	ZCelk.Zmena56Celk as Zmena56Celk,
	ZCelk.Zmena57Celk as Zmena57Celk,
	ZCelk.Zmena58Celk as Zmena58Celk,
	ZCelk.Zmena59Celk as Zmena59Celk,
	ZCelk.Zmena60Celk as Zmena60Celk,
	ZCelk.Zmena61Celk as Zmena61Celk,
	ZCelk.Zmena62Celk as Zmena62Celk,
	ZCelk.ZmenaCelk2Celk as ZmenaCelk2Celk
	 
	from @Laktacie as l

	left outer join @PocZapojL1 ZapojL1 on ((ZapojL1.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null) and ZapojL1.typPlem=l.typPlem)
	left outer  join @PocZapojL2 ZapojL2 on ((ZapojL2.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null) and ZapojL2.typPlem=l.typPlem)
	left outer  join @PocZapojLCelk  ZapojLCelk on ((ZapojLCelk.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null) and ZapojLCelk.typPlem=l.typPlem)
	left outer  join @pocLAKV1  LAKV1 on ((LAKV1.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null) and LAKV1.typPlem=l.typPlem)
	left outer  join @pocLAKV2  LAKV2 on ((LAKV2.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null) and LAKV2.typPlem=l.typPlem)
	left outer join @pocLAKVCelk LAKVC on ((LAKVC.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null) and LAKVC.typPlem=l.typPlem)
	left outer  join @lakt1  L1 on ((L1.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null) and L1.typPlem=l.typPlem)
	left outer  join @lakt2  L2 on ((substring(l.CHOVATEL, 1, len(@chov))= L2.CHOV or @chov is null)and L2.typPlem=l.typPlem)
	left outer  join @laktCelkom as lCelk on (( substring(l.CHOVATEL, 1, len(@chov))= lCelk.CHOV or @chov is null)and lCelk.typPlem=l.typPlem)
	left outer  join @NormLak1  NL1 on ((NL1.CHOV =  substring(l.CHOVATEL, 1, len(@chov)) or @chov is null)and NL1.typPlem=l.typPlem)
	left outer  join @NormLak2  NL2 on ((substring(l.CHOVATEL, 1, len(@chov))= NL2.CHOV or @chov is null)and NL2.typPlem=l.typPlem)
	left outer  join @NormLakCelk as NlCelk on ((substring(CHOVATEL, 1, len(@chov))= NlCelk.CHOV or @chov is null)and NlCelk.typPlem=l.typPlem)
	left outer  join @ZmenaL1 as ZL1 on ((substring(l.CHOVATEL, 1, len(@chov))= ZL1.CHOV or @chov is null)and ZL1.typPlem=l.typPlem)
	left outer  join @ZmenaL2 as ZL2 on ((substring(l.CHOVATEL, 1, len(@chov))= ZL2.CHOV or @chov is null)and ZL2.typPlem=l.typPlem)
	left outer  join @ZmenaCelk as ZCelk on ((substring(l.CHOVATEL, 1, len(@chov))= ZCelk.CHOV or @chov is null)and ZCelk.typPlem=l.typPlem)
	left outer  join  NC_OKRES as reg on ((reg.KRAJ + reg.OKRES)= substring(l.CHOVATEL, 1, 3) or @chov is null)
	
	--where (substring(l.CHOVATEL, 1, len(@chov))=@chov or @chov is null) and (l.Region=@region or @region is null) and (l.PLEM=@plem or @plem is null)
	
	--select * from plis.dbo.CR_LaktacneZostavy --order by Oznacenie
	--where (Oznacenie= @chov or @chov is null )
	--and DatumOd=@datumOd and DatumDo = @datumDo and (REGION = @region or @region is null) and (PlemTyp=@plem or @plem is null)
	
/*****************************************/

	declare @PocZapojL1_Vs table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocZapojL1] int NULL
	)

	Insert @PocZapojL1_Vs
	select 
		@chov as CHOV, 
		@region as Region,
		typPlem as typPlem, 
		count(k_Vs.ciskravy) as PocZapojL1
	--from CM_Krava as k
	from @kravy_Vs as k_Vs

	 where 	k_Vs.PORPREBLAK ='1'
 	group by 
		case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(k_Vs.CHOV, 1, len(@chov))) end end,k_Vs.typPlem
		
----select * from @PocZapojL1 

declare @PocZapojL2_Vs table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocZapojL2] int NULL
	)

	Insert @PocZapojL2_Vs
	select 
		@chov as CHOV, 
		@region as Region,
		typPlem as typPlem, 
		count(k_Vs.ciskravy) as PocZapojL2
	from @kravy_Vs as k_Vs
	

	where k_Vs.PORPREBLAK >='2'
 	
	group by 
		case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(k_Vs.CHOV, 1, len(@chov))) end end,k_Vs.typPlem 

----select * from @PocZapojL2 

declare @PocZapojLCelk_Vs table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocZapojLCelk] int NULL
	)

	Insert @PocZapojLCelk_Vs
	select 
		@chov as CHOV, 
		@region as Region,
		typPlem as typPlem, 
		count(k_Vs.ciskravy) as PocZapojLCelk

	from @kravy_Vs as k_Vs

	group by 
		case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(k_Vs.CHOV, 1, len(@chov))) end end,typPlem

----select * from @PocZapojL1 


declare @pocLAKV1_Vs table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakV1] [float](4) NULL
)

	Insert @pocLAKV1_Vs
	select 
	@chov as CHOV, 
	@region as Region,
	typPlem as typPlem, 
	count(*) as PocLakV1

	from @Laktacie_Vs as l_Vs	where PORLAK = '1'

	group by  case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem

	--select * from @pocLAKV1 


declare @pocLAKV2_Vs table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakV2] [float](4) NULL
)
	Insert @pocLAKV2_Vs
	select 
	@chov as CHOV, 
	@region as Region,
	typPlem as typPlem, 
	count(*) as PocLakV2

	from @Laktacie_Vs as l_Vs	where PORLAK >= '2'

	group by case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem

	--select * from @pocLAKV2

declare @pocLAKVCelk_Vs table
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakVCelk] [float](4) NULL
)

	Insert @pocLAKVCelk_Vs
	select 
	@chov as CHOV, 
	@region as Region,
	typPlem as typPlem, 
	count(*) as PocLakVCelk

	from @Laktacie_Vs as l_Vs
		
	group by  case when @chov is null and @region is null then @chov	
		else
		case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem

	--select * from @pocLAKVCelk 

Declare @lakt1_Vs table
	
	([CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakN1] [float](4) NULL,
	[MedziobdL1] [float](7) NULL,
    [LakdniL1] [float](7) NULL,
    [LakdniNL1] [float](7) NULL,	
    [MliekNorL1] [float](9) NULL,
    [TukNorL1] [float](7) NULL,
    [BielkNorL1] [float](7) NULL,
    [LaktozaNL1] [float](7) NULL, 
	[IPZL1] [float](5) NULL,
	[VyrZootechL1] [varchar](4) NULL,
	[VyrZdravDovL1] [varchar](4) NULL
	)

	Insert into @lakt1_Vs
	(CHOV,Region,typPlem, PocLakN1, MedziobdL1, LakdniL1, LakdniNL1, MliekNorL1, TukNorL1, BielkNorL1, LaktozaNL1, IPZL1, 
	VyrZootechL1,VyrZdravDovL1 )
	
select 
	@chov as CHOV, 
	@region as Region,
	l_Vs.typPlem as typPlem,
	count(*)  as PocLakN1, 
	ROUND(AVG(MEDZIOBD),2)  as MedziobdL1,
	ROUND(AVG(LAKTDNI),2) as LaktdniL1,
	ROUND(AVG(LAKDNIN),2)as LakdniNL1,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorL1,
	ROUND(AVG(TUKNOR),2)as TukNorL1,
	ROUND(AVG(BIELKNOR),2) as BielkNorL1,
	ROUND(AVG(LAKTOZAN),2) as LaktozaNL1,
	AVG(INDPER) as IPZL1,
	Sum(case when (l_Vs.DOVVYR='54' or l_Vs.DOVVYR='53' or l_Vs. DOVVYR='52' or l_Vs.DOVVYR='51' ) then 1 else 0 end) as VyrZootechL1,
	Sum(case when (l_Vs.DOVVYR='55' or l_Vs.DOVVYR='56' or l_Vs.DOVVYR='57' or l_Vs.DOVVYR='58' or l_Vs.DOVVYR='59' or l_Vs.DOVVYR='60' or l_Vs.DOVVYR='61' or l_Vs.DOVVYR='62' ) then 1 else 0 end) as VyrZdravDovL1

	from @Laktacie_Vs as l_Vs
		where  PORLAK = '1'
		and (l_Vs.ZMENA = '30' or l_Vs.ZMENA='40') 

	group by  case when @chov is null and @region is null then @chov	
				   else
					case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem
	
	--select * from @lakt1  
	
  Declare @lakt2_Vs table
  ( [CHOV] [varchar](9) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	--[PocLakV2] [float](4) NULL,
	[PocLakN2] [float](4) NULL,
	[MedziobdL2] [float](7) NULL,
    [LaktDniL2] [float](7) NULL,
    [LakDniNL2] [float](7) NULL,	
    [MliekNorL2] [float](9) NULL,
    [TukNorL2] [float](7) NULL,
    [BielkNorL2] [float](7) NULL,
    [LaktozaNL2] [float](7) NULL,
	[IPZL2] [float](5) NULL,
	[VyrZootechL2] [varchar](4) NULL,
	[VyrZdravDovL2] [varchar](4) NULL
	)
 insert @lakt2_Vs
 select
	@chov as CHOV, 
	@region as Region,
	l_Vs.typPlem as typPlem,
	count(*) as PocLakN2, 
	ROUND(AVG(MEDZIOBD),2) as MedziobdL2,
	ROUND(AVG(LAKTDNI),2)as LaktdniL2,
	ROUND(AVG(LAKDNIN),2)as LakdniNL2,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorL2,
	ROUND(AVG(TUKNOR),2)as TukNorL2,
	ROUND(AVG(BIELKNOR),2) as BielkNorL2,
	ROUND(AVG(LAKTOZAN),2) as LaktozaNL2,
	AVG(INDPER) as IPZL2,
	Sum(case when (l_Vs.DOVVYR='54' or l_Vs.DOVVYR='53' or l_Vs.DOVVYR='52' or l_Vs.DOVVYR='51' ) then 1 else 0 end) as VyrZootechL2,
	Sum(case when (l_Vs.DOVVYR='55' or l_Vs.DOVVYR='56' or l_Vs.DOVVYR='57' or l_Vs.DOVVYR='58' or l_Vs.DOVVYR='59' or l_Vs.DOVVYR='60' or l_Vs.DOVVYR='61' or l_Vs.DOVVYR='62') then 1 else 0 end) as VyrZdravDovL2

	from @Laktacie_Vs as l_Vs
	where 
	PORLAK >= '2'
	and (l_Vs.ZMENA = '30' or l_Vs.ZMENA='40') 

	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem
	
 --select * from @lakt2 order by CHOV

  Declare @laktCelkom_Vs table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[PocLakNcelk] [float] NULL,
	[MedziobdCelk] [float] NULL,
    [LaktDniCelk] [float] NULL,
    [LakDniNCelk] [float] NULL,	
    [MliekNorCelk] [float] NULL,
    [TukNorCelk] [float] NULL,
    [BielkNorCelk] [float] NULL,
    [LaktozaNCelk] [float] NULL,
	[IPZCelk] [float](5) NULL,
	[VyrZootechCelk] [varchar](4) NULL,
	[VyrZdravDovCelk] [varchar](4) NULL
	)

insert @laktCelkom_Vs
select
	@chov as CHOV, 
	@region as Region,
	l_Vs.typPlem as typPlem,
	count(*) as PocLakCelk, 
	ROUND(AVG(MEDZIOBD),2) as MedziobdCelk,
	ROUND(AVG(LAKTDNI),2) as LaktdniCelk,
	ROUND(AVG(LAKDNIN),2) as LakdniNCelk,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorCelk,
	ROUND(AVG(TUKNOR),2) as TukNorCelk,
	ROUND(AVG(BIELKNOR),2) as BielkNorCelk,
	ROUND(AVG(LAKTOZAN),2) as LaktozaNCelk,
	AVG(INDPER) as IPZCelk,
	Sum(case when (l_Vs.DOVVYR='54' or l_Vs.DOVVYR='53' or l_Vs.DOVVYR='52' or l_Vs.DOVVYR='51' ) then 1 else 0 end) as VyrZootechCelk,
	Sum(case when (l_Vs.DOVVYR='55' or l_Vs.DOVVYR='56' or l_Vs.DOVVYR='57' or l_Vs.DOVVYR='58' or l_Vs.DOVVYR='59' or l_Vs.DOVVYR='60' or l_Vs.DOVVYR='61' or l_Vs.DOVVYR='62' ) then 1 else 0 end) as VyrZdravDovCelk

	from @Laktacie_Vs as l_Vs
	
	where (l_Vs.ZMENA = '30' or l_Vs.ZMENA='40') 

	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem
	
 --select * from @laktCelkom order by CHOV
  
  Declare @NormLak1_Vs table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Do3500L1] [float](4) NULL,
	[Do4000L1] [float](4) NULL,
	[Do4500L1] [float](4) NULL,
	[Do5000L1] [float](4) NULL,
	[Do5500L1] [float](4) NULL,
	[Do6000L1] [float](4) NULL,
	[Do6500L1] [float](4) NULL,
	[Do7000L1] [float](4) NULL,
	[Do7500L1] [float](4) NULL,
	[Do8000L1] [float](4) NULL,
	[Do8500L1] [float](4) NULL,
	[Do9000L1] [float](4) NULL,
	[Do9500L1] [float](4) NULL,
	[Do10000L1] [float](4) NULL,
	[Do10500L1] [float](4) NULL,
	[Do11000L1] [float](4) NULL,
	[Do11500L1] [float](4) NULL,
	[Do12000L1] [float](4) NULL,
	[Do12500L1] [float](4) NULL,
	[Do13000L1] [float](4) NULL,
	[Do13500L1] [float](4) NULL,
	[Do14000L1] [float](4) NULL,
	[Od14000L1] [float](4) NULL
	)
	
	insert @NormLak1_Vs
	select 
	@chov as CHOV, 
	@region as Region,
	l_Vs.typPlem as typPlem,
	Sum(case when l_Vs.MLIEKNOR<='3500' then 1 else 0 end) as Do3500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'3500' and l_Vs.MLIEKNOR<='4000') then 1 else 0 end) as Do4000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'4000' and l_Vs.MLIEKNOR<='4500') then 1 else 0 end) as Do4500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'4500' and l_Vs.MLIEKNOR<='5000') then 1 else 0 end) as Do5000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'5000' and l_Vs.MLIEKNOR<='5500') then 1 else 0 end) as Do5500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'5500' and l_Vs.MLIEKNOR<='6000') then 1 else 0 end) as Do6000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'6000' and l_Vs.MLIEKNOR<='6500') then 1 else 0 end) as Do6500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'6500' and l_Vs.MLIEKNOR<='7000') then 1 else 0 end) as Do7000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'7000' and l_Vs.MLIEKNOR<='7500') then 1 else 0 end) as Do7500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'7500' and l_Vs.MLIEKNOR<='8000') then 1 else 0 end) as Do8000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'8000' and l_Vs.MLIEKNOR<='8500') then 1 else 0 end) as Do8500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'8500' and l_Vs.MLIEKNOR<='9000') then 1 else 0 end) as Do9000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'9000' and l_Vs.MLIEKNOR<='9500') then 1 else 0 end) as Do9500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'9500' and l_Vs.MLIEKNOR<='10000') then 1 else 0 end) as Do10000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'10000' and l_Vs.MLIEKNOR<='10500') then 1 else 0 end) as Do10500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'10500' and l_Vs.MLIEKNOR<='11000') then 1 else 0 end) as Do11000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'11000' and l_Vs.MLIEKNOR<='11500') then 1 else 0 end) as Do11500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'11500' and l_Vs.MLIEKNOR<='12000') then 1 else 0 end) as Do12000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'12000' and l_Vs.MLIEKNOR<='12500') then 1 else 0 end) as Do12500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'12500' and l_Vs.MLIEKNOR<='13000') then 1 else 0 end) as Do13000L1, 
	Sum(case when (l_Vs.MLIEKNOR>'13000' and  l_Vs.MLIEKNOR<='13500') then 1 else 0 end) as DO13500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'13500' and l_Vs.MLIEKNOR<='14000') then 1 else 0 end) as DO14000L1, 
	Sum(case when l_Vs.MLIEKNOR>'14000' then 1 else 0 end) as Od14000L1 
	
	from @Laktacie_Vs as l_Vs
	
	
	where 
	l_Vs.PORLAK = '1'
	and (l_Vs.ZMENA = '30' or l_Vs.ZMENA='40')
	
	group by case when @chov is null and @region is null then @chov else
	 case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem
	
	--select * from @NormLak1 order by CHOV

	Declare @NormLak2_Vs table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Do3500L2] [float](4) NULL,
	[Do4000L2] [float](4) NULL,
	[Do4500L2] [float](4) NULL,
	[Do5000L2] [float](4) NULL,
	[Do5500L2] [float](4) NULL,
	[Do6000L2] [float](4) NULL,
	[Do6500L2] [float](4) NULL,
	[Do7000L2] [float](4) NULL,
	[Do7500L2] [float](4) NULL,
	[Do8000L2] [float](4) NULL,
	[Do8500L2] [float](4) NULL,
	[Do9000L2] [float](4) NULL,
	[Do9500L2] [float](4) NULL,
	[Do10000L2] [float](4) NULL,
	[Do10500L2] [float](4) NULL,
	[Do11000L2] [float](4) NULL,
	[Do11500L2] [float](4) NULL,
	[Do12000L2] [float](4) NULL,
	[Do12500L2] [float](4) NULL,
	[Do13000L2] [float](4) NULL,
	[Do13500L2] [float](4) NULL,
	[Do14000L2] [float](4) NULL,
	[Od14000L2] [float](4) NULL
	)
	insert @NormLak2_Vs
	select
	@chov as CHOV, 
	@region as Region,
	l_Vs.typPlem as typPlem,
	Sum(case when l_Vs.MLIEKNOR<='3500' then 1 else 0 end) as Do3500L1, 
	Sum(case when (l_Vs.MLIEKNOR>'3500' and l_Vs.MLIEKNOR<='4000') then 1 else 0 end) as Do4000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'4000' and l_Vs.MLIEKNOR<='4500') then 1 else 0 end) as Do4500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'4500' and l_Vs.MLIEKNOR<='5000') then 1 else 0 end) as Do5000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'5000' and l_Vs.MLIEKNOR<='5500') then 1 else 0 end) as Do5500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'5500' and l_Vs.MLIEKNOR<='6000') then 1 else 0 end) as Do6000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'6000' and l_Vs.MLIEKNOR<='6500') then 1 else 0 end) as Do6500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'6500' and l_Vs.MLIEKNOR<='7000') then 1 else 0 end) as Do7000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'7000' and l_Vs.MLIEKNOR<='7500') then 1 else 0 end) as Do7500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'7500' and l_Vs.MLIEKNOR<='8000') then 1 else 0 end) as Do8000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'8000' and l_Vs.MLIEKNOR<='8500') then 1 else 0 end) as Do8500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'8500' and l_Vs.MLIEKNOR<='9000') then 1 else 0 end) as Do9000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'9000' and l_Vs.MLIEKNOR<='9500') then 1 else 0 end) as Do9500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'9500' and l_Vs.MLIEKNOR<='10000') then 1 else 0 end) as Do10000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'10000' and l_Vs.MLIEKNOR<='10500') then 1 else 0 end) as Do10500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'10500' and l_Vs.MLIEKNOR<='11000') then 1 else 0 end) as Do11000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'11000' and l_Vs.MLIEKNOR<='11500') then 1 else 0 end) as Do11500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'11500' and l_Vs.MLIEKNOR<='12000') then 1 else 0 end) as Do12000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'12000' and l_Vs.MLIEKNOR<='12500') then 1 else 0 end) as Do12500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'12500' and l_Vs.MLIEKNOR<='13000') then 1 else 0 end) as Do13000L2, 
	Sum(case when (l_Vs.MLIEKNOR>'13000' and  l_Vs.MLIEKNOR<='13500') then 1 else 0 end) as DO13500L2, 
	Sum(case when (l_Vs.MLIEKNOR>'13500' and l_Vs.MLIEKNOR<='14000') then 1 else 0 end) as DO14000L2, 
	Sum(case when l_Vs.MLIEKNOR>'14000' then 1 else 0 end) as Od14000L2 
	
	from @Laktacie_Vs as l_Vs
	
	where 
	l_Vs.PORLAK >= '2'
	and (l_Vs.ZMENA = '30' or l_Vs.ZMENA='40')
	
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem
	
	--select * from @NormLak2 order by CHOV
	
	Declare @NormLakCelk_Vs table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Do3500Celk] [float](4) NULL,
	[Do4000Celk] [float](4) NULL,
	[Do4500Celk] [float](4) NULL,
	[Do5000Celk] [float](4) NULL,
	[Do5500Celk] [float](4) NULL,
	[Do6000Celk] [float](4) NULL,
	[Do6500Celk] [float](4) NULL,
	[Do7000Celk] [float](4) NULL,
	[Do7500Celk] [float](4) NULL,
	[Do8000Celk] [float](4) NULL,
	[Do8500Celk] [float](4) NULL,
	[Do9000Celk] [float](4) NULL,
	[Do9500Celk] [float](4) NULL,
	[Do10000Celk] [float](4) NULL,
	[Do10500Celk] [float](4) NULL,
	[Do11000Celk] [float](4) NULL,
	[Do11500Celk] [float](4) NULL,
	[Do12000Celk] [float](4) NULL,
	[Do12500Celk] [float](4) NULL,
	[Do13000Celk] [float](4) NULL,
	[Do13500Celk] [float](4) NULL,
	[Do14000Celk] [float](4) NULL,
	[Od14000Celk] [float](4) NULL
	)

	insert @NormLakCelk_Vs
	select
	@chov as CHOV, 
	@region as Region,
	l_Vs.typPlem as typPlem,
	Sum(case when l_Vs.MLIEKNOR<='3500' then 1 else 0 end) as Do3500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'3500' and l_Vs.MLIEKNOR<='4000') then 1 else 0 end) as Do4000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'4000' and l_Vs.MLIEKNOR<='4500') then 1 else 0 end) as Do4500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'4500' and l_Vs.MLIEKNOR<='5000') then 1 else 0 end) as Do5000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'5000' and l_Vs.MLIEKNOR<='5500') then 1 else 0 end) as Do5500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'5500' and l_Vs.MLIEKNOR<='6000') then 1 else 0 end) as Do6000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'6000' and l_Vs.MLIEKNOR<='6500') then 1 else 0 end) as Do6500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'6500' and l_Vs.MLIEKNOR<='7000') then 1 else 0 end) as Do7000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'7000' and l_Vs.MLIEKNOR<='7500') then 1 else 0 end) as Do7500Celk,
	Sum(case when (l_Vs.MLIEKNOR>'7500' and l_Vs.MLIEKNOR<='8000') then 1 else 0 end) as Do8000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'8000' and l_Vs.MLIEKNOR<='8500') then 1 else 0 end) as Do8500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'8500' and l_Vs.MLIEKNOR<='9000') then 1 else 0 end) as Do9000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'9000' and l_Vs.MLIEKNOR<='9500') then 1 else 0 end) as Do9500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'9500' and l_Vs.MLIEKNOR<='10000') then 1 else 0 end) as Do10000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'10000' and l_Vs.MLIEKNOR<='10500') then 1 else 0 end) as Do10500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'10500' and l_Vs.MLIEKNOR<='11000') then 1 else 0 end) as Do11000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'11000' and l_Vs.MLIEKNOR<='11500') then 1 else 0 end) as Do11500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'11500' and l_Vs.MLIEKNOR<='12000') then 1 else 0 end) as Do12000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'12000' and l_Vs.MLIEKNOR<='12500') then 1 else 0 end) as Do12500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'12500' and l_Vs.MLIEKNOR<='13000') then 1 else 0 end) as Do13000Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'13000' and  l_Vs.MLIEKNOR<='13500') then 1 else 0 end) as DO13500Celk, 
	Sum(case when (l_Vs.MLIEKNOR>'13500' and l_Vs.MLIEKNOR<='14000') then 1 else 0 end) as DO14000Celk, 
	Sum(case when l_Vs.MLIEKNOR>'14000' then 1 else 0 end) as Od14000L1 
	
	from @Laktacie_Vs as l_Vs
	
	where 
	(l_Vs.ZMENA = '30' or l_Vs.ZMENA='40')
	
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem
	
	--select * from @NormLakCelk order by CHOV

	Declare @ZmenaL1_Vs table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Zmena10L1] [float](4) NULL,
	[Zmena30L1] [float](4) NULL,
	[Zmena31L1] [float](4) NULL,
	[Zmena40L1] [float](4) NULL,
	[Zmena41L1] [float](4) NULL,
	[Zmena42L1] [float](4) NULL,
	[Zmena43L1] [float](4) NULL,
	[ZmenaCelk1L1] [float](4) NULL,
	[Zmena51L1] [float](4) NULL,
	[Zmena52L1] [float](4) NULL,
	[Zmena53L1] [float](4) NULL,
	[Zmena54L1] [float](4) NULL,
	[Zmena55L1] [float](4) NULL,
	[Zmena56L1] [float](4) NULL,
	[Zmena57L1] [float](4) NULL,
	[Zmena58L1] [float](4) NULL,
	[Zmena59L1] [float](4) NULL,
	[Zmena60L1] [float](4) NULL,
	[Zmena61L1] [float](4) NULL,
	[Zmena62L1] [float](4) NULL,
	[ZmenaCelk2L1] [float](4) NULL
	)
	insert @ZmenaL1_Vs
	select
	@chov as CHOV, 
	@region as Region,
	l_Vs.typPlem as typPlem,
	Sum(case when l_Vs.ZMENA='10' then 1 else 0 end) as Zmena10L1, 
	Sum(case when l_Vs.ZMENA='30' then 1 else 0 end) as Zmena30L1, 
	Sum(case when l_Vs.ZMENA='31' then 1 else 0 end) as Zmena31L1, 
	Sum(case when l_Vs.ZMENA='40' then 1 else 0 end) as Zmena40L1, 
	Sum(case when l_Vs.ZMENA='41' then 1 else 0 end) as Zmena41L1, 
	Sum(case when l_Vs.ZMENA='42' then 1 else 0 end) as Zmena42L1, 
	Sum(case when l_Vs.ZMENA='43' then 1 else 0 end) as Zmena43L1, 
	Sum(case when (l_Vs.ZMENA='10' or l_Vs.ZMENA='30' or l_Vs.ZMENA='31' or l_Vs.ZMENA='40' or l_Vs.ZMENA='41' 
	or l_Vs.ZMENA='42' or l_Vs.ZMENA='43') then 1 else 0 end) as ZmenaCelk1L1, 
	Sum(case when l_Vs.DOVVYR='51' then 1 else 0 end) as Zmena51L1, 
	Sum(case when l_Vs.DOVVYR='52' then 1 else 0 end) as Zmena52L1, 
	Sum(case when l_Vs.DOVVYR='53' then 1 else 0 end) as Zmena53L1, 
	Sum(case when l_Vs.DOVVYR='54' then 1 else 0 end) as Zmena54L1, 
	Sum(case when l_Vs.DOVVYR='55' then 1 else 0 end) as Zmena55L1, 
	Sum(case when l_Vs.DOVVYR='56' then 1 else 0 end) as Zmena56L1, 
	Sum(case when l_Vs.DOVVYR='57' then 1 else 0 end) as Zmena57L1, 
	Sum(case when l_Vs.DOVVYR='58' then 1 else 0 end) as Zmena58L1, 
	Sum(case when l_Vs.DOVVYR='59' then 1 else 0 end) as Zmena59L1, 
	Sum(case when l_Vs.DOVVYR='60' then 1 else 0 end) as Zmena60L1, 
	Sum(case when l_Vs.DOVVYR='61' then 1 else 0 end) as Zmena61L1, 
	Sum(case when l_Vs.DOVVYR='62' then 1 else 0 end) as Zmena62L1, 
	Sum(case when (l_Vs.DOVVYR='51' or l_Vs.DOVVYR='52' or l_Vs.DOVVYR='53' or l_Vs.DOVVYR='54' or l_Vs.DOVVYR='55' 
	or l_Vs.DOVVYR='56' or l_Vs.DOVVYR='57' or l_Vs.DOVVYR='58' or l_Vs.DOVVYR='59' or l_Vs.DOVVYR='60' or l_Vs.DOVVYR='61' or l_Vs.DOVVYR='62' ) then 1 else 0 end) as ZmenaCelk2L1 

	from @Laktacie_Vs as l_Vs
	
	where 
	PORLAK='1'
	 
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem
	
	--select * from @ZmenaL1 order by CHOV
	
	Declare @ZmenaL2_Vs table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Zmena10L2] [float](4) NULL,
	[Zmena30L2] [float](4) NULL,
	[Zmena31L2] [float](4) NULL,
	[Zmena40L2] [float](4) NULL,
	[Zmena41L2] [float](4) NULL,
	[Zmena42L2] [float](4) NULL,
	[Zmena43L2] [float](4) NULL,
	[ZmenaCelk1L2] [float](4) NULL,
	[Zmena51L2] [float](4) NULL,
	[Zmena52L2] [float](4) NULL,
	[Zmena53L2] [float](4) NULL,
	[Zmena54L2] [float](4) NULL,
	[Zmena55L2] [float](4) NULL,
	[Zmena56L2] [float](4) NULL,
	[Zmena57L2] [float](4) NULL,
	[Zmena58L2] [float](4) NULL,
	[Zmena59L2] [float](4) NULL,
	[Zmena60L2] [float](4) NULL,
	[Zmena61L2] [float](4) NULL,
	[Zmena62L2] [float](4) NULL,
	[ZmenaCelk2L2] [float](4) NULL
	)
	insert @ZmenaL2_Vs
	select
	@chov as CHOV, 
	@region as Region,
	l_Vs.typPlem as typPlem,

	Sum(case when l_Vs.ZMENA='10' then 1 else 0 end) as Zmena10L2, 
	Sum(case when l_Vs.ZMENA='30' then 1 else 0 end) as Zmena30L2, 
	Sum(case when l_Vs.ZMENA='31' then 1 else 0 end) as Zmena31L2, 
	Sum(case when l_Vs.ZMENA='40' then 1 else 0 end) as Zmena40L2, 
	Sum(case when l_Vs.ZMENA='41' then 1 else 0 end) as Zmena41L2, 
	Sum(case when l_Vs.ZMENA='42' then 1 else 0 end) as Zmena42L2, 
	Sum(case when l_Vs.ZMENA='43' then 1 else 0 end) as Zmena43L2, 
	Sum(case when (l_Vs.ZMENA='10' or l_Vs.ZMENA='30' or l_Vs.ZMENA='31' or l_Vs.ZMENA='40' or l_Vs.ZMENA='41' 
	or l_Vs.ZMENA='42' or l_Vs.ZMENA='43') then 1 else 0 end) as ZmenaCelk1L2, 
	Sum(case when l_Vs.DOVVYR='51' then 1 else 0 end) as Zmena51L2, 
	Sum(case when l_Vs.DOVVYR='52' then 1 else 0 end) as Zmena52L2, 
	Sum(case when l_Vs.DOVVYR='53' then 1 else 0 end) as Zmena53L2, 
	Sum(case when l_Vs.DOVVYR='54' then 1 else 0 end) as Zmena54L2, 
	Sum(case when l_Vs.DOVVYR='55' then 1 else 0 end) as Zmena55L2, 
	Sum(case when l_Vs.DOVVYR='56' then 1 else 0 end) as Zmena56L2, 
	Sum(case when l_Vs.DOVVYR='57' then 1 else 0 end) as Zmena57L2, 
	Sum(case when l_Vs.DOVVYR='58' then 1 else 0 end) as Zmena58L2, 
	Sum(case when l_Vs.DOVVYR='59' then 1 else 0 end) as Zmena59L2, 
	Sum(case when l_Vs.DOVVYR='60' then 1 else 0 end) as Zmena60L2, 
	Sum(case when l_Vs.DOVVYR='61' then 1 else 0 end) as Zmena61L2, 
	Sum(case when l_Vs.DOVVYR='62' then 1 else 0 end) as Zmena62L2, 
	Sum(case when (l_Vs.DOVVYR='51' or l_Vs.DOVVYR='52' or l_Vs.DOVVYR='53' or l_Vs.DOVVYR='54' or l_Vs.DOVVYR='55' 
	or l_Vs.DOVVYR='56' or l_Vs.DOVVYR='57' or l_Vs.DOVVYR='58' or l_Vs.DOVVYR='59' or l_Vs.DOVVYR='60' or l_Vs.DOVVYR='61' or l_Vs.DOVVYR='62' ) then 1 else 0 end) as ZmenaCelk2L2


	from @Laktacie_Vs as l_Vs
	
	where 
	PORLAK>='2'
	
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end,l_Vs.typPlem
	
	--select * from @ZmenaL2 order by CHOV

	Declare @ZmenaCelk_Vs table
  ( [CHOV] [varchar](10) NULL,
	[Region] [varchar](2) NULL,
	[typPlem] [varchar] (5) null,
	[Zmena10Celk] [float](4) NULL,
	[Zmena30Celk] [float](4) NULL,
	[Zmena31Celk] [float](4) NULL,
	[Zmena40Celk] [float](4) NULL,
	[Zmena41Celk] [float](4) NULL,
	[Zmena42Celk] [float](4) NULL,
	[Zmena43Celk] [float](4) NULL,
	[ZmenaCelk1Celk] [float](4) NULL,
	[Zmena51Celk] [float](4) NULL,
	[Zmena52Celk] [float](4) NULL,
	[Zmena53Celk] [float](4) NULL,
	[Zmena54Celk] [float](4) NULL,
	[Zmena55Celk] [float](4) NULL,
	[Zmena56Celk] [float](4) NULL,
	[Zmena57Celk] [float](4) NULL,
	[Zmena58Celk] [float](4) NULL,
	[Zmena59Celk] [float](4) NULL,
	[Zmena60Celk] [float](4) NULL,
	[Zmena61Celk] [float](4) NULL,
	[Zmena62Celk] [float](4) NULL,
	[ZmenaCelk2Celk] [float](4) NULL
	)

	insert @ZmenaCelk_Vs
	select
	@chov as CHOV, 
	@region as Region,
	l_Vs.typPlem as typPlem,
	Sum(case when l_Vs.ZMENA='10' then 1 else 0 end) as Zmena10Celk, 
	Sum(case when l_Vs.ZMENA='30' then 1 else 0 end) as Zmena30Celk, 
	Sum(case when l_Vs.ZMENA='31' then 1 else 0 end) as Zmena31Celk, 
	Sum(case when l_Vs.ZMENA='40' then 1 else 0 end) as Zmena40Celk, 
	Sum(case when l_Vs.ZMENA='41' then 1 else 0 end) as Zmena41Celk, 
	Sum(case when l_Vs.ZMENA='42' then 1 else 0 end) as Zmena42Celk, 
	Sum(case when l_Vs.ZMENA='43' then 1 else 0 end) as Zmena43Celk, 
	Sum(case when (l_Vs.ZMENA='10' or l_Vs.ZMENA='30' or l_Vs.ZMENA='31' or l_Vs.ZMENA='40' or l_Vs.ZMENA='41' 
	or l_Vs.ZMENA='42' or l_Vs.ZMENA='43') then 1 else 0 end) as ZmenaCelk1Celk, 
	Sum(case when l_Vs.DOVVYR='51' then 1 else 0 end) as Zmena51Celk, 
	Sum(case when l_Vs.DOVVYR='52' then 1 else 0 end) as Zmena52Celk, 
	Sum(case when l_Vs.DOVVYR='53' then 1 else 0 end) as Zmena53Celk, 
	Sum(case when l_Vs.DOVVYR='54' then 1 else 0 end) as Zmena54Celk, 
	Sum(case when l_Vs.DOVVYR='55' then 1 else 0 end) as Zmena55Celk, 
	Sum(case when l_Vs.DOVVYR='56' then 1 else 0 end) as Zmena56Celk, 
	Sum(case when l_Vs.DOVVYR='57' then 1 else 0 end) as Zmena57Celk, 
	Sum(case when l_Vs.DOVVYR='58' then 1 else 0 end) as Zmena58Celk, 
	Sum(case when l_Vs.DOVVYR='59' then 1 else 0 end) as Zmena59Celk, 
	Sum(case when l_Vs.DOVVYR='60' then 1 else 0 end) as Zmena60Celk, 
	Sum(case when l_Vs.DOVVYR='61' then 1 else 0 end) as Zmena61Celk, 
	Sum(case when l_Vs.DOVVYR='62' then 1 else 0 end) as Zmena62Celk, 
	Sum(case when (l_Vs.DOVVYR='51' or l_Vs.DOVVYR='52' or l_Vs.DOVVYR='53' or l_Vs.DOVVYR='54' or l_Vs.DOVVYR='55' 
	or l_Vs.DOVVYR='56' or l_Vs.DOVVYR='57' or l_Vs.DOVVYR='58' or l_Vs.DOVVYR='59' or l_Vs.DOVVYR='60' or l_Vs.DOVVYR='61' or l_Vs.DOVVYR='62') then 1 else 0 end) as ZmenaCelk2Celk 

	from @Laktacie_Vs as l_Vs
	
	group by case when @chov is null and @region is null then @chov else
	case when @chov is null then @region else (substring(l_Vs.CHOVATEL, 1, len(@chov))) end end, l_Vs.typPlem
	
	--select * from @ZmenaCelk order by CHOV


insert CR_LaktacneZostavy_Opr
	(
	Oznacenie,DatumOd,DatumDo,Filter, datumGenerovania, Region,PlemTyp, EkoChov,

	PocZapojL1, PocLakV1, PocLakN1, MedziobdL1,LakdniL1,LakdniNL1,MliekNorL1,TukNorL1, BielkNorL1,	LaktozaNL1, IPZL1, VyrZootechL1, VyrZdravDovL1,
	
	PocZapojL2, PocLakV2,PocLakN2,MedziobdL2,LaktDniL2,LakDniNL2,MliekNorL2,TukNorL2, BielkNorL2, LaktozaNL2, IPZL2, VyrZootechL2, VyrZdravDovL2,

	PocZapojCelk,PocLakVcelk,PocLakNcelk,MedziobdCelk,LaktDniCelk, LakDniNCelk, MliekNorCelk,TukNorCelk, BielkNorCelk, LaktozaNCelk, IPZCelk, VyrZootechCelk, VyrZdravDovCelk,

	Do3500L1,Do4000L1,Do4500L1, Do5000L1,Do5500L1, Do6000L1, Do6500L1, Do7000L1, Do7500L1, Do8000L1, Do8500L1,
	Do9000L1, Do9500L1, Do10000L1, Do10500L1, Do11000L1, Do11500L1,Do12000L1,Do12500L1, Do13000L1,Do13500L1, Do14000L1, Od14000L1,
	 
	Do3500L2, Do4000L2, Do4500L2, Do5000L2, Do5500L2, Do6000L2, Do6500L2, Do7000L2, Do7500L2, Do8000L2,Do8500L2, Do9000L2,Do9500L2, 
	Do10000L2, Do10500L2, Do11000L2, Do11500L2, Do12000L2, Do12500L2, Do13000L2,Do13500L2, Do14000L2, Od14000L2,
	 
	Do3500Celk, Do4000Celk, Do4500Celk, Do5000Celk, Do5500Celk, Do6000Celk, Do6500Celk, Do7000Celk,	Do7500Celk, Do8000Celk, Do8500Celk,
	Do9000Celk, Do9500Celk,Do10000Celk, Do10500Celk,Do11000Celk, Do11500Celk,Do12000Celk, Do12500Celk, Do13000Celk, Do13500Celk, Do14000Celk, Od14000Celk,

	Zmena10L1, Zmena30L1,Zmena31L1,Zmena40L1,Zmena41L1,	Zmena42L1,Zmena43L1,ZmenaCelk1L1,Zmena51L1,Zmena52L1,Zmena53L1,Zmena54L1,Zmena55L1,Zmena56L1,Zmena57L1,
	Zmena58L1,Zmena59L1,Zmena60L1,Zmena61L1,Zmena62L1,ZmenaCelk2L1,

	Zmena10L2, Zmena30L2,Zmena31L2,Zmena40L2,Zmena41L2,	Zmena42L2,Zmena43L2,ZmenaCelk1L2,Zmena51L2,Zmena52L2,Zmena53L2,Zmena54L2,Zmena55L2,Zmena56L2,Zmena57L2,
	Zmena58L2,Zmena59L2,Zmena60L2,Zmena61L2,Zmena62L2,ZmenaCelk2L2,
	
	Zmena10Celk, Zmena30Celk,Zmena31Celk,Zmena40Celk,Zmena41Celk,	Zmena42Celk,Zmena43Celk,ZmenaCelk1Celk,Zmena51Celk,Zmena52Celk,Zmena53Celk,Zmena54Celk,Zmena55Celk,Zmena56Celk,Zmena57Celk,
	Zmena58Celk,Zmena59Celk,Zmena60Celk,Zmena61Celk,Zmena62Celk,ZmenaCelk2Celk
	)

	select distinct
	
	(Select distinct case when @chov is null and @region is null then ('SR') else
	case when @chov is null then ('R'+ @region) else  @chov end end)as Oznacenie,
	@datumOd as DatumOd,
	@datumDo as DatumDo,
	
	(Select distinct case when @chov is null and @region is null then ('SR') else
	case when @chov is null then ('R'+ @region) else  @chov end end) +','+l_Vs.typPlem as Filer,
	getdate() as datumGenerovania,
	@region as Region,
	
	l_Vs.typPlem as PlemTyp,
	l_Vs.EkoChov as EkoChov,
	ZapojL1_Vs.PocZapojL1 as PocZapojL1,
	ROUND(LAKV1_Vs.PocLakV1,2) as PocLakV1, 
	ROUND(L1_Vs.PocLakN1,2) as PocLakN1, 
	convert(varchar, round(L1_Vs.MEDZIOBDL1 / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, L1_Vs.MedziobdL1) % 30.42, 0)) ) AS  MedziobdL1,
	ROUND(L1_Vs.LakdniL1,2) as LakdniL1,
	ROUND(L1_Vs.LakdniNL1,2) as LakdniNL1,
	ROUND(L1_Vs.MliekNorL1,2) as MliekNorL1,
	ROUND(L1_Vs.TukNorL1,2) as TukNorL1,
	ROUND(L1_Vs.BielkNorL1,2) as BielkNorL1 ,
	ROUND(L1_Vs.LaktozaNL1,2) as LaktozaNL1, 
	ROUND(L1_Vs.IPZL1,2) as IPZL1,
	L1_Vs.VyrZootechL1 as VyrZootechL1,
	L1_Vs.VyrZdravDovL1 as VyrZdravDovL1,

	ZapojL2_Vs.PocZapojL2 as PocZapojL2, 
	ROUND(LAKV2_Vs.PocLakV2,2) as PocLakV2,
	ROUND(L2_Vs.PocLakN2,2) as PocLakN2,
	ROUND(L2_Vs.MedziobdL2,2) as MedziobdL2,
	ROUND(L2_Vs.LaktDniL2,2) as LaktDniL2,
	ROUND(L2_Vs.LakDniNL2,2) as LakDniNL2,
	ROUND(L2_Vs.MliekNorL2,2) as MliekNorL2,
	ROUND(L2_Vs.TukNorL2,2) as TukNorL2,
	ROUND(L2_Vs.BielkNorL2,2) as BielkNorL2,
	ROUND(L2_Vs.LaktozaNL2,2) as LaktozaNL2,
	ROUND(L2_Vs.IPZL2,2) as IPZL2,
	L2_Vs.VyrZootechL2 as VyrZootechL2,
	L2_Vs.VyrZdravDovL2 as VyrZdravDovL2,

	ZapojLCelk_Vs.PocZapojLCelk as PocZapojCelk, 
	ROUND(LAKVC_Vs.PocLakVcelk,2) as PocLakVcelk,
	ROUND(lCelk_Vs.PocLakNcelk,2) as PocLakNcelk,
	ROUND(lCelk_Vs.MedziobdCelk,2) as MedziobdCelk,
	ROUND(lCelk_Vs.LaktDniCelk,2) as LaktDniCelk,
	ROUND(lCelk_Vs.LakDniNCelk,2) as LakDniNCelk,
	ROUND(lCelk_Vs.MliekNorCelk,2) as MliekNorCelk,
	ROUND(lCelk_Vs.TukNorCelk,2) as TukNorCelk,
	ROUND(lCelk_Vs.BielkNorCelk,2) as BielkNorCelk,
	ROUND(lCelk_Vs.LaktozaNCelk,2) as LaktozaNCelk,
	ROUND(lCelk_Vs.IPZCelk,2) as IPZCelk,
	lCelk_Vs.VyrZootechCelk as VyrZootechCelk,
	lCelk_Vs.VyrZdravDovCelk as VyrZdravDovCelk,

	NL1_Vs.Do3500L1 AS Do3500L1,
	NL1_Vs.Do4000L1 as Do4000L1,
	NL1_Vs.Do4500L1 as Do4500L1,
	NL1_Vs.Do5000L1 as Do5000L1,
	NL1_Vs.Do5500L1 as Do5500L1,
	NL1_Vs.Do6000L1 as Do6000L1,
	NL1_Vs.Do6500L1 as Do6500L1,
	NL1_Vs.Do7000L1 as Do7000L1,
	NL1_Vs.Do7500L1 as Do7500L1,
	NL1_Vs.Do8000L1 as Do8000L1,
	NL1_Vs.Do8500L1 as Do8500L1,
	NL1_Vs.Do9000L1 as Do9000L1,
	NL1_Vs.Do9500L1 as Do9500L1,
	NL1_Vs.Do10000L1 as Do10000L1,
	NL1_Vs.Do10500L1 as Do10500L1,
	NL1_Vs.Do11000L1 as Do11000L1,
	NL1_Vs.Do11500L1 as Do11500L1,
	NL1_Vs.Do12000L1 as Do12000L1,
	NL1_Vs.Do12500L1 as Do12500L1,
	NL1_Vs.Do13000L1 as Do13000L1,
	NL1_Vs.Do13500L1 as Do13500L1,
	NL1_Vs.Do14000L1 as Do14000L1,
	NL1_Vs.Od14000L1 as Od14000L1,
	 
	NL2_Vs.Do3500L2 AS Do3500L2,
	NL2_Vs.Do4000L2 as Do4000L2,
	NL2_Vs.Do4500L2 as Do4500L2,
	NL2_Vs.Do5000L2 as Do5000L2,
	NL2_Vs.Do5500L2 as Do5500L2,
	NL2_Vs.Do6000L2 as Do6000L2,
	NL2_Vs.Do6500L2 as Do6500L2,
	NL2_Vs.Do7000L2 as Do7000L2,
	NL2_Vs.Do7500L2 as Do7500L2,
	NL2_Vs.Do8000L2 as Do8000L2,
	NL2_Vs.Do8500L2 as Do8500L2,
	NL2_Vs.Do9000L2 as Do9000L2,
	NL2_Vs.Do9500L2 as Do9500L2,
	NL2_Vs.Do10000L2 as Do10000L2,
	NL2_Vs.Do10500L2 as Do10500L2,
	NL2_Vs.Do11000L2 as Do11000L2,
	NL2_Vs.Do11500L2 as Do11500L2,
	NL2_Vs.Do12000L2 as Do12000L2,
	NL2_Vs.Do12500L2 as Do12500L2,
	NL2_Vs.Do13000L2 as Do13000L2,
	NL2_Vs.Do13500L2 as Do13500L2,
	NL2_Vs.Do14000L2 as Do14000L2,
	NL2_Vs.Od14000L2 as Od14000L2,
	 
	NlCelk_Vs.Do3500Celk AS Do3500Celk,
	NlCelk_Vs.Do4000Celk as Do4000Celk,
	NlCelk_Vs.Do4500Celk as Do4500Celk,
	NlCelk_Vs.Do5000Celk as Do5000Celk,
	NlCelk_Vs.Do5500Celk as Do5500Celk,
	NlCelk_Vs.Do6000Celk as Do6000Celk,
	NlCelk_Vs.Do6500Celk as Do6500Celk,
	NlCelk_Vs.Do7000Celk as Do7000Celk,
	NlCelk_Vs.Do7500Celk as Do7500Celk,
	NlCelk_Vs.Do8000Celk as Do8000Celk,
	NlCelk_Vs.Do8500Celk as Do8500Celk,
	NlCelk_Vs.Do9000Celk as Do9000Celk,
	NlCelk_Vs.Do9500Celk as Do9500Celk,
	NlCelk_Vs.Do10000Celk as Do10000Celk,
	NlCelk_Vs.Do10500Celk as Do10500Celk,
	NlCelk_Vs.Do11000Celk as Do11000Celk,
	NlCelk_Vs.Do11500Celk as Do11500Celk,
	NlCelk_Vs.Do12000Celk as Do12000Celk,
	NlCelk_Vs.Do12500Celk as Do12500Celk,
	NlCelk_Vs.Do13000Celk as Do13000Celk,
	NlCelk_Vs.Do13500Celk as Do13500Celk,
	NlCelk_Vs.Do14000Celk as Do14000Celk,
	NlCelk_Vs.Od14000Celk as Od14000Celk, 

	ZL1_Vs.Zmena10L1 as Zmena10L1, 
	ZL1_Vs.Zmena30L1 as Zmena30L1,
	ZL1_Vs.Zmena31L1 as Zmena31L1,
	ZL1_Vs.Zmena40L1 as Zmena40L1,
	ZL1_Vs.Zmena41L1 as Zmena41L1,	
	ZL1_Vs.Zmena42L1 as Zmena42L1,
	ZL1_Vs.Zmena43L1 as Zmena43L1,
	ZL1_Vs.ZmenaCelk1L1 as ZmenaCelk1L1,
	ZL1_Vs.Zmena51L1 as Zmena51L1,
	ZL1_Vs.Zmena52L1 as Zmena52L1,
	ZL1_Vs.Zmena53L1 as Zmena53L1,
	ZL1_Vs.Zmena54L1 as Zmena54L1,
	ZL1_Vs.Zmena55L1 as Zmena55L1,
	ZL1_Vs.Zmena56L1 as Zmena56L1,
	ZL1_Vs.Zmena57L1 as Zmena57L1,
	ZL1_Vs.Zmena58L1 as Zmena58L1,
	ZL1_Vs.Zmena59L1 as Zmena59L1,
	ZL1_Vs.Zmena60L1 as Zmena60L1,
	ZL1_Vs.Zmena61L1 as Zmena61L1,
	ZL1_Vs.Zmena62L1 as Zmena62L1,
	ZL1_Vs.ZmenaCelk2L1 asZmenaCelk2L1,

	ZL2_Vs.Zmena10L2 as Zmena10L2, 
	ZL2_Vs.Zmena30L2 as Zmena30L2,
	ZL2_Vs.Zmena31L2 as Zmena31L2,
	ZL2_Vs.Zmena40L2 as Zmena40L2,
	ZL2_Vs.Zmena41L2 as Zmena41L2,	
	ZL2_Vs.Zmena42L2 as Zmena42L2,
	ZL2_Vs.Zmena43L2 as Zmena43L2,
	ZL2_Vs.ZmenaCelk1L2 as ZmenaCelk1L2,
	ZL2_Vs.Zmena51L2 as Zmena51L2,
	ZL2_Vs.Zmena52L2 as Zmena52L2,
	ZL2_Vs.Zmena53L2 as Zmena53L2,
	ZL2_Vs.Zmena54L2 as Zmena54L2,
	ZL2_Vs.Zmena55L2 as Zmena55L2,
	ZL2_Vs.Zmena56L2 as Zmena56L2,
	ZL2_Vs.Zmena57L2 as Zmena57L2,
	ZL2_Vs.Zmena58L2 as Zmena58L2,
	ZL2_Vs.Zmena59L2 as Zmena59L2,
	ZL2_Vs.Zmena60L2 as Zmena60L2,
	ZL2_Vs.Zmena61L2 as Zmena61L2,
	ZL2_Vs.Zmena62L2 as Zmena62L2,
	ZL2_Vs.ZmenaCelk2L2 asZmenaCelk2L2,

	ZCelk_Vs.Zmena10Celk as Zmena10Celk, 
	ZCelk_Vs.Zmena30Celk as Zmena30Celk,
	ZCelk_Vs.Zmena31Celk as Zmena31Celk,
	ZCelk_Vs.Zmena40Celk as Zmena40Celk,
	ZCelk_Vs.Zmena41Celk as Zmena41Celk,	
	ZCelk_Vs.Zmena42Celk as Zmena42Celk,
	ZCelk_Vs.Zmena43Celk as Zmena43Celk,
	ZCelk_Vs.ZmenaCelk1Celk as ZmenaCelk1Celk,
	ZCelk_Vs.Zmena51Celk as Zmena51Celk,
	ZCelk_Vs.Zmena52Celk as Zmena52Celk,
	ZCelk_Vs.Zmena53Celk as Zmena53Celk,
	ZCelk_Vs.Zmena54Celk as Zmena54Celk,
	ZCelk_Vs.Zmena55Celk as Zmena55Celk,
	ZCelk_Vs.Zmena56Celk as Zmena56Celk,
	ZCelk_Vs.Zmena57Celk as Zmena57Celk,
	ZCelk_Vs.Zmena58Celk as Zmena58Celk,
	ZCelk_Vs.Zmena59Celk as Zmena59Celk,
	ZCelk_Vs.Zmena60Celk as Zmena60Celk,
	ZCelk_Vs.Zmena61Celk as Zmena61Celk,
	ZCelk_Vs.Zmena62Celk as Zmena62Celk,
	ZCelk_Vs.ZmenaCelk2Celk as ZmenaCelk2Celk
	 
	from @Laktacie_Vs as l_Vs

	left outer join @PocZapojL1_Vs ZapojL1_Vs on ((ZapojL1_Vs.CHOV =  substring(l_Vs.CHOVATEL, 1, len(@chov))or @chov is null) and ZapojL1_Vs.typPlem = l_Vs.typPlem)
	left outer  join @PocZapojL2_Vs ZapojL2_Vs on ((ZapojL2_Vs.CHOV =  substring(l_Vs.CHOVATEL, 1, len(@chov))or @chov is null) and ZapojL2_Vs.typPlem = l_Vs.typPlem)
	left outer  join @PocZapojLCelk_Vs  ZapojLCelk_Vs on ((ZapojLCelk_Vs.CHOV =  substring(l_Vs.CHOVATEL, 1, len(@chov))or @chov is null) and ZapojLCelk_Vs.typPlem = l_Vs.typPlem)
	left outer  join @pocLAKV1_Vs  LAKV1_Vs on ((LAKV1_Vs.CHOV =  substring(l_Vs.CHOVATEL, 1, len(@chov))or @chov is null) and LAKV1_Vs.typPlem = l_Vs.typPlem)
	left outer  join @pocLAKV2_Vs  LAKV2_Vs on ((LAKV2_Vs.CHOV =  substring(l_Vs.CHOVATEL, 1, len(@chov))or @chov is null) and LAKV2_Vs.typPlem = l_Vs.typPlem)
	left outer join @pocLAKVCelk_Vs LAKVC_Vs on ((LAKVC_Vs.CHOV =  substring(l_Vs.CHOVATEL, 1, len(@chov))or @chov is null) and LAKVC_Vs.typPlem = l_Vs.typPlem)
	left outer  join @lakt1_Vs  L1_Vs on ((L1_Vs.CHOV =  substring(l_Vs.CHOVATEL, 1, len(@chov))or @chov is null) and L1_Vs.typPlem = l_Vs.typPlem)
	left outer  join @lakt2_Vs  L2_Vs on ((substring(l_Vs.CHOVATEL, 1, len(@chov))= L2_Vs.CHOV or @chov is null)and L2_Vs.typPlem = l_Vs.typPlem)
	left outer  join @laktCelkom_Vs as lCelk_Vs on (( substring(l_Vs.CHOVATEL, 1, len(@chov))= lCelk_Vs.CHOV or @chov is null)and lCelk_Vs.typPlem = l_Vs.typPlem)
	left outer  join @NormLak1_Vs  NL1_Vs on ((NL1_Vs.CHOV =  substring(l_Vs.CHOVATEL, 1, len(@chov)) or @chov is null)and NL1_Vs.typPlem = l_Vs.typPlem)
	left outer  join @NormLak2_Vs  NL2_Vs on ((substring(l_Vs.CHOVATEL, 1, len(@chov))= NL2_Vs.CHOV or @chov is null)and NL2_Vs.typPlem = l_Vs.typPlem)
	left outer  join @NormLakCelk_Vs as NlCelk_Vs on ((substring(l_Vs.CHOVATEL, 1, len(@chov))= NlCelk_Vs.CHOV or @chov is null)and NlCelk_Vs.typPlem=l_Vs.typPlem)
	left outer  join @ZmenaL1_Vs as ZL1_Vs on ((substring(l_Vs.CHOVATEL, 1, len(@chov))= ZL1_Vs.CHOV or @chov is null)and ZL1_Vs.typPlem=l_Vs.typPlem)
	left outer  join @ZmenaL2_Vs as ZL2_Vs on ((substring(l_Vs.CHOVATEL, 1, len(@chov))= ZL2_Vs.CHOV or @chov is null)and ZL2_Vs.typPlem=l_Vs.typPlem)
	left outer  join @ZmenaCelk_Vs as ZCelk_Vs on ((substring(l_Vs.CHOVATEL, 1, len(@chov))= ZCelk_Vs.CHOV or @chov is null)and ZCelk_Vs.typPlem=l_Vs.typPlem)
	left outer  join  NC_OKRES as reg on ((reg.KRAJ + reg.OKRES)= substring(l_Vs.CHOVATEL, 1, 3) or @chov is null)



	/*************dopocet poradia ukoncenej laktacie do excelovskej tabulky pre rocenku *******/
	
	---------select typplem, convert(decimal(5,2),AVG(PORLAK *1.0)) from @Laktacie group by typPlem
	---------select vs.typplem, convert(decimal(5,2),AVG(vs.PORLAK *1.0)) from @Laktacie_Vs as vs group by vs.typPlem

		end
go


-------------------------------------------------------------------------------------------------------------



--use plis
/***** 
Rocenka KU mlieko - skr poslednu tabulku v rocenke : Vysledky kontroly [6itkovosti  hov. dobytka v SR - prepocitava hodnoty za *chov spolu* do tabulky Roc_MLHD_Tab_22A 
... prepocitava sa v pripade, ak jeden chov ma viac mastali( napr. 108520071 a 108520072...prepocita udaje za chov 10852007  
***/
 CREATE procedure [dbo].[Roc_MLHD_22_chov]
	@chov varchar(8),
	@datumOd date,
	@datumDo date

--declare @chov varchar(8), @datumOd date, @datumDo date

--set @chov = '10852007'
--set @datumOd= '2017-01-01'
--set @datumDo = '2017-12-31'
as 
begin
delete from CR_LaktacneZostavy_Opr where @chov = Oznacenie and Oznacenie = Filter and DatumOd = @datumOd and DatumDo = @datumDo

Declare @Laktacie table(
--CREATE TABLE @Laktacie(
	  [PORLAK][int],
      [CHOVATEL][varchar] (9) null,
	  [Region] [varchar](2) NULL,
	  [ZMENA][varchar] (2) null,
      [MEDZIOBD][float] NULL,  
      [LAKTDNI][float] NULL,
      [LAKDNIN][float] NULL,
      [MLIEKNOR][float] NULL,
      [TUKNOR][float] NULL,
      [BIELKNOR][float] NULL,
      [LAKTOZAN] [float] NULL,
	  [INDPER] [float] NULL,
	  [PLEM] [varchar] (10) null,
      [DOVVYR][varchar] (2) null,
      [DATVYR][date] null,
	  [EkoChov][varchar](1) NULL
	  
) --ON [PRIMARY]

declare @kravy table
	(
	CHOV varchar(8) NULL,
	ciskravy varchar(14),
	PORPREBLAK int
	)

insert into @Laktacie
		 SELECT
 			 PORLAK, substring(CHOVATEL,1,8), (select region from NC_OKRES reg where (reg.KRAJ + reg.OKRES)= lakt.okres),
			 ZMENA, MEDZIOBD, LAKTDNI,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, Plem, 
			 DOVVYR, DATVYR,
			 (select case when @chov = (eko.KRAJ + eko.OKRES + eko.PODNIK + substring(eko.CHOV,1,2)) and eko.EkoChov='1' then '1' 
						else null end)as EkoChov
		 FROM dbo.View_CP_LaktaciePreZostavy as Lakt		 
			left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV )= CHOVATEL)
		 where (substring(Lakt.CHOVATEL,1,8) in (select substring(chov,1,8) from CP_ZoznamChovov)) -- chovy, ktoré sú v kontrole úžitkovosti
			and substring(lakt.chovatel,1,8) = @chov			
			and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
				or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
			and eko.ZRUS is null AND eko.TYPZV='1'
			
			and MLIEKCEL <>''

			--select * from @Laktacie

	Insert into @kravy
	select 
		@chov as CHOV, 
		k.ciskravy,
		PORPREBLAK
	from CM_Krava as k
	left outer join  NC_OKRES as reg on ((reg.KRAJ + reg.OKRES)= substring(CHOVATEL, 1, 3))
		where (substring(k.CHOVATEL,1,8) in (select distinct CHOVATEL from @Laktacie)) 
		and	k.DOVVYR is null and k.PRIZNAKKU='1' --and k.PORPREBLAK ='1'

		--select * from @kravy
		

	declare @PocZapojL1 table
		(
		[CHOV] [varchar](9) NULL,
		[PocZapojL1] int NULL
		)
	

	Insert @PocZapojL1
	select 
		@chov as CHOV, 
		count(k.ciskravy) as PocZapojL1
	from @kravy as k
	 where
		k.PORPREBLAK ='1'
 	--group by @chov


--select * from @PocZapojL1 
declare @PocZapojL2 table
	(
	 [CHOV] [varchar](9) NULL,
	 [PocZapojL2] int NULL
	)

	Insert @PocZapojL2
	select 
		@chov as CHOV, 
		count(k.ciskravy) as PocZapojL2
	from @kravy as k
	where k.PORPREBLAK >='2' 		
	----group by @chov
		

declare @PocZapojLCelk table
	([CHOV] [varchar](9) NULL,
	[PocZapojLCelk] int NULL
	)

	Insert @PocZapojLCelk
	select 
		@chov as CHOV, 
		count(k.ciskravy) as PocZapojLCelk
	from @kravy as k 
	----group by @chov
		
declare @pocLAKV1 table
	([CHOV] [varchar](9) NULL,
	[PocLakV1] [float](4) NULL
)

	Insert @pocLAKV1
	select 
	@chov as CHOV, 
	count(*) as PocLakV1

	from @Laktacie as l	where PORLAK = '1'

	----group by @chov

		--select * from @pocLAKV1 


declare @pocLAKV2 table
	(
	[CHOV] [varchar](9) NULL,
	[PocLakV2] [float](4) NULL
	)
	Insert @pocLAKV2
	select 
	@chov as CHOV, 
	count(*) as PocLakV2

	from @Laktacie as l	where PORLAK >= '2'

	----group by @chov 
	
--select * from @pocLAKV2

declare @pocLAKVCelk table
	([CHOV] [varchar](9) NULL,
	
	[PocLakVCelk] [float](4) NULL
)

	Insert @pocLAKVCelk
	select 
	@chov as CHOV, 
	count(*) as PocLakVCelk

	from @Laktacie as l
		
	----group by @chov 
		--select * from @pocLAKVCelk 

Declare @lakt1 table
	
	([CHOV] [varchar](9) NULL,
	[PocLakN1] [float](4) NULL,
	[MedziobdL1] [float](7) NULL,
    [LakdniL1] [float](7) NULL,
    [LakdniNL1] [float](7) NULL,	
    [MliekNorL1] [float](9) NULL,
    [TukNorL1] [float](7) NULL,
    [BielkNorL1] [float](7) NULL,
    [LaktozaNL1] [float](7) NULL, 
	[IPZL1] [float](5) NULL,
	[VyrZootechL1] [varchar](4) NULL,
	[VyrZdravDovL1] [varchar](4) NULL
	)

	Insert into @lakt1
	(CHOV, PocLakN1, MedziobdL1, LakdniL1, LakdniNL1, MliekNorL1, TukNorL1, BielkNorL1, LaktozaNL1, IPZL1, 
	VyrZootechL1,VyrZdravDovL1 )
	
select 
	@chov as CHOV, 
	count(*)  as PocLakN1, 
	ROUND(AVG(MEDZIOBD),2)  as MedziobdL1,
	ROUND(AVG(LAKTDNI),2) as LaktdniL1,
	ROUND(AVG(LAKDNIN),2)as LakdniNL1,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorL1,
	ROUND(AVG(TUKNOR),2)as TukNorL1,
	ROUND(AVG(BIELKNOR),2) as BielkNorL1,
	ROUND(AVG(LAKTOZAN),2) as LaktozaNL1,
	AVG(INDPER) as IPZL1,
	Sum(case when (l.DOVVYR='54' or l.DOVVYR='53' or l. DOVVYR='52' or l.DOVVYR='51' ) then 1 else 0 end) as VyrZootechL1,
	Sum(case when (l.DOVVYR='55' or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61' or l.DOVVYR='62'  ) then 1 else 0 end) as VyrZdravDovL1

	from @Laktacie as l
		where  PORLAK = '1'
		and (l.ZMENA = '30' or l.ZMENA='40') 

	----group by @chov 
	--select * from @lakt1  
	
  Declare @lakt2 table
  ( [CHOV] [varchar](9) NULL,
	[PocLakN2] [float](4) NULL,
	[MedziobdL2] [float](7) NULL,
    [LaktDniL2] [float](7) NULL,
    [LakDniNL2] [float](7) NULL,	
    [MliekNorL2] [float](9) NULL,
    [TukNorL2] [float](7) NULL,
    [BielkNorL2] [float](7) NULL,
    [LaktozaNL2] [float](7) NULL,
	[IPZL2] [float](5) NULL,
	[VyrZootechL2] [varchar](4) NULL,
	[VyrZdravDovL2] [varchar](4) NULL
	)
 insert @lakt2
 select
	@chov as CHOV, 
	count(*) as PocLakN2, 
	ROUND(AVG(MEDZIOBD),2) as MedziobdL2,
	ROUND(AVG(LAKTDNI),2)as LaktdniL2,
	ROUND(AVG(LAKDNIN),2)as LakdniNL2,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorL2,
	ROUND(AVG(TUKNOR),2)as TukNorL2,
	ROUND(AVG(BIELKNOR),2) as BielkNorL2,
	ROUND(AVG(LAKTOZAN),2) as LaktozaNL2,
	AVG(INDPER) as IPZL2,
	Sum(case when (l.DOVVYR='54' or l.DOVVYR='53' or l.DOVVYR='52' or l.DOVVYR='51' ) then 1 else 0 end) as VyrZootechL2,
	Sum(case when (l.DOVVYR='55' or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61' or l.DOVVYR='62'  ) then 1 else 0 end) as VyrZdravDovL2

	from @Laktacie as l
	where 
	PORLAK >= '2'
	and (l.ZMENA = '30' or l.ZMENA='40') 

	----group by @chov 
 --select * from @lakt2 order by CHOV

  Declare @laktCelkom table
  ( [CHOV] [varchar](10) NULL,
	[PocLakNcelk] [float] NULL,
	[MedziobdCelk] [float] NULL,
    [LaktDniCelk] [float] NULL,
    [LakDniNCelk] [float] NULL,	
    [MliekNorCelk] [float] NULL,
    [TukNorCelk] [float] NULL,
    [BielkNorCelk] [float] NULL,
    [LaktozaNCelk] [float] NULL,
	[IPZCelk] [float](5) NULL,
	[VyrZootechCelk] [varchar](4) NULL,
	[VyrZdravDovCelk] [varchar](4) NULL
	)

insert @laktCelkom
select
	@chov as CHOV, 
	count(*) as PocLakCelk, 
	ROUND(AVG(MEDZIOBD),2) as MedziobdCelk,
	ROUND(AVG(LAKTDNI),2) as LaktdniCelk,
	ROUND(AVG(LAKDNIN),2) as LakdniNCelk,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorCelk,
	ROUND(AVG(TUKNOR),2) as TukNorCelk,
	ROUND(AVG(BIELKNOR),2) as BielkNorCelk,
	ROUND(AVG(LAKTOZAN),2) as LaktozaNCelk,
	AVG(INDPER) as IPZCelk,
	Sum(case when (l.DOVVYR='54' or l.DOVVYR='53' or l.DOVVYR='52' or l.DOVVYR='51' ) then 1 else 0 end) as VyrZootechCelk,
	Sum(case when (l.DOVVYR='55' or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61' or l.DOVVYR='62' ) then 1 else 0 end) as VyrZdravDovCelk

	from @Laktacie as l
	
	where (l.ZMENA = '30' or l.ZMENA='40') 

	----group by @chov 
	
 --select * from @laktCelkom order by CHOV
  
  Declare @NormLak1 table
  ( [CHOV] [varchar](10) NULL,
	----[Region] [varchar](2) NULL,
	----[PlemTyp] [varchar] (10) Null,
	[Do3500L1] [float](4) NULL,
	[Do4000L1] [float](4) NULL,
	[Do4500L1] [float](4) NULL,
	[Do5000L1] [float](4) NULL,
	[Do5500L1] [float](4) NULL,
	[Do6000L1] [float](4) NULL,
	[Do6500L1] [float](4) NULL,
	[Do7000L1] [float](4) NULL,
	[Do7500L1] [float](4) NULL,
	[Do8000L1] [float](4) NULL,
	[Do8500L1] [float](4) NULL,
	[Do9000L1] [float](4) NULL,
	[Do9500L1] [float](4) NULL,
	[Do10000L1] [float](4) NULL,
	[Do10500L1] [float](4) NULL,
	[Do11000L1] [float](4) NULL,
	[Do11500L1] [float](4) NULL,
	[Do12000L1] [float](4) NULL,
	[Do12500L1] [float](4) NULL,
	[Do13000L1] [float](4) NULL,
	[Do13500L1] [float](4) NULL,
	[Do14000L1] [float](4) NULL,
	[Od14000L1] [float](4) NULL
	)
	
	insert @NormLak1
	select 
	@chov as CHOV, 
	Sum(case when l.MLIEKNOR<='3500' then 1 else 0 end) as Do3500L1, 
	Sum(case when (l.MLIEKNOR>'3500' and l.MLIEKNOR<='4000') then 1 else 0 end) as Do4000L1, 
	Sum(case when (l.MLIEKNOR>'4000' and l.MLIEKNOR<='4500') then 1 else 0 end) as Do4500L1, 
	Sum(case when (l.MLIEKNOR>'4500' and l.MLIEKNOR<='5000') then 1 else 0 end) as Do5000L1, 
	Sum(case when (l.MLIEKNOR>'5000' and l.MLIEKNOR<='5500') then 1 else 0 end) as Do5500L1, 
	Sum(case when (l.MLIEKNOR>'5500' and l.MLIEKNOR<='6000') then 1 else 0 end) as Do6000L1, 
	Sum(case when (l.MLIEKNOR>'6000' and l.MLIEKNOR<='6500') then 1 else 0 end) as Do6500L1, 
	Sum(case when (l.MLIEKNOR>'6500' and l.MLIEKNOR<='7000') then 1 else 0 end) as Do7000L1, 
	Sum(case when (l.MLIEKNOR>'7000' and l.MLIEKNOR<='7500') then 1 else 0 end) as Do7500L1, 
	Sum(case when (l.MLIEKNOR>'7500' and l.MLIEKNOR<='8000') then 1 else 0 end) as Do8000L1, 
	Sum(case when (l.MLIEKNOR>'8000' and l.MLIEKNOR<='8500') then 1 else 0 end) as Do8500L1, 
	Sum(case when (l.MLIEKNOR>'8500' and l.MLIEKNOR<='9000') then 1 else 0 end) as Do9000L1, 
	Sum(case when (l.MLIEKNOR>'9000' and l.MLIEKNOR<='9500') then 1 else 0 end) as Do9500L1, 
	Sum(case when (l.MLIEKNOR>'9500' and l.MLIEKNOR<='10000') then 1 else 0 end) as Do10000L1, 
	Sum(case when (l.MLIEKNOR>'10000' and l.MLIEKNOR<='10500') then 1 else 0 end) as Do10500L1, 
	Sum(case when (l.MLIEKNOR>'10500' and l.MLIEKNOR<='11000') then 1 else 0 end) as Do11000L1, 
	Sum(case when (l.MLIEKNOR>'11000' and l.MLIEKNOR<='11500') then 1 else 0 end) as Do11500L1, 
	Sum(case when (l.MLIEKNOR>'11500' and l.MLIEKNOR<='12000') then 1 else 0 end) as Do12000L1, 
	Sum(case when (l.MLIEKNOR>'12000' and l.MLIEKNOR<='12500') then 1 else 0 end) as Do12500L1, 
	Sum(case when (l.MLIEKNOR>'12500' and l.MLIEKNOR<='13000') then 1 else 0 end) as Do13000L1, 
	Sum(case when (l.MLIEKNOR>'13000' and  l.MLIEKNOR<='13500') then 1 else 0 end) as DO13500L1, 
	Sum(case when (l.MLIEKNOR>'13500' and l.MLIEKNOR<='14000') then 1 else 0 end) as DO14000L1, 
	Sum(case when l.MLIEKNOR>'14000' then 1 else 0 end) as Od14000L1 
	
	from @Laktacie as l
	
	where 
	l.PORLAK = '1'
	and (l.ZMENA = '30' or l.ZMENA='40')
	
	----group by @chov
	--select * from @NormLak1 order by CHOV

	Declare @NormLak2 table
  ( [CHOV] [varchar](10) NULL,
	[Do3500L2] [float](4) NULL,
	[Do4000L2] [float](4) NULL,
	[Do4500L2] [float](4) NULL,
	[Do5000L2] [float](4) NULL,
	[Do5500L2] [float](4) NULL,
	[Do6000L2] [float](4) NULL,
	[Do6500L2] [float](4) NULL,
	[Do7000L2] [float](4) NULL,
	[Do7500L2] [float](4) NULL,
	[Do8000L2] [float](4) NULL,
	[Do8500L2] [float](4) NULL,
	[Do9000L2] [float](4) NULL,
	[Do9500L2] [float](4) NULL,
	[Do10000L2] [float](4) NULL,
	[Do10500L2] [float](4) NULL,
	[Do11000L2] [float](4) NULL,
	[Do11500L2] [float](4) NULL,
	[Do12000L2] [float](4) NULL,
	[Do12500L2] [float](4) NULL,
	[Do13000L2] [float](4) NULL,
	[Do13500L2] [float](4) NULL,
	[Do14000L2] [float](4) NULL,
	[Od14000L2] [float](4) NULL
	)
	insert @NormLak2
	select
	@chov as CHOV, 
	Sum(case when l.MLIEKNOR<='3500' then 1 else 0 end) as Do3500L2, 
	Sum(case when (l.MLIEKNOR>'3500' and l.MLIEKNOR<='4000') then 1 else 0 end) as Do4000L2, 
	Sum(case when (l.MLIEKNOR>'4000' and l.MLIEKNOR<='4500') then 1 else 0 end) as Do4500L2, 
	Sum(case when (l.MLIEKNOR>'4500' and l.MLIEKNOR<='5000') then 1 else 0 end) as Do5000L2, 
	Sum(case when (l.MLIEKNOR>'5000' and l.MLIEKNOR<='5500') then 1 else 0 end) as Do5500L2, 
	Sum(case when (l.MLIEKNOR>'5500' and l.MLIEKNOR<='6000') then 1 else 0 end) as Do6000L2, 
	Sum(case when (l.MLIEKNOR>'6000' and l.MLIEKNOR<='6500') then 1 else 0 end) as Do6500L2, 
	Sum(case when (l.MLIEKNOR>'6500' and l.MLIEKNOR<='7000') then 1 else 0 end) as Do7000L2, 
	Sum(case when (l.MLIEKNOR>'7000' and l.MLIEKNOR<='7500') then 1 else 0 end) as Do7500L2, 
	Sum(case when (l.MLIEKNOR>'7500' and l.MLIEKNOR<='8000') then 1 else 0 end) as Do8000L2, 
	Sum(case when (l.MLIEKNOR>'8000' and l.MLIEKNOR<='8500') then 1 else 0 end) as Do8500L2, 
	Sum(case when (l.MLIEKNOR>'8500' and l.MLIEKNOR<='9000') then 1 else 0 end) as Do9000L2, 
	Sum(case when (l.MLIEKNOR>'9000' and l.MLIEKNOR<='9500') then 1 else 0 end) as Do9500L2, 
	Sum(case when (l.MLIEKNOR>'9500' and l.MLIEKNOR<='10000') then 1 else 0 end) as Do10000L2, 
	Sum(case when (l.MLIEKNOR>'10000' and l.MLIEKNOR<='10500') then 1 else 0 end) as Do10500L2, 
	Sum(case when (l.MLIEKNOR>'10500' and l.MLIEKNOR<='11000') then 1 else 0 end) as Do11000L2, 
	Sum(case when (l.MLIEKNOR>'11000' and l.MLIEKNOR<='11500') then 1 else 0 end) as Do11500L2, 
	Sum(case when (l.MLIEKNOR>'11500' and l.MLIEKNOR<='12000') then 1 else 0 end) as Do12000L2, 
	Sum(case when (l.MLIEKNOR>'12000' and l.MLIEKNOR<='12500') then 1 else 0 end) as Do12500L2, 
	Sum(case when (l.MLIEKNOR>'12500' and l.MLIEKNOR<='13000') then 1 else 0 end) as Do13000L2, 
	Sum(case when (l.MLIEKNOR>'13000' and  l.MLIEKNOR<='13500') then 1 else 0 end) as DO13500L2, 
	Sum(case when (l.MLIEKNOR>'13500' and l.MLIEKNOR<='14000') then 1 else 0 end) as DO14000L2, 
	Sum(case when  l.MLIEKNOR>'14000' then 1 else 0 end) as Od14000L2 
	
	from @Laktacie as l
	
	where 
	l.PORLAK >= '2'
	and (l.ZMENA = '30' or l.ZMENA='40')
	
	----group by @chov 
	--select * from @NormLak2 order by CHOV
	
	Declare @NormLakCelk table
  ( [CHOV] [varchar](10) NULL,
	[Do3500Celk] [float](4) NULL,
	[Do4000Celk] [float](4) NULL,
	[Do4500Celk] [float](4) NULL,
	[Do5000Celk] [float](4) NULL,
	[Do5500Celk] [float](4) NULL,
	[Do6000Celk] [float](4) NULL,
	[Do6500Celk] [float](4) NULL,
	[Do7000Celk] [float](4) NULL,
	[Do7500Celk] [float](4) NULL,
	[Do8000Celk] [float](4) NULL,
	[Do8500Celk] [float](4) NULL,
	[Do9000Celk] [float](4) NULL,
	[Do9500Celk] [float](4) NULL,
	[Do10000Celk] [float](4) NULL,
	[Do10500Celk] [float](4) NULL,
	[Do11000Celk] [float](4) NULL,
	[Do11500Celk] [float](4) NULL,
	[Do12000Celk] [float](4) NULL,
	[Do12500Celk] [float](4) NULL,
	[Do13000Celk] [float](4) NULL,
	[Do13500Celk] [float](4) NULL,
	[Do14000Celk] [float](4) NULL,
	[Od14000Celk] [float](4) NULL
	)

	insert @NormLakCelk
	select
	@chov as CHOV, 
	Sum(case when l.MLIEKNOR<='3500' then 1 else 0 end) as Do3500Celk, 
	Sum(case when (l.MLIEKNOR>'3500' and l.MLIEKNOR<='4000') then 1 else 0 end) as Do4000Celk, 
	Sum(case when (l.MLIEKNOR>'4000' and l.MLIEKNOR<='4500') then 1 else 0 end) as Do4500Celk, 
	Sum(case when (l.MLIEKNOR>'4500' and l.MLIEKNOR<='5000') then 1 else 0 end) as Do5000Celk, 
	Sum(case when (l.MLIEKNOR>'5000' and l.MLIEKNOR<='5500') then 1 else 0 end) as Do5500Celk, 
	Sum(case when (l.MLIEKNOR>'5500' and l.MLIEKNOR<='6000') then 1 else 0 end) as Do6000Celk, 
	Sum(case when (l.MLIEKNOR>'6000' and l.MLIEKNOR<='6500') then 1 else 0 end) as Do6500Celk, 
	Sum(case when (l.MLIEKNOR>'6500' and l.MLIEKNOR<='7000') then 1 else 0 end) as Do7000Celk, 
	Sum(case when (l.MLIEKNOR>'7000' and l.MLIEKNOR<='7500') then 1 else 0 end) as Do7500Celk, 
	Sum(case when (l.MLIEKNOR>'7500' and l.MLIEKNOR<='8000') then 1 else 0 end) as Do8000Celk, 
	Sum(case when (l.MLIEKNOR>'8000' and l.MLIEKNOR<='8500') then 1 else 0 end) as Do8500Celk, 
	Sum(case when (l.MLIEKNOR>'8500' and l.MLIEKNOR<='9000') then 1 else 0 end) as Do9000Celk, 
	Sum(case when (l.MLIEKNOR>'9000' and l.MLIEKNOR<='9500') then 1 else 0 end) as Do9500Celk, 
	Sum(case when (l.MLIEKNOR>'9500' and l.MLIEKNOR<='10000') then 1 else 0 end) as Do10000Celk, 
	Sum(case when (l.MLIEKNOR>'10000' and l.MLIEKNOR<='10500') then 1 else 0 end) as Do10500Celk, 
	Sum(case when (l.MLIEKNOR>'10500' and l.MLIEKNOR<='11000') then 1 else 0 end) as Do11000Celk, 
	Sum(case when (l.MLIEKNOR>'11000' and l.MLIEKNOR<='11500') then 1 else 0 end) as Do11500Celk, 
	Sum(case when (l.MLIEKNOR>'11500' and l.MLIEKNOR<='12000') then 1 else 0 end) as Do12000Celk, 
	Sum(case when (l.MLIEKNOR>'12000' and l.MLIEKNOR<='12500') then 1 else 0 end) as Do12500Celk, 
	Sum(case when (l.MLIEKNOR>'12500' and l.MLIEKNOR<='13000') then 1 else 0 end) as Do13000Celk, 
	Sum(case when (l.MLIEKNOR>'13000' and  l.MLIEKNOR<='13500') then 1 else 0 end) as DO13500Celk, 
	Sum(case when (l.MLIEKNOR>'13500' and l.MLIEKNOR<='14000') then 1 else 0 end) as DO14000Celk, 
	Sum(case when l.MLIEKNOR>'14000' then 1 else 0 end) as Od14000Celk 
	
	from @Laktacie as l
	
	where 
	(l.ZMENA = '30' or l.ZMENA='40')
	
	----group by @chov
	--select * from @NormLakCelk order by CHOV

	Declare @ZmenaL1 table
  ( [CHOV] [varchar](10) NULL,
	--[Region] [varchar](2) NULL,
	--[PlemTyp] [varchar] (10) Null,
	[Zmena10L1] [float](4) NULL,
	[Zmena30L1] [float](4) NULL,
	[Zmena31L1] [float](4) NULL,
	[Zmena40L1] [float](4) NULL,
	[Zmena41L1] [float](4) NULL,
	[Zmena42L1] [float](4) NULL,
	[Zmena43L1] [float](4) NULL,
	[ZmenaCelk1L1] [float](4) NULL,
	[Zmena51L1] [float](4) NULL,
	[Zmena52L1] [float](4) NULL,
	[Zmena53L1] [float](4) NULL,
	[Zmena54L1] [float](4) NULL,
	[Zmena55L1] [float](4) NULL,
	[Zmena56L1] [float](4) NULL,
	[Zmena57L1] [float](4) NULL,
	[Zmena58L1] [float](4) NULL,
	[Zmena59L1] [float](4) NULL,
	[Zmena60L1] [float](4) NULL,
	[Zmena61L1] [float](4) NULL,
	[Zmena62L1] [float](4) NULL,
	[ZmenaCelk2L1] [float](4) NULL
	)
	insert @ZmenaL1
	select
	@chov as CHOV, 
	Sum(case when l.ZMENA='10' then 1 else 0 end) as Zmena10L1, 
	Sum(case when l.ZMENA='30' then 1 else 0 end) as Zmena30L1, 
	Sum(case when l.ZMENA='31' then 1 else 0 end) as Zmena31L1, 
	Sum(case when l.ZMENA='40' then 1 else 0 end) as Zmena40L1, 
	Sum(case when l.ZMENA='41' then 1 else 0 end) as Zmena41L1, 
	Sum(case when l.ZMENA='42' then 1 else 0 end) as Zmena42L1, 
	Sum(case when l.ZMENA='43' then 1 else 0 end) as Zmena43L1, 
	Sum(case when (l.ZMENA='10' or l.ZMENA='30' or l.ZMENA='31' or l.ZMENA='40' or l.ZMENA='41' 
	or l.ZMENA='42' or l.ZMENA='43') then 1 else 0 end) as ZmenaCelk1L1, 
	Sum(case when l.DOVVYR='51' then 1 else 0 end) as Zmena51L1, 
	Sum(case when l.DOVVYR='52' then 1 else 0 end) as Zmena52L1, 
	Sum(case when l.DOVVYR='53' then 1 else 0 end) as Zmena53L1, 
	Sum(case when l.DOVVYR='54' then 1 else 0 end) as Zmena54L1, 
	Sum(case when l.DOVVYR='55' then 1 else 0 end) as Zmena55L1, 
	Sum(case when l.DOVVYR='56' then 1 else 0 end) as Zmena56L1, 
	Sum(case when l.DOVVYR='57' then 1 else 0 end) as Zmena57L1, 
	Sum(case when l.DOVVYR='58' then 1 else 0 end) as Zmena58L1, 
	Sum(case when l.DOVVYR='59' then 1 else 0 end) as Zmena59L1, 
	Sum(case when l.DOVVYR='60' then 1 else 0 end) as Zmena60L1, 
	Sum(case when l.DOVVYR='61' then 1 else 0 end) as Zmena61L1, 
	Sum(case when l.DOVVYR='62' then 1 else 0 end) as Zmena62L1, 
	Sum(case when (l.DOVVYR='51' or l.DOVVYR='52' or l.DOVVYR='53' or l.DOVVYR='54' or l.DOVVYR='55' 
	or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60'or l.DOVVYR='61'or l.DOVVYR='62' ) then 1 else 0 end) as ZmenaCelk2L1 

	from @Laktacie as l
	
	where 
	PORLAK='1'
	 
	----group by @chov 	
	--select * from @ZmenaL1 order by CHOV
	
	Declare @ZmenaL2 table
  ( [CHOV] [varchar](10) NULL,
	[Zmena10L2] [float](4) NULL,
	[Zmena30L2] [float](4) NULL,
	[Zmena31L2] [float](4) NULL,
	[Zmena40L2] [float](4) NULL,
	[Zmena41L2] [float](4) NULL,
	[Zmena42L2] [float](4) NULL,
	[Zmena43L2] [float](4) NULL,
	[ZmenaCelk1L2] [float](4) NULL,
	[Zmena51L2] [float](4) NULL,
	[Zmena52L2] [float](4) NULL,
	[Zmena53L2] [float](4) NULL,
	[Zmena54L2] [float](4) NULL,
	[Zmena55L2] [float](4) NULL,
	[Zmena56L2] [float](4) NULL,
	[Zmena57L2] [float](4) NULL,
	[Zmena58L2] [float](4) NULL,
	[Zmena59L2] [float](4) NULL,
	[Zmena60L2] [float](4) NULL,
	[Zmena61L2] [float](4) NULL,
	[Zmena62L2] [float](4) NULL,
	[ZmenaCelk2L2] [float](4) NULL
	)
	insert @ZmenaL2
	select
	@chov as CHOV, 
	Sum(case when l.ZMENA='10' then 1 else 0 end) as Zmena10L2, 
	Sum(case when l.ZMENA='30' then 1 else 0 end) as Zmena30L2, 
	Sum(case when l.ZMENA='31' then 1 else 0 end) as Zmena31L2, 
	Sum(case when l.ZMENA='40' then 1 else 0 end) as Zmena40L2, 
	Sum(case when l.ZMENA='41' then 1 else 0 end) as Zmena41L2, 
	Sum(case when l.ZMENA='42' then 1 else 0 end) as Zmena42L2, 
	Sum(case when l.ZMENA='43' then 1 else 0 end) as Zmena43L2, 
	Sum(case when (l.ZMENA='10' or l.ZMENA='30' or l.ZMENA='31' or l.ZMENA='40' or l.ZMENA='41' 
	or l.ZMENA='42' or l.ZMENA='43') then 1 else 0 end) as ZmenaCelk1L2, 
	Sum(case when l.DOVVYR='51' then 1 else 0 end) as Zmena51L2, 
	Sum(case when l.DOVVYR='52' then 1 else 0 end) as Zmena52L2, 
	Sum(case when l.DOVVYR='53' then 1 else 0 end) as Zmena53L2, 
	Sum(case when l.DOVVYR='54' then 1 else 0 end) as Zmena54L2, 
	Sum(case when l.DOVVYR='55' then 1 else 0 end) as Zmena55L2, 
	Sum(case when l.DOVVYR='56' then 1 else 0 end) as Zmena56L2, 
	Sum(case when l.DOVVYR='57' then 1 else 0 end) as Zmena57L2, 
	Sum(case when l.DOVVYR='58' then 1 else 0 end) as Zmena58L2, 
	Sum(case when l.DOVVYR='59' then 1 else 0 end) as Zmena59L2, 
	Sum(case when l.DOVVYR='60' then 1 else 0 end) as Zmena60L2, 
	Sum(case when l.DOVVYR='61' then 1 else 0 end) as Zmena61L2, 
	Sum(case when l.DOVVYR='62' then 1 else 0 end) as Zmena62L2, 
	Sum(case when (l.DOVVYR='51' or l.DOVVYR='52' or l.DOVVYR='53' or l.DOVVYR='54' or l.DOVVYR='55' 
	or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60' or l.DOVVYR='61'or l.DOVVYR='62' ) then 1 else 0 end) as ZmenaCelk2L2 

	from @Laktacie as l
	
	where 
	PORLAK>='2'
	
	----group by @chov
	--select * from @ZmenaL2 order by CHOV

	Declare @ZmenaCelk table
  ( [CHOV] [varchar](10) NULL,
	[Zmena10Celk] [float](4) NULL,
	[Zmena30Celk] [float](4) NULL,
	[Zmena31Celk] [float](4) NULL,
	[Zmena40Celk] [float](4) NULL,
	[Zmena41Celk] [float](4) NULL,
	[Zmena42Celk] [float](4) NULL,
	[Zmena43Celk] [float](4) NULL,
	[ZmenaCelk1Celk] [float](4) NULL,
	[Zmena51Celk] [float](4) NULL,
	[Zmena52Celk] [float](4) NULL,
	[Zmena53Celk] [float](4) NULL,
	[Zmena54Celk] [float](4) NULL,
	[Zmena55Celk] [float](4) NULL,
	[Zmena56Celk] [float](4) NULL,
	[Zmena57Celk] [float](4) NULL,
	[Zmena58Celk] [float](4) NULL,
	[Zmena59Celk] [float](4) NULL,
	[Zmena60Celk] [float](4) NULL,
	[Zmena61Celk] [float](4) NULL,
	[Zmena62Celk] [float](4) NULL,
	[ZmenaCelk2Celk] [float](4) NULL
	)

	insert @ZmenaCelk
	select
	@chov as CHOV, 
	Sum(case when l.ZMENA='10' then 1 else 0 end) as Zmena10Celk, 
	Sum(case when l.ZMENA='30' then 1 else 0 end) as Zmena30Celk, 
	Sum(case when l.ZMENA='31' then 1 else 0 end) as Zmena31Celk, 
	Sum(case when l.ZMENA='40' then 1 else 0 end) as Zmena40Celk, 
	Sum(case when l.ZMENA='41' then 1 else 0 end) as Zmena41Celk, 
	Sum(case when l.ZMENA='42' then 1 else 0 end) as Zmena42Celk, 
	Sum(case when l.ZMENA='43' then 1 else 0 end) as Zmena43Celk, 
	Sum(case when (l.ZMENA='10' or l.ZMENA='30' or l.ZMENA='31' or l.ZMENA='40' or l.ZMENA='41' 
	or l.ZMENA='42' or l.ZMENA='43') then 1 else 0 end) as ZmenaCelk1Celk, 
	Sum(case when l.DOVVYR='51' then 1 else 0 end) as Zmena51Celk, 
	Sum(case when l.DOVVYR='52' then 1 else 0 end) as Zmena52Celk, 
	Sum(case when l.DOVVYR='53' then 1 else 0 end) as Zmena53Celk, 
	Sum(case when l.DOVVYR='54' then 1 else 0 end) as Zmena54Celk, 
	Sum(case when l.DOVVYR='55' then 1 else 0 end) as Zmena55Celk, 
	Sum(case when l.DOVVYR='56' then 1 else 0 end) as Zmena56Celk, 
	Sum(case when l.DOVVYR='57' then 1 else 0 end) as Zmena57Celk, 
	Sum(case when l.DOVVYR='58' then 1 else 0 end) as Zmena58Celk, 
	Sum(case when l.DOVVYR='59' then 1 else 0 end) as Zmena59Celk, 
	Sum(case when l.DOVVYR='60' then 1 else 0 end) as Zmena60Celk, 
	Sum(case when l.DOVVYR='61' then 1 else 0 end) as Zmena61Celk, 
	Sum(case when l.DOVVYR='62' then 1 else 0 end) as Zmena62Celk, 
	Sum(case when (l.DOVVYR='51' or l.DOVVYR='52' or l.DOVVYR='53' or l.DOVVYR='54' or l.DOVVYR='55' 
	or l.DOVVYR='56' or l.DOVVYR='57' or l.DOVVYR='58' or l.DOVVYR='59' or l.DOVVYR='60'or l.DOVVYR='61'or l.DOVVYR='62' ) then 1 else 0 end) as ZmenaCelk2Celk 

	from @Laktacie as l
	
	----group by @chov 
	--select * from @ZmenaCelk order by CHOV



insert dbo.CR_LaktacneZostavy_Opr 
	(
	Oznacenie,DatumOd,DatumDo,Filter, datumGenerovania, EkoChov,

	PocZapojL1, PocLakV1, PocLakN1, MedziobdL1,LakdniL1,LakdniNL1,MliekNorL1,TukNorL1, BielkNorL1,	LaktozaNL1, IPZL1, VyrZootechL1, VyrZdravDovL1,
	
	PocZapojL2, PocLakV2,PocLakN2,MedziobdL2,LaktDniL2,LakDniNL2,MliekNorL2,TukNorL2, BielkNorL2, LaktozaNL2, IPZL2, VyrZootechL2, VyrZdravDovL2,

	PocZapojCelk,PocLakVcelk,PocLakNcelk,MedziobdCelk,LaktDniCelk, LakDniNCelk, MliekNorCelk,TukNorCelk, BielkNorCelk, LaktozaNCelk, IPZCelk, VyrZootechCelk, VyrZdravDovCelk,

	Do3500L1,Do4000L1,Do4500L1, Do5000L1,Do5500L1, Do6000L1, Do6500L1, Do7000L1, Do7500L1, Do8000L1, Do8500L1,
	Do9000L1, Do9500L1, Do10000L1, Do10500L1, Do11000L1, Do11500L1,Do12000L1,Do12500L1, Do13000L1,Do13500L1, Do14000L1, Od14000L1,
	 
	Do3500L2, Do4000L2, Do4500L2, Do5000L2, Do5500L2, Do6000L2, Do6500L2, Do7000L2, Do7500L2, Do8000L2,Do8500L2, Do9000L2,Do9500L2, 
	Do10000L2, Do10500L2, Do11000L2, Do11500L2, Do12000L2, Do12500L2, Do13000L2,Do13500L2, Do14000L2, Od14000L2,
	 
	Do3500Celk, Do4000Celk, Do4500Celk, Do5000Celk, Do5500Celk, Do6000Celk, Do6500Celk, Do7000Celk,	Do7500Celk, Do8000Celk, Do8500Celk,
	Do9000Celk, Do9500Celk,Do10000Celk, Do10500Celk,Do11000Celk, Do11500Celk,Do12000Celk, Do12500Celk, Do13000Celk, Do13500Celk, Do14000Celk, Od14000Celk,

	Zmena10L1, Zmena30L1,Zmena31L1,Zmena40L1,Zmena41L1,	Zmena42L1,Zmena43L1,ZmenaCelk1L1,Zmena51L1,Zmena52L1,Zmena53L1,Zmena54L1,Zmena55L1,Zmena56L1,Zmena57L1,
	Zmena58L1,Zmena59L1,Zmena60L1,Zmena61L1,Zmena62L1,ZmenaCelk2L1,

	Zmena10L2, Zmena30L2,Zmena31L2,Zmena40L2,Zmena41L2,	Zmena42L2,Zmena43L2,ZmenaCelk1L2,Zmena51L2,Zmena52L2,Zmena53L2,Zmena54L2,Zmena55L2,Zmena56L2,Zmena57L2,
	Zmena58L2,Zmena59L2,Zmena60L2,Zmena61L2,Zmena62L2,ZmenaCelk2L2,
	
	Zmena10Celk, Zmena30Celk,Zmena31Celk,Zmena40Celk,Zmena41Celk,	Zmena42Celk,Zmena43Celk,ZmenaCelk1Celk,Zmena51Celk,Zmena52Celk,Zmena53Celk,Zmena54Celk,Zmena55Celk,Zmena56Celk,Zmena57Celk,
	Zmena58Celk,Zmena59Celk,Zmena60Celk,Zmena61Celk,Zmena62Celk,ZmenaCelk2Celk
	)

	select distinct
	@chov as Oznacenie,
	@datumOd as DatumOd,
	@datumDo as DatumDo,
	@chov as Filer,
	getdate() as datumGenerovania,
	l.EkoChov as EkoChov,
	ZapojL1.PocZapojL1 as PocZapojL1,
	ROUND(LAKV1.PocLakV1,2) as PocLakV1, 
	ROUND(L1.PocLakN1,2) as PocLakN1, 
	convert(varchar, round(L1.MEDZIOBDL1 / 30.42, 0))+' / '+convert(varchar, convert(decimal(5,0), ROUND( convert(int, L1.MedziobdL1) % 30.42, 0)) ) AS  MedziobdL1,
	ROUND(L1.LakdniL1,2) as LakdniL1,
	ROUND(L1.LakdniNL1,2) as LakdniNL1,
	ROUND(L1.MliekNorL1,2) as MliekNorL1,
	ROUND(L1.TukNorL1,2) as TukNorL1,
	ROUND(L1.BielkNorL1,2) as BielkNorL1 ,
	ROUND(L1.LaktozaNL1,2) as LaktozaNL1, 
	ROUND(L1.IPZL1,2) as IPZL1,
	L1.VyrZootechL1 as VyrZootechL1,
	L1.VyrZdravDovL1 as VyrZdravDovL1,
	ZapojL2.PocZapojL2 as PocZapojL2, 
	ROUND(LAKV2.PocLakV2,2) as PocLakV2,
	ROUND(L2.PocLakN2,2) as PocLakN2,
	ROUND(L2.MedziobdL2,2) as MedziobdL2,
	ROUND(L2.LaktDniL2,2) as LaktDniL2,
	ROUND(L2.LakDniNL2,2) as LakDniNL2,
	ROUND(L2.MliekNorL2,2) as MliekNorL2,
	ROUND(L2.TukNorL2,2) as TukNorL2,
	ROUND(L2.BielkNorL2,2) as BielkNorL2,
	ROUND(L2.LaktozaNL2,2) as LaktozaNL2,
	ROUND(L2.IPZL2,2) as IPZL2,
	L2.VyrZootechL2 as VyrZootechL2,
	L2.VyrZdravDovL2 as VyrZdravDovL2,

	ZapojLCelk.PocZapojLCelk as PocZapojCelk, 
	ROUND(LAKVC.PocLakVcelk,2) as PocLakVcelk,
	ROUND(lCelk.PocLakNcelk,2) as PocLakNcelk,
	ROUND(lCelk.MedziobdCelk,2) as MedziobdCelk,
	ROUND(lCelk.LaktDniCelk,2) as LaktDniCelk,
	ROUND(lCelk.LakDniNCelk,2) as LakDniNCelk,
	ROUND(lCelk.MliekNorCelk,2) as MliekNorCelk,
	ROUND(lCelk.TukNorCelk,2) as TukNorCelk,
	ROUND(lCelk.BielkNorCelk,2) as BielkNorCelk,
	ROUND(lCelk.LaktozaNCelk,2) as LaktozaNCelk,
	ROUND(lCelk.IPZCelk,2) as IPZCelk,
	lCelk.VyrZootechCelk as VyrZootechCelk,
	lCelk.VyrZdravDovCelk as VyrZdravDovCelk,

	NL1.Do3500L1 AS Do3500L1,
	NL1.Do4000L1 as Do4000L1,
	NL1.Do4500L1 as Do4500L1,
	NL1.Do5000L1 as Do5000L1,
	NL1.Do5500L1 as Do5500L1,
	NL1.Do6000L1 as Do6000L1,
	NL1.Do6500L1 as Do6500L1,
	NL1.Do7000L1 as Do7000L1,
	NL1.Do7500L1 as Do7500L1,
	NL1.Do8000L1 as Do8000L1,
	NL1.Do8500L1 as Do8500L1,
	NL1.Do9000L1 as Do9000L1,
	NL1.Do9500L1 as Do9500L1,
	NL1.Do10000L1 as Do10000L1,
	NL1.Do10500L1 as Do10500L1,
	NL1.Do11000L1 as Do11000L1,
	NL1.Do11500L1 as Do11500L1,
	NL1.Do12000L1 as Do12000L1,
	NL1.Do12500L1 as Do12500L1,
	NL1.Do13000L1 as Do13000L1,
	NL1.Do13500L1 as Do13500L1,
	NL1.Do14000L1 as Do14000L1,
	NL1.Od14000L1 as Od14000L1,
	 
	NL2.Do3500L2 AS Do3500L2,
	NL2.Do4000L2 as Do4000L2,
	NL2.Do4500L2 as Do4500L2,
	NL2.Do5000L2 as Do5000L2,
	NL2.Do5500L2 as Do5500L2,
	NL2.Do6000L2 as Do6000L2,
	NL2.Do6500L2 as Do6500L2,
	NL2.Do7000L2 as Do7000L2,
	NL2.Do7500L2 as Do7500L2,
	NL2.Do8000L2 as Do8000L2,
	NL2.Do8500L2 as Do8500L2,
	NL2.Do9000L2 as Do9000L2,
	NL2.Do9500L2 as Do9500L2,
	NL2.Do10000L2 as Do10000L2,
	NL2.Do10500L2 as Do10500L2,
	NL2.Do11000L2 as Do11000L2,
	NL2.Do11500L2 as Do11500L2,
	NL2.Do12000L2 as Do12000L2,
	NL2.Do12500L2 as Do12500L2,
	NL2.Do13000L2 as Do13000L2,
	NL2.Do13500L2 as Do13500L2,
	NL2.Do14000L2 as Do14000L2,
	NL2.Od14000L2 as Od14000L2,
	 
	NlCelk.Do3500Celk AS Do3500Celk,
	NlCelk.Do4000Celk as Do4000Celk,
	NlCelk.Do4500Celk as Do4500Celk,
	NlCelk.Do5000Celk as Do5000Celk,
	NlCelk.Do5500Celk as Do5500Celk,
	NlCelk.Do6000Celk as Do6000Celk,
	NlCelk.Do6500Celk as Do6500Celk,
	NlCelk.Do7000Celk as Do7000Celk,
	NlCelk.Do7500Celk as Do7500Celk,
	NlCelk.Do8000Celk as Do8000Celk,
	NlCelk.Do8500Celk as Do8500Celk,
	NlCelk.Do9000Celk as Do9000Celk,
	NlCelk.Do9500Celk as Do9500Celk,
	NlCelk.Do10000Celk as Do10000Celk,
	NlCelk.Do10500Celk as Do10500Celk,
	NlCelk.Do11000Celk as Do11000Celk,
	NlCelk.Do11500Celk as Do11500Celk,
	NlCelk.Do12000Celk as Do12000Celk,
	NlCelk.Do12500Celk as Do12500Celk,
	NlCelk.Do13000Celk as Do13000Celk,
	NlCelk.Do13500Celk as Do13500Celk,
	NlCelk.Do14000Celk as Do14000Celk,
	NlCelk.Od14000Celk as Od14000Celk, 

	ZL1.Zmena10L1 as Zmena10L1, 
	ZL1.Zmena30L1 as Zmena30L1,
	ZL1.Zmena31L1 as Zmena31L1,
	ZL1.Zmena40L1 as Zmena40L1,
	ZL1.Zmena41L1 as Zmena41L1,	
	ZL1.Zmena42L1 as Zmena42L1,
	ZL1.Zmena43L1 as Zmena43L1,
	ZL1.ZmenaCelk1L1 as ZmenaCelk1L1,
	ZL1.Zmena51L1 as Zmena51L1,
	ZL1.Zmena52L1 as Zmena52L1,
	ZL1.Zmena53L1 as Zmena53L1,
	ZL1.Zmena54L1 as Zmena54L1,
	ZL1.Zmena55L1 as Zmena55L1,
	ZL1.Zmena56L1 as Zmena56L1,
	ZL1.Zmena57L1 as Zmena57L1,
	ZL1.Zmena58L1 as Zmena58L1,
	ZL1.Zmena59L1 as Zmena59L1,
	ZL1.Zmena60L1 as Zmena60L1,
	ZL1.Zmena61L1 as Zmena61L1,
	ZL1.Zmena62L1 as Zmena62L1,
	ZL1.ZmenaCelk2L1 asZmenaCelk2L1,

	ZL2.Zmena10L2 as Zmena10L2, 
	ZL2.Zmena30L2 as Zmena30L2,
	ZL2.Zmena31L2 as Zmena31L2,
	ZL2.Zmena40L2 as Zmena40L2,
	ZL2.Zmena41L2 as Zmena41L2,	
	ZL2.Zmena42L2 as Zmena42L2,
	ZL2.Zmena43L2 as Zmena43L2,
	ZL2.ZmenaCelk1L2 as ZmenaCelk1L2,
	ZL2.Zmena51L2 as Zmena51L2,
	ZL2.Zmena52L2 as Zmena52L2,
	ZL2.Zmena53L2 as Zmena53L2,
	ZL2.Zmena54L2 as Zmena54L2,
	ZL2.Zmena55L2 as Zmena55L2,
	ZL2.Zmena56L2 as Zmena56L2,
	ZL2.Zmena57L2 as Zmena57L2,
	ZL2.Zmena58L2 as Zmena58L2,
	ZL2.Zmena59L2 as Zmena59L2,
	ZL2.Zmena60L2 as Zmena60L2,
	ZL2.Zmena61L2 as Zmena61L2,
	ZL2.Zmena62L2 as Zmena62L2,
	ZL2.ZmenaCelk2L2 asZmenaCelk2L2,

	ZCelk.Zmena10Celk as Zmena10Celk, 
	ZCelk.Zmena30Celk as Zmena30Celk,
	ZCelk.Zmena31Celk as Zmena31Celk,
	ZCelk.Zmena40Celk as Zmena40Celk,
	ZCelk.Zmena41Celk as Zmena41Celk,	
	ZCelk.Zmena42Celk as Zmena42Celk,
	ZCelk.Zmena43Celk as Zmena43Celk,
	ZCelk.ZmenaCelk1Celk as ZmenaCelk1Celk,
	ZCelk.Zmena51Celk as Zmena51Celk,
	ZCelk.Zmena52Celk as Zmena52Celk,
	ZCelk.Zmena53Celk as Zmena53Celk,
	ZCelk.Zmena54Celk as Zmena54Celk,
	ZCelk.Zmena55Celk as Zmena55Celk,
	ZCelk.Zmena56Celk as Zmena56Celk,
	ZCelk.Zmena57Celk as Zmena57Celk,
	ZCelk.Zmena58Celk as Zmena58Celk,
	ZCelk.Zmena59Celk as Zmena59Celk,
	ZCelk.Zmena60Celk as Zmena60Celk,
	ZCelk.Zmena61Celk as Zmena61Celk,
	ZCelk.Zmena62Celk as Zmena62Celk,
	ZCelk.ZmenaCelk2Celk as ZmenaCelk2Celk
	 
	from @Laktacie as l

	left outer join @PocZapojL1 ZapojL1 on ((ZapojL1.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null))
	left outer  join @PocZapojL2 ZapojL2 on ((ZapojL2.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null)) 
	left outer  join @PocZapojLCelk  ZapojLCelk on ((ZapojLCelk.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null)) 
	left outer  join @pocLAKV1  LAKV1 on ((LAKV1.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null))
	left outer  join @pocLAKV2  LAKV2 on ((LAKV2.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null))
	left outer join @pocLAKVCelk LAKVC on ((LAKVC.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null))
	left outer  join @lakt1  L1 on ((L1.CHOV =  substring(l.CHOVATEL, 1, len(@chov))or @chov is null))
	left outer  join @lakt2  L2 on ((substring(l.CHOVATEL, 1, len(@chov))= L2.CHOV or @chov is null))
	left outer  join @laktCelkom as lCelk on (( substring(l.CHOVATEL, 1, len(@chov))= lCelk.CHOV or @chov is null))
	left outer  join @NormLak1  NL1 on ((NL1.CHOV =  substring(l.CHOVATEL, 1, len(@chov)) or @chov is null))
	left outer  join @NormLak2  NL2 on ((substring(l.CHOVATEL, 1, len(@chov))= NL2.CHOV or @chov is null))
	left outer  join @NormLakCelk as NlCelk on ((substring(CHOVATEL, 1, len(@chov))= NlCelk.CHOV or @chov is null))
	left outer  join @ZmenaL1 as ZL1 on ((substring(l.CHOVATEL, 1, len(@chov))= ZL1.CHOV or @chov is null))
	left outer  join @ZmenaL2 as ZL2 on ((substring(l.CHOVATEL, 1, len(@chov))= ZL2.CHOV or @chov is null))
	left outer  join @ZmenaCelk as ZCelk on ((substring(l.CHOVATEL, 1, len(@chov))= ZCelk.CHOV or @chov is null))
	left outer  join  NC_OKRES as reg on ((reg.KRAJ + reg.OKRES)= substring(l.CHOVATEL, 1, 3) or @chov is null)
	
	update Roc_MLHD_Tab_22A 
	set stpec_7 = PocLakN1
				, stpec_8 = LakdniNL1
				, stpec_9 = MliekNorL1
				, stpec_10 = round((TukNorL1*100)/MliekNorL1,2)
				, stpec_11 = TukNorL1
				, stpec_12 = round((BielkNorL1*100)/MliekNorL1,2)
				, stpec_13 = BielkNorL1
				, stpec_14Mesiac = (select val from string2table (k.MedziobdL1,'/') where seq = 1)
				, stpec_14Den = (select val from string2table (k.MedziobdL1,'/') where seq = 2)
				, stpec_15 = PocLakN2
				, stpec_16 = LakDniNL2
				, stpec_17 = MliekNorL2
				, stpec_18 = round((TukNorL2*100)/MliekNorL2,2) 
				, stpec_19 = TukNorL2
				, stpec_20 = round((BielkNorL2*100)/MliekNorL2,2)
				, stpec_21 = BielkNorL2
				, stpec_22 = MedziobdL2
				, stpec_23 = PocLakNcelk
				, stpec_24 = LakDniNCelk
				, stpec_25 = MliekNorCelk
				, stpec_26 = round((TukNorCelk*100)/MliekNorCelk,2)
				, stpec_27 = TukNorCelk
				, stpec_28 = round((BielkNorCelk*100)/MliekNorCelk,2)
				, stpec_29 = BielkNorCelk

				from CR_LaktacneZostavy_Opr as k  
				where k.oznacenie= @chov  and oznacenie = Filter
					and SUBSTRING(Oznacenie,1,6) = kraj + okres + podnik 
					and rok = datepart(year, k.datumOd)
					and stpec_6 = 'Chov spolu'




	end
go

------------------------------------------------------------------------------


/****** Script for SelectTopNRows command from SSMS  ******/
/** Rocenka MLHD ----PREHLAD VYSLEDKOV PODLA KRAJOV - POCET SOMATICKYCH BUNIEK VO VZORKACH MLIEKA ---str 15 **/
/**  SB do 400 tisic a nad 400 tisic**/
CREATE procedure  [dbo].[Roc_MLHD_5]

    @datumOd date,
    @datumDo date
  --declare @datumOd date = '2018-01-01', @datumDo date= '2018-09-30'
as
  begin

    select do400.kraj, do400.nazov, pocet_do_400, pocet_nad_400, pocet, spolu_SB, priemer_pocet_SB
    from (/**somaticke bunky do 400 tisic**/
         select distinct t.kraj, t.nazov, Count(*) as pocet_do_400
         from (select distinct p.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR
               from CM_Kontroly as k
                      left outer join NC_KRAJ p on p.KRAJ = SUBSTRING(k.CISCHOVU, 1, 1)
               where k.DATKONTR >= @datumOd
                 and k.DATKONTR <= @datumDo
                 and k.BUNECELEM < 400
                 and p.KRAJ <> 0
               union
               select distinct p.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR
               from CM_ArchKon as ak
                      left outer join NC_KRAJ p on p.KRAJ = SUBSTRING(ak.CISCHOVU, 1, 1)
               where ak.DATKONTR >= @datumOd
                 and ak.DATKONTR <= @datumDo
                 and ak.BUNECELEM < 400
                 and p.KRAJ <> 0) as t
         group by t.kraj, t.nazov) as do400
           left outer join (/**somaticke bunky nad 400 tisic**/
                           select distinct t.kraj, t.nazov, Count(*) as pocet_nad_400
                           from (select distinct p.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR
                                 from CM_Kontroly as k
                                        left outer join NC_KRAJ p on p.KRAJ = SUBSTRING(k.CISCHOVU, 1, 1)
                                 where k.DATKONTR >= @datumOd
                                   and k.DATKONTR <= @datumDo
                                   and k.BUNECELEM >= 400
                                   and p.KRAJ <> 0
                                 union
                                 select distinct p.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR
                                 from CM_ArchKon as ak
                                        left outer join NC_KRAJ p on p.KRAJ = SUBSTRING(ak.CISCHOVU, 1, 1)
                                 where ak.DATKONTR >= @datumOd
                                   and ak.DATKONTR <= @datumDo
                                   and ak.BUNECELEM >= 400
                                   and p.KRAJ <> 0) as t
                           group by t.kraj, t.nazov) as nad400 on do400.KRAJ = nad400.KRAJ
           left outer join (/**priemer SB za kraj**/
                           select distinct t.kraj,
                                           t.nazov,
                                           Count(*)                  as pocet,
                                           sum(BUNECELEM)            as spolu_SB,
                                           sum(BUNECELEM) / Count(*) as priemer_pocet_SB
                           from (select distinct p.KRAJ, p.NAZOV, k.CISKRAVY, k.DATKONTR, k.BUNECELEM
                                 from CM_Kontroly as k
                                        left outer join NC_KRAJ p on p.KRAJ = SUBSTRING(k.CISCHOVU, 1, 1)
                                 where k.DATKONTR >= @datumOd
                                   and k.DATKONTR <= @datumDo
                                   and k.BUNECELEM is not null
                                   and p.KRAJ <> 0
                                 union
                                 select distinct p.KRAJ, p.NAZOV, ak.CISKRAVY, ak.DATKONTR, ak.BUNECELEM
                                 from CM_ArchKon as ak
                                        left outer join NC_KRAJ p on p.KRAJ = SUBSTRING(ak.CISCHOVU, 1, 1)
                                 where ak.DATKONTR >= @datumOd
                                   and ak.DATKONTR <= @datumDo
                                   and ak.BUNECELEM is not null
                                   and p.KRAJ <> 0) as t
                           group by t.kraj, t.nazov)
        as priemer on do400.KRAJ = priemer.KRAJ

    order by KRAJ

  end
go


------------------------------------------------------------------------------------


-- =============================================
-- Author:		PSSR, š.p.
-- Create date: 16.12.2017
-- Description:	Udaje do rocenky za plemeno S/P/H/B kvoli tabulke: VYSLEDKY KONTROLY UZISTKOVOSTI ZA SLACHTITELSKE CHOVY - PODLA PLEMIEN 
--				nasledne sa pouziju data z tabulky CR_LaktacneZostavy_rocenka do tabulky Roc_MLHD_Tab_19A
-- =============================================
CREATE procedure [dbo].[Roc_MLHD_19_SR]
	
	@datumOd date,
	@datumDo date =''
as	
begin
delete from Roc_MLHD_Tab_19A where kraj+OKRES + PODNIK + CHOV = '999999999' and rok = DATEPART(YEAR, @datumOd)
--use mirka_db
--declare @datumOd date = '2017-01-01', @datumDO date = '2017-12-31'

--delete from Roc_MLHD_Tab_19A where rok = DATEPART(YEAR, @datumOd)

insert into Roc_MLHD_Tab_19A
  ( Por,KRAJ,OKRES,PODNIK,CHOV,stpec_1,stpec_2,stpec_3,stpec_4,stpec_5,stpec_6,stpec_7
      ,stpec_8,stpec_9,stpec_10,stpec_11,stpec_12,stpec_13,stpec_14Mesiac,stpec_14Den,stpec_15,stpec_16,stpec_17,stpec_18
      ,stpec_19,stpec_20,stpec_21,stpec_22,stpec_23,stpec_24,stpec_25,stpec_26,stpec_27,stpec_28,stpec_29,rok,Plem_typ)

select '2' as Por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
		,''as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,'' as stpec_5
		,'Plemeno - Holsteinské' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29 
		,datepart (year, @datumOd) as rok
		,'Hol' as Plem_typ

	 from dbo.CR_LaktacneZostavy_Opr as z
		where datumDO= @datumDo 
					and DatumOd= @datumOd
					and Filter = 'SR,ChZ3'
--SR,ChZ1
--SR,ChZ2
--SR,ChZ3
--SR,ChZ5

union 
	select 
		'1' as Por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
				--ChCh.NAZOV as CHARCHOV,
		,'' as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,''as stpec_5
		,'Vyhovujúce štatútu / všetky' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29
		,datepart (year, @datumOd) as rok
		,'Hol' as Plem_typ
	 from dbo.CR_LaktacneZostavy_Opr  as z
		where 'H' = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and filter='SR,H'
union 
select '2' as Por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
		,''as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,'' as stpec_5
		,'Plemeno - Slovenské strakaté' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29 
		,datepart (year, @datumOd) as rok
		,'SLst' as Plem_typ

	 from dbo.CR_LaktacneZostavy_Opr as z
		where datumDO= @datumDo 
					and DatumOd= @datumOd
					and Filter = 'SR,ChZ1'
--SR,ChZ1
--SR,ChZ2
--SR,ChZ3
--SR,ChZ5

union 
	select 
		'1' as Por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
				--ChCh.NAZOV as CHARCHOV,
		,'' as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,''as stpec_5
		,'Vyhovujúce štatútu / všetky' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29
		,datepart (year, @datumOd) as rok
		,'SLst' as Plem_typ
	 from dbo.CR_LaktacneZostavy_Opr as z
		where 'S' = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and filter='SR,S'

union 

select '2' as Por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
		,''as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,'' as stpec_5
		,'Plemeno - Slovenské pinzgauské' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29 
		,datepart (year, @datumOd) as rok
		,'Pin' as Plem_typ

	 from dbo.CR_LaktacneZostavy_Opr as z
		where datumDO= @datumDo 
					and DatumOd= @datumOd
					and Filter = 'SR,ChZ2'
--SR,ChZ1
--SR,ChZ2
--SR,ChZ3
--SR,ChZ5


					--and (ch.ZRUS is null or(ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
union 
	select 
		'1' as Por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
				--ChCh.NAZOV as CHARCHOV,
		,'' as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,''as stpec_5
		,'Vyhovujúce štatútu / všetky' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29
		,datepart (year, @datumOd) as rok
		,'Pin' as Plem_typ
	 from dbo.CR_LaktacneZostavy_Opr  as z
		where 'P' = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and filter='SR,P'

union select '2' as Por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
		,''as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,'' as stpec_5
		,'Plemeno - Braunvieh' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29 
		,datepart (year, @datumOd) as rok
		,'Brau' as Plem_typ

	 from dbo.CR_LaktacneZostavy_Opr as z
		where datumDO= @datumDo 
					and DatumOd= @datumOd
					and Filter = 'SR,ChZ5'
--SR,ChZ1
--SR,ChZ2
--SR,ChZ3
--SR,ChZ5

union 
	select 
		'1' as Por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
		--ChCh.NAZOV as CHARCHOV,
		,'' as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,''as stpec_5
		,'Vyhovujúce štatútu / všetky' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29
		,datepart (year, @datumOd) as rok
		,'Brau' as Plem_typ
	 from dbo.CR_LaktacneZostavy_Opr as z
		where 'B' = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and filter='SR,B'
/*****spolu za SR***/				
union
	select 
		'3' as por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
				--ChCh.NAZOV as CHARCHOV,
		,'' as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,''as stpec_5
		,'Plemeno - Holsteinské' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29
		,datepart (year, @datumOd) as rok
		,'SR' as Plem_typ
	 from dbo.CR_LaktacneZostavy_Opr  as z
		--left outer join NM_HDDETAIL as h on h.KRAJ + h.OKRES + h.PODNIK + h.CHOV = @chov
		--left outer join NC_VyrObl as vo on vo.KOD = h.VYROBL
		--left outer join NC_CharChov as ChCh on ChCh.KOD = h.CHARCHOV and ChCh.DRUHHZ = h.TYPZV
		where 'H' = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and filter='SR,H'
			
	union 
	select 	'1' as por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
				--ChCh.NAZOV as CHARCHOV,
		,'' as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,''as stpec_5
		,'Plemeno - Slovenské strakaté' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29
		,datepart (year, @datumOd) as rok
		,'SR' as Plem_typ
	 from dbo.CR_LaktacneZostavy_Opr  as z
		where 'S' = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and filter='SR,S'

union 
	select 
		'2' as por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
				--ChCh.NAZOV as CHARCHOV,
		,'' as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,''as stpec_5
		,'Plemeno - Slovenské pinzgauské' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29
		,datepart (year, @datumOd) as rok
		,'SR' as Plem_typ
	 from dbo.CR_LaktacneZostavy_Opr  as z
		where 'P' = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and filter='SR,P'

	union 
		select 
		'4' as por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
			--ChCh.NAZOV as CHARCHOV,
		,'' as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,''as stpec_5
		,'Plemeno - Braunvieh' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29
		,datepart (year, @datumOd) as rok
		,'SR' as Plem_typ
	 from dbo.CR_LaktacneZostavy_Opr  as z
		where 'B' = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and filter='SR,B'

	union 
		select 
		'5' as por
		,'9' as kraj
		,'99' as okres
		,'999' as podnik
		,'999' as chov
		,'' as stpec_1--SPVYKON,
		,'' AS stpec_2--CHARCHOV_kod,
		,'' as stpec_3--VYROBL, 
		,'' as stpec_4--CHARUS
		,''as stpec_5
		,'Spolu' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1,0) as stpec_8
		,round(z.MliekNorL1,0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1,0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1,0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2,0) as stpec_16
		,round(z.MliekNorL2,0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2,0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2,0) as stpec_21
		,round(z.MedziobdL2,0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk,0) as stpec_24
		,round(z.MliekNorCelk,0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk,0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk,0) as stpec_29
		,datepart (year, @datumOd) as rok
		,'SR' as Plem_typ
	 from dbo.CR_LaktacneZostavy_Opr  as z
		where 'SR' = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and filter='SR,SR'


end
go



--------------------------------------------------

------ =============================================
------ Author:		PSSR, š.p.
------ Create date: 16.12.2017
------ Vysledky kontroly uzitkovosti za slachtitelske  chovy vyberie udaje z tabuliek plis.dbo.CR_LaktacneZostavy (za slachtitelske chovy
------ a plis.dbo.CR_LaktacneZostavy_rocenka (za plemeno, ktore je na chove uznane ako slachtitelske)
------ Do tabulky Roc_MLHD_Tab_19A

CREATE procedure [dbo].[Roc_MLHD_19]
	@chov varchar(9),
	@datumOd date,
	@datumDo date
	

as	
begin
delete from Roc_MLHD_Tab_19A where @chov = KRAJ + OKRES + PODNIK + CHOV and rok = DATEPART(year, @datumOd)
----declare 
----@chov varchar(10),
----@datumOd date,
----@datumDo date

----set @chov = 'SR'
----set @datumOd ='2017-01-01'
----set @datumDo ='2017-12-14' 


declare @zvaz varchar(30) = (select filter from dbo.CR_LaktacneZostavy_Opr
								where datumDO= @datumDo 
									and DatumOd= @datumOd
									and substring(Filter,1,13) = @chov + ',ChZ')
declare @plem varchar(1) = (select case when SUBSTRING(@zvaz,14,1)=1 then 'S'
									when SUBSTRING(@zvaz,14,1)=2 then 'P'
									when SUBSTRING(@zvaz,14,1)=3 then 'H'
									when SUBSTRING(@zvaz,14,1)=5 then 'B' end )

declare @plemTyp varchar(6) = (select case when SUBSTRING(@zvaz,14,1)=1 then 'SLst'
									when SUBSTRING(@zvaz,14,1)=2 then 'Pin'
									when SUBSTRING(@zvaz,14,1)=3 then 'Hol'
									when SUBSTRING(@zvaz,14,1)=5 then 'Brau' end )

insert into Roc_MLHD_Tab_19A
  ( por, KRAJ,OKRES,PODNIK,CHOV,stpec_1,stpec_2,stpec_3,stpec_4,stpec_5,stpec_6,stpec_7
      ,stpec_8,stpec_9,stpec_10,stpec_11,stpec_12,stpec_13,stpec_14Mesiac,stpec_14Den,stpec_15,stpec_16,stpec_17,stpec_18
      ,stpec_19,stpec_20,stpec_21,stpec_22,stpec_23,stpec_24,stpec_25,stpec_26,stpec_27,stpec_28,stpec_29,rok,Plem_typ)
	  
select  '2' as por
		,SUBSTRING(@chov,1,1) as kraj
		,SUBSTRING(@chov,2,2) as okres
		,SUBSTRING(@chov,4,3) as podnik
		,SUBSTRING(@chov,7,3) as chov
		,h.SPVYKON as stpec_1--SPVYKON,
		,(CASE WHEN h.CHARCHOV = '0' THEN 'O'
			WHEN h.CHARCHOV = '1' THEN 'S'
			WHEN h.CHARCHOV = '2' THEN 'P'
			WHEN h.CHARCHOV = '3' THEN 'H'
			WHEN h.CHARCHOV = '4' THEN 'M'
			WHEN h.CHARCHOV = '5' THEN 'B'
			END) AS stpec_2--CHARCHOV_kod,
		--ChCh.NAZOV as CHARCHOV,
		,(case when h.VYROBL = '1' then 'H'
				when h.VYROBL = '2' then 'N'
				else '' end) as stpec_3--VYROBL, 
		,h.CHARUS as stpec_4--CHARUS
		,@plem as stpec_5
		,ch.NAZOV as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1, 0) as stpec_8
		,round(z.MliekNorL1, 0) as stpec_9
		,round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1, 0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1, 0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2, 0) as stpec_16
		,round(z.MliekNorL2, 0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2, 0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2, 0) as stpec_21
		,round(z.MedziobdL2, 0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk, 0) as stpec_24
		,round(z.MliekNorCelk, 0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk, 0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk, 0) as stpec_29 
		,datepart (year, @datumOd) as rok
		,@plemTyp as Plem_typ

	 from /*dbo.CR_LaktacneZostavy*/ dbo.CR_LaktacneZostavy_Opr as z
		left outer join NM_HDDETAIL as h on h.KRAJ + h.OKRES + h.PODNIK + h.CHOV = @chov
		left outer join NC_VyrObl as vo on vo.KOD = h.VYROBL
		left outer join NC_CharChov as ChCh on ChCh.KOD = h.CHARCHOV and ChCh.DRUHHZ = h.TYPZV
		left outer join NM_CHOVMAS as ch on ch.kraj+ch.okres+ch.podnik+ch.chov= @chov
				where datumDO= @datumDo 
					and DatumOd= @datumOd
					and @zvaz = Filter
					and (ch.ZRUS is null or(ch.ZRUS is not null and ch.datumZrusenia > @datumOd))
union 
	select '1' as por
		,SUBSTRING(@chov,1,1) as kraj
		,SUBSTRING(@chov,2,2) as okres
		,SUBSTRING(@chov,4,3) as podnik
		,SUBSTRING(@chov,7,3) as chov
		,h.SPVYKON as stpec_1--SPVYKON,
		,(CASE WHEN h.CHARCHOV = '0' THEN 'O'
					WHEN h.CHARCHOV = '1' THEN 'S'
					WHEN h.CHARCHOV = '2' THEN 'P'
					WHEN h.CHARCHOV = '3' THEN 'H'
					WHEN h.CHARCHOV = '4' THEN 'M'
					WHEN h.CHARCHOV = '5' THEN 'B'
					END) AS stpec_2--CHARCHOV_kod,
				--ChCh.NAZOV as CHARCHOV,
		,(case when h.VYROBL = '1' then 'H'
				when h.VYROBL = '2' then 'N'
				else '' end) as stpec_3--VYROBL, 
		,h.CHARUS as stpec_4--CHARUS
		,@plem as stpec_5
		,'Vyhovujúce štatútu / všetky' as stpec_6
		,z.PocLakN1 as stpec_7
		,round(z.LakdniNL1, 0) as stpec_8
		,round(z.MliekNorL1, 0) as stpec_9
		, round((z.TukNorL1*100)/MliekNorL1,2) as stpec_10
		,round(z.TukNorL1, 0) as stpec_11
		,round((z.BielkNorL1*100)/MliekNorL1,2) as stpec_12
		,round(z.BielkNorL1, 0) as stpec_13
		,(select val from string2table (z.MedziobdL1,'/') where seq = 1) as stpec_14Den
		,(select val from string2table (z.MedziobdL1,'/') where seq = 2) as stpec_14Mesiac
		,z.PocLakN2 as stpec_15
		,round(z.LakDniNL2, 0) as stpec_16
		,round(z.MliekNorL2, 0) as stpec_17
		,round((z.TukNorL2*100)/z.MliekNorL2,2) as stpec_18
		,round(z.TukNorL2, 0) as stpec_19
		,round((z.BielkNorL2*100)/z.MliekNorL2,2) as stpec_20
		,round(z.BielkNorL2, 0) as stpec_21
		,round(z.MedziobdL2, 0) as stpec_22
		,z.PocLakNcelk as stpec_23
		,round(z.LakDniNCelk, 0) as stpec_24
		,round(z.MliekNorCelk, 0) as stpec_25
		,round((z.TukNorCelk*100)/z.MliekNorCelk,2) as stpec_26
		,round(z.TukNorCelk, 0) as stpec_27
		,round((z.BielkNorCelk*100)/z.MliekNorCelk,2) as stpec_28
		,round(z.BielkNorCelk, 0) as stpec_29
		,datepart (year, @datumOd) as rok
		,@plemTyp as Plem_typ
	 from /*dbo.CR_LaktacneZostavy_rocenka */ dbo.CR_LaktacneZostavy_Opr as z
		left outer join NM_HDDETAIL as h on h.KRAJ + h.OKRES + h.PODNIK + h.CHOV = @chov
		left outer join NC_VyrObl as vo on vo.KOD = h.VYROBL
		left outer join NC_CharChov as ChCh on ChCh.KOD = h.CHARCHOV and ChCh.DRUHHZ = h.TYPZV
		where @plem = PlemTyp 
				and datumOd = @datumOd 
				and datumDo = @datumDo 
				and oznacenie=@chov
				


end
go

------------------------------------------------------------------------------


CREATE procedure [dbo].[Rocenka_MLHD_Tab_22_A]
    @rok varchar(4)
as
  begin


    select z.KRAJ,z.OKRES,z.PODNIK,Okres_nazov,stpec_1,stpec_2,stpec_3,stpec_4,stpec_5,
      ( case when stpec_6 ='Výsledky za predchádzajúci kontrolný rok' then 'Výsledky za predchádzajúci rok'
        when stpec_6 <>'Výsledky za predchádzajúci kontrolný rok' then stpec_6 end) as stpec_6,

      (case when  stlpec_6c = '' and stpec_6 = 'Výsledky za predchádzajúci kontrolný rok' then '199'
       when stlpec_6c = '' and stpec_6 <> 'Výsledky za predchádzajúci kontrolný rok'then '999'
       when stlpec_6c <> '' then stlpec_6c  end) as	 stlpec_6c,
      stpec_7
      ,stpec_8,stpec_9,stpec_10,stpec_11,stpec_12,stpec_13,stpec_14Mesiac,stpec_14Den,stpec_15,stpec_16,stpec_17,stpec_18
      ,stpec_19,stpec_20,stpec_21,stpec_22,stpec_23,stpec_24,stpec_25,stpec_26,stpec_27,stpec_28,stpec_29,rok,chov.EkoChov

    from Roc_MLHD_Tab_22A as z
      left OUTER JOIN NM_CHOVMAS chov on chov.KRAJ = z.KRAJ and chov.OKRES = z.okres and chov.PODNIK = z.podnik and chov.CHOV = z.stlpec_6c  and chov.ZRUS is null and chov.TYPZV = 1
    where z.rok = @rok
    order by KRAJ, okres, podnik, case when len(stlpec_6c) < 3 then stlpec_6c+'9' else stlpec_6c end;
  end
go


-----------------------------------------------------------------------------------------------------------


CREATE procedure  [dbo].[Roc_MLHD_14]
	@datumOd date,
	@datumDo date

	as 
	begin

--declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31'
		delete from Roc_MLHD_Tab_14 where rok = datepart(year,@datumOd);


declare @kravy_S table(
	Por bigint,
	Ciskravy varchar(14),
	Okres varchar(30),
	Podnik varchar(100),
	Chov varchar(50),
	OLinReg varchar(20),
	Plemeno  varchar(30),
	Por_lak int,
	Mlieko_nor int, 
	Tuk_P float,
	Tuk int,
	Bielk_P float,
	Bielk int,
	Rok varchar(4),
	Plem_typ varchar(6),
    Ml_B varchar(1)
	)

	insert into @kravy_S 
		select distinct top 50
			 ROW_NUMBER() OVER(ORDER BY Lakt.MLIEKNOR desc) AS Por,
			Lakt.CISKRAVY as Ciskravy,
			o.NAZOV as Okres, 
			p.NAZOVSKR as Podnik, 
			UPPER(ch.NAZOV) as Chov, 
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			ISNULL(k.PL1 + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(k.PL2, '') as Plemeno,
			Lakt.PORLAK as Por_lak, 
			Lakt.MLIEKNOR as Mlieko_nor, 
			Round(Lakt.TUKNOR / Lakt.MLIEKNOR*100,2,2) as Tuk_P, 
			round(Lakt.TUKNOR,0) as Tuk, 
			round(Lakt.BIELKNOR / Lakt.MLIEKNOR*100,2,2) as Bielk_P, 
			Lakt.BIELKNOR as Bielk,
			datepart(year,@datumOd) as Rok,
			'SLst' as Plem_typ,
			'M' as Ml_B

		from  dbo.View_CP_LaktaciePreZostavy as Lakt
			left outer join CM_Krava as k on k.ciskravy = Lakt.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
			left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK+ ch.CHOV = Lakt.CHOVATEL
			left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				--and Lakt.PLEM in ('S0','S1','S2','S3')
				and k.TYPPLEM IN ('11','12','13','14')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
				and Lakt.TUKNOR / Lakt.MLIEKNOR*100 < 6
				and Lakt.BIELKNOR / Lakt.MLIEKNOR*100 < 5 
				and (k.OTECLIN is not null or b.MENO is not null)
				and ch.ZRUS is null and ch.TYPZV='1'
				order by Lakt.MLIEKNOR desc
	insert into Roc_MLHD_Tab_14
	select * from @kravy_S

	declare @kravy_H table(
	Por bigint,
	Ciskravy varchar(14),
	Okres varchar(30),
	Podnik varchar(100),
	Chov varchar(50),
	OLinReg varchar(20),
	Plemeno  varchar(30),
	Por_lak int,
	Mlieko_nor int, 
	Tuk_P float,
	Tuk int,
	Bielk_P float,
	Bielk int,
	Rok varchar(4),
	Plem_typ varchar(6),
    Ml_B varchar(1)
	)

	insert into @kravy_H 
		select distinct top 100
			 ROW_NUMBER() OVER(ORDER BY Lakt.MLIEKNOR desc) AS Por,
			Lakt.CISKRAVY as Ciskravy,
			o.NAZOV as Okres, 
			p.NAZOVSKR as Podnik, 
			UPPER(ch.NAZOV) as Chov, 
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			ISNULL(k.PL1 + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(k.PL2, '') as Plemeno,
			Lakt.PORLAK as Por_lak, 
			Lakt.MLIEKNOR as Mlieko_nor, 
			Round(Lakt.TUKNOR / Lakt.MLIEKNOR*100,2,2) as Tuk_P, 
			round(Lakt.TUKNOR,0) as Tuk, 
			round(Lakt.BIELKNOR / Lakt.MLIEKNOR*100,2,2) as Bielk_P, 
			round(Lakt.BIELKNOR,0) as Bielk,
			datepart(year,@datumOd) as Rok,
			'Hol' as Plem_typ,
			'M' as Ml_B

		from  dbo.View_CP_LaktaciePreZostavy as Lakt
			left outer join CM_Krava as k on k.ciskravy = Lakt.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
			left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK+ ch.CHOV = Lakt.CHOVATEL
			left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				and Lakt.PLEM in ('H0','H1','H2','H3')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
				and Lakt.TUKNOR / Lakt.MLIEKNOR*100 < 6
				and Lakt.BIELKNOR / Lakt.MLIEKNOR*100 < 5 
				and (k.OTECLIN is not null or b.MENO is not null)
				and ch.ZRUS is null and ch.TYPZV='1'
				order by Lakt.MLIEKNOR desc
	insert into Roc_MLHD_Tab_14
	select * from @kravy_H

	declare @kravy_P table(
	Por bigint,
	Ciskravy varchar(14),
	Okres varchar(30),
	Podnik varchar(100),
	Chov varchar(50),
	OLinReg varchar(20),
	Plemeno  varchar(30),
	Por_lak int,
	Mlieko_nor int, 
	Tuk_P float,
	Tuk int,
	Bielk_P float,
	Bielk int,
	Rok varchar(4),
	Plem_typ varchar(6),
    Ml_B varchar(1)
	)

	insert into @kravy_P 
		select distinct top 25
			 ROW_NUMBER() OVER(ORDER BY Lakt.MLIEKNOR desc) AS Por,
			Lakt.CISKRAVY as Ciskravy,
			o.NAZOV as Okres, 
			p.NAZOVSKR as Podnik, 
			UPPER(ch.NAZOV) as Chov, 
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			ISNULL(k.PL1 + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(k.PL2, '') as Plemeno,
			Lakt.PORLAK as Por_lak, 
			Lakt.MLIEKNOR as Mlieko_nor, 
			Round(Lakt.TUKNOR / Lakt.MLIEKNOR*100,2,2) as Tuk_P, 
			round(Lakt.TUKNOR,0) as Tuk, 
			round(Lakt.BIELKNOR / Lakt.MLIEKNOR*100,2,2) as Bielk_P, 
			round(Lakt.BIELKNOR,0) as Bielk,
			datepart(year,@datumOd) as Rok,
			'Pin' as Plem_typ,
			'M' as Ml_B

		from  dbo.View_CP_LaktaciePreZostavy as Lakt
			left outer join CM_Krava as k on k.ciskravy = Lakt.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
			left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK+ ch.CHOV = Lakt.CHOVATEL
			left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				and Lakt.PLEM in ('P0','P1','P2','P3')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
				and k.OTECLIN not in ('NEZ','RER','TUR','PGR','TIT')
				and Lakt.TUKNOR / Lakt.MLIEKNOR*100 < 6
				and Lakt.BIELKNOR / Lakt.MLIEKNOR*100 < 5 
				and (k.OTECLIN is not null or b.MENO is not null)
				and ch.ZRUS is null and ch.TYPZV='1'
				order by Lakt.MLIEKNOR desc
	insert into Roc_MLHD_Tab_14
	select * from @kravy_P


	declare @kravy_B table(
	Por bigint,
	Ciskravy varchar(14),
	Okres varchar(30),
	Podnik varchar(100),
	Chov varchar(50),
	OLinReg varchar(20),
	Plemeno  varchar(30),
	Por_lak int,
	Mlieko_nor int, 
	Tuk_P float,
	Tuk int,
	Bielk_P float,
	Bielk int,
	Rok varchar(4),
	Plem_typ varchar(6),
    Ml_B varchar(1)
	)

	insert into @kravy_B 
		select distinct top 25
			 ROW_NUMBER() OVER(ORDER BY Lakt.MLIEKNOR desc) AS Por,
			Lakt.CISKRAVY as Ciskravy,
			o.NAZOV as Okres, 
			p.NAZOVSKR as Podnik, 
			UPPER(ch.NAZOV) as Chov, 
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			ISNULL(k.PL1 + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(k.PL2, '') as Plemeno,
			Lakt.PORLAK as Por_lak, 
			Lakt.MLIEKNOR as Mlieko_nor, 
			Round(Lakt.TUKNOR / Lakt.MLIEKNOR*100,2,2) as Tuk_P, 
			round(Lakt.TUKNOR,0) as Tuk, 
			round(Lakt.BIELKNOR / Lakt.MLIEKNOR*100,2,2) as Bielk_P, 
			round(Lakt.BIELKNOR,0) as Bielk,
			datepart(year,@datumOd) as Rok,
			'Brau' as Plem_typ,
			'M' as Ml_B

		from  dbo.View_CP_LaktaciePreZostavy as Lakt
			left outer join CM_Krava as k on k.ciskravy = Lakt.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
			left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK+ ch.CHOV = Lakt.CHOVATEL
			left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				and Lakt.PLEM in ('B0','B1','B2','B3')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
				and Lakt.TUKNOR / Lakt.MLIEKNOR*100 < 6
				and Lakt.BIELKNOR / Lakt.MLIEKNOR*100 < 5 
				and (k.OTECLIN is not null or b.MENO is not null)
				and ch.ZRUS is null and ch.TYPZV='1'
				order by Lakt.MLIEKNOR desc
	insert into Roc_MLHD_Tab_14
	select * from @kravy_B



/**rocenka MLHD - Kravy s najvyssou uzitkovostou za normovane laktacie v kontrolnom roku podla kg BIELKOVIN*/
/**tab 14**/


declare @kravyB_S table(
	Por bigint,
	Ciskravy varchar(14),
	Okres varchar(30),
	Podnik varchar(100),
	Chov varchar(50),
	OLinReg varchar(20),
	Plemeno  varchar(30),
	Por_lak int,
	Mlieko_nor int, 
	Tuk_P float,
	Tuk int,
	Bielk_P float,
	Bielk int,
	Rok varchar(4),
	Plem_typ varchar(6),
    Ml_B varchar(1)
	)

	insert into @kravyB_S 
		select distinct top 100
			 ROW_NUMBER() OVER(ORDER BY Lakt.BIELKNOR desc) AS Por,
			Lakt.CISKRAVY as Ciskravy,
			o.NAZOV as Okres, 
			p.NAZOVSKR as Podnik, 
			UPPER(ch.NAZOV) as Chov, 
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			ISNULL(k.PL1 + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(k.PL2, '')+  ISNULL(k.PL3, '')+  ISNULL(k.PL4, '')+  ISNULL(k.PL5, '') as Plemeno,
			Lakt.PORLAK as Por_lak, 
			Lakt.MLIEKNOR as Mlieko_nor, 
			Round(Lakt.TUKNOR / Lakt.MLIEKNOR*100,2,2) as Tuk_P, 
			round(Lakt.TUKNOR,0) as Tuk, 
			round(Lakt.BIELKNOR / Lakt.MLIEKNOR*100,2,2) as Bielk_P, 
			round(Lakt.BIELKNOR,0) as Bielk,
			datepart(year,@datumOd) as Rok,
			'SLst+K' as Plem_typ,
			'B' as Ml_B

		from  dbo.View_CP_LaktaciePreZostavy as Lakt
			left outer join CM_Krava as k on k.ciskravy = Lakt.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
			left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK+ ch.CHOV = Lakt.CHOVATEL
			left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				--and Lakt.PLEM in ('S0','S1','S2','S3')
				and k.TYPPLEM IN ('11','12','13','14')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
				and Lakt.TUKNOR / Lakt.MLIEKNOR*100 < 6
				and Lakt.BIELKNOR / Lakt.MLIEKNOR*100 < 5 
				and (k.OTECLIN is not null or b.MENO is not null)
				and ch.ZRUS is null and ch.TYPZV='1'
				order by round(Lakt.BIELKNOR,0) desc
	insert into Roc_MLHD_Tab_14
	select * from @kravyB_S

	declare @kravyB_H table(
	Por bigint,
	Ciskravy varchar(14),
	Okres varchar(30),
	Podnik varchar(100),
	Chov varchar(50),
	OLinReg varchar(20),
	Plemeno  varchar(30),
	Por_lak int,
	Mlieko_nor int, 
	Tuk_P float,
	Tuk int,
	Bielk_P float,
	Bielk int,
	Rok varchar(4),
	Plem_typ varchar(6),
    Ml_B varchar(1)
	)

	insert into @kravyB_H 
		select distinct top 100
			 ROW_NUMBER() OVER(ORDER BY Lakt.BIELKNOR desc) AS Por,
			Lakt.CISKRAVY as Ciskravy,
			o.NAZOV as Okres, 
			p.NAZOVSKR as Podnik, 
			UPPER(ch.NAZOV) as Chov, 
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			ISNULL(k.PL1 + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(k.PL2, '')+  ISNULL(k.PL3, '')+  ISNULL(k.PL4, '')+  ISNULL(k.PL5, '') as Plemeno,
			Lakt.PORLAK as Por_lak, 
			Lakt.MLIEKNOR as Mlieko_nor, 
			Round(Lakt.TUKNOR / Lakt.MLIEKNOR*100,2,2) as Tuk_P, 
			round(Lakt.TUKNOR,0) as Tuk, 
			round(Lakt.BIELKNOR / Lakt.MLIEKNOR*100,2,2) as Bielk_P, 
			round(Lakt.BIELKNOR,0) as Bielk,
			datepart(year,@datumOd) as Rok,
			'Hol+K' as Plem_typ,
			'B' as Ml_B

		from  dbo.View_CP_LaktaciePreZostavy as Lakt
			left outer join CM_Krava as k on k.ciskravy = Lakt.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
			left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK+ ch.CHOV = Lakt.CHOVATEL
			left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				and k.PL1 in ('H','R')
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
				and Lakt.TUKNOR / Lakt.MLIEKNOR*100 < 6
				and Lakt.BIELKNOR / Lakt.MLIEKNOR*100 < 5 
				and (k.OTECLIN is not null or b.MENO is not null)
				and ch.ZRUS is null and ch.TYPZV='1'
				order by round(Lakt.BIELKNOR,0) desc
	insert into Roc_MLHD_Tab_14
	select * from @kravyB_H

	declare @kravyB_P table(
	Por bigint,
	Ciskravy varchar(14),
	Okres varchar(30),
	Podnik varchar(100),
	Chov varchar(50),
	OLinReg varchar(20),
	Plemeno  varchar(30),
	Por_lak int,
	Mlieko_nor int, 
	Tuk_P float,
	Tuk int,
	Bielk_P float,
	Bielk int,
	Rok varchar(4),
	Plem_typ varchar(6),
    Ml_B varchar(1)
	)

	insert into @kravyB_P 
		select distinct top 100
			 ROW_NUMBER() OVER(ORDER BY Lakt.BIELKNOR desc) AS Por,
			Lakt.CISKRAVY as Ciskravy,
			o.NAZOV as Okres, 
			p.NAZOVSKR as Podnik, 
			UPPER(ch.NAZOV) as Chov, 
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			ISNULL(k.PL1 + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(k.PL2, '')+  ISNULL(k.PL3, '')+  ISNULL(k.PL4, '')+  ISNULL(k.PL5, '') as Plemeno,
			Lakt.PORLAK as Por_lak, 
			Lakt.MLIEKNOR as Mlieko_nor, 
			Round(Lakt.TUKNOR / Lakt.MLIEKNOR*100,2,2) as Tuk_P, 
			round(Lakt.TUKNOR,0) as Tuk, 
			round(Lakt.BIELKNOR / Lakt.MLIEKNOR*100,2,2) as Bielk_P, 
			round(Lakt.BIELKNOR,0) as Bielk,
			datepart(year,@datumOd) as Rok,
			'Pin+K' as Plem_typ,
			'B' as Ml_B

		from  dbo.View_CP_LaktaciePreZostavy as Lakt
			left outer join CM_Krava as k on k.ciskravy = Lakt.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
			left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK+ ch.CHOV = Lakt.CHOVATEL
			left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				and k.PL1 = 'P'
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
				and Lakt.TUKNOR / Lakt.MLIEKNOR*100 < 6
				and Lakt.BIELKNOR / Lakt.MLIEKNOR*100 < 5 
				and (k.OTECLIN is not null or b.MENO is not null)
				and ch.ZRUS is null and ch.TYPZV='1'
				order by round(Lakt.BIELKNOR,0) desc
	insert into Roc_MLHD_Tab_14
	select * from @kravyB_P


	declare @kravyB_B table(
	Por bigint,
	Ciskravy varchar(14),
	Okres varchar(30),
	Podnik varchar(100),
	Chov varchar(50),
	OLinReg varchar(20),
	Plemeno  varchar(30),
	Por_lak int,
	Mlieko_nor int, 
	Tuk_P float,
	Tuk int,
	Bielk_P float,
	Bielk int,
	Rok varchar(4),
	Plem_typ varchar(6),
    Ml_B varchar(1)
	)

	insert into @kravyB_B 
		select distinct top 100
			 ROW_NUMBER() OVER(ORDER BY Lakt.BIELKNOR desc) AS Por,
			Lakt.CISKRAVY as Ciskravy,
			o.NAZOV as Okres, 
			p.NAZOVSKR as Podnik, 
			UPPER(ch.NAZOV) as Chov, 
			(case when k.Oteclin is null then substring(b.MENO,1,15)
				 else k.Oteclin + '-' + RIGHT('000' + CONVERT(varchar,k.otecreg), 3)end) as OLinReg, 
			ISNULL(k.PL1 + CONVERT(varchar, k.KR1), '') 
						+  ISNULL(k.PL2, '')+  ISNULL(k.PL3, '')+  ISNULL(k.PL4, '')+  ISNULL(k.PL5, '') as Plemeno,
			Lakt.PORLAK as Por_lak, 
			Lakt.MLIEKNOR as Mlieko_nor, 
			Round(Lakt.TUKNOR / Lakt.MLIEKNOR*100,2,2) as Tuk_P, 
			round(Lakt.TUKNOR,0) as Tuk, 
			round(Lakt.BIELKNOR / Lakt.MLIEKNOR*100,2,2) as Bielk_P, 
			round(Lakt.BIELKNOR,0) as Bielk,
			datepart(year,@datumOd) as Rok,
			'Brau+K' as Plem_typ,
			'B' as Ml_B

		from  dbo.View_CP_LaktaciePreZostavy as Lakt
			left outer join CM_Krava as k on k.ciskravy = Lakt.ciskravy
			left outer join CM_Byci as b on b.USCISLO = k.OUSCIS
			left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = SUBSTRING(Lakt.CHOVATEL,1,6)
			left outer join NM_CHOVMAS as ch on ch.KRAJ + ch.OKRES + ch.PODNIK+ ch.CHOV = Lakt.CHOVATEL
			left outer join NC_OKRES as o on o.KRAJ + o.OKRES = SUBSTRING(Lakt.CHOVATEL,1,3)
		where  ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
					or (Lakt.DATUKNORL >= @datumOd and Lakt.DATUKNORL <= @datumDo))
				and Lakt.MLIEKCEL <>''
				and Lakt.ZMENA in ('30','40')
				and k.PL1 = 'B'
				and (Lakt.DOVVYR is null or (Lakt.DOVVYR is not null and Lakt.DATVYR>@datumOd))
				and Lakt.TUKNOR / Lakt.MLIEKNOR*100 < 6
				and Lakt.BIELKNOR / Lakt.MLIEKNOR*100 < 5 
				and (k.OTECLIN is not null or b.MENO is not null)
				and ch.ZRUS is null and ch.TYPZV='1'
				order by round(Lakt.BIELKNOR,0) desc
	insert into Roc_MLHD_Tab_14
	select * from @kravyB_B

	End
go


-------------------------------------------------------------------------------------------------------

/****** Script for SelectTopNRows command from SSMS  ******/
-- rocenka mlieko ---ulozene do Roc_MLHD_Tab_18 - nasledne sa do rocenky vytiahne reportom
----Prehlad uzavretych laktacii za kontrolny rok pre kravy zapisane v plememennych knihach ---str. 67
-- Exec Roc_MLHD_18 '2017-01-01', '2017-12-31'
CREATE procedure  [dbo].[Roc_MLHD_18]
	@datumOd date,
	@datumDo date

	as 
	begin

    delete from Roc_MLHD_Tab_18 where rok = datepart(year,@datumOd);

    -- declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31'

Declare @Laktacie table(
	  [PORLAK][int],
      [CHOVATEL][varchar] (9) null,
	  [ZMENA][varchar] (2) null,
      [MEDZIOBD][float] NULL,  
      [LAKDNIN][float] NULL,
      [MLIEKNOR][float] NULL,
      [TUKNOR][float] NULL,
      [BIELKNOR][float] NULL,
      [LAKTOZAN] [float] NULL,
	  [INDPER] [float] NULL,
	  [PLEM] [varchar] (10) null,
      [DOVVYR][varchar] (2) null,
      [DATVYR][date] null
	  ) 

	insert into @Laktacie			
	 SELECT distinct
 		 PORLAK, Lakt.CHOVATEL,
		 ZMENA, MEDZIOBD,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, 
		 (case when k.PK ='PHA'  then 'PHA'
			 when k.PK ='PHB'  then 'PHB'
			 when k.PK ='PHC'  then 'PHC'
			 when k.PK ='PHD'  then 'PHD'
			 when k.PK ='PSA'  then 'PSA'
			 when k.PK ='PSB'  then 'PSB'
			 when k.PK ='PPA'  then 'PPA'
			 when k.PK ='PPB'  then 'PPB'
			 when k.PK ='PPC'  then 'PPC'
							 end) as Plem,
		Lakt.DOVVYR, Lakt.DATVYR--,b.KOD, b.NAZOV
		 
	 FROM dbo.View_CP_LaktaciePreZostavy as Lakt
		 left outer join NM_HDDETAIL as h on h.KRAJ + h.OKRES + h.PODNIK + h.CHOV = Lakt.chovatel
		-- left outer join NC_CharChov as b on (b.KOD=h.CHARCHOV) and (b.DRUHHZ=h.TYPZV) 
		 left outer join NC_OKRES as reg on ((reg.KRAJ + reg.OKRES)= substring(CHOVATEL, 1, 3))
		 left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV)= CHOVATEL)
		 left outer join CM_Krava as k on k.ciskravy=lakt.ciskravy
		where 
		 (Lakt.CHOVATEL in (select chov from CP_ZoznamChovov)) -- chovy, ktoré sú v kontrole úžitkovosti
		--	and h.CHARCHOV in ('1','2','3','4','5')
			and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd 
						and Lakt.DATUKNORL <= @datumDo))
			and eko.ZRUS is null and eko.TYPZV='1'
			and MLIEKCEL <>''
			and k.PK in ('PHA', 'PHB','PHC','PHD','PSA','PSB','PPA','PPB','PPC')
/** select * from @Laktacie 		**/

Declare @Laktacie_vs table(
--CREATE TABLE @Laktacie(
	  [PORLAK][int],
      [CHOVATEL][varchar] (9) null,
	  [ZMENA][varchar] (2) null,
      [MEDZIOBD][float] NULL,  
      [LAKDNIN][float] NULL,
      [MLIEKNOR][float] NULL,
      [TUKNOR][float] NULL,
      [BIELKNOR][float] NULL,
      [LAKTOZAN] [float] NULL,
	  [INDPER] [float] NULL,
	  [PLEM] [varchar] (10) null,
      [DOVVYR][varchar] (2) null,
      [DATVYR][date] null	  	  
      ) 
insert into @Laktacie_vs			
	 SELECT distinct
 		 PORLAK, Lakt.CHOVATEL,
		 ZMENA, MEDZIOBD,LAKDNIN, MLIEKNOR,TUKNOR,BIELKNOR,LAKTOZAN, INDPER, 
		 (case when k.PK in('PHA','PHB','PHC','PHD') then 'H'
			 when k.PK in ('PSA','PSB')  then 'S'
			 when k.PK in ('PPA','PPB','PPC')  then 'P'
							end) as Plem,
		Lakt.DOVVYR, Lakt.DATVYR--,b.KOD, b.NAZOV
		 
	 FROM dbo.View_CP_LaktaciePreZostavy as Lakt
		 left outer join NM_HDDETAIL as h on h.KRAJ + h.OKRES + h.PODNIK + h.CHOV = Lakt.chovatel
		-- left outer join NC_CharChov as b on (b.KOD=h.CHARCHOV) and (b.DRUHHZ=h.TYPZV) 
		 left outer join NC_OKRES as reg on ((reg.KRAJ + reg.OKRES)= substring(CHOVATEL, 1, 3))
		 left outer join NM_CHOVMAS as eko on ((eko.KRAJ + eko.OKRES + eko.PODNIK + eko.CHOV)= CHOVATEL)
		 left outer join CM_Krava as k on k.ciskravy=lakt.ciskravy
		where 
		 (Lakt.CHOVATEL in (select chov from CP_ZoznamChovov)) -- chovy, ktoré sú v kontrole úžitkovosti
			--and h.CHARCHOV in ('1','2','3','4','5')
			and ((Lakt.DATUKONL >= @datumOd and Lakt.DATUKONL <= @datumDo) and (Lakt.DATUKNORL is null or Lakt.DATUKNORL >= @datumOd) 
						or (Lakt.DATUKNORL >= @datumOd 
						and Lakt.DATUKNORL <= @datumDo))
			and eko.ZRUS is null and eko.TYPZV='1'
			and MLIEKCEL <>''
			and k.PK in ('PHA', 'PHB','PHC','PHD','PSA','PSB','PPA','PPB','PPC')



	declare @pocLAKV1 table
		(	
		[PlemTyp] [varchar] (10) Null,
		[PocLakV1] [float](4) NULL
		)

	Insert @pocLAKV1
		select 
			distinct l.plem as PlemTyp, 
			count(*) as PocLakV1
			
		from @Laktacie as l	
			where PORLAK = '1'
				and PLEM<>'0'
		group by  l.PLEM
/**	select * from @pocLAKV1 **/


	Declare @lakt1 table
	(
		[PlemTyp] [varchar] (10) Null,
		[PocLakN1] [float](4) NULL,
		[LakdniNL1] [float](7) NULL,	
		[MliekNorL1] [float](9) NULL,
		[TukNorL1] [float](7) NULL,
		[BielkNorL1] [float](7) NULL
		--[CharChov_KOD][varchar] (2) null,
		--[CharChov][varchar] (30) null
	)

	Insert into @lakt1
		(PlemTyp, pocLakN1, LakdniNL1, MliekNorL1, TukNorL1, BielkNorL1/*, CharChov_KOD,CharChov*/)
	select distinct plem as PlemTyp,
		count(*)  as PocLakN1, 
		ROUND(AVG(LAKDNIN),2)as LakdniNL1,	
		ROUND(AVG(MLIEKNOR),2) as MliekNorL1,
		ROUND(AVG(TUKNOR),2)as TukNorL1,
		ROUND(AVG(BIELKNOR),2) as BielkNorL1
		--CharChov_KOD as CharChov_KOD,
		--CharChov as Charchov
	from @Laktacie as l
		where  PORLAK = '1'
			and (l.ZMENA = '30' or l.ZMENA='40') 
			and PLEM<>'0'
		group by  plem--,CharChov_KOD, CharChov

/**select * from @lakt1
		order by PlemTyp**/

 Declare @lakt2 table
  (	[PlemTyp] [varchar] (10) Null,
	[PocLakN2] [float](4) NULL,
	[LakdniNL2] [float](7) NULL,	
	[MliekNorL2] [float](9) NULL,
	[TukNorL2] [float](7) NULL,
	[BielkNorL2] [float](7) NULL,
	--[CharChov_KOD][varchar] (2) null,
	--[CharChov][varchar] (30) null,
	[MedziobdL2] [float](7) NULL
	)
 insert @lakt2
	select distinct plem as PlemTyp,
		count(*)  as PocLakN1, 
		ROUND(AVG(LAKDNIN),2)as LakdniNL2,	
		ROUND(AVG(MLIEKNOR),2) as MliekNorL2,
		ROUND(AVG(TUKNOR),2)as TukNorL2,
		ROUND(AVG(BIELKNOR),2) as BielkNorL2,
		--CharChov_KOD as CharChov_KOD,
		--CharChov as Charchov,
		ROUND(AVG(MEDZIOBD),2) as MedziobdL2
	from @Laktacie as l	
			where PORLAK >='2'
				and PLEM <>'0'
				and (l.ZMENA = '30' or l.ZMENA='40') 
		group by  l.PLEM--,l.CharChov_KOD ,l.CharChov


declare @pocLAKVCelk table
		(
		[PlemTyp] [varchar] (10) Null,
		[PocLakVCelk] [float](4) NULL
		--[CharChov_KOD][varchar] (2) null,
		--[CharChov][varchar] (30) null
		)

Insert @pocLAKVCelk
		select 
			l.PLEM as PlemTyp,
			count(*) as PocLakVCelk
			--CharChov_KOD as CharChov_KOD,
			--CharChov as Charchov
		from @Laktacie as l
		
		group by  l.PLEM--,l.CharChov_KOD ,l.CharChov

	/**select * from @pocLAKVCelk **/

	Declare @laktCelkom table
		( 
		[PlemTyp] [varchar] (10) Null,
		[PocLakNcelk] [float] NULL,
		[MedziobdCelk] [float] NULL,
		[LakDniNCelk] [float] NULL,	
		[MliekNorCelk] [float] NULL,
		[TukNorCelk] [float] NULL,
		[BielkNorCelk] [float] NULL
		--[CharChov_KOD][varchar] (2) null,
		--[CharChov][varchar] (30) null
		)

insert @laktCelkom
	select
	l.PLEM as PlemTyp,
	count(*) as PocLakCelk, 
	ROUND(AVG(MEDZIOBD),2) as MedziobdCelk,
	ROUND(AVG(LAKDNIN),2) as LakdniNCelk,	
	ROUND(AVG(MLIEKNOR),2) as MliekNorCelk,
	ROUND(AVG(TUKNOR),2) as TukNorCelk,
	ROUND(AVG(BIELKNOR),2) as BielkNorCelk
	--CharChov_KOD as CharChov_KOD,
 --   CharChov as Charchov
 	from @Laktacie as l
		where (l.ZMENA = '30' or l.ZMENA='40') 
	group by  l.PLEM--,l.CharChov_KOD ,l.CharChov
/****spolu za vsetky plem - podla zvazu***/

declare @pocLAKV1_vs table
		(	
		[PlemTyp] [varchar] (10) Null,
		[PocLakV1] [float](4) NULL
		--[CharChov_KOD][varchar] (2) null,
		--[CharChov][varchar] (30) null
		)

	Insert @pocLAKV1_vs
		select 
			distinct l_vs.plem as PlemTyp, 
			count(*) as PocLakV1
			
		from @Laktacie_vs as l_vs
			where PORLAK = '1'
				and PLEM<>'0'
		group by l_vs.PLEM

	Declare @lakt1_vs table
	(
		[PlemTyp] [varchar] (10) Null,
		[PocLakN1] [float](4) NULL,
		[LakdniNL1] [float](7) NULL,	
		[MliekNorL1] [float](9) NULL,
		[TukNorL1] [float](7) NULL,
		[BielkNorL1] [float](7) NULL
	)

	Insert into @lakt1_vs
		( PlemTyp,pocLakN1, LakdniNL1, MliekNorL1, TukNorL1, BielkNorL1)
	select distinct plem as PlemTyp,
		count(*)  as PocLakN1, 
		ROUND(AVG(LAKDNIN),2)as LakdniNL1,	
		ROUND(AVG(MLIEKNOR),2) as MliekNorL1,
		ROUND(AVG(TUKNOR),2)as TukNorL1,
		ROUND(AVG(BIELKNOR),2) as BielkNorL1

	from @Laktacie_vs as l_vs
		where  PORLAK = '1'
			and (l_vs.ZMENA = '30' or l_vs.ZMENA='40') 
	group by  plem

/**select * from @lakt1
		order by PlemTyp**/

Declare @lakt2_vs table
  (	[PlemTyp] [varchar] (10) Null,
	[PocLakN2] [float](4) NULL,
	[LakdniNL2] [float](7) NULL,	
	[MliekNorL2] [float](9) NULL,
	[TukNorL2] [float](7) NULL,
	[BielkNorL2] [float](7) NULL,
	[MedziobdL2] [float](7) NULL
	)
 insert @lakt2_vs
select distinct l_vs.plem as PlemTyp,
		count(*)  as PocLakN1, 
		ROUND(AVG(l_vs.LAKDNIN),2)as LakdniNL2,	
		ROUND(AVG(l_vs.MLIEKNOR),2) as MliekNorL2,
		ROUND(AVG(l_vs.TUKNOR),2)as TukNorL2,
		ROUND(AVG(l_vs.BIELKNOR),2) as BielkNorL2,
		ROUND(AVG(l_vs.MEDZIOBD),2) as MedziobdL2
	from @Laktacie_vs as l_vs	
			where l_vs.PORLAK >='2'
				and (l_vs.ZMENA = '30' or l_vs.ZMENA='40') 
		group by l_vs.PLEM


declare @pocLAKVCelk_vs table
		(
		[PlemTyp] [varchar] (10) Null,
		[PocLakVCelk] [float](4) NULL
		)

	Insert @pocLAKVCelk_vs
		select distinct l_vs.PLEM,
			count(*) as PocLakVCelk
		from @Laktacie_vs as l_vs
		group by l_vs.plem

	/**select * from @pocLAKVCelk **/

	Declare @laktCelkom_vs table
		( 
		[PlemTyp] [varchar] (10) Null,
		[PocLakNcelk] [float] NULL,
		[MedziobdCelk] [float] NULL,
		[LakDniNCelk] [float] NULL,	
		[MliekNorCelk] [float] NULL,
		[TukNorCelk] [float] NULL,
		[BielkNorCelk] [float] NULL
		)

insert @laktCelkom_vs
	select
		distinct l_vs.PLEM,
		count(*) as PocLakCelk, 
		ROUND(AVG(l_vs.MEDZIOBD),2) as MedziobdCelk,
		ROUND(AVG(l_vs.LAKDNIN),2) as LakdniNCelk,	
		ROUND(AVG(l_vs.MLIEKNOR),2) as MliekNorCelk,
		ROUND(AVG(l_vs.TUKNOR),2) as TukNorCelk,
		ROUND(AVG(l_vs.BIELKNOR),2) as BielkNorCelk
	from @Laktacie_vs as l_vs
		where (l_vs.ZMENA = '30' or l_vs.ZMENA='40')
			
	group by  l_vs.PLEM

	/****spolu za SLOVENSKO***/

	declare @pocLAKV1_SR table
		(	
		[PlemTyp] [varchar] (10) Null,
		[PocLakV1] [float](4) NULL
		)

	Insert @pocLAKV1_SR
		select 
			'SR' as PlemTyp,
			count(*) as PocLakV1
			
		from @Laktacie_vs as l_vs
			where PORLAK = '1'
				and PLEM<>'0'
		--group by l_vs.PLEM

	Declare @lakt1_SR table
	(
		[PlemTyp] [varchar] (10) Null,
		[PocLakN1] [float](4) NULL,
		[LakdniNL1] [float](7) NULL,	
		[MliekNorL1] [float](9) NULL,
		[TukNorL1] [float](7) NULL,
		[BielkNorL1] [float](7) NULL
	)

	Insert into @lakt1_SR
		( PlemTyp,pocLakN1, LakdniNL1, MliekNorL1, TukNorL1, BielkNorL1)
	select distinct 'SR' as PlemTyp,
		count(*)  as PocLakN1, 
		ROUND(AVG(LAKDNIN),2)as LakdniNL1,	
		ROUND(AVG(MLIEKNOR),2) as MliekNorL1,
		ROUND(AVG(TUKNOR),2)as TukNorL1,
		ROUND(AVG(BIELKNOR),2) as BielkNorL1

	from @Laktacie_vs as l_vs
		where  PORLAK = '1'
			and (l_vs.ZMENA = '30' or l_vs.ZMENA='40') 
	--group by  plem


Declare @lakt2_SR table
  (	[PlemTyp] [varchar] (10) Null,
	[PocLakN2] [float](4) NULL,
	[LakdniNL2] [float](7) NULL,	
	[MliekNorL2] [float](9) NULL,
	[TukNorL2] [float](7) NULL,
	[BielkNorL2] [float](7) NULL,
	[MedziobdL2] [float](7) NULL
	)
 insert @lakt2_SR
select distinct 'SR' as PlemTyp,
		count(*)  as PocLakN1, 
		ROUND(AVG(l_vs.LAKDNIN),2)as LakdniNL2,	
		ROUND(AVG(l_vs.MLIEKNOR),2) as MliekNorL2,
		ROUND(AVG(l_vs.TUKNOR),2)as TukNorL2,
		ROUND(AVG(l_vs.BIELKNOR),2) as BielkNorL2,
		ROUND(AVG(l_vs.MEDZIOBD),2) as MedziobdL2
	from @Laktacie_vs as l_vs	
			where PORLAK >='2'
				and (l_vs.ZMENA = '30' or l_vs.ZMENA='40') 
		--group by l_vs.PLEM


declare @pocLAKVCelk_SR table
		(
		[PlemTyp] [varchar] (10) Null,
		[PocLakVCelk] [float](4) NULL
		)

	Insert @pocLAKVCelk_SR
		select  'SR' as PlemTyp,
			count(*) as PocLakVCelk
		from @Laktacie_vs as l_vs
		where PLEM<>'0'
		--group by l_vs.PLEM

		--group by l_vs.plem

select * from @pocLAKVCelk_SR

	

	Declare @laktCelkom_SR table
		( 
		[PlemTyp] [varchar] (10) Null,
		[PocLakNcelk] [float] NULL,
		[MedziobdCelk] [float] NULL,
		[LakDniNCelk] [float] NULL,	
		[MliekNorCelk] [float] NULL,
		[TukNorCelk] [float] NULL,
		[BielkNorCelk] [float] NULL
		)

insert @laktCelkom_SR
	select
		distinct 'SR' as PlemTyp,
		count(*) as PocLakCelk, 
		ROUND(AVG(l_vs.MEDZIOBD),2) as MedziobdCelk,
		ROUND(AVG(l_vs.LAKDNIN),2) as LakdniNCelk,	
		ROUND(AVG(l_vs.MLIEKNOR),2) as MliekNorCelk,
		ROUND(AVG(l_vs.TUKNOR),2) as TukNorCelk,
		ROUND(AVG(l_vs.BIELKNOR),2) as BielkNorCelk
	from @Laktacie_vs as l_vs
		where (l_vs.ZMENA = '30' or l_vs.ZMENA='40')
			
	--group by  l_vs.PLEM



	insert into Roc_MLHD_Tab_18
	Select (case when L.PlemTyp in ('PSA','PSB','PSC')  then 'SLOVENSKÝ STRAKATÝ'
				when L.PlemTyp in ('PPA','PPB','PPC') then 'SLOVENSKÝ PINZGAUSKÝ'
				when L.PlemTyp in ('PHA','PHB','PHC','PHD') then 'HOLSTEINSKÝ' END) AS ChovZvaz,
				L.PlemTyp AS Oddiel,-- L.CharChov_KOD AS KOD,
				'prvé' as Lakt,
				l1.PocLakN1 as Uzav_lakt, --normovanych 
				--L.PocLakV1 AS Uzav_lakt, 
				l1.LakdniNL1 AS Lakt_dni, 
				l1.MliekNorL1 AS mlieko, 
				l1.TukNorL1 AS tuk_KG, 
				round(l1.TukNorL1 / l1.MliekNorL1*100,2) AS tuk_P, 
				l1.BielkNorL1 as bielk_KG, 
				round(l1.BielkNorL1 / l1.MliekNorL1*100,2) AS bielk_P, 
				null as medziobd, 
				/*'2017'*/ DATEPART(YEAR, @datumOd) as rok
		from @pocLAKV1 as l
		left outer join @lakt1 as l1 on  l1.PlemTyp = l.PlemTyp
		
	union 
		Select  (case when lc.PlemTyp in ('PSA','PSB','PSC')  then 'SLOVENSKÝ STRAKATÝ'
				when lc.PlemTyp in ('PPA','PPB','PPC') then 'SLOVENSKÝ PINZGAUSKÝ'
				when lc.PlemTyp in ('PHA','PHB','PHC','PHD') then 'HOLSTEINSKÝ' END) AS ChovZvaz,
				lc.PlemTyp AS Oddiel, --L.CharChov_KOD AS KOD,
				'všetky' as Lakt,
				--lvc.PocLakVCelk as Uzav_lakt,
				lc.PocLakNcelk as Uzav_lakt, --normovanych
				lc.LakdniNCelk AS Lakt_dni, 
				lc.MliekNorCelk AS mlieko,
				lc.TukNorCelk AS tuk_KG, 
				round(lc.TukNorCelk / lc.MliekNorCelk*100,2) AS tuk_P, 
				lc.BielkNorCelk as bielk_KG, 
				round(lc.BielkNorCelk / lc.MliekNorCelk*100,2) AS bielk_P, 
				l2.MedziobdL2 as medziobd, 
				DATEPART(YEAR, @datumOd)  as rok
		from @pocLAKVCelk as lvc
		left outer join @lakt2 as l2 on l2.PlemTyp = lvc.PlemTyp
		left outer join @laktCelkom as lc on lc.PlemTyp = lvc.PlemTyp
	
	union 
		Select  (case when l_vs.PlemTyp ='S'  then 'SLOVENSKÝ STRAKATÝ'
				when l_vs.PlemTyp ='P' then 'SLOVENSKÝ PINZGAUSKÝ'
				when l_vs.PlemTyp ='H'then 'HOLSTEINSKÝ' END) AS ChovZvaz,
				L_vs.PlemTyp AS Oddiel,-- L.CharChov_KOD AS KOD,
				'prvé' as Lakt, 
				--L_vs.PocLakV1 AS Uzav_lakt, 
				l1_vs.PocLakN1 AS Uzav_lakt, --normovane
				l1_vs.LakdniNL1 AS Lakt_dni, 
				l1_vs.MliekNorL1 AS mlieko, 
				l1_vs.TukNorL1 AS tuk_KG, 
				round(l1_vs.TukNorL1 / l1_vs.MliekNorL1*100,2) AS tuk_P, 
				l1_vs.BielkNorL1 as bielk_KG, 
				round(l1_vs.BielkNorL1 / l1_vs.MliekNorL1*100,2) AS bielk_P, 
				null as medziobd, 
				DATEPART(YEAR, @datumOd)  as rok
				from @pocLAKV1_vs as l_vs
		left outer join @lakt1_vs as l1_vs on  l1_vs.PlemTyp = l_vs.PlemTyp

		union 
		Select  (case when lvc_vs.PlemTyp ='S'  then 'SLOVENSKÝ STRAKATÝ'
				when lvc_vs.PlemTyp ='P' then 'SLOVENSKÝ PINZGAUSKÝ'
				when lvc_vs.PlemTyp ='H'then 'HOLSTEINSKÝ' END) AS ChovZvaz,
				lc_vs.PlemTyp AS Oddiel, --L.CharChov_KOD AS KOD,
				'všetky' as Lakt,
				--lvc_vs.PocLakVCelk as Uzav_lakt,
				lc_vs.PocLakNcelk as Uzav_lakt, --normovane
				lc_vs.LakdniNCelk AS Lakt_dni, 
				lc_vs.MliekNorCelk AS mlieko,
				lc_vs.TukNorCelk AS tuk_KG, 
				round(lc_vs.TukNorCelk / lc_vs.MliekNorCelk*100,2) AS tuk_P, 
				lc_vs.BielkNorCelk as bielk_KG, 
				round(lc_vs.BielkNorCelk / lc_vs.MliekNorCelk*100,2) AS bielk_P, 
				l2_vs.MedziobdL2 as medziobd, 
				DATEPART(YEAR, @datumOd)  as rok
		from @pocLAKVCelk_vs as lvc_vs
		left outer join @lakt2_vs as l2_vs on l2_vs.PlemTyp = lvc_vs.PlemTyp
		left outer join @laktCelkom_vs as lc_vs on lc_vs.PlemTyp = lvc_vs.PlemTyp
	
		
	--union
	--	Select 'SR' AS ChovZvaz,
	--			l2_SR.PlemTyp AS Oddiel, --L.CharChov_KOD AS KOD,
	--			'všetky' as Lakt,
	--			lvc_SR.PocLakVCelk as Uzav_lakt,
	--			lc_SR.LakdniNCelk AS Lakt_dni, 
	--			lc_SR.MliekNorCelk AS mlieko,
	--			lc_SR.TukNorCelk AS tuk_KG, 
	--			round(lc_SR.TukNorCelk / lc_SR.MliekNorCelk*100,2) AS tuk_P, 
	--			lc_SR.BielkNorCelk as bielk_KG, 
	--			round(lc_SR.BielkNorCelk / lc_SR.MliekNorCelk*100,2) AS bielk_P, 
	--			l2_SR.MedziobdL2 as medziobd, 
	--			'2017' as rok
	--	from @pocLAKVCelk_SR as lvc_SR 
	--	left outer join @lakt2_SR  as l2_SR on l2_SR.PlemTyp = lvc_SR.PlemTyp
	--	left outer join @laktCelkom_SR  as lc_SR on lc_SR.PlemTyp = lvc_SR.PlemTyp

	union 
		Select  'SR' AS ChovZvaz,
				l__SR.PlemTyp AS Oddiel,-- L.CharChov_KOD AS KOD,
				'prvé' as Lakt, 
				--l__SR.PocLakV1 AS Uzav_lakt, 
				l1__SR.PocLakN1 AS Uzav_lakt, --normovane
				l1__SR.LakdniNL1 AS Lakt_dni, 
				l1__SR.MliekNorL1 AS mlieko, 
				l1__SR.TukNorL1 AS tuk_KG, 
				round(l1__SR.TukNorL1 / l1__SR.MliekNorL1*100,2) AS tuk_P, 
				l1__SR.BielkNorL1 as bielk_KG, 
				round(l1__SR.BielkNorL1 / l1__SR.MliekNorL1*100,2) AS bielk_P, 
				null as medziobd, 
				DATEPART(YEAR, @datumOd)  as rok
				from @pocLAKV1_SR as l__SR 
		left outer join @lakt1_SR as l1__SR  on  l1__SR.PlemTyp = l__SR.PlemTyp
		
	union
		Select 'SR' AS ChovZvaz,
				lc_SR.PlemTyp AS Oddiel, --L.CharChov_KOD AS KOD,
				'všetky' as Lakt,
				--lvc_SR.PocLakVCelk as Uzav_lakt,
				lc_SR.PocLakNcelk  as Uzav_lakt,--normovane
				lc_SR.LakdniNCelk AS Lakt_dni, 
				lc_SR.MliekNorCelk AS mlieko,
				lc_SR.TukNorCelk AS tuk_KG, 
				round(lc_SR.TukNorCelk / lc_SR.MliekNorCelk*100,2) AS tuk_P, 
				lc_SR.BielkNorCelk as bielk_KG, 
				round(lc_SR.BielkNorCelk / lc_SR.MliekNorCelk*100,2) AS bielk_P, 
				l2_SR.MedziobdL2 as medziobd, 
				DATEPART(YEAR, @datumOd)  as rok
		from @pocLAKVCelk_SR as lvc_SR
		left outer join @lakt2_SR as l2_SR on l2_SR.PlemTyp = lvc_SR.PlemTyp
		left outer join @laktCelkom_SR as lc_SR on lc_SR.PlemTyp = lvc_SR.PlemTyp

	--select * from Roc_MLHD_Tab_18

	--select * from @Laktacie order by PLEM
	--select * from @Laktacie_vs order by PLEM


	--select * from Roc_MLHD_Tab_18 where rok = 2017 order by oddiel, lakt
	--delete from Roc_MLHD_Tab_18 where rok = 2017 
	end
go



/*********************** 
		vyber udajov do reportu TAB1 do Masovej rocenky krav 
		v rocenke z r. 2017 na strane 26 ...."Sumarne vysledky kontroly uzitkovosti"
 ***********************/
 CREATE procedure [dbo].[Rocenka_MPHD_1]
	
	@rok varchar(4)

	as 
	begin

	select 
	case when plemeno ='AA' then 1
				when plemeno ='BdA' then 2
				--when plemeno ='BBM' then 3
				when plemeno ='Gal' then 3
				when plemeno ='HEM' then 4
				when plemeno ='High' then 5
				when plemeno ='Char' then 6
				when plemeno ='Lim' then 7
				--when plemeno ='SDM' then 8
				--when plemeno ='Piem' then 8
				when plemeno ='Pin' then 8 
				when plemeno ='Sim_maso' then 9
				when plemeno ='Slst' then 10
				when plemeno ='Osta' then 11
				when plemeno ='Nez' then 12
				when plemeno ='SR' then 13 end  as poradie,
	
	case when plemeno ='AA' then 'Aberdeen Angus'
				when plemeno ='BdA' then 'Blonde d´Aquitaine'
				when plemeno ='BBM' then 'Belgické modré'
				when plemeno ='Gal' then 'Galloway'
				when plemeno ='High' then 'Highland'
				when plemeno ='Char' then 'Charolais'
				when plemeno ='Lim' then 'Limousine'
				when plemeno ='Hem' then 'Hereford'
				when plemeno ='Sim_maso' then 'Simentál mäsový'
				when plemeno ='Piem' then 'Piemontese'
				when plemeno ='Pin' then 'Pinzgauské'
				when plemeno ='SDM' then 'Maďarský stepný dobytok'
				when plemeno ='Slst' then 'Slovenské strakaté'
				when plemeno ='Osta' then 'Ostatné plemená'
				when plemeno ='Nez' then 'Neznáme'
				when plemeno ='SR' then 'Výsledky za Slovensko' end as	plemeno, 
	
	byk_nar_ks, byk_nar_kg, jal_nar_ks, jal_nar_kg, byk_120ks, jal_120ks, byk_210ks, jal_210ks, byk_365ks, jal_365ks, byk_500ks, jal_500ks, 
		isnull(byk_120kg,0) as byk_120kg, 
		isnull(jal_120kg,0) as jal_120kg, 
		isnull(byk_210kg,0) as byk_210kg, 
		isnull(jal_210kg,0) as jal_210kg, 
		isnull(byk_365kg,0) as byk_365kg, 
		isnull(jal_365kg,0) as jal_365kg, 
		isnull(byk_500kg,0) as byk_500kg, 
		isnull(jal_500kg,0) as jal_500kg,
		isnull(byk_g_den_120,0) as byk_g_den_120, 
		isnull(jal_g_den_120,0) as jal_g_den_120, 
		isnull(byk_g_den_210,0) as byk_g_den_210, 
		isnull(jal_g_den_210,0) as jal_g_den_210, 
		isnull(byk_g_den_365,0) as byk_g_den_365, 
		isnull(jal_g_den_365,0) as jal_g_den_365, 
		isnull(byk_g_den_500,0) as byk_g_den_500, 
		isnull(jal_g_den_500,0) as jal_g_den_500, 
		rok 
	
	from Roc_MPHD_Tab_1
	where @rok = rok
	order by poradie

	end
go

------------------------------------------------------------------------------------------


create FUNCTION dbo.toMesiacDen
  (
    @dni float
  )
  RETURNS varchar(7)
AS
  BEGIN
    declare @res varchar(7); 
    IF (@dni IS NOT NULL)
      set @res = convert(varchar, FLOOR(@dni / 30.42))+' / '+convert(varchar, FLOOR(ROUND(CAST(@dni as decimal(38,19)) % 30.42,0)));;
    return @res;
  END
go



---------------------------------------------------------------------------------


CREATE procedure  [dbo].[Roc_MLHD_16]
	@datumOd date,
	@datumDo date

	as 
	begin

--declare @datumOd date = '2017-01-01', @datumDo date = '2017-12-31'

		delete from Roc_MLHD_Tab_16 where rok = DATEPART(YEAR,@datumOd); 
		

	--holstein
	declare @mastale_H table
		(
		--Por bigint,
		podnik varchar(9),
		Nazov varchar(100),
		Sidlo  varchar(100),
		Uzitk_mlieka int,
		Prevaz_plem  varchar(10),
		Uzav_lakt float,
		tuk_P float,
		bielk_P float,
		Priem_lakt float,
		Kraj varchar(100),
		rok varchar(4),
		Plem_typ varchar(6)
		)
	--slovenske strakate
	declare @mastale_S table
		(
		--Por bigint,
		podnik varchar(9),
		Nazov varchar(100),
		Sidlo  varchar(100),
		Uzitk_mlieka int,
		Prevaz_plem  varchar(10),
		Uzav_lakt float,
		tuk_P float,
		bielk_P float,
		Priem_lakt float,
		Kraj varchar(100),
		rok varchar(4),
		Plem_typ varchar(6)
		)
	--Pinzgauske
	declare @mastale_P table
		(
		--Por bigint,
		podnik varchar(9),
		Nazov varchar(100),
		Sidlo  varchar(100),
		Uzitk_mlieka int,
		Prevaz_plem  varchar(10),
		Uzav_lakt float,
		tuk_P float,
		bielk_P float,
		Priem_lakt float,
		Kraj varchar(100),
		rok varchar(4),
		Plem_typ varchar(6)
		)

		declare @podiely table				-----PL1 a ich podiel v chove
			(
			podnik varchar (6),
			PL1 varchar(3),
			KR1 float,
			PodielPerc float--
			)
		
	declare @podniky int = (select count(oznacenie) from  CR_LaktacneZostavy_Opr where len(Oznacenie)=6 and Oznacenie=Filter )
	 print 'podniky'
	 print @podniky
	
	if @podniky >0
	begin 
		Insert into @podiely
		 (PL1, podnik,  KR1, PodielPerc)

			select distinct	 k.pl1 as PL1,
												substring(k.chovatel,1,6) as podnik,
												sum(k.KR1)as KR1,
												(sum(k.KR1)/(select sum(k1.KR1)from CM_Krava as k1
												where substring(k1.chovatel,1,6) = substring(k.chovatel,1,6)
															and PRIZNAKKU = 1
															and (k1.dovvyr is null or (k1.dovvyr is not null and k1.DATVYR>=@datumOd))))*100 as PodielPerc
			from CR_LaktacneZostavy_Opr as a --CM_Krava
				left outer join CM_Krava as k on substring(k.CHOVATEL,1,6) = a.Oznacenie
			where  substring(k.CHOVATEL,1,6)  =  a.Oznacenie
						 and substring(k.CHOVATEL,7,3) not in ('010','700', '699')
						 and k.PRIZNAKKU = 1
						 and (k.dovvyr is null or (k.dovvyr is not null and k.DATVYR>=@datumOd))
						 and k.PL1 is not null
			group by k.PL1, substring(k.chovatel,1,6)

	end
	--select * from @podiely
		
	declare @counter int,  @podnik varchar(6)
		declare @plemena table
		(
		PL1 varchar(3),
		KR1 float,
		PodielPerc float,
		CHOVATEL varchar (9),
		por int
		)

	declare @ZoznamPL1 table
		(
		podnik VARCHAR(6),
		plem varchar(10)
		)
		
	DECLARE poradie_cursor CURSOR LOCAL
		FOR
			SELECT podnik FROM @podiely group by podnik
						
		OPEN poradie_cursor
		FETCH NEXT FROM poradie_cursor INTO @podnik
		WHILE @@FETCH_STATUS = 0
			BEGIN 			
				--print @chovatelia			
				delete from  @plemena			
				insert into @plemena
					(PL1, KR1, PodielPerc, CHOVATEL, por)
					select distinct PL1,KR1, PodielPerc, podnik,ROW_NUMBER() OVER (ORDER BY PodielPerc desc) as por from @podiely as p where p.PodielPerc >12.5 and podnik = @podnik
			
				declare @PL1 varchar(10) = ISNULL((select pl1 from @plemena where por=1),'') +' '+ isnull((select PL1 from @plemena where por=2),'') +' '+ isnull((select PL1  from @plemena where por=3),'') 
		
				insert into @ZoznamPL1
				select distinct @podnik,@PL1
						
				FETCH NEXT FROM poradie_cursor INTO @podnik
			END

		CLOSE poradie_cursor
		DEALLOCATE poradie_cursor

		--select * from  @ZoznamPL1


insert into @mastale_H 
			(podnik,Nazov,Sidlo ,Uzitk_mlieka ,Prevaz_plem ,Uzav_lakt ,tuk_P ,bielk_P,Priem_lakt,Kraj,rok ,Plem_typ)
		select  distinct top 25 --ROW_NUMBER() OVER(ORDER BY Lakt.MliekNorCelk desc) AS Por,
				Lakt.Oznacenie as podnik, 
				p.NAZOVSKR as Nazov, 
				pl.Sidlo as Sidlo,
				round(Lakt.MliekNorCelk,0)  as Uzitk_mlieka,
				z.plem as Prevaz_plem,
				round(Lakt.PocLakNcelk,0) as Uzav_lakt,
				round((Lakt.TukNorCelk*100)/Lakt.MliekNorCelk,2) as tuk_P,
				round((Lakt.BielkNorCelk*100)/Lakt.MliekNorCelk,2) as bielk_P,
				pl.priem_lakt as Priem_lakt,
				(case when left(Lakt.Oznacenie,1)='1' then 'Bratislavský'
						when left(Lakt.Oznacenie,1)='2' then 'Trnavský'
						when left(Lakt.Oznacenie,1)='3' then 'Trenčiansky'
						when left(Lakt.Oznacenie,1)='4' then 'Nitriansky' 
						when left(Lakt.Oznacenie,1)='5' then 'Žilinský' 
						when left(Lakt.Oznacenie,1)='6' then 'Banskobystrický' 
						when left(Lakt.Oznacenie,1)='7' then 'Prešovský' 
						when left(Lakt.Oznacenie,1)='8' then 'Košický' 
						end) as Kraj,
				datepart(year, @datumOd) as rok,
				'Hol' as Plem_typ
		FROM CR_LaktacneZostavy_Opr as Lakt	 
					left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = Lakt.Oznacenie
					--left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.Oznacenie
					left outer join Roc_MLHD_Tab_23A as pl on pl.kraj + pl.okres + pl.podnik = Lakt.Oznacenie and pl.rok = DATEPART(YEAR,@datumOd)
					left outer join  @ZoznamPL1 as z on z.podnik = Lakt.Oznacenie
					where  len(Lakt.Oznacenie)=6 and Lakt.Oznacenie = Lakt.Filter and Lakt.DatumOd = @datumOd and Lakt.DatumDo = @datumDo
					and pl.rok = DATEPART(YEAR,@datumOd)
					and left(z.plem,1) in ('H','R')
			order by round(Lakt.MliekNorCelk,0) desc 
	--select * from @mastale_H

	insert into @mastale_S 
			(podnik,Nazov,Sidlo ,Uzitk_mlieka ,Prevaz_plem ,Uzav_lakt ,tuk_P ,bielk_P,Priem_lakt,Kraj,rok ,Plem_typ)
		select distinct top 25-- ROW_NUMBER() OVER(ORDER BY Lakt.MliekNorCelk desc) AS Por,
				Lakt.Oznacenie as podnik, 
				p.NAZOVSKR as Nazov, 
				pl.Sidlo as Sidlo,
			  round(Lakt.MliekNorCelk,0)  as Uzitk_mlieka,
				z.plem as Prevaz_plem,
			  round(Lakt.PocLakNcelk,0) as Uzav_lakt,
				round((Lakt.TukNorCelk*100)/Lakt.MliekNorCelk,2) as tuk_P,
				round((Lakt.BielkNorCelk*100)/Lakt.MliekNorCelk,2) as bielk_P,
				pl.priem_lakt as Priem_lakt,
				(case when left(Lakt.Oznacenie,1)='1' then 'Bratislavský'
						when left(Lakt.Oznacenie,1)='2' then 'Trnavský'
						when left(Lakt.Oznacenie,1)='3' then 'Trenčiansky'
						when left(Lakt.Oznacenie,1)='4' then 'Nitriansky' 
						when left(Lakt.Oznacenie,1)='5' then 'Žilinský' 
						when left(Lakt.Oznacenie,1)='6' then 'Banskobystrický' 
						when left(Lakt.Oznacenie,1)='7' then 'Prešovský' 
						when left(Lakt.Oznacenie,1)='8' then 'Košický' 
						end) as Kraj,
				datepart(year, @datumOd) as rok,
				'SLst' as Plem_typ
				
			FROM CR_LaktacneZostavy_Opr as Lakt	 
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = Lakt.Oznacenie
							--left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.Oznacenie
							left outer join Roc_MLHD_Tab_23A as pl on pl.kraj + pl.okres + pl.podnik = Lakt.Oznacenie and pl.rok = DATEPART(YEAR,@datumOd)
							left outer join  @ZoznamPL1 as z on z.podnik = Lakt.Oznacenie
						 where  len(Lakt.Oznacenie)=6 and Lakt.Oznacenie = Lakt.Filter and Lakt.DatumOd = @datumOd and Lakt.DatumDo = @datumDo
							and pl.rok = DATEPART(YEAR,@datumOd)
							and left(z.plem,2) in ('S ','MB')
							and Lakt.PocLakNcelk > 10
					order by round(Lakt.MliekNorCelk,0) desc 
	--select * from @mastale_S


	insert into @mastale_P
			(podnik,Nazov,Sidlo ,Uzitk_mlieka ,Prevaz_plem ,Uzav_lakt ,tuk_P ,bielk_P,Priem_lakt,Kraj,rok ,Plem_typ)
		select  distinct top 5 --ROW_NUMBER() OVER(ORDER BY Lakt.MliekNorCelk desc) AS Por,
				Lakt.Oznacenie as podnik, 
				p.NAZOVSKR as Nazov, 
				pl.Sidlo as Sidlo,
			  round(Lakt.MliekNorCelk,0)  as Uzitk_mlieka,
				z.plem as Prevaz_plem,
	  		round(Lakt.PocLakNcelk,0) as Uzav_lakt,
				round((Lakt.TukNorCelk*100)/Lakt.MliekNorCelk,2) as tuk_P,
				round((Lakt.BielkNorCelk*100)/Lakt.MliekNorCelk,2) as bielk_P,
				pl.priem_lakt as Priem_lakt,
				(case when left(Lakt.Oznacenie,1)='1' then 'Bratislavský'
						when left(Lakt.Oznacenie,1)='2' then 'Trnavský'
						when left(Lakt.Oznacenie,1)='3' then 'Trenčiansky'
						when left(Lakt.Oznacenie,1)='4' then 'Nitriansky' 
						when left(Lakt.Oznacenie,1)='5' then 'Žilinský' 
						when left(Lakt.Oznacenie,1)='6' then 'Banskobystrický' 
						when left(Lakt.Oznacenie,1)='7' then 'Prešovský' 
						when left(Lakt.Oznacenie,1)='8' then 'Košický' 
						end) as Kraj,
				datepart(year, @datumOd) as rok,
				'Pin' as Plem_typ
					
		FROM CR_LaktacneZostavy_Opr as Lakt	 
							left outer join NM_PODNIK as p on p.kraj + p.okres + p.podnik = Lakt.Oznacenie
							--left outer join NM_HDDETAIL as h on h.KRAJ+ h.OKRES+ h.PODNIK + h.CHOV = Lakt.Oznacenie
							left outer join Roc_MLHD_Tab_23A as pl on pl.kraj + pl.okres + pl.podnik = Lakt.Oznacenie and pl.rok = DATEPART(YEAR,@datumOd)
							left outer join  @ZoznamPL1 as z on z.podnik = Lakt.Oznacenie
						 where  len(Lakt.Oznacenie)=6 and Lakt.Oznacenie = Lakt.Filter and Lakt.DatumOd = @datumOd and Lakt.DatumDo = @datumDo
							and pl.rok = DATEPART(YEAR,@datumOd)
							and left(z.plem,1) ='P'
					order by round(Lakt.MliekNorCelk,0) desc 
	--select * from @mastale_P
	
	insert into Roc_MLHD_Tab_16
	select ROW_NUMBER() OVER(ORDER BY Uzitk_mlieka desc) AS Por,
		Nazov,
		Sidlo,
		Uzitk_mlieka,
		Prevaz_plem ,
		Uzav_lakt ,
		tuk_P ,
		bielk_P,
		Priem_lakt ,
		Kraj ,
		rok ,
		Plem_typ  from @mastale_H
	
	insert into Roc_MLHD_Tab_16
	select ROW_NUMBER() OVER(ORDER BY Uzitk_mlieka desc) AS Por,
	Nazov,
		Sidlo,
		Uzitk_mlieka,
		Prevaz_plem ,
		Uzav_lakt ,
		tuk_P ,
		bielk_P,
		Priem_lakt ,
		Kraj ,
		rok ,
		Plem_typ from @mastale_S
	
	insert into Roc_MLHD_Tab_16
	select ROW_NUMBER() OVER(ORDER BY Uzitk_mlieka desc) AS Por,
	Nazov,
		Sidlo,
		Uzitk_mlieka,
		Prevaz_plem ,
		Uzav_lakt ,
		tuk_P ,
		bielk_P,
		Priem_lakt ,
		Kraj ,
		rok ,
		Plem_typ from @mastale_P

End
go











