
insert into plis..CC_ChybyKU(CISCHYBY,TEXTCHYBY, ZNCH_CV_INS,ZNCH_CT_INS,ZNCH_CT_UPD) values (140,'Z teľaťa je už dospelé zviera',2,2,2)
insert into plis..CC_ChybyKU(CISCHYBY,TEXTCHYBY, ZNCH_CV_INS,ZNCH_CT_INS,ZNCH_CT_UPD) values (141,'Presun teľaťa môže byť len z ML chovu',2,2,2)
go;

-- =============================================
-- Author:		PSSR,�.p.
-- Create date: 14.12.2011
-- Description:	Doklad o vazeni - aktualizacia
-- Edit: 19.3.2021 - pridana kontrola, ci datum zadanie nie je vacsi ako datum spracovania
-- Edit: 16.06.2022 - presun teliat z ML do ML chovu ZMENIT ZAVER 999 na ine, ked sa to pojde nasadzovat!!!
-- =============================================
alter PROCEDURE [dbo].[C_aktual_Dokvazml_aktualizacia]
@parChov varchar(9)

AS
BEGIN
    declare @IDR int
    declare @DATZAPIS [datetime]
    declare @DATSPRAC [datetime]
    declare @SPRAC [bit]
    declare @CISTELATA [varchar](28)
    declare @DATVAZ [date]
    declare @HMOT [decimal](7,3)
    declare @CHOVVAZ [varchar](18)
    declare @TURNUS [varchar](4)
    declare @ZAVER [varchar](2)

    declare @errorflag bit
    declare @rowcount1 int
    declare @counter1 int
    declare @navrat_hodn [varchar](1)
    declare @JeTelaVTelatach bit
    declare @V_DATVAZ [date]
    declare @_DATNAR [date]
    declare @V_HMOT [decimal](7,3)
    declare @_HMOT_NAR [decimal](7,3)
    declare @_HMOT_PRED [decimal](7,3)
    declare @_DAT_PRED [date]
    declare @MaVazenia bit
    declare @Prirastok [decimal](7,3)
    declare @_DOVVYR [varchar](2)
    declare @T_DOVVYR [varchar](2)
    declare @TelaJeVyradene bit
    declare @CHOVVAZ_POV [varchar](18)
    declare @jeOprava bit
    declare @CHOVATEL [varchar](9)

    declare @IDParChov bigint
    -- ziskanie id spracovavaneho chovu
    SELECT @IDParChov = max(IDR) FROM VstupyPLIS.dbo.CP_SPRAC_CHOVY WHERE CHOV = @parChov

    -- vyber doposial nespracovanych dokladov vazeni
    declare db_cursor_dokvazml cursor
        FOR
        SELECT IDR
             ,CHOV
             ,CISTELATA
             ,convert(decimal(7,3),nullif(HMOT, '')) as HMOT
             ,nullif(ZAVER, '')
             ,convert(date, nullif(DATVAZ, ''), 104) as DATVAZ
             ,nullif(TURNUS, '')
        FROM VstupyPLIS.dbo.CP_HD15_DOKVAZ where PRIZSPRAC = 0 AND (CHOV = @parChov OR @parChov is NULL)
                                             -- pridana moznost vyradenia teliat na chove ML (cez hlasenie vazeni) -- 20160505
                                             AND (dbo.HDchov_ma_typ_KU(CHOV, 'ML') = 1 OR dbo.HDchov_ma_typ_KU(CHOV, 'TMHD') = 1)
                                             -- pridane zotriedenie podla datumu vazenia pre moznost spracovat viacero vazeni na jedno zviera -- 20160427
        ORDER BY convert(date, nullif(DATVAZ, ''), 104)

    OPEN db_cursor_dokvazml


    -- cyklus cez vsetky nespracovane hlasenia vazeni
    FETCH NEXT
        FROM db_cursor_dokvazml INTO
        @IDR
        ,@CHOVVAZ
        ,@CISTELATA
        ,@HMOT
        ,@ZAVER
        ,@DATVAZ
        ,@TURNUS

    WHILE @@FETCH_STATUS = 0
        begin
            -- zaznam v tabulke hlaseni vazeni nastaveny ako "v spracovani"
            update VstupyPLIS.dbo.CP_HD15_DOKVAZ set
                                                     DATSPRAC = GETDATE(),
                                                     PRIZSPRAC = 1
            where IDR = @IDR

            --zaciatok transakcie
            begin tran dokvazml
                begin try

                    set @JeTelaVTelatach = 1
                    set @MaVazenia = 0
                    set @T_DOVVYR = null
                    set @TelaJeVyradene = 0
                    set @errorflag = 0
                    set @jeOprava = 0
                    set @navrat_hodn = null

                    if (@HMOT is not null AND @ZAVER is null)
                        set @ZAVER = '0'

                    -- odfiltrovanie prazdnych dat poslanych zo zberaca
                    if ((@DATVAZ is not null OR (@DATVAZ is null AND @ZAVER is not null)) AND (@HMOT is not null OR @ZAVER is not null))
                        begin
                            -- nacitanie niektorych udajov z tabulky CM_Telata
                            select @_DATNAR = DATNAR, @_DOVVYR = DOVVYR, @CHOVATEL = CHOVATEL from PLIS.dbo.CM_Telata where CISTELATA = @CISTELATA

                            set @V_DATVAZ = @DATVAZ
                            set @V_HMOT = @HMOT

                            -- kontrola: ide o chov s TMHD
                            if not(((select dbo.HDchov_ma_typ_KU(@CHOVVAZ, 'TMHD')) = 1) OR
                                -- alebo vyradenie telata na chove ML -- 20160505
                                   ((@ZAVER = '2' or @ZAVER = '3' or @ZAVER = '4' or @ZAVER = '7' or @ZAVER = '8' or @ZAVER = '9') AND ((select dbo.HDchov_ma_typ_KU(@CHOVVAZ, 'ML')) = 1)))
                                begin
                                    -- priradenie chyby 004
                                    exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 4
                                    if (@navrat_hodn = '2')
                                        begin
                                            set @errorflag = (select 1)
                                        end
                                end

                            -- kontrola: je tela v CM_Telata
                            if ((select COUNT(*) from PLIS.dbo.CM_Telata where (CISTELATA = @CISTELATA)) = 0 and @CISTELATA != 'SK999999999999')
                                begin
                                    -- priradenie chyby 111
                                    exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 111
                                    if (@navrat_hodn = '2')
                                        begin
                                            set @errorflag = (select 1)
                                        end
                                    set @JeTelaVTelatach = 0
                                end

                            -- kontrola: chybny datum vazenia
                            if (DATEDIFF(DAY, @DATVAZ, getdate()) < 0) or (DATEDIFF(DAY, '2000-01-01', @DATVAZ) < 0)
                                begin
                                    -- priradenie chyby 112
                                    exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 112
                                    if (@navrat_hodn = '2')
                                        begin
                                            set @errorflag = (select 1)
                                        end else
                                        if (@navrat_hodn = '1')
                                            begin
                                                set @V_DATVAZ = null
                                            end
                                end

                            -- kontrola: Vazenie po 48 hod od narodenia a pohlavie telata konci na 6
                            if (@JeTelaVTelatach = 1 and DATEDIFF(DAY, @_DATNAR, @DATVAZ) >= 2)
                                begin
                                    if('6' = (select substring(pohlavie,2,1) from CM_Telata where CISTELATA = @CISTELATA and POHLAVIE is not null))
                                        -- priradenie chyby 231
                                        exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 231
                                    if (@navrat_hodn = '2')
                                        begin
                                            set @errorflag = (select 1)
                                        end else
                                        if (@navrat_hodn = '1')
                                            begin
                                                set @V_DATVAZ = null
                                            end
                                end

                            -- kontrola: D�tum narodenia > d�tum v�enia
                            if (DATEDIFF(DAY, @_DATNAR, @DATVAZ) < 0)
                                begin
                                    -- priradenie chyby 113
                                    exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 113
                                    if (@navrat_hodn = '2')
                                        begin
                                            set @errorflag = (select 1)
                                        end else
                                        if (@navrat_hodn = '1')
                                            begin
                                                set @V_DATVAZ = null
                                            end
                                end

                            -- kontrola: Datum vazenie > datum spracovania
                            --if (DATEDIFF(DAY, @DATVAZ, SYSDATETIME()) < 0)
                            --  begin
                            --    exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 232
                            --    if (@navrat_hodn = '2')
                            --      begin
                            --        set @errorflag = (select 1)
                            --      end
                            --  end

                            -- kontrola: nespravny zaver
                            if not ((@ZAVER in (select KOD from plis.dbo.CC_VazeniaZaver)) or (@ZAVER is null))
                                begin
                                    -- priradenie chyby 116
                                    exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 116
                                    if (@navrat_hodn = '2')
                                        begin
                                            set @errorflag = (select 1)
                                        end
                                end

                            ---- kontrola: Duplicitn� v�enie
                            if (select COUNT(*) from PLIS.dbo.CM_Vazenia where CISTELATA = @CISTELATA and DATVAZ = @DATVAZ) > 0
                                begin
                                    ---- priradenie chyby 151
                                    --exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 151
                                    --if (@navrat_hodn = '2')
                                    --begin
                                    --	set @errorflag = (select 1)
                                    --end

                                    -- nie je to chyba - ide o opravu hmotnosti
                                    set @jeOprava = 1
                                end

                            -- Presun telata z ML do ML chovu
                            if (@ZAVER = '999')
                                begin
                                    -- ak je z telata uz krava alebo byk tak chyba
                                    if((select (select count(*) from plis..CM_Krava where CISKRAVY = @CISTELATA)+
                                               (select count(*)  from plis..CM_Byci where USCISLO = @CISTELATA)) > 0)
                                        begin
                                            exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 140
                                            if (@navrat_hodn = '2')
                                                begin
                                                    set @errorflag = (select 1)
                                                end
                                        end


                                    --kontrola ci chov odkial prisuvam tela je ML (kontrola ci chov na ktorom pracujem - kam prisuvam nemusim kontrolovat, lebo to uz je osetrene pri selecte dokladov)
                                    if(@JeTelaVTelatach = 1 and
                                       (dbo.HDchov_ma_typ_KU((select CHOVATEL from plis..CM_Telata where CISTELATA = @CISTELATA), 'ML') <> 1))
                                        begin
                                            exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 141
                                            if (@navrat_hodn = '2')
                                                begin
                                                    set @errorflag = (select 1)
                                                end
                                        end
                                end

                            -- aktualizacia
                            if (@errorflag != 1)
                                begin
                                    -- zaver 0 (hlasenie hmotnosti a zrusenie vyradenia), 6
                                    if @ZAVER = '0' or @ZAVER = '6'
                                        begin
                                            -- kontrola: hmotnost v platnom rozsahu
                                            if @HMOT < 25 or @HMOT > 750
                                                begin
                                                    -- priradenie chyby 118
                                                    exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 118
                                                    if (@navrat_hodn = '2')
                                                        begin
                                                            set @errorflag = (select 1)
                                                        end else
                                                        if (@navrat_hodn = '1')
                                                            begin
                                                                set @V_HMOT = null
                                                            end
                                                end

                                            -- kontrola: denny prirastok hmotnosti v platnom rozsahu
                                            SELECT TOP 1 @_DAT_PRED = DATVAZ, @_HMOT_PRED = HMOT, @MaVazenia = 1 FROM PLIS.dbo.CM_Vazenia where CISTELATA = @CISTELATA order by DATVAZ desc
                                            if @MaVazenia = 1
                                                begin
                                                    set @Prirastok = ((ISNULL(@HMOT, 0) - ISNULL(@_HMOT_PRED, 0)) / nullif(DATEDIFF(day, @_DAT_PRED, @DATVAZ), 0))
                                                    if (@Prirastok < -0.5 or @Prirastok > 2.0) and (@HMOT is not null)
                                                        begin
                                                            -- priradenie chyby 119
                                                            exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 119
                                                            if (@navrat_hodn = '2')
                                                                begin
                                                                    set @errorflag = (select 1)
                                                                end
                                                        end
                                                end

                                            -- kontrola: zivotny prirastok hmotnosti v platnom rozsahu
                                            select @_HMOT_NAR = HMOTNAR, @CHOVVAZ_POV = CHOVATEL from PLIS.dbo.CM_Telata where CISTELATA = @CISTELATA
                                            set @Prirastok = ((ISNULL(@HMOT, 0) - ISNULL(@_HMOT_NAR, 0)) / nullif(DATEDIFF(day, @_DATNAR, @DATVAZ), 0))
                                            if (@Prirastok < 0.3 or @Prirastok > 2.0) and (@HMOT is not null)
                                                begin
                                                    -- priradenie chyby 120
                                                    exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 120
                                                    if (@navrat_hodn = '2')
                                                        begin
                                                            set @errorflag = (select 1)
                                                        end
                                                end

                                            if @JeTelaVTelatach = 1
                                                begin
                                                    -- kontrola: vyradenie telata
                                                    if (@_DOVVYR in (select DOVVYR from plis.dbo.CC_DovodyVyradenia)) and (@_DOVVYR != '99') and (@_DOVVYR is not null)
                                                        begin
                                                            -- priradenie chyby 121
                                                            exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 121
                                                            if (@navrat_hodn = '2')
                                                                begin
                                                                    set @errorflag = (select 1)
                                                                end
                                                            set @TelaJeVyradene = 1
                                                        end
                                                end else
                                                begin
                                                    if @MaVazenia = 1
                                                        begin
                                                            SELECT TOP 1 @_DAT_PRED = DATVAZ FROM PLIS.dbo.CM_Vazenia where CISTELATA = @CISTELATA order by DATVAZ asc
                                                            -- kontrola: prislo vazenie a zviera nie je viac ako 10 mesiacov v Telatach
                                                            if DATEDIFF(MONTH, @_DAT_PRED, @DATVAZ) > 10
                                                                begin
                                                                    -- priradenie chyby 110
                                                                    exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 110
                                                                    if (@navrat_hodn = '2')
                                                                        begin
                                                                            set @errorflag = (select 1)
                                                                        end
                                                                end else
                                                                -- kontrola: prislo vazenie a zviera nie je viac ako 6 mesiacov v Telatach
                                                                if DATEDIFF(MONTH, @_DAT_PRED, @DATVAZ) > 6
                                                                    begin
                                                                        -- priradenie chyby 114
                                                                        exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 114
                                                                        if (@navrat_hodn = '2')
                                                                            begin
                                                                                set @errorflag = (select 1)
                                                                            end
                                                                    end
                                                        end
                                                end

                                            if (@errorflag != 1)
                                                begin
                                                    -- zapis vazenia do tabulky vazeni CM_Vazenia
                                                    if isnull(@V_HMOT, 0) != 0
                                                        begin
                                                            if (@jeOprava = 0)
                                                                begin
                                                                    insert into PLIS.dbo.CM_Vazenia (CISTELATA, DATVAZ, HMOT, CHOVVAZ, PRIZNAKKU, RASTPAS, TURNUS, SPRACINSERT, SPRACUPDATE)
                                                                    values (@CISTELATA, @V_DATVAZ, @V_HMOT, @CHOVVAZ, '1', PLIS.dbo.C_aktual_zisti_rastove_pasmo(@CISTELATA, @V_DATVAZ, @V_HMOT), @TURNUS, @IDParChov, @IDParChov)
                                                                end else
                                                                begin
                                                                    update PLIS.dbo.CM_Vazenia set HMOT = @V_HMOT where CISTELATA = @CISTELATA and DATVAZ = @V_DATVAZ
                                                                end

                                                            if @CHOVVAZ != @CHOVVAZ_POV
                                                                -- presun telata ak treba
                                                                update PLIS.dbo.CM_Telata set
                                                                                              CHOVATEL = @CHOVVAZ, PRIZNAKKU = '1', SPRACUPDATE = @IDParChov
                                                                where CISTELATA = @CISTELATA
                                                        end

                                                    if (@TelaJeVyradene = 1 and @JeTelaVTelatach = 1)
                                                        -- zrusenie vyradenia telata ak treba
                                                        update PLIS.dbo.CM_Telata set
                                                                                      DOVVYR = null,
                                                                                      DATVYR = null, SPRACUPDATE = @IDParChov
                                                        where CISTELATA = @CISTELATA
                                                end
                                        end else

                                        -- zaver 1 (zrusenie vazeni(a))
                                        if @ZAVER = '1'
                                            begin
                                                if @HMOT = 999
                                                    -- kontrola: su rusene vazenia v CM_Vazenia
                                                    if (select COUNT(*) from PLIS.dbo.CM_Vazenia where CISTELATA = @CISTELATA) = 0
                                                        -- priradenie chyby 117
                                                        exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 117
                                                    else
                                                        delete from PLIS.dbo.CM_Vazenia
                                                        where CISTELATA = @CISTELATA
                                                else
                                                    -- kontrola: je rusene vazenie v CM_Vazenia
                                                    if (select COUNT(*) from PLIS.dbo.CM_Vazenia where CISTELATA = @CISTELATA and DATVAZ = @V_DATVAZ) = 0
                                                        -- priradenie chyby 117
                                                        exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 117
                                                    else
                                                        delete from PLIS.dbo.CM_Vazenia
                                                        where CISTELATA = @CISTELATA and DATVAZ = @V_DATVAZ

                                            end else
                                            -- zaver - ostatne (vyradenie zvierat(a))
                                            if @ZAVER = '2' or @ZAVER = '3' or @ZAVER = '4' or @ZAVER = '7' or @ZAVER = '8' or @ZAVER = '9'
                                                begin
                                                    -- kontrola na zhodu chovu
                                                    if (@CHOVVAZ != @CHOVATEL)
                                                        begin
                                                            -- priradenie chyby 64
                                                            exec @navrat_hodn = plis.[dbo].[C_aktual_Dokvazml_zapis_chybu] @IDR, 64
                                                            if (@navrat_hodn = '2')
                                                                begin
                                                                    set @errorflag = (select 1)
                                                                end
                                                        end

                                                    if (@errorflag != 1)
                                                        begin
                                                            select @T_DOVVYR = Kod_vyradenia from PLIS.dbo.CC_VazeniaZaver where Kod = @ZAVER
                                                            if (@CISTELATA = 'SK999999999999')
                                                                update PLIS.dbo.CM_Telata set
                                                                                              DOVVYR = @T_DOVVYR,
                                                                                              DATVYR = @V_DATVAZ, SPRACUPDATE = @IDParChov
                                                                where DOVVYR is null and CHOVATEL = @CHOVVAZ
                                                            else
                                                                update PLIS.dbo.CM_Telata set
                                                                                              DOVVYR = @T_DOVVYR,
                                                                                              DATVYR = @V_DATVAZ, SPRACUPDATE = @IDParChov
                                                                where DOVVYR is null and CISTELATA = @CISTELATA
                                                        end
                                                end

                                    --presun teliat z ML do ML chovu.
                                    if @ZAVER = '999' -- TREBA ZMENIT
                                        begin--Presunom sa zrusi vyradenie ak nahodou je
                                        update plis..CM_Telata set CHOVATEL = @CHOVVAZ, DOVVYR = null, DATVYR = null
                                        where CISTELATA = @CISTELATA
                                        end
                                end
                        end

                    --------------------------------------------------------
                    -- zaznam o vazeni nastaveny ako spracovany
                    update VstupyPLIS.dbo.CP_HD15_DOKVAZ set
                                                             DATSPRAC = GETDATE(),
                                                             PRIZSPRAC = 2
                    where IDR = @IDR

                    -- zaznam o spracovani
                    insert into VstupyPLIS.dbo.CP_SPRAC_CHOVY_HLAS
                    SELECT
                        @IDR
                         ,'15'
                         ,@IDParChov
                         ,NULL AS ErrorMessage
                         ,NULL AS ErrorLine
                         ,NULL AS ErrorProcedure
                         ,NULL AS ErrorState

                end try
                begin catch
                    IF @@TRANCOUNT > 0
                        rollback tran dokvazml;

                    -- zaznam o spracovani s chybou
                    insert into VstupyPLIS.dbo.CP_SPRAC_CHOVY_HLAS
                    SELECT
                        @IDR
                         ,'15'
                         ,@IDParChov
                         ,LEFT(ERROR_MESSAGE(), 300) AS ErrorMessage
                         ,ERROR_LINE() AS ErrorLine
                         ,ERROR_PROCEDURE() AS ErrorProcedure
                         ,ERROR_STATE() AS ErrorState

                end catch;

                IF @@TRANCOUNT > 0
                    -- koniec transakcie
                    commit tran dokvazml

                FETCH NEXT
                    FROM db_cursor_dokvazml INTO
                    @IDR
                    ,@CHOVVAZ
                    ,@CISTELATA
                    ,@HMOT
                    ,@ZAVER
                    ,@DATVAZ
                    ,@TURNUS
        end

    CLOSE db_cursor_dokvazml
    DEALLOCATE db_cursor_dokvazml

    print 'vyradenie';

    -- vyradenie TMHD teliat chovu, ktorym neprislo vazenie uz 9 mesiacov
    if (dbo.HDchov_typ_KU(@parChov) = 'TMHD')
        UPDATE t
        SET t.DATVYR = GETDATE(),
            t.DOVVYR = 51, SPRACUPDATE = @IDParChov
        FROM CM_Telata AS t
        WHERE t.CHOVATEL = @parChov AND (DATEADD(MONTH, -9, GETDATE()) > (SELECT MAX(v.DATVAZ) FROM CM_Vazenia AS v WHERE v.CISTELATA = t.CISTELATA)) AND t.DOVVYR IS NULL
    ---------------------------------------------------------------

    insert into VstupyPLIS.dbo.CP_SPRAC_CHOVY_LOG
    SELECT
        @IDParChov
         ,'C_aktual_Dokvazml_aktualizacia ...OK'
END
go

