update plis..CC_ChybyKU set ZNCH_CT_INS = 2, ZNCH_CT_UPD = 2 where CISCHYBY = 111
insert into plis..CC_ChybyKU(CISCHYBY,TEXTCHYBY, ZNCH_CV_INS,ZNCH_CT_INS,ZNCH_CT_UPD) values (142,'Teľa nemá hlásené vyradenie',1,1,1)
go;
 -- =============================================
-- Author:		PSSR,š.p.
-- Create date: 18.11.2011
-- Description:	Zaradenie teliat mlieka - aktualizacia
-- Edit 22.06.2022: Priadnie zrusenie vyradenia telata v ML chove
-- =============================================
alter PROCEDURE [dbo].[C_aktual_Zarteliatml_aktualizacia] 
	@parChov varchar(9)

AS
BEGIN
	declare @IDR int
	declare @DATZAPIS [datetime] 
	declare @DATSPRAC [datetime]
	declare @SPRAC [bit] 
	declare @CHOVTEL [varchar](9) 
	declare @CISTEL [varchar](14) 
	declare @PORPREBLAK_ [varchar](2)
	declare @POHLTEL [varchar](2)
	declare @DATNAR [date]
	declare @OTECLIN [varchar](3),		@T_OTECLIN [varchar](3) 
	declare @OTECREG_ [varchar](3),		@T_OTECREG [int] 
	declare @OTEC [varchar](14),		@T_OTEC [varchar](14)
	declare @MATKA [varchar](14),		@T_MATKA [varchar](14)
	declare @PL1 [varchar](2)			
	declare @KR1 [decimal](6,2)
	declare @PL2 [varchar](2)
	declare @KR2 [decimal](5,2)
	declare @PL3 [varchar](2)
	declare @KR3 [decimal](5,2)
	declare @PL4 [varchar](2)
	declare @KR4 [decimal](5,2)
	declare @PL5 [varchar](2)
	declare @FARBA [varchar](2)
	declare @ZNAKET [bit] 
	declare @DI [varchar](1)
	
	declare @errorflag bit
	declare @navrat_hodn [varchar](1)	
	declare @OtecJeVCM_Byci [bit]
	declare @MatkaJeVCM_Krava [bit]
	declare @NajdenyOtecJeVCM_Byci [bit]
	declare @NajdenaMatkaJeVCM_Krava [bit]
	declare @PL1_POM [varchar](2)
	declare @IDTELATA int
		
	declare 
		@pov_PL1 [varchar](2),
		@pov_KR1 [decimal](5,2),
		@pov_PL2 [varchar](2),
		@pov_KR2 [decimal](5,2),
		@pov_PL3 [varchar](2),
		@pov_KR3 [decimal](5,2),
		@pov_PL4 [varchar](2),
		@pov_KR4 [decimal](5,2),
		@pov_PL5 [varchar](2)
		
	declare @MFARBA [varchar](2)
	declare @OFARBA [varchar](2)		
	DECLARE @sql_update nvarchar(2000)	
	declare @pom_IDBYKA int
	declare @pom_OUSCIS varchar(15)
	declare @pom_IDKRAVY int		
	declare @pom_TYPPLEM varchar(3)
	declare @operacia varchar(3)
	declare @PORPREBLAK int	
	declare @OTECREG int	
	declare @OT varchar (15), @povod varchar (1), @DobaNos int, @povod_ varchar(1), @DobaNos_ int, @MATKA_ [varchar](14), @_OTECLIN varchar(3), @_OTECREG int		
	declare @dupl int	
	declare @dvojca int
	declare @IdTelBezCis as table
	(	
		IDTELATA int,
		POHLAVIE varchar(2)
	)
	declare @pov_OTECLIN [varchar](3)
	declare @pov_OTECREG [varchar](3)
	declare @pov_OTEC [varchar](14)
	declare @exist_cistel int

	-- neznamy povod -- 20161026
	declare @OTECLINNEZ [varchar](3)
	declare @MATKANEZ [varchar](14)
	
  	declare @IDParChov bigint
    declare @JeTelaVTelatach bit

	-- ziskanie id spracovavaneho chovu
	SELECT @IDParChov = max(IDR) FROM VstupyPLIS.dbo.CP_SPRAC_CHOVY WHERE CHOV = @parChov	

	-- vyber doposial nespracovanych zaradeni 
	declare db_cursor_zarteliatml cursor
	FOR
	SELECT IDR
      ,CHOV
      ,CISTEL
      ,convert(int, nullif(PORPREBLAK, '')) as PORPREBLAK
      ,nullif(POHLTEL, '') as POHLTEL
      ,convert(date, nullif(DATNAR, ''), 104) as DATNAR
      ,nullif(OTECLIN, '')
      ,case when ISNUMERIC(OTECREG) = 1 then convert(int, OTECREG) else null end as OTECREG
	  ,nullif(OTEC, '') as OTEC
      ,nullif(MATKA, '')
      ,nullif(PL1, '')
      ,case when ISNUMERIC(KR1) = 0 then 0 else convert(decimal(6,2),replace(KR1,',','.')) end as KR1
      ,nullif(PL2, '')
      ,case when ISNUMERIC(KR2) = 0 then 0 else convert(decimal(5,2),replace(KR2,',','.')) end as KR2
      ,nullif(PL3, '')
      ,case when ISNUMERIC(KR3) = 0 then 0 else convert(decimal(5,2),replace(KR3,',','.')) end as KR3
      ,nullif(PL4, '')
      ,case when ISNUMERIC(KR4) = 0 then 0 else convert(decimal(5,2),replace(KR4,',','.')) end as KR4
      ,NULL as PL5 -- neprichadza zo zberaca
	  ,RIGHT('00'+nullif(FARBA, ''),2) --nullif(FARBA, '')
      ,nullif(ZNAKET, '')
      ,nullif(DI, '')
	FROM VstupyPLIS.dbo.CP_HD08_ZARTELIATML where PRIZSPRAC = 0 AND (CHOV = @parChov OR @parChov is NULL) 
	order by convert(date, nullif(DATNAR, ''), 104) -- 20170206
	
	OPEN db_cursor_zarteliatml

	-- cyklus cez vsetky nespracovane zaradenia teliat ML
	FETCH NEXT
	FROM db_cursor_zarteliatml INTO 	
		 @IDR
		,@CHOVTEL
		,@CISTEL
		,@PORPREBLAK_
		,@POHLTEL
		,@DATNAR
		,@OTECLIN
		,@OTECREG_
		,@OTEC
		,@MATKA
		,@PL1
		,@KR1
		,@PL2
		,@KR2
		,@PL3
		,@KR3
		,@PL4
		,@KR4
		,@PL5
		,@FARBA
		,@ZNAKET
		,@DI
	
	WHILE @@FETCH_STATUS = 0
	begin
		-- zaznam v tabulke zaradeni nastaveny ako "v spracovani"
		update VstupyPLIS.dbo.CP_HD08_ZARTELIATML set
			DATSPRAC = GETDATE(),
			PRIZSPRAC = 1
			where IDR = @IDR	

	    --zaciatok transakcie
		begin tran zarteliatml
   		begin try
            set @JeTelaVTelatach = 1
			set @OtecJeVCM_Byci = (select 0)
			set @MatkaJeVCM_Krava = (select 0)
			set @NajdenyOtecJeVCM_Byci = (select 0)
			set @NajdenaMatkaJeVCM_Krava = (select 0)
			set @errorflag = (select 0)		
			set @dupl = 0	
			set @dvojca = 0	
			set @OT = null
			set @povod = null
			set @DobaNos = null
			set @pov_OTECLIN = null
			set @pov_OTECREG = null
			set @pov_OTEC = null
			-- neznamy povod -- 20161026
			set @OTECLINNEZ = null
			set @MATKANEZ = null
			set @OFARBA = null
			set @MFARBA = null    
				
			-- OPRAVA dat zo vstupu -------------------------------
			-- oprava podielu krvi cistokrvnych zvierat (0 -> 100)
			if (@KR1 = 0 and @PL1 is not null)
				set @KR1 = 100
				
			-- ak su podiely krvi zadane v desatinach %
			if (@KR1 + @KR2 + @KR3 + @KR4) > 990
			begin
				set @KR1 = @KR1/10
				set @KR2 = @KR2/10
				set @KR3 = @KR3/10
				set @KR4 = @KR4/10
			end	

			-- oprava podielov krvi  (0 -> null)
			if (@KR1 = 0)
				set @KR1 = (select null)
			if (@KR2 = 0)
				set @KR2 = (select null)
			if (@KR3 = 0)
				set @KR3 = (select null)
			if (@KR4 = 0)
				set @KR4 = (select null)
			

			-- zarovnanie plemena
			set @PL1 = LTRIM(@PL1)
			set @PL2 = LTRIM(@PL2)
			set @PL3 = LTRIM(@PL3)
			set @PL4 = LTRIM(@PL4)
			set @PL5 = LTRIM(@PL5)
			
			-- zarovnanie linie otca
			set @OTECLIN = LTRIM(@OTECLIN)

			-- zmena registra otca na cislo
			set @OTECREG = CONVERT(int, @OTECREG_)
			if @OTECREG = 0
				set @OTECREG = NULL
			
			-- znulovanie neznamych linii otcov 
			if UPPER(@OTECLIN) = 'IL' or UPPER(@OTECLIN) = 'NEZ' or @OTECLIN = '997' or @OTECLIN is null
			begin
				-- neznamy povod -- 20161026
				if UPPER(@OTECLIN) = 'NEZ' 
					set @OTECLINNEZ = UPPER(@OTECLIN)
				else
					set @OTECLIN = null

				set @OTECREG = null
			end
				
			if @MATKA = 'SK999999999999'
			begin
				-- neznamy povod -- 20161026
				set @MATKANEZ = @MATKA

				--set @MATKA = null
			end

			-- 20161109
			if @MATKA = 'SK888888888888'
			begin
				set @MATKA = null
			end
			
			-- zmena poradia prebiehajucej laktacie na cislo
			set @PORPREBLAK = CONVERT(int, @PORPREBLAK_)
			if @PORPREBLAK = 0
				set @PORPREBLAK = NULL
				
			-- nahrada prazdnej CISLOZV na NULL
			if @CISTEL = 'SK000000000000'
				set @CISTEL = NULL				
			
			if (@PL1 is not null)	
			begin
				set @povod = 4
				set @DobaNos = 0
			end	

			set @POHLTEL = right('00'+ rtrim(@POHLTEL), 2)
			if @POHLTEL = '00' or @POHLTEL = '**'
				set @POHLTEL = null

			delete from @IdTelBezCis

			set @IDTELATA = null
			set @_OTECLIN = null
			set @_OTECREG = null

			set	@pov_PL1 = null
			set	@pov_KR1 = null
			set	@pov_PL2 = null
			set	@pov_KR2 = null
			set	@pov_PL3 = null
			set	@pov_KR3 = null
			set	@pov_PL4 = null
			set	@pov_KR4 = null
			set	@pov_PL5 = null
			set @exist_cistel = 0

			set @T_MATKA =	@MATKA 
			set @T_OTECLIN = @OTECLIN 
			set @T_OTECREG = @OTECREG 
			set @T_OTEC = @OTEC

			-------------------------------------------------------						
			
			if (@DI = '1') or (@DI = '2')
			begin
				if (@DI = '2')
					set @operacia = 'UPD'
				else	
					set @operacia = 'INS'
					
				-- kontrola: je tela s danym cislom uz v CM_Telata
				if (@DI = '1')			
				begin
					exec @dupl = PLIS.dbo.C_aktual_zisti_dupl_tela  @MATKA, @DATNAR, @CISTEL, @POHLTEL 
					if @dupl = 1
					begin
						-- ak ma ist o doplnenie cisla telata (a dalsich udajov) telatu bez cisla - spracuje sa ako update (aj cisla zvierata)
						insert into @IdTelBezCis
						select IDTELATA, POHLAVIE from plis.dbo.CM_Telata where MATKA = @MATKA and DATNAR = @DATNAR and CISTELATA is null

						if (select count(*) from @IdTelBezCis) = 1
						begin
							set @IDTELATA = (select IDTELATA from @IdTelBezCis)
						end
						else 
						begin
							if (select count(*) from @IdTelBezCis) > 1
								set @IDTELATA = (select top(1) IDTELATA from @IdTelBezCis where POHLAVIE = @POHLTEL)
						end

						-- kontrola, ci uz tela s danym cislom existuje -- 2016-07-06
						if (@CISTEL is not null)
						begin
							if (select count(*) from CM_Telata where CISTELATA = @CISTEL) > 0
								set @exist_cistel = 1
						end
						
						if (@IDTELATA is not null and @exist_cistel = 0)
						--if @IDTELATA is not null -- 2016-07-06
						begin
							set @DI = '2'
							set @operacia = 'UPD'
						end
						else
						begin
							-- priradenie chyby 43
							exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 43, @operacia
							if (@navrat_hodn = '2')
							begin
								set @errorflag = (select 1)
							end	
						end
					end
					else
					begin
						-- zistenie ci ide o dvojca -- 20170206
						exec @dvojca = plis.dbo.C_aktual_zisti_tela_dvojca  @MATKA, @DATNAR, @CISTEL, @POHLTEL
					end
				end
				else
				if (@DI = '2')
				begin
					select @IDTELATA = IDTELATA from PLIS.dbo.CM_Telata where (CISTELATA = @CISTEL)
					if @IDTELATA is null
						select top(1) @IDTELATA = IDTELATA from plis.dbo.CM_Telata where MATKA = @MATKA and DATNAR = @DATNAR and POHLAVIE = @POHLTEL

					if (select COUNT(*) from PLIS.dbo.CM_Telata where (IDTELATA = @IDTELATA)) = 0
					begin
						-- priradenie chyby 111
						exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 111, @operacia
						if (@navrat_hodn = '2')
						begin
							set @errorflag = (select 1)
						end	
					end	
					else
					--if (SELECT CHOVATEL FROM PLIS.dbo.CM_Telata WHERE IDTELATA = @IDTELATA) != @CHOVTEL
					-- kontrola na rozdielny chov len v pripade ak ide o inu KU v zmysle ML, MP (ML a TMHD sa nerozlisi)
					if ((SELECT CHOVATEL FROM PLIS.dbo.CM_Telata WHERE IDTELATA = @IDTELATA) != @CHOVTEL) 
						and not((plis.dbo.HDchov_typ_KU((SELECT CHOVATEL FROM PLIS.dbo.CM_Telata WHERE IDTELATA = @IDTELATA)) in ('ML', 'TMHD')) and (plis.dbo.HDchov_typ_KU(@CHOVTEL) in ('ML', 'TMHD')))
					begin
						-- priradenie chyby 64 (tela je z ineho chovu)
						exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 64, @operacia
						if (@navrat_hodn = '2')
						begin
							set @errorflag = (select 1)
						end	
					end											
				end		
				
				-- kontrola: chov je v menovke
				if (select COUNT(*) from PLIS.dbo.NM_HDDETAIL where (KRAJ+OKRES+PODNIK+CHOV = @CHOVTEL)) = 0
				begin
					-- priradenie chyby 04
					exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 4, @operacia
					if (@navrat_hodn = '2')
					begin
						set @errorflag = (select 1)
					end else
					if (@navrat_hodn = '1')
					begin
						set @CHOVTEL = (select null)
					end
				end			
				
				/*if not((@DI = '2') and (@PORPREBLAK is null))
					-- kontrola: pre kravu v KU neexistuje laktacia s danym poradim 
					if (select COUNT(*) from plis.dbo.CM_Laktacie where CISKRAVY = @MATKA and PORLAK = @PORPREBLAK) = 0 and 
						(select COUNT(*) from plis.dbo.CM_Naplak where CISKRAVY = @MATKA and PORLAK = @PORPREBLAK) = 0*/
					if (((select isnull(PORPREBLAK, 0) from plis.dbo.CM_Krava where CISKRAVY = @MATKA) >= isnull(@PORPREBLAK, 0))
					      and (@MATKA in (select MATKA from CM_Telata where MATKA = @MATKA and DATNAR = @DATNAR and not(pohlavie in ('11','22','31','32','41','42','26','51','52')) ))  and (@DI = '1'))
					-- pre @DI = '2' kontola odpada
					begin
						-- priradenie chyby 44
						exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 44, @operacia
						if (@navrat_hodn = '2')
						begin
							set @errorflag = (select 1)
						end else
						if (@navrat_hodn = '1') 
						begin
							set @PORPREBLAK = null
						end
					end	
				
				if not((@DI = '2') and (@POHLTEL is null))
					-- kontrola: Nesprávny kód pohlavia teľaťa 
					if (@POHLTEL not in (select KOD from plis.dbo.CC_Pohlavie)) or (@POHLTEL is null)
					begin
						-- priradenie chyby 25
						exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 25, @operacia
						if (@navrat_hodn = '2')
						begin
							set @errorflag = (select 1)
						end else
						if (@navrat_hodn = '1')
						begin
							set @POHLTEL = null
						end
					end				
				
				if not((@DI = '2') and (@DATNAR is null))
					-- kontrola: platny datum narodenia
					if (@DATNAR is null)
					begin
						-- priradenie chyby 12
						exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 12, @operacia
						if (@navrat_hodn = '2')
						begin
							set @errorflag = (select 1)
						end
					end			
					else
					begin
						if (select datediff(day, @DATNAR, GETDATE())) < 0
						begin
							-- priradenie chyby 12
							exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 12, @operacia
							if (@navrat_hodn = '2')
							begin
								set @errorflag = (select 1)
							end else
							if (@navrat_hodn = '1')
							begin
								set @DATNAR = null
							end
						end							
					end

				-- kontrola: otec nie je uvedeny
				if ((@OTECLIN is null or @OTECREG is null) and @OTEC is null) and (@DI = '1')
				--if (@OTECLIN is null or @OTECREG is null) and (@DI = '1')
				begin
					-- priradenie chyby 90
					exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 90, @operacia
					if (@navrat_hodn = '2')
					begin
						set @errorflag = (select 1)
					end	
				end		
				if (@OTECLIN is not null and @OTECREG is not null or @OTEC is not null)	
				begin	
					-- kontrola: otec nie je v CM_Byci
					--if (select COUNT(*) from PLIS.dbo.CM_Byci where (LIN = @OTECLIN and REG = @OTECREG)) = 0
				if (select COUNT(*) from PLIS.dbo.CM_Byci where (LIN = @OTECLIN and REG = @OTECREG or USCISLO = @OTEC and @OTEC is not null)) = 0
				begin
					-- priradenie chyby 07
					exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 7, @operacia
					if (@navrat_hodn = '2')
					begin
						set @errorflag = (select 1)
					end else
					if (@navrat_hodn = '1')
					begin
						set @OTECLIN = (select null)
						set @OTECREG = (select null)
						set @OTEC = null
					end	
				end	
				else
				begin
					set @OtecJeVCM_Byci = (select 1)
					end
				end
					
				-- kontrola: matka nie je uvedena
				if (@MATKA is null)
				begin
					-- priradenie chyby 91
					exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 91, @operacia
					if (@navrat_hodn = '2')
					begin
						set @errorflag = (select 1)
					end
				end	
				else
				begin								
					-- kontrola: matka nie je v CM_Krava
					if (select COUNT(*) from PLIS.dbo.CM_Krava where (CISKRAVY = @MATKA)) = 0
					begin
						-- priradenie chyby 06
						exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 6, @operacia
						if (@navrat_hodn = '2')
						begin
							set @errorflag = (select 1)
						end else
						if (@navrat_hodn = '1')
						begin
							set @MATKA = (select null)
						end	
					end	
					else
					begin
						set @MatkaJeVCM_Krava = (select 1)
					end								
				end	
				
				-- kontrola: chybny podiel krvi plemien a pripadny prepocet plemien
					
				--if ((@OtecJeVCM_Byci = 1 or @NajdenyOtecJeVCM_Byci = 1) and (@MatkaJeVCM_Krava = 1 or @NajdenaMatkaJeVCM_Krava = 1))
				--begin
				--	-- ak je povod ne-preukazny a hlasil plemennu skladbu - zober ju
				--	if not(@povod in ('2','3','5') and @PL1 is not null)
				--	begin
				--		select  @PL1 = PL1, @KR1 = KR1, @PL2 = PL2, @KR2 = KR2, @PL3 = PL3, @KR3 = KR3, @PL4 = PL4, @KR4 = KR4, @PL5 = PL5 from C_aktual_plem_potomok_funkcia (@OTEC, @MATKA, null)
				--	end
				--	else
				--	begin
				--		set @OTEC = @pov_OTEC
				--		set @OTECLIN = @pov_OTECLIN
				--		set @OTECREG = @pov_OTECREG
				--		set @povod = 4
				--		set @DobaNos = 0
				--	end
				--end
				--else
				if (@PL1 is not null)
				begin
					-- kontrola: chybny kod plemena
					set @PL1_POM = (select @PL1)
					if not((@PL1 is null or @PL1 in (select kodpl from PLIS.dbo.CC_Plemena))
					and (@PL2 is null or @PL2 in (select kodpl from PLIS.dbo.CC_Plemena))
					and (@PL3 is null or @PL3 in (select kodpl from PLIS.dbo.CC_Plemena))
					and (@PL4 is null or @PL4 in (select kodpl from PLIS.dbo.CC_Plemena))
					and (@PL5 is null or @PL5 in (select kodpl from PLIS.dbo.CC_Plemena)))		
					begin
						-- priradenie chyby 10
						exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 10, @operacia
						if (@navrat_hodn = '2')
						begin
							set @errorflag = (select 1)
						end else
						if (@navrat_hodn = '1')
						begin
							set @PL1_POM = (select null)
						end	
					end		
					
					if not (
					(
					((@PL1 is not null and @KR1 is not null) and (@PL2 is null and @KR2 is null) and (@PL3 is null and @KR3 is null) and (@PL4 is null and @KR4 is null) and (@PL5 is null) and (@KR1 = 100)) or 

					((@PL1 is not null and @KR1 is not null) and (@PL2 is not null and @KR2 is not null) and (@PL3 is null and @KR3 is null) and (@PL4 is null and @KR4 is null) and (@PL5 is null) and (ISNULL(@KR1, 0) + ISNULL(@KR2, 0) = 100)) or 
												
					((@PL1 is not null and @KR1 is not null) and (@PL2 is not null and @KR2 is not null) and (@PL3 is not null and @KR3 is not null) and (@PL4 is null and @KR4 is null) and (@PL5 is null) and (ISNULL(@KR1, 0) + ISNULL(@KR2, 0) + ISNULL(@KR3, 0) = 100)) or 		
								
					((@PL1 is not null and @KR1 is not null) and (@PL2 is not null and @KR2 is not null) and (@PL3 is not null and @KR3 is not null) and (@PL4 is not null and @KR4 is not null) and (@PL5 is null) and (ISNULL(@KR1, 0) + ISNULL(@KR2, 0) + ISNULL(@KR3, 0) + ISNULL(@KR4, 0) = 100)) or 
																	
					((@PL1 is not null and @KR1 is not null) and (@PL2 is not null and @KR2 is not null) and (@PL3 is not null and @KR3 is not null) and (@PL4 is not null and @KR4 is not null) and (@PL5 is not null) and (ISNULL(@KR1, 0) + ISNULL(@KR2, 0) + ISNULL(@KR3, 0) + ISNULL(@KR4, 0) <= 100))
					)	
					and
						(ISNULL(@KR1, 0) >= ISNULL(@KR2, 0)) and (ISNULL(@KR2, 0) >= ISNULL(@KR3, 0)) and (ISNULL(@KR3, 0) >= ISNULL(@KR4, 0)) and (100 - (ISNULL(@KR1, 0) + ISNULL(@KR2, 0) + ISNULL(@KR3, 0) + ISNULL(@KR4, 0)) <= ISNULL(@KR4, 0))
					)					
					begin
						-- priradenie chyby 11
						exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 11, @operacia
						if (@navrat_hodn = '2')
						begin
							set @errorflag = (select 1)
						end else
						if (@navrat_hodn = '1')
						begin
							set @PL1_POM = (select null)
						end	
					end	
					set @PL1 = @PL1_POM
				end
			
				--pri zruseni vyradenia telata (druh informacie 5) netreba kontrolovat farbu
				if not((@DI = '2') and (@FARBA is null)) and (@DI <> '5')
					-- kontrola: nespravny kod farby
					if (select COUNT(*) from PLIS.dbo.CC_Farby where (KODF = @FARBA)) = 0
					begin
						-- priradenie chyby 13
						exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 13, @operacia
						if (@navrat_hodn = '2')
						begin
							set @errorflag = (select 1)
						end else
						if (@navrat_hodn = '1')
						begin
							set @FARBA = (select null)
						end	
					end		
				
				-- kontrola: nespravne oznacenie ET
				if @ZNAKET > 1 
				begin
					-- priradenie chyby 45
					exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 45, @operacia
					if (@navrat_hodn = '2')
					begin
						set @errorflag = (select 1)
					end else
					if (@navrat_hodn = '1')
					begin
						set @ZNAKET = (select null)
					end	
				end

				if(@DI = 5 )
				    begin
				        --je tela v telatach
                        if ((select COUNT(*) from PLIS.dbo.CM_Telata where (CISTELATA = @CISTEL)) = 0 and @CISTEL != 'SK999999999999')
                            begin
                                -- priradenie chyby 111
                                exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 111, @operacia
                                if (@navrat_hodn = '2')
                                    begin
                                        set @errorflag = (select 1)
                                    end
                                set @JeTelaVTelatach = 0
                            end

				        --kontrola ci ma tela hlasene vyradenie
				        if(@JeTelaVTelatach = 1 and ((select COUNT(*) from PLIS.dbo.CM_Telata where CISTELATA = @CISTEL and DATVYR is null) = 1))
				            begin
                                exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 142, @operacia
                                if (@navrat_hodn = '2')
                                    begin
                                        set @errorflag = (select 1)
                                    end
                            end

                        -- ak je z telata uz krava alebo byk tak chyba
                        if((select (select count(*) from plis..CM_Krava where CISKRAVY = @CISTEL)+
                                   (select count(*)  from plis..CM_Byci where USCISLO = @CISTEL)) > 0)
                            begin
                                exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 140, @operacia
                                if (@navrat_hodn = '2')
                                    begin
                                        set @errorflag = (select 1)
                                    end
                            end
                    end

				-- neboli chyby typu 2			
				if (@errorflag != 1)		
				begin
					-- zaradenie telata
					if (@DI = '1') 
					begin	
						-- znulovanie plemena ak nebolo spravne zadane
						-- urcenie povodu -- 20161110
						if (@DATNAR is not null and @POHLTEL is not null)
							exec PLIS.dbo.C_aktual_zisti_povod_telata @MATKA, @DATNAR, @POHLTEL, @OT output, @povod output, @DobaNos output
						if (@OT is not null) 
						begin
							select @T_OTEC = USCISLO, @T_OTECLIN = LIN, @T_OTECREG = REG from CM_Byci where IDBYKA = @OT	
						end	

						if (@povod != '1')
						begin
							if (@OTECLIN is not null )
								set @T_OTEC = dbo.C_aktual_zisti_USCISBYKA(@OTECLIN, @OTECREG)	
							else							
							begin
								select @T_OTECLIN = LIN, @T_OTECREG = REG from PLIS.dbo.CM_Byci where USCISLO = @OTEC 
							end 
							set @povod = 4
							set @DobaNos = 0						
						end

						-- spustat prepocet plemena okrem pripadu, ked nie je znamy ote ani matka a plemeno je zadane --20161109
						if not ((@PL1 is not null) and ((dbo.C_aktual_zisti_IDBYKA(@T_OTECLIN, @T_OTECREG, @T_OTEC) is null) and (dbo.C_aktual_zisti_IDKRAVY(@T_MATKA) is null)))
							or (@PL1 is null)
						begin
							-- ak je povod ne-preukazny a hlasil plemennu skladbu - zober ju
							if not(@povod in ('2','3','5') and @PL1 is not null)
							begin
								select  @PL1 = PL1, @KR1 = KR1, @PL2 = PL2, @KR2 = KR2, @PL3 = PL3, @KR3 = KR3, @PL4 = PL4, @KR4 = KR4, @PL5 = PL5 from C_aktual_plem_potomok_funkcia (@T_OTEC, @T_MATKA, null)
							end
							else
							begin
								set @T_OTEC = @OTEC
								set @T_OTECLIN = @OTECLIN
								set @T_OTECREG = @OTECREG
								set @povod = 4
								set @DobaNos = 0
							end
						end
								
						if (@PL1 is NULL)
						begin
							select @KR1 = NULL, @PL2 = NULL, @KR2 = NULL, @PL3 = NULL, @KR3 = NULL, @PL4 = NULL, @KR4 = NULL, @PL5 = NULL
						end			
						-- neznamy povod -- 20161026		
						--if @OTECLIN is null and @OTEC is null and @OTECLINNEZ is not null
						--	set @OTECLIN = @OTECLINNEZ
								
						-- zviera s usnym cislom je v subore teliat
					INSERT INTO [PLIS].[dbo].[CM_Telata]
								([CISTELATA],[CHOVNAR],[OTECLIN],[OTECREG]
								,[OUC],[MATKA],[HMOTOT],[DATNAR],[HMOTNAR]
								,[PL1],[KR1],[PL2],[KR2],[PL3],[KR3],[PL4],[KR4],[PL5],[TYPPLEM]
								,[FARBA],[PORLAK],[POHLAVIE],[ZNAKET]
								,[PREUKAZ],[DOBANOS],[CHOVATEL],[PRIEBPOR],[URCTEL],[PRICOBTPOR],[PRICUHYN]
								,[DOVVYR],[DATVYR],[PRIZNAKKU],[IDMA]
								,[IDOT], SPRACINSERT, SPRACUPDATE)	
							values (@CISTEL, @CHOVTEL, @T_OTECLIN, @T_OTECREG
								,isnull(dbo.C_aktual_zisti_USCISBYKA(@T_OTECLIN, @T_OTECREG), @T_OTEC), @T_MATKA, null, @DATNAR, 30
								,@PL1, @KR1, @PL2, @KR2, @PL3, @KR3, @PL4, @KR4, @PL5, 
								PLIS.dbo.C_aktual_zisti_plemenny_typ(@PL1, @KR1, @PL2, @KR2, @PL3, @KR3, @PL4, @KR4, @PL5,@FARBA)
								,@FARBA, @PORPREBLAK, @POHLTEL, @ZNAKET
								,@povod, @DobaNos, @CHOVTEL, null, null, null, null
								,null, null, '1', PLIS.dbo.C_aktual_zisti_IDKRAVY(@T_MATKA)
								,PLIS.dbo.C_aktual_zisti_IDBYKA(@T_OTECLIN, @T_OTECREG, null), @IDParChov, @IDParChov)			
						end
					
					-- oprava 
					else if (@DI = '2')	
					begin
						-- urcenie povodu -- 20161110
						select @T_OTECLIN = OTECLIN, @T_OTECREG = OTECREG, @T_OTEC = OUC, @T_MATKA = MATKA from PLIS.dbo.CM_Telata where IDTELATA = @IDTELATA
						if (@T_OTEC is null)
							select @T_OTEC = USCISLO from PLIS.dbo.CM_Byci where @T_OTECLIN = LIN and @T_OTECREG = REG
					
						if (@OTECLIN is not null) 
						begin
							set @T_OTECLIN = @OTECLIN
							set @T_OTECREG = @OTECREG 
							set @T_OTEC = dbo.C_aktual_zisti_USCISBYKA(@OTECLIN, @OTECREG)
						
							set @povod = 4
							set @DobaNos = 0	
						end
						else if (@OTEC is not null)
							begin
								set @T_OTEC = @OTEC
								select @T_OTECLIN = LIN, @T_OTECREG = REG from PLIS.dbo.CM_Byci where USCISLO = @OTEC  

								set @povod = 4
								set @DobaNos = 0	
							end
					
						if (@MATKA is not null)
						begin
							set @T_MATKA = @MATKA

							set @povod = 4
							set @DobaNos = 0	
						end
						
								            -- prepocet farby telata ak sa opravovala alebo nahlasovala matka alebo otec 

						if ((@MATKA is not null and @farba is null) or (@OTECLIN is not null and @farba is null) or (@OTEC is not null and @farba is null) )

                       begin 
                             if @Matka is not null 
		                        begin  
                                  select @MFARBA = FARBA from PLIS.dbo.CM_Krava where (CISKRAVY = @MATKA)
		                        end

                            if @Matka is null and (@OTECLIN is not null or @OTEC is not null)
                    		     begin
			                       select @POM_IDKRAVY = IDMA from PLIS.dbo.CM_Telata where (CISTELATA = @CISTEL)
				                   select @MFARBA = FARBA from PLIS.dbo.CM_Krava where (IDKRAVY = @POM_IDKRAVY)
			                     end
                           if (@OTECLIN is not null and @OTECREG is not null or @OTEC is not null)
		                         begin
			                       select @OFARBA = FARBA from PLIS.dbo.CM_BYCI where (LIN = @OTECLIN and REG = @OTECREG or USCISLO = @OTEC and @OTEC is not null)
			                     end
                           if @Matka is not null and (@OTECLIN is null and  @OTEC is  null)
		                         begin
			                       select @POM_IDBYKA = IDOT from PLIS.dbo.CM_Telata where (CISTELATA = @CISTEL)
				                   select @OFARBA = FARBA from PLIS.dbo.CM_BYCI where (IDBYKA = @POM_IDBYKA)
	                       		 end
	   	
		  
                           if (@MFarba is null) or (@OFarba is null) 
								begin
									set @Farba = null
								end
								else
								begin
									-- zistenie farby telata
									if @MFarba < @OFarba
										set @Farba = @MFarba
									else
										set @Farba = @OFarba
		                       end

                       end
						
						-- prepocet plemena okrem pripadu, ze nie je znamy aspon jeden rodic a je zadane plemeno -- 20161108
						if not(((dbo.C_aktual_zisti_IDBYKA(@T_OTECLIN, @T_OTECREG, @T_OTEC) is null) or (dbo.C_aktual_zisti_IDKRAVY(@T_MATKA) is null)) and (@PL1 is not null))
							or (@PL1 is null)
						begin
							-- ak je povod ne-preukazny a hlasil plemennu skladbu - zober ju
							if not(@povod in ('2','3','5') and @PL1 is not null)
							begin
								select  @PL1 = PL1, @KR1 = KR1, @PL2 = PL2, @KR2 = KR2, @PL3 = PL3, @KR3 = KR3, @PL4 = PL4, @KR4 = KR4, @PL5 = PL5 from C_aktual_plem_potomok_funkcia (@T_OTEC, @T_MATKA, null)
							end
							else
							begin
								set @T_OTEC = @OTEC
								set @T_OTECLIN = @OTECLIN
								set @T_OTECREG = @OTECREG
								set @povod = 4
								set @DobaNos = 0
							end
						end
					
							
						-- ak nedoslo k zmene v plemennej skladbe (po hlaseni alebo vypocte) neprepisuj povod
						select @pov_PL1 = PL1,@pov_KR1 = KR1, @pov_PL2 = PL2, @pov_KR2 = KR2, @pov_PL3 = PL3, @pov_KR3 = KR3, @pov_PL4 = PL4, @pov_KR4 = KR4, @pov_PL5 = PL5 from PLIS.dbo.CM_Telata where IDTELATA = @IDTELATA
						if (@pov_PL1 = @PL1 and isnull(@pov_KR1,0) = isnull(@KR1,0) and 
							isnull(@pov_PL2,0) = isnull(@PL2,0) and isnull(@pov_KR2,0) = isnull(@KR2,0) and 
							isnull(@pov_PL3,0) = isnull(@PL3,0) and isnull(@pov_KR3,0) = isnull(@KR3,0) and 
							isnull(@pov_PL4,0) = isnull(@PL4,0) and isnull(@pov_KR4,0) = isnull(@KR4,0) and 
							isnull(@pov_PL5,0) = isnull(@PL5,0) and @PL1 is not null) 
						begin
							set @PL1 = null
							set @povod = 4
							set @DobaNos = 0
						end


						-- vytvorenie dynamickeho update prikazu
						set @sql_update = ''
						if @CISTEL is not null
							set @sql_update = @sql_update + 'CISTELATA = ''' + @CISTEL + ''', '		
--						if @CHOVTEL is not null kobrtkova 2017/09/25
--							set @sql_update = @sql_update + 'CHOVATEL = ''' + @CHOVTEL + ''', '						
						if @PORPREBLAK is not null
							set @sql_update = @sql_update + 'PORLAK = ' + convert(varchar, @PORPREBLAK) + ', '			
						if @POHLTEL is not null
							set @sql_update = @sql_update + 'POHLAVIE = ''' + @POHLTEL + ''', '					

						-- neznamy povod -- 20161026
						if @OTECLINNEZ is not null
						begin				
							set @sql_update = @sql_update + 'OTECLIN = ''' + @OTECLINNEZ + ''', OTECREG = NULL, OUC = NULL, IDOT = NULL, '
						end
						else
						if (@OTEC is not null and dbo.C_aktual_zisti_IDBYKA(@OTECLIN, @OTECREG, @OTEC) is null)
						begin				
							set @sql_update = @sql_update + 'OTECLIN = NULL, OTECREG = NULL, OUC = ''' + @OTEC + ''', IDOT = NULL, '
						end
						else
						--------------
						if (@OTEC is not null and dbo.C_aktual_zisti_IDBYKA(null, null, @OTEC) is not null and @OTECLIN is null)
						begin		
							if @T_OTECLIN is not null
								set @sql_update = @sql_update + 'OTECLIN = ''' + @T_OTECLIN + ''', OTECREG = ' + isnull(convert(varchar, @T_OTECREG), 'NULL') + ', '
							else
								set @sql_update = @sql_update + 'OTECLIN = NULL, OTECREG = NULL, '
							set @sql_update = @sql_update + 'OUC = ''' + @OTEC + ''', IDOT = ' + convert(varchar, dbo.C_aktual_zisti_IDBYKA(null, null, @OTEC)) + ', '
						end
						else
						--------------
						begin											

							if @T_OTECLIN is not null
								set @sql_update = @sql_update + 'OTECLIN = ''' + @T_OTECLIN + ''', '
							if @T_OTECREG is not null						   
								set @sql_update = @sql_update + 'OTECREG = ' + convert(varchar, @T_OTECREG) + ', '	
							if @T_OTECLIN is not null and @T_OTECREG is not null
							begin
								set @pom_IDBYKA = PLIS.dbo.C_aktual_zisti_IDBYKA(@T_OTECLIN, @T_OTECREG, null)
								if @pom_IDBYKA is not null
									set @sql_update = @sql_update + 'IDOT = ' + convert(varchar, @pom_IDBYKA) + ', '
								set @pom_OUSCIS = PLIS.dbo.C_aktual_zisti_USCISBYKA(@T_OTECLIN, @T_OTECREG)
								if @pom_OUSCIS is not null
									set @sql_update = @sql_update + 'OUC = ''' + @pom_OUSCIS + ''', '							
							end			
						end
						-- neznamy povod -- 20161026
						if (@MATKA is not null and dbo.C_aktual_zisti_IDKRAVY(@MATKA) is null)
						begin				
							set @sql_update = @sql_update + 'MATKA = ''' + @MATKA + ''', IDMA = NULL, '
						end
						else
						begin										
							if @T_MATKA is not null
							begin
								set @sql_update = @sql_update + 'MATKA = ''' + @T_MATKA + ''', '	
								set @pom_IDKRAVY = PLIS.dbo.C_aktual_zisti_IDKRAVY(@T_MATKA)
								if @pom_IDKRAVY is not null
									set @sql_update = @sql_update + 'IDMA = ' + convert(varchar, @pom_IDKRAVY) + ', '						
							end				
						end						
						if @DATNAR is not null
							set @sql_update = @sql_update + 'DATNAR = ''' + convert(varchar, @DATNAR) + ''', '
							
						if @PL1 is not null
						begin
							set @sql_update = @sql_update + 'PL1 = ''' + @PL1 + ''', KR1 = ' + convert(varchar, @KR1) + ', ' 
							if @PL2 is not null
								set @sql_update = @sql_update + 'PL2 = ''' + @PL2 + ''', KR2 = ' + convert(varchar, @KR2) + ', ' 
							else
								set @sql_update = @sql_update + 'PL2 = NULL, KR2 = NULL, ' 
							if @PL3 is not null
								set @sql_update = @sql_update + 'PL3 = ''' + @PL3 + ''', KR3 = ' + convert(varchar, @KR3) + ', ' 
							else
								set @sql_update = @sql_update + 'PL3 = NULL, KR3 = NULL, ' 							
							if @PL4 is not null
								set @sql_update = @sql_update + 'PL4 = ''' + @PL4 + ''', KR4 = ' + convert(varchar, @KR4) + ', ' 
							else
								set @sql_update = @sql_update + 'PL4 = NULL, KR4 = NULL, ' 							
							if @PL5 is not null
								set @sql_update = @sql_update + 'PL5 = ''' + @PL5 + ''', '
							else
								set @sql_update = @sql_update + 'PL5 = NULL, ' 
															
							set @pom_TYPPLEM = PLIS.dbo.C_aktual_zisti_plemenny_typ(@PL1, @KR1, @PL2, @KR2, @PL3, @KR3, @PL4, @KR4, @PL5, @FARBA)
							if @pom_TYPPLEM is not NULL				
								set @sql_update = @sql_update + 'TYPPLEM = ''' + @pom_TYPPLEM + ''', '													
						end
						if @FARBA is not null
							set @sql_update = @sql_update + 'FARBA = ''' + @FARBA + ''', '					
						if @povod is not null
							set @sql_update = @sql_update + 'PREUKAZ = ''' + @povod + ''', '	
						if @DobaNos is not null
							set @sql_update = @sql_update + 'DOBANOS = ' + convert(varchar, @DobaNos) + ', '						
						if @ZNAKET is not null
							set @sql_update = @sql_update + 'ZNAKET = ' + convert(varchar, @ZNAKET) + ', '
						if @sql_update != ''
						begin
							set @sql_update = @sql_update + 'PRIZNAKKU = ''1'', SPRACUPDATE = ' + convert(varchar, @IDParChov) + ' '					
							set @sql_update = @sql_update + 'where IDTELATA = ' + convert(varchar, @IDTELATA) + ''	
							set @sql_update = 'update PLIS.dbo.CM_Telata set ' + @sql_update
							exec (@sql_update)
						end   						
					end 
				end			
			end
			else 
			-- mazanie zaznamu o telati
			if (@DI = '3')
			begin
				if @CISTEL is not null 
				begin
					delete from CM_Telata where CISTELATA = @CISTEL
					delete from CM_Vazenia where CISTELATA = @CISTEL
				end
				else
					if @MATKA is not null and @DATNAR is not null
						delete from CM_Telata where MATKA = @MATKA and DATNAR = @DATNAR
			end
			else
			-- iny typ informacie
			begin
				-- priradenie chyby 99
				exec @navrat_hodn = plis.[dbo].[C_aktual_Zarteliatml_zapis_chybu] @IDR, 99, 'INS'
			end
            
            --zrusenie vyradenie telata
            if(@DI = '5')
                begin
                    update CM_Telata set DATVYR = null, DOVVYR = null where CISTELATA = @CISTEL
                end

			-- zaznam v kontajneri zaradeni nastaveny ako spracovany
			update VstupyPLIS.dbo.CP_HD08_ZARTELIATML set
				DATSPRAC = GETDATE(),
				PRIZSPRAC = 2
				where IDR = @IDR		
			
      			-- zaznam o spracovani
			insert into VstupyPLIS.dbo.CP_SPRAC_CHOVY_HLAS
			SELECT 
				@IDR
				,'8'
				,@IDParChov
				,NULL AS ErrorMessage
				,NULL AS ErrorLine	
				,NULL AS ErrorProcedure				
				,NULL AS ErrorState			
			
		end try
		begin catch
			IF @@TRANCOUNT > 0
				rollback tran zarteliatml;		
		
			-- zaznam o spracovani s chybou
			insert into VstupyPLIS.dbo.CP_SPRAC_CHOVY_HLAS
			SELECT 
				@IDR
				,'8'
				,@IDParChov
				,LEFT(ERROR_MESSAGE(), 300) AS ErrorMessage
				,ERROR_LINE() AS ErrorLine	
				,ERROR_PROCEDURE() AS ErrorProcedure				
				,ERROR_STATE() AS ErrorState									

		end catch;

		IF @@TRANCOUNT > 0			
		-- koniec transakcie
			commit tran zarteliatml				
			
			FETCH NEXT
		FROM db_cursor_zarteliatml INTO 	
			 @IDR				
			,@CHOVTEL
			,@CISTEL
			,@PORPREBLAK_
			,@POHLTEL
			,@DATNAR
			,@OTECLIN
			,@OTECREG_
			,@OTEC
			,@MATKA
			,@PL1
			,@KR1
			,@PL2
			,@KR2
			,@PL3
			,@KR3
			,@PL4
			,@KR4
			,@PL5
			,@FARBA
			,@ZNAKET
			,@DI	
	end 
	
	CLOSE db_cursor_zarteliatml
	DEALLOCATE db_cursor_zarteliatml	
	
	insert into VstupyPLIS.dbo.CP_SPRAC_CHOVY_LOG
	SELECT 
		@IDParChov
		,'C_aktual_Zarteliatml_aktualizacia ...OK'		
END
 go

