alter procedure [dbo].[Rocenka_MLHD_Tab_2]
    @rok int,
    @typ varchar(10)
as
begin
    IF @typ = 'SlPin'
        begin
            select 'SLOVENSKÉ PINZGAUSKÉ' as plemeno, SR_51.nazov as nazov,
                   '87,5 - 100 %'  as perc1,  SR_51.lakt1 as lakt1_1,     SR_51.lakt2 as lakt1_2,     SR_51.lakt as lakt1_vs,
                   '75 - 87,5 %'   as perc2,  SR_53.lakt1 as lakt2_1,     SR_53.lakt2 as lakt2_2,     SR_53.lakt as lakt2_vs,
                   '50 - 75 %'     as perc3,  SR_54.lakt1 as lakt3_1,     SR_54.lakt2 as lakt3_2,     SR_54.lakt as lakt3_vs,
                   'Plemeno spolu' as percSp, SR_SlPin.lakt1 as laktSp_1, SR_SlPin.lakt2 as laktSp_2, SR_SlPin.lakt as laktSp_3
            from
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_51 where Filter = 'SR,51' and rok = @rok) as SR_51
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_53 where Filter = 'SR,53' and rok = @rok) as SR_53 on SR_53.rok = SR_51.rok and SR_53.poradie = SR_51.poradie
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_54 where Filter = 'SR,54' and rok = @rok) as SR_54 on SR_54.rok = SR_51.rok and SR_54.poradie = SR_51.poradie
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_SlPin where Filter = 'SR,SlPin' and rok = @rok) as SR_SlPin on SR_SlPin.rok = SR_51.rok and SR_SlPin.poradie = SR_51.poradie
            where SR_SlPin.rok = @rok;
        end

    IF @typ = 'SlStr'
        begin
            select 'SLOVENSKÉ STRAKATÉ' as plemeno, SR_11.nazov as nazov,
                   '87,5 - 100 %'  as perc1,  SR_11.lakt1 as lakt1_1,     SR_11.lakt2 as lakt1_2,     SR_11.lakt as lakt1_vs,
                   '75 - 87,5 %'   as perc2,  SR_13.lakt1 as lakt2_1,     SR_13.lakt2 as lakt2_2,     SR_13.lakt as lakt2_vs,
                   '50 - 75 %'     as perc3,  SR_14.lakt1 as lakt3_1,     SR_14.lakt2 as lakt3_2,     SR_14.lakt as lakt3_vs,
                   'Plemeno spolu' as percSp, SR_SlStr.lakt1 as laktSp_1, SR_SlStr.lakt2 as laktSp_2, SR_SlStr.lakt as laktSp_3
            from
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_11 where Filter = 'SR,11' and rok = @rok) as SR_11
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_13 where Filter = 'SR,13' and rok = @rok) as SR_13 on SR_13.rok = SR_11.rok and SR_13.poradie = SR_11.poradie
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_14 where Filter = 'SR,14' and rok = @rok) as SR_14 on SR_14.rok = SR_11.rok and SR_14.poradie = SR_11.poradie
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_SlStr where Filter = 'SR,SlStr' and rok = @rok) as SR_SlStr on SR_SlStr.rok = SR_11.rok and SR_SlStr.poradie = SR_11.poradie
            where SR_SlStr.rok = @rok;
        end

    IF @typ = 'Hol'
        begin
            select 'HOLSTEINSKÉ' as plemeno, SR_99.nazov as nazov,
                   '94 - 100 %'    as perc1,  SR_99.lakt1 as lakt1_1,   SR_99.lakt2 as lakt1_2,   SR_99.lakt as lakt1_vs,
                   '87,5 - 94 %'   as perc2,  SR_98.lakt1 as lakt2_1,   SR_98.lakt2 as lakt2_2,   SR_98.lakt as lakt2_vs,
                   '75 - 87,5 %'   as perc3,  SR_97.lakt1 as lakt3_1,   SR_97.lakt2 as lakt3_2,   SR_97.lakt as lakt3_vs,
                   '50 - 75 %'     as perc4,  SR_96.lakt1 as lakt4_1,   SR_96.lakt2 as lakt4_2,   SR_96.lakt as lakt4_vs,
                   'Plemeno spolu' as percSp, SR_Hol.lakt1 as laktSp_1, SR_Hol.lakt2 as laktSp_2, SR_Hol.lakt as laktSp_3
            from
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_99 where Filter = 'SR,99' and rok = @rok) as SR_99
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_98 where Filter = 'SR,98' and rok = @rok) as SR_98 on SR_98.rok = SR_99.rok and SR_98.poradie = SR_99.poradie
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_97 where Filter = 'SR,97' and rok = @rok) as SR_97 on SR_97.rok = SR_99.rok and SR_97.poradie = SR_99.poradie
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_96 where Filter = 'SR,96' and rok = @rok) as SR_96 on SR_96.rok = SR_99.rok and SR_96.poradie = SR_99.poradie
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_Hol where Filter = 'SR,Hol' and rok = @rok) as SR_Hol on SR_Hol.rok = SR_99.rok and SR_Hol.poradie = SR_99.poradie
            where SR_99.rok = @rok;
        end


    IF @typ = 'Brau'
        begin
            select 'BRAUNVIEH' as plemeno, SR_21.nazov as nazov,
                   '87,5 - 100 %'   as perc1,  SR_21.lakt1 as lakt1_1,    SR_21.lakt2 as lakt1_2,    SR_21.lakt as lakt1_vs,
                   '75 - 87,5 %'    as perc2,  SR_22.lakt1 as lakt2_1,    SR_22.lakt2 as lakt2_2,    SR_22.lakt as lakt2_vs ,
                   '50 - 75 %'      as perc3,  SR_23.lakt1 as lakt3_1,    SR_23.lakt2 as lakt3_2,    SR_23.lakt as lakt3_vs,
                   'Plemeno spolu'  as percSp, SR_Brau.lakt1 as laktSp_1, SR_Brau.lakt2 as laktSp_2, SR_Brau.lakt as laktSp_3
            from
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_21 where Filter = 'SR,21' and rok = @rok) as SR_21
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_22 where Filter = 'SR,22' and rok = @rok) as SR_22 on SR_22.rok = SR_21.rok and SR_22.poradie = SR_21.poradie
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_23 where Filter = 'SR,23' and rok = @rok) as SR_23 on SR_23.rok = SR_21.rok and SR_23.poradie = SR_21.poradie
                    left outer join
                (select poradie, nazov, lakt1, lakt2,lakt, rok from View_Roc_MLHD_TAB_2 as SR_Brau where Filter = 'SR,Brau' and rok = @rok) as SR_Brau on SR_Brau.rok = SR_21.rok and SR_Brau.poradie = SR_21.poradie
            where SR_21.rok = @rok;
        end

    IF @typ = '0000'
        begin
            select 'OSTATNÉ' as plemeno, nazov as nazov, lakt1 as lakt1, lakt2 as lakt2, lakt as lakt from View_Roc_MLHD_TAB_2 where rok = @rok and Filter = 'SR,0000';
        end

end
go

