﻿select top 100
dacs.isoIdCow as "Ušné číslo",
k.chovatel as "číslo chovu",
c.NAZOV as "názov chovu",
pp.NAZOV AS "podnik",
p.TYPS AS "Plemenný typ",
k.ouscis as "otec ušné číslo",
cast(b.lin as varchar) + '-' + cast(b.reg as varchar) as "Otec-register",
k.porpreblak as "poradie laktácie",
CAST(ROUND(Milchwert, 0) AS INT) AS "hodnotenie MW",
reliabilityMilchwert as "REL [%]",
ZWMilkkg1az3L as "Mlieko [kg]",
ZWFatkg1az3L as "Tuk [kg]",
ZWProteinkg1az3L as "Bielk. [kg]",
CONVERT(varchar, month(Created)) + '/' + CONVERT(varchar, year(Created)) as "Dátum hodnotenia"

FROM CM_DACS_EBVcowallSVKSim dacs 
LEFT JOIN CM_Krava k ON k.CISKRAVY = dacs.isoIdCow 
LEFT OUTER JOIN CC_PlemTyp AS p ON k.TYPPLEM = p.TYPC
LEFT JOIN cm_byci b ON k.ouscis = b.uscislo
LEFT OUTER JOIN NM_CHOVMAS AS c ON c.KRAJ + c.OKRES + c.PODNIK + c.CHOV = k.CHOVATEL 
LEFT OUTER JOIN NM_PODNIK AS pp ON pp.KRAJ + pp.OKRES + pp.PODNIK = SUBSTRING(k.CHOVATEL, 1, 6) 
where 
	dacs.isoIdCow in (select ciskravy from cm_krava) and
	p.TYPS = 'S0' and
	k.PRIZNAKKU in (1)
	and dacs.Created = '2022-12-04'
order by "hodnotenie MW" desc


select created, count(*) from CM_DACS_EBVcowallSVKSim
group by created