SELECT *
FROM (
	SELECT c.kraj + c.okres + c.podnik + c.chov AS chovatel
		,c.NAZOV AS "nazov_chovu"
		,pp.NAZOV AS "podnik"
		,COUNT(DISTINCT (k.CISKRAVY)) AS POCET_KRAV_V_KU
		,COUNT(DISTINCT (h.ciskravy)) AS POCET_V_HODNOTENI_MW
		,cast(Round(AVG(h.Milchwert), 1) AS DECIMAL(5, 1)) AS priem_mw
	FROM NM_HDDETAIL d
	LEFT JOIN NM_CHOVMAS AS c ON c.KRAJ + c.OKRES + c.PODNIK + c.CHOV = d.KRAJ + d.OKRES + d.PODNIK + d.CHOV
	LEFT JOIN NM_PODNIK AS pp ON pp.KRAJ + pp.OKRES + pp.PODNIK = c.KRAJ + c.OKRES + c.PODNIK
	LEFT JOIN CM_Krava k ON c.kraj + c.okres + c.podnik + c.chov = k.CHOVATEL
	LEFT JOIN (
		SELECT s.Milchwert
			,s.isoIdCow
			,k.CISKRAVY
			,k.CHOVATEL
		FROM CM_DACS_EBVcowallSVKSim s
		INNER JOIN (
			SELECT isoIdCow
				,max(Created) AS maxCreated
			FROM CM_DACS_EBVcowallSVKSim
			WHERE YEAR(created) = '2023'
				AND MONTH(created) = '04'
			GROUP BY IsoIdCow
			) g ON s.isoIdCow = g.isoIdCow
		LEFT JOIN CM_KRAVA k ON s.isoIdCow = k.CISKRAVY
			AND s.Created = g.maxCreated
		) h ON h.CISKRAVY = k.CISKRAVY
	WHERE --k.CHOVATEL = '701585011' AND
		d.PRIZNAK = '01'
		AND (
			c.datumZrusenia <= '2023-12-31'
			OR c.datumZrusenia IS NULL
			)
		AND c.ZRUS IS NULL
		AND (
			(
				k.PL1 = 'S'
				AND k.KR1 >= 50
				)
			OR (
				k.PL2 = 'S'
				AND k.KR2 >= 50
				)
			)
		AND (
			k.DATVYR IS NULL
			OR k.DATVYR <= '2023-03-31'
			)
		AND k.DOVVYR IS NULL
	GROUP BY c.kraj + c.okres + c.podnik + c.chov
		,c.NAZOV
		,pp.NAZOV
	) a
WHERE priem_mw > 0
ORDER BY priem_mw
